/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.queryparser.flexible.standard.QueryParserUtil;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.impl.fulltext.FulltextConfig;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProviderFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.ThreadTestUtils;
import org.neo4j.test.rule.CleanupRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.VerboseTimeout;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.util.concurrent.BinaryLatch;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class FulltextProceduresTest {
    private static final String DB_INDEXES = "CALL db.indexes";
    private static final String DROP = "CALL db.index.fulltext.drop(\"%s\")";
    private static final String LIST_AVAILABLE_ANALYZERS = "CALL db.index.fulltext.listAvailableAnalyzers()";
    private static final String DB_AWAIT_INDEX = "CALL db.index.fulltext.awaitIndex(\"%s\")";
    static final String QUERY_NODES = "CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")";
    static final String QUERY_RELS = "CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")";
    static final String AWAIT_REFRESH = "CALL db.index.fulltext.awaitEventuallyConsistentIndexRefresh()";
    static final String NODE_CREATE = "CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )";
    static final String RELATIONSHIP_CREATE = "CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)";
    private static final String SCORE = "score";
    static final String NODE = "node";
    static final String RELATIONSHIP = "relationship";
    private static final String DESCARTES_MEDITATIONES = "/meditationes--rene-descartes--public-domain.txt";
    private static final Label LABEL = Label.label((String)"Label");
    private static final RelationshipType REL = RelationshipType.withName((String)"REL");
    private final Timeout timeout = VerboseTimeout.builder().withTimeout(1L, TimeUnit.HOURS).build();
    private final DefaultFileSystemRule fs = new DefaultFileSystemRule();
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final ExpectedException expectedException = ExpectedException.none();
    private final CleanupRule cleanup = new CleanupRule();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.timeout).around((TestRule)this.fs).around((TestRule)this.testDirectory).around((TestRule)this.expectedException).around((TestRule)this.cleanup);
    private GraphDatabaseAPI db;
    private GraphDatabaseBuilder builder;
    private static final String PROP = "prop";
    private static final String EVENTUALLY_CONSISTENT = ", {eventually_consistent: 'true'}";

    @Before
    public void before() {
        GraphDatabaseFactory factory = new GraphDatabaseFactory();
        this.builder = factory.newEmbeddedDatabaseBuilder(this.testDirectory.databaseDir());
        this.builder.setConfig(GraphDatabaseSettings.store_internal_log_level, "DEBUG");
    }

    @After
    public void tearDown() {
        if (this.db != null) {
            this.db.shutdown();
        }
    }

    @Test
    public void createNodeFulltextIndex() {
        Map row;
        Result result;
        this.db = this.createDatabase();
        this.db.execute(String.format(NODE_CREATE, "test-index", FulltextProceduresTest.array("Label1", "Label2"), FulltextProceduresTest.array("prop1", "prop2"))).close();
        try (Transaction tx = this.db.beginTx();){
            result = this.db.execute(DB_INDEXES);
            Assert.assertTrue((boolean)result.hasNext());
            row = result.next();
            Assert.assertEquals((Object)"INDEX ON NODE:Label1, Label2(prop1, prop2)", row.get("description"));
            Assert.assertEquals(Arrays.asList("Label1", "Label2"), row.get("tokenNames"));
            Assert.assertEquals(Arrays.asList("prop1", "prop2"), row.get("properties"));
            Assert.assertEquals((Object)"test-index", row.get("indexName"));
            Assert.assertEquals((Object)"node_fulltext", row.get("type"));
            Assert.assertFalse((boolean)result.hasNext());
            result.close();
            this.awaitIndexesOnline();
            result = this.db.execute(DB_INDEXES);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"ONLINE", result.next().get("state"));
            Assert.assertFalse((boolean)result.hasNext());
            result.close();
            Assert.assertNotNull((Object)this.db.schema().getIndexByName("test-index"));
            tx.success();
        }
        this.db.shutdown();
        this.db = this.createDatabase();
        tx = this.db.beginTx();
        var4_2 = null;
        try {
            result = this.db.execute(DB_INDEXES);
            Assert.assertTrue((boolean)result.hasNext());
            row = result.next();
            Assert.assertEquals((Object)"INDEX ON NODE:Label1, Label2(prop1, prop2)", row.get("description"));
            Assert.assertEquals((Object)"ONLINE", row.get("state"));
            Assert.assertFalse((boolean)result.hasNext());
            Assert.assertFalse((boolean)result.hasNext());
            Assert.assertNotNull((Object)this.db.schema().getIndexByName("test-index"));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void createRelationshipFulltextIndex() {
        Map row;
        Result result;
        this.db = this.createDatabase();
        this.db.execute(String.format(RELATIONSHIP_CREATE, "test-index", FulltextProceduresTest.array("Reltype1", "Reltype2"), FulltextProceduresTest.array("prop1", "prop2"))).close();
        try (Transaction tx = this.db.beginTx();){
            result = this.db.execute(DB_INDEXES);
            Assert.assertTrue((boolean)result.hasNext());
            row = result.next();
            Assert.assertEquals((Object)"INDEX ON RELATIONSHIP:Reltype1, Reltype2(prop1, prop2)", row.get("description"));
            Assert.assertEquals(Arrays.asList("Reltype1", "Reltype2"), row.get("tokenNames"));
            Assert.assertEquals(Arrays.asList("prop1", "prop2"), row.get("properties"));
            Assert.assertEquals((Object)"test-index", row.get("indexName"));
            Assert.assertEquals((Object)"relationship_fulltext", row.get("type"));
            Assert.assertFalse((boolean)result.hasNext());
            result.close();
            this.awaitIndexesOnline();
            result = this.db.execute(DB_INDEXES);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"ONLINE", result.next().get("state"));
            Assert.assertFalse((boolean)result.hasNext());
            result.close();
            Assert.assertNotNull((Object)this.db.schema().getIndexByName("test-index"));
            tx.success();
        }
        this.db.shutdown();
        this.db = this.createDatabase();
        tx = this.db.beginTx();
        var4_2 = null;
        try {
            result = this.db.execute(DB_INDEXES);
            Assert.assertTrue((boolean)result.hasNext());
            row = result.next();
            Assert.assertEquals((Object)"INDEX ON RELATIONSHIP:Reltype1, Reltype2(prop1, prop2)", row.get("description"));
            Assert.assertEquals((Object)"ONLINE", row.get("state"));
            Assert.assertFalse((boolean)result.hasNext());
            Assert.assertFalse((boolean)result.hasNext());
            Assert.assertNotNull((Object)this.db.schema().getIndexByName("test-index"));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void dropIndex() {
        this.db = this.createDatabase();
        this.db.execute(String.format(NODE_CREATE, NODE, FulltextProceduresTest.array("Label1", "Label2"), FulltextProceduresTest.array("prop1", "prop2"))).close();
        this.db.execute(String.format(RELATIONSHIP_CREATE, "rel", FulltextProceduresTest.array("Reltype1", "Reltype2"), FulltextProceduresTest.array("prop1", "prop2"))).close();
        HashMap indexes = new HashMap();
        this.db.execute("call db.indexes").forEachRemaining(m -> indexes.put((String)m.get("indexName"), (String)m.get("description")));
        this.db.execute(String.format(DROP, NODE));
        indexes.remove(NODE);
        HashMap newIndexes = new HashMap();
        this.db.execute("call db.indexes").forEachRemaining(m -> newIndexes.put((String)m.get("indexName"), (String)m.get("description")));
        Assert.assertEquals(indexes, newIndexes);
        this.db.execute(String.format(DROP, "rel"));
        indexes.remove("rel");
        newIndexes.clear();
        this.db.execute("call db.indexes").forEachRemaining(m -> newIndexes.put((String)m.get("indexName"), (String)m.get("description")));
        Assert.assertEquals(indexes, newIndexes);
    }

    @Test
    public void mustNotBeAbleToCreateTwoIndexesWithSameName() {
        this.db = this.createDatabase();
        this.db.execute(String.format(NODE_CREATE, NODE, FulltextProceduresTest.array("Label1", "Label2"), FulltextProceduresTest.array("prop1", "prop2"))).close();
        this.expectedException.expectMessage("already exists");
        this.db.execute(String.format(NODE_CREATE, NODE, FulltextProceduresTest.array("Label1", "Label2"), FulltextProceduresTest.array("prop3", "prop4"))).close();
    }

    @Test
    public void nodeIndexesMustHaveLabels() {
        this.db = this.createDatabase();
        this.expectedException.expect(QueryExecutionException.class);
        this.db.execute(String.format(NODE_CREATE, "nodeIndex", FulltextProceduresTest.array(new String[0]), FulltextProceduresTest.array(PROP))).close();
    }

    @Test
    public void relationshipIndexesMustHaveRelationshipTypes() {
        this.db = this.createDatabase();
        this.expectedException.expect(QueryExecutionException.class);
        this.db.execute(String.format(RELATIONSHIP_CREATE, "relIndex", FulltextProceduresTest.array(new String[0]), FulltextProceduresTest.array(PROP)));
    }

    @Test
    public void nodeIndexesMustHaveProperties() {
        this.db = this.createDatabase();
        this.expectedException.expect(QueryExecutionException.class);
        this.db.execute(String.format(NODE_CREATE, "nodeIndex", FulltextProceduresTest.array("Label"), FulltextProceduresTest.array(new String[0]))).close();
    }

    @Test
    public void relationshipIndexesMustHaveProperties() {
        this.db = this.createDatabase();
        this.expectedException.expect(QueryExecutionException.class);
        this.db.execute(String.format(RELATIONSHIP_CREATE, "relIndex", FulltextProceduresTest.array("RELTYPE"), FulltextProceduresTest.array(new String[0])));
    }

    @Test
    public void creatingIndexesWhichImpliesTokenCreateMustNotBlockForever() {
        this.db = this.createDatabase();
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute(String.format(NODE_CREATE, "nodesA", FulltextProceduresTest.array("SOME_LABEL"), FulltextProceduresTest.array("this")));
            this.db.execute(String.format(RELATIONSHIP_CREATE, "relsA", FulltextProceduresTest.array("SOME_REL_TYPE"), FulltextProceduresTest.array("foo")));
            this.db.execute(String.format(NODE_CREATE, "nodesB", FulltextProceduresTest.array("SOME_OTHER_LABEL"), FulltextProceduresTest.array("that")));
            this.db.execute(String.format(RELATIONSHIP_CREATE, "relsB", FulltextProceduresTest.array("SOME_OTHER_REL_TYPE"), FulltextProceduresTest.array("bar")));
        }
    }

    @Test
    public void creatingIndexWithSpecificAnalyzerMustUseThatAnalyzerForPopulationUpdatingAndQuerying() {
        this.db = this.createDatabase();
        LongHashSet noResults = new LongHashSet();
        LongHashSet swedishNodes = new LongHashSet();
        LongHashSet englishNodes = new LongHashSet();
        LongHashSet swedishRels = new LongHashSet();
        LongHashSet englishRels = new LongHashSet();
        String labelledSwedishNodes = "labelledSwedishNodes";
        String typedSwedishRelationships = "typedSwedishRelationships";
        try (Transaction tx = this.db.beginTx();){
            Node nodeA = this.db.createNode(new Label[]{LABEL});
            nodeA.setProperty(PROP, (Object)"En apa och en tomte bodde i ett hus.");
            swedishNodes.add(nodeA.getId());
            Node nodeB = this.db.createNode(new Label[]{LABEL});
            nodeB.setProperty(PROP, (Object)"Hello and hello again, in the end.");
            englishNodes.add(nodeB.getId());
            Relationship relA = nodeA.createRelationshipTo(nodeB, REL);
            relA.setProperty(PROP, (Object)"En apa och en tomte bodde i ett hus.");
            swedishRels.add(relA.getId());
            Relationship relB = nodeB.createRelationshipTo(nodeA, REL);
            relB.setProperty(PROP, (Object)"Hello and hello again, in the end.");
            englishRels.add(relB.getId());
            tx.success();
        }
        tx = this.db.beginTx();
        var9_9 = null;
        try {
            String lbl = FulltextProceduresTest.array(LABEL.name());
            String rel = FulltextProceduresTest.array(REL.name());
            String props = FulltextProceduresTest.array(PROP);
            String swedish = props + ", {analyzer: '" + "swedish" + "'}";
            this.db.execute(String.format(NODE_CREATE, labelledSwedishNodes, lbl, swedish)).close();
            this.db.execute(String.format(RELATIONSHIP_CREATE, typedSwedishRelationships, rel, swedish)).close();
            tx.success();
        }
        catch (Throwable lbl) {
            var9_9 = lbl;
            throw lbl;
        }
        finally {
            if (tx != null) {
                if (var9_9 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable lbl) {
                        var9_9.addSuppressed(lbl);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        var9_9 = null;
        try {
            Node nodeC = this.db.createNode(new Label[]{LABEL});
            nodeC.setProperty(PROP, (Object)"En apa och en tomte bodde i ett hus.");
            swedishNodes.add(nodeC.getId());
            Node nodeD = this.db.createNode(new Label[]{LABEL});
            nodeD.setProperty(PROP, (Object)"Hello and hello again, in the end.");
            englishNodes.add(nodeD.getId());
            Relationship relC = nodeC.createRelationshipTo(nodeD, REL);
            relC.setProperty(PROP, (Object)"En apa och en tomte bodde i ett hus.");
            swedishRels.add(relC.getId());
            Relationship relD = nodeD.createRelationshipTo(nodeC, REL);
            relD.setProperty(PROP, (Object)"Hello and hello again, in the end.");
            englishRels.add(relD.getId());
            tx.success();
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var9_9 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var9_9 = null;
        try (Transaction ignore = this.db.beginTx();){
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, labelledSwedishNodes, "and", englishNodes);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, labelledSwedishNodes, "ett", noResults);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, labelledSwedishNodes, "apa", swedishNodes);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, typedSwedishRelationships, "and", englishRels);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, typedSwedishRelationships, "ett", noResults);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, typedSwedishRelationships, "apa", swedishRels);
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
    }

    @Test
    public void queryShouldFindDataAddedInLaterTransactions() {
        long horseRelId;
        long horseId;
        this.db = this.createDatabase();
        this.db.execute(String.format(NODE_CREATE, NODE, FulltextProceduresTest.array("Label1", "Label2"), FulltextProceduresTest.array("prop1", "prop2"))).close();
        this.db.execute(String.format(RELATIONSHIP_CREATE, "rel", FulltextProceduresTest.array("Reltype1", "Reltype2"), FulltextProceduresTest.array("prop1", "prop2"))).close();
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node zebra = this.db.createNode();
            zebra.setProperty("prop1", (Object)"zebra");
            Node horse = this.db.createNode(new Label[]{Label.label((String)"Label1")});
            horse.setProperty("prop2", (Object)"horse");
            horse.setProperty("prop3", (Object)"zebra");
            Relationship horseRel = zebra.createRelationshipTo(horse, RelationshipType.withName((String)"Reltype1"));
            horseRel.setProperty("prop1", (Object)"horse");
            Relationship loop = horse.createRelationshipTo(horse, RelationshipType.withName((String)"loop"));
            loop.setProperty("prop2", (Object)"zebra");
            horseId = horse.getId();
            horseRelId = horseRel.getId();
            tx.success();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "horse", LongHashSet.newSetWith((long[])new long[]{horseId}));
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "horse zebra", LongHashSet.newSetWith((long[])new long[]{horseId}));
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "horse", LongHashSet.newSetWith((long[])new long[]{horseRelId}));
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "horse zebra", LongHashSet.newSetWith((long[])new long[]{horseRelId}));
    }

    @Test
    public void queryShouldFindDataAddedInIndexPopulation() {
        Relationship relationship;
        Node node2;
        Node node1;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            node1 = this.db.createNode(new Label[]{LABEL});
            node1.setProperty(PROP, (Object)"This is a integration test.");
            node2 = this.db.createNode(new Label[]{LABEL});
            node2.setProperty("otherprop", (Object)"This is a related integration test");
            relationship = node1.createRelationshipTo(node2, REL);
            relationship.setProperty(PROP, (Object)"They relate");
            tx.success();
        }
        tx = this.db.beginTx();
        var5_2 = null;
        try {
            this.db.execute(String.format(NODE_CREATE, NODE, FulltextProceduresTest.array(LABEL.name()), FulltextProceduresTest.array(PROP, "otherprop")));
            this.db.execute(String.format(RELATIONSHIP_CREATE, "rel", FulltextProceduresTest.array(REL.name()), FulltextProceduresTest.array(PROP)));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.awaitIndexesOnline();
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "integration", node1.getId(), node2.getId());
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "test", node1.getId(), node2.getId());
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "related", LongHashSet.newSetWith((long[])new long[]{node2.getId()}));
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "relate", LongHashSet.newSetWith((long[])new long[]{relationship.getId()}));
    }

    @Test
    public void updatesToEventuallyConsistentIndexMustEventuallyBecomeVisible() {
        String value = "bla bla";
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.db.execute(String.format(NODE_CREATE, NODE, FulltextProceduresTest.array(LABEL.name()), FulltextProceduresTest.array(PROP) + EVENTUALLY_CONSISTENT));
            this.db.execute(String.format(RELATIONSHIP_CREATE, "rel", FulltextProceduresTest.array(REL.name()), FulltextProceduresTest.array(PROP) + EVENTUALLY_CONSISTENT));
            tx.success();
        }
        int entityCount = 200;
        LongHashSet nodeIds = new LongHashSet();
        LongHashSet relIds = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < entityCount; ++i) {
                Node node = this.db.createNode(new Label[]{LABEL});
                node.setProperty(PROP, (Object)value);
                Relationship rel = node.createRelationshipTo(node, REL);
                rel.setProperty(PROP, (Object)value);
                nodeIds.add(node.getId());
                relIds.add(rel.getId());
            }
            tx.success();
        }
        long deadline = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(20L);
        boolean success = false;
        while (true) {
            try {
                FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "bla", nodeIds);
                FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "bla", relIds);
                success = true;
            }
            finally {
                if (!success) continue;
            }
            break;
        }
    }

    @Test
    public void updatesToEventuallyConsistentIndexMustBecomeVisibleAfterAwaitRefresh() {
        String value = "bla bla";
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.db.execute(String.format(NODE_CREATE, NODE, FulltextProceduresTest.array(LABEL.name()), FulltextProceduresTest.array(PROP) + EVENTUALLY_CONSISTENT));
            this.db.execute(String.format(RELATIONSHIP_CREATE, "rel", FulltextProceduresTest.array(REL.name()), FulltextProceduresTest.array(PROP) + EVENTUALLY_CONSISTENT));
            tx.success();
        }
        this.awaitIndexesOnline();
        int entityCount = 200;
        LongHashSet nodeIds = new LongHashSet();
        LongHashSet relIds = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < entityCount; ++i) {
                Node node = this.db.createNode(new Label[]{LABEL});
                node.setProperty(PROP, (Object)value);
                Relationship rel = node.createRelationshipTo(node, REL);
                rel.setProperty(PROP, (Object)value);
                nodeIds.add(node.getId());
                relIds.add(rel.getId());
            }
            tx.success();
        }
        this.db.execute(AWAIT_REFRESH).close();
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "bla", nodeIds);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "bla", relIds);
    }

    @Test
    public void eventuallyConsistentIndexMustPopulateWithExistingDataWhenCreated() {
        String value = "bla bla";
        this.db = this.createDatabase();
        int entityCount = 200;
        LongHashSet nodeIds = new LongHashSet();
        LongHashSet relIds = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < entityCount; ++i) {
                Node node = this.db.createNode(new Label[]{LABEL});
                node.setProperty(PROP, (Object)value);
                Relationship rel = node.createRelationshipTo(node, REL);
                rel.setProperty(PROP, (Object)value);
                nodeIds.add(node.getId());
                relIds.add(rel.getId());
            }
            tx.success();
        }
        tx = this.db.beginTx();
        var6_6 = null;
        try {
            this.db.execute(String.format(NODE_CREATE, NODE, FulltextProceduresTest.array(LABEL.name()), FulltextProceduresTest.array(PROP) + EVENTUALLY_CONSISTENT));
            this.db.execute(String.format(RELATIONSHIP_CREATE, "rel", FulltextProceduresTest.array(REL.name()), FulltextProceduresTest.array(PROP) + EVENTUALLY_CONSISTENT));
            tx.success();
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_6 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.awaitIndexesOnline();
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "bla", nodeIds);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "bla", relIds);
    }

    @Test
    public void concurrentPopulationAndUpdatesToAnEventuallyConsistentIndexMustEventuallyResultInCorrectIndexState() throws Exception {
        String oldValue = "red";
        String newValue = "green";
        this.db = this.createDatabase();
        int entityCount = 200;
        LongHashSet nodeIds = new LongHashSet();
        LongHashSet relIds = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < entityCount; ++i) {
                Node node = this.db.createNode(new Label[]{LABEL});
                node.setProperty(PROP, (Object)oldValue);
                Relationship rel = node.createRelationshipTo(node, REL);
                rel.setProperty(PROP, (Object)oldValue);
                nodeIds.add(node.getId());
                relIds.add(rel.getId());
            }
            tx.success();
        }
        CountDownLatch readyLatch = new CountDownLatch(2);
        BinaryLatch startLatch = new BinaryLatch();
        Runnable createIndexes = () -> {
            readyLatch.countDown();
            startLatch.await();
            try (Transaction tx = this.db.beginTx();){
                this.db.execute(String.format(NODE_CREATE, NODE, FulltextProceduresTest.array(LABEL.name()), FulltextProceduresTest.array(PROP) + EVENTUALLY_CONSISTENT));
                this.db.execute(String.format(RELATIONSHIP_CREATE, "rel", FulltextProceduresTest.array(REL.name()), FulltextProceduresTest.array(PROP) + EVENTUALLY_CONSISTENT));
                tx.success();
            }
        };
        Runnable makeAllEntitiesGreen = () -> {
            try (Transaction tx = this.db.beginTx();){
                nodeIds.forEach((LongProcedure & Serializable)nodeId -> this.db.getNodeById(nodeId).setProperty(PROP, (Object)newValue));
                relIds.forEach((LongProcedure & Serializable)relId -> this.db.getRelationshipById(relId).setProperty(PROP, (Object)newValue));
                tx.success();
                readyLatch.countDown();
                startLatch.await();
            }
        };
        ExecutorService executor = (ExecutorService)this.cleanup.add((Object)Executors.newFixedThreadPool(2));
        Future<?> future1 = executor.submit(createIndexes);
        Future<?> future2 = executor.submit(makeAllEntitiesGreen);
        readyLatch.await();
        startLatch.release();
        future1.get();
        future2.get();
        this.awaitIndexesOnline();
        this.db.execute(AWAIT_REFRESH).close();
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, newValue, nodeIds);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", newValue, relIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fulltextIndexesMustBeEventuallyConsistentByDefaultWhenThisIsConfigured() throws InterruptedException {
        long relId;
        this.builder.setConfig(FulltextConfig.eventually_consistent, "true");
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.db.execute(String.format(NODE_CREATE, NODE, FulltextProceduresTest.array(LABEL.name()), FulltextProceduresTest.array(PROP, "otherprop")));
            this.db.execute(String.format(RELATIONSHIP_CREATE, "rel", FulltextProceduresTest.array(REL.name()), FulltextProceduresTest.array(PROP)));
            tx.success();
        }
        this.awaitIndexesOnline();
        BinaryLatch indexUpdateBlocker = new BinaryLatch();
        ((JobScheduler)this.db.getDependencyResolver().resolveDependency(JobScheduler.class, DependencyResolver.SelectionStrategy.ONLY)).schedule(Group.INDEX_UPDATING, () -> ((BinaryLatch)indexUpdateBlocker).await());
        LongHashSet nodeIds = new LongHashSet();
        try {
            try (Transaction tx = this.db.beginTx();){
                Node node1 = this.db.createNode(new Label[]{LABEL});
                node1.setProperty(PROP, (Object)"bla bla");
                Node node2 = this.db.createNode(new Label[]{LABEL});
                node2.setProperty("otherprop", (Object)"bla bla");
                Relationship relationship = node1.createRelationshipTo(node2, REL);
                relationship.setProperty(PROP, (Object)"bla bla");
                nodeIds.add(node1.getId());
                nodeIds.add(node2.getId());
                relId = relationship.getId();
                tx.success();
            }
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "bla", new LongHashSet());
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "bla", new LongHashSet());
        }
        finally {
            Thread.sleep(10L);
            indexUpdateBlocker.release();
        }
        this.db.execute(AWAIT_REFRESH).close();
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "bla", nodeIds);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "bla", LongHashSet.newSetWith((long[])new long[]{relId}));
    }

    @Test
    public void mustBeAbleToListAvailableAnalyzers() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            HashSet<Object> analyzers = new HashSet<Object>();
            try (ResourceIterator iterator = this.db.execute(LIST_AVAILABLE_ANALYZERS).columnAs("analyzer");){
                while (iterator.hasNext()) {
                    analyzers.add(iterator.next());
                }
            }
            Assert.assertThat(analyzers, (Matcher)Matchers.hasItem((Object)"english"));
            Assert.assertThat(analyzers, (Matcher)Matchers.hasItem((Object)"swedish"));
            Assert.assertThat(analyzers, (Matcher)Matchers.hasItem((Object)"standard"));
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            try (Result result = this.db.execute(LIST_AVAILABLE_ANALYZERS);){
                while (result.hasNext()) {
                    Map row = result.next();
                    Object description = row.get("description");
                    if (row.containsKey("description") && description instanceof String && !((String)description).trim().isEmpty()) continue;
                    Assert.fail((String)("Found no description for analyzer: " + row));
                }
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryNodesMustThrowWhenQueryingRelationshipIndex() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex();
            tx.success();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.expectedException.expect(Exception.class);
            this.db.execute(String.format(QUERY_NODES, "rels", "bla bla")).close();
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryRelationshipsMustThrowWhenQueryingNodeIndex() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.expectedException.expect(Exception.class);
            this.db.execute(String.format(QUERY_RELS, "nodes", "bla bla")).close();
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void fulltextIndexMustIgnoreNonStringPropertiesForUpdate() {
        this.db = this.createDatabase();
        Label label = LABEL;
        Transaction tx = this.db.beginTx();
        Object object = null;
        try {
            this.db.execute(String.format(NODE_CREATE, "nodes", FulltextProceduresTest.array(label.name()), FulltextProceduresTest.array(PROP))).close();
            this.createSimpleRelationshipIndex();
            tx.success();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.awaitIndexesOnline();
        List<Value> values = this.generateRandomNonStringValues();
        try (Transaction tx2 = this.db.beginTx();){
            for (Value value : values) {
                Node node = this.db.createNode(new Label[]{label});
                Object propertyValue = value.asObject();
                node.setProperty(PROP, propertyValue);
                node.createRelationshipTo(node, REL).setProperty(PROP, propertyValue);
            }
            tx2.success();
        }
        for (Value value : values) {
            Result nodes;
            String fulltextQuery = this.quoteValueForQuery(value);
            String cypherQuery = String.format(QUERY_NODES, "nodes", fulltextQuery);
            try {
                nodes = this.db.execute(cypherQuery);
            }
            catch (QueryExecutionException e) {
                throw new AssertionError("Failed to execute query: " + cypherQuery + " based on value " + value.prettyPrint(), e);
            }
            if (nodes.hasNext()) {
                Assert.fail((String)("did not expect to find any nodes, but found at least: " + nodes.next()));
            }
            nodes.close();
            Result relationships = this.db.execute(String.format(QUERY_RELS, "rels", fulltextQuery));
            if (relationships.hasNext()) {
                Assert.fail((String)("did not expect to find any relationships, but found at least: " + relationships.next()));
            }
            relationships.close();
        }
    }

    @Test
    public void fulltextIndexMustIgnoreNonStringPropertiesForPopulation() {
        this.db = this.createDatabase();
        List<Value> values = this.generateRandomNonStringValues();
        try (Transaction tx = this.db.beginTx();){
            for (Value value : values) {
                Node node = this.db.createNode(new Label[]{LABEL});
                Object propertyValue = value.asObject();
                node.setProperty(PROP, propertyValue);
                node.createRelationshipTo(node, REL).setProperty(PROP, propertyValue);
            }
            tx.success();
        }
        tx = this.db.beginTx();
        var3_3 = null;
        try {
            this.createSimpleNodesIndex();
            this.createSimpleRelationshipIndex();
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.awaitIndexesOnline();
        for (Value value : values) {
            Result nodes;
            String fulltextQuery = this.quoteValueForQuery(value);
            String cypherQuery = String.format(QUERY_NODES, "nodes", fulltextQuery);
            try {
                nodes = this.db.execute(cypherQuery);
            }
            catch (QueryExecutionException e) {
                throw new AssertionError("Failed to execute query: " + cypherQuery + " based on value " + value.prettyPrint(), e);
            }
            if (nodes.hasNext()) {
                Assert.fail((String)("did not expect to find any nodes, but found at least: " + nodes.next()));
            }
            nodes.close();
            Result relationships = this.db.execute(String.format(QUERY_RELS, "rels", fulltextQuery));
            if (relationships.hasNext()) {
                Assert.fail((String)("did not expect to find any relationships, but found at least: " + relationships.next()));
            }
            relationships.close();
        }
    }

    @Test
    public void entitiesMustBeRemovedFromFulltextIndexWhenPropertyValuesChangeAwayFromText() {
        long nodeId;
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode(new Label[]{LABEL});
            nodeId = node.getId();
            node.setProperty(PROP, (Object)"bla bla");
            tx.success();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            node = this.db.getNodeById(nodeId);
            node.setProperty(PROP, (Object)42);
            tx.success();
        }
        catch (Throwable node2) {
            var4_8 = node2;
            throw node2;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable node2) {
                        var4_8.addSuppressed(node2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            Result result = this.db.execute(String.format(QUERY_NODES, "nodes", "bla"));
            Assert.assertFalse((boolean)result.hasNext());
            result.close();
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void entitiesMustBeAddedToFulltextIndexWhenPropertyValuesChangeToText() {
        long nodeId;
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)42);
            nodeId = node.getId();
            tx.success();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            node = this.db.getNodeById(nodeId);
            node.setProperty(PROP, (Object)"bla bla");
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "bla", nodeId);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void propertiesMustBeRemovedFromFulltextIndexWhenTheirValueTypeChangesAwayFromText() {
        long nodeId;
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.db.execute(String.format(NODE_CREATE, "nodes", FulltextProceduresTest.array(LABEL.name()), FulltextProceduresTest.array("prop1", "prop2"))).close();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode(new Label[]{LABEL});
            nodeId = node.getId();
            node.setProperty("prop1", (Object)"foo");
            node.setProperty("prop2", (Object)"bar");
            tx.success();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            node = this.db.getNodeById(nodeId);
            node.setProperty("prop2", (Object)42);
            tx.success();
        }
        catch (Throwable node2) {
            var4_8 = node2;
            throw node2;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable node2) {
                        var4_8.addSuppressed(node2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "foo", nodeId);
            Result result = this.db.execute(String.format(QUERY_NODES, "nodes", "bar"));
            Assert.assertFalse((boolean)result.hasNext());
            result.close();
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void propertiesMustBeAddedToFulltextIndexWhenTheirValueTypeChangesToText() {
        long nodeId;
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.db.execute(String.format(NODE_CREATE, "nodes", FulltextProceduresTest.array(LABEL.name()), FulltextProceduresTest.array("prop1", "prop2"))).close();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode(new Label[]{LABEL});
            nodeId = node.getId();
            node.setProperty("prop1", (Object)"foo");
            node.setProperty("prop2", (Object)42);
            tx.success();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            node = this.db.getNodeById(nodeId);
            node.setProperty("prop2", (Object)"bar");
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "foo", nodeId);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "bar", nodeId);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void mustBeAbleToIndexHugeTextPropertiesInIndexUpdates() throws Exception {
        long nodeId;
        String meditationes;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(DESCARTES_MEDITATIONES), StandardCharsets.UTF_8));){
            meditationes = reader.lines().collect(Collectors.joining("\n"));
        }
        this.db = this.createDatabase();
        Label label = Label.label((String)"Book");
        try (Transaction tx = this.db.beginTx();){
            this.db.execute(String.format(NODE_CREATE, "books", FulltextProceduresTest.array(label.name()), FulltextProceduresTest.array("title", "author", "contents"))).close();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode(new Label[]{label});
            nodeId = node.getId();
            node.setProperty("title", (Object)"Meditationes de prima philosophia");
            node.setProperty("author", (Object)"Ren\u00e9 Descartes");
            node.setProperty("contents", (Object)meditationes);
            tx.success();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        var6_13 = null;
        try {
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "books", "impellit scriptum offerendum", nodeId);
            tx.success();
        }
        catch (Throwable throwable) {
            var6_13 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_13 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_13.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void mustBeAbleToIndexHugeTextPropertiesInIndexPopulation() throws Exception {
        long nodeId;
        String meditationes;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(DESCARTES_MEDITATIONES), StandardCharsets.UTF_8));){
            meditationes = reader.lines().collect(Collectors.joining("\n"));
        }
        this.db = this.createDatabase();
        Label label = Label.label((String)"Book");
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode(new Label[]{label});
            nodeId = node.getId();
            node.setProperty("title", (Object)"Meditationes de prima philosophia");
            node.setProperty("author", (Object)"Ren\u00e9 Descartes");
            node.setProperty("contents", (Object)meditationes);
            tx.success();
        }
        tx = this.db.beginTx();
        var6_10 = null;
        try {
            this.db.execute(String.format(NODE_CREATE, "books", FulltextProceduresTest.array(label.name()), FulltextProceduresTest.array("title", "author", "contents"))).close();
            tx.success();
        }
        catch (Throwable throwable) {
            var6_10 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_10 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_10.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        var6_10 = null;
        try {
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "books", "impellit scriptum offerendum", nodeId);
            tx.success();
        }
        catch (Throwable throwable) {
            var6_10 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_10 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_10.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void mustBeAbleToQuerySpecificPropertiesViaLuceneSyntax() {
        long book2id;
        this.db = this.createDatabase();
        Label book = Label.label((String)"Book");
        try (Transaction tx = this.db.beginTx();){
            this.db.execute(String.format(NODE_CREATE, "books", FulltextProceduresTest.array(book.name()), FulltextProceduresTest.array("title", "author"))).close();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            Node book1 = this.db.createNode(new Label[]{book});
            book1.setProperty("author", (Object)"Ren\u00e9 Descartes");
            book1.setProperty("title", (Object)"Meditationes de prima philosophia");
            Node book2 = this.db.createNode(new Label[]{book});
            book2.setProperty("author", (Object)"E. M. Curley");
            book2.setProperty("title", (Object)"Descartes Against the Skeptics");
            book2id = book2.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var5_9 = null;
        try {
            LongHashSet ids = LongHashSet.newSetWith((long[])new long[]{book2id});
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "books", "title:Descartes", ids);
            tx.success();
        }
        catch (Throwable throwable) {
            var5_9 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_9 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_9.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void mustIndexNodesByCorrectProperties() {
        long nodeId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.db.execute(String.format(NODE_CREATE, "nodes", FulltextProceduresTest.array(LABEL.name()), FulltextProceduresTest.array("a", "b", "c", "d", "e", "f"))).close();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            Node node = this.db.createNode(new Label[]{LABEL});
            node.setProperty("e", (Object)"value");
            nodeId = node.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "e:value", nodeId);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryingIndexInPopulatingStateMustBlockUntilIndexIsOnline() {
        this.db = this.createDatabase();
        long nodeCount = 10000L;
        try (Transaction tx = this.db.beginTx();){
            int i = 0;
            while ((long)i < nodeCount) {
                this.db.createNode(new Label[]{LABEL}).setProperty(PROP, (Object)"value");
                ++i;
            }
            tx.success();
        }
        tx = this.db.beginTx();
        var4_3 = null;
        try {
            this.createSimpleNodesIndex();
            tx.success();
        }
        catch (Throwable i) {
            var4_3 = i;
            throw i;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable i) {
                        var4_3.addSuppressed(i);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var4_3 = null;
        try {
            try (Result result = this.db.execute(String.format(QUERY_NODES, "nodes", "value"));
                 Stream stream = result.stream();){
                Assert.assertThat((Object)stream.count(), (Matcher)Matchers.is((Object)nodeCount));
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryingIndexInPopulatingStateMustBlockUntilIndexIsOnlineEvenWhenTransactionHasState() {
        this.db = this.createDatabase();
        long nodeCount = 10000L;
        try (Transaction tx = this.db.beginTx();){
            int i = 0;
            while ((long)i < nodeCount) {
                this.db.createNode(new Label[]{LABEL}).setProperty(PROP, (Object)"value");
                ++i;
            }
            tx.success();
        }
        tx = this.db.beginTx();
        var4_3 = null;
        try {
            this.createSimpleNodesIndex();
            tx.success();
        }
        catch (Throwable i) {
            var4_3 = i;
            throw i;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable i) {
                        var4_3.addSuppressed(i);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var4_3 = null;
        try {
            this.db.createNode(new Label[]{LABEL}).setProperty(PROP, (Object)"value");
            try (Result result = this.db.execute(String.format(QUERY_NODES, "nodes", "value"));
                 Stream stream = result.stream();){
                Assert.assertThat((Object)stream.count(), (Matcher)Matchers.is((Object)(nodeCount + 1L)));
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryingIndexInTransactionItWasCreatedInMustThrow() {
        this.db = this.createDatabase();
        try (Transaction ignore = this.db.beginTx();){
            this.createSimpleNodesIndex();
            this.expectedException.expect(QueryExecutionException.class);
            this.db.execute(String.format(QUERY_NODES, "nodes", "value")).close();
        }
    }

    @Test
    public void queryResultsMustNotIncludeNodesDeletedInOtherConcurrentlyCommittedTransactions() throws Exception {
        long nodeIdB;
        long nodeIdA;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            Node nodeA = this.db.createNode(new Label[]{LABEL});
            nodeA.setProperty(PROP, (Object)"value");
            nodeIdA = nodeA.getId();
            Node nodeB = this.db.createNode(new Label[]{LABEL});
            nodeB.setProperty(PROP, (Object)"value");
            nodeIdB = nodeB.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var6_10 = null;
        try {
            try (Result result = this.db.execute(String.format(QUERY_NODES, "nodes", "value"));){
                ThreadTestUtils.forkFuture(() -> {
                    try (Transaction forkedTx = this.db.beginTx();){
                        this.db.getNodeById(nodeIdA).delete();
                        this.db.getNodeById(nodeIdB).delete();
                        forkedTx.success();
                    }
                    return null;
                }).get();
                Assert.assertThat((Object)result.stream().count(), (Matcher)Matchers.is((Object)0L));
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var6_10 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_10 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_10.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryResultsMustNotIncludeRelationshipsDeletedInOtherConcurrentlyCommittedTransactions() throws Exception {
        long relIdB;
        long relIdA;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            Node node = this.db.createNode();
            Relationship relA = node.createRelationshipTo(node, REL);
            relA.setProperty(PROP, (Object)"value");
            relIdA = relA.getId();
            Relationship relB = node.createRelationshipTo(node, REL);
            relB.setProperty(PROP, (Object)"value");
            relIdB = relB.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var6_10 = null;
        try {
            try (Result result = this.db.execute(String.format(QUERY_RELS, "rels", "value"));){
                ThreadTestUtils.forkFuture(() -> {
                    try (Transaction forkedTx = this.db.beginTx();){
                        this.db.getRelationshipById(relIdA).delete();
                        this.db.getRelationshipById(relIdB).delete();
                        forkedTx.success();
                    }
                    return null;
                }).get();
                Assert.assertThat((Object)result.stream().count(), (Matcher)Matchers.is((Object)0L));
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var6_10 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_10 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_10.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryResultsMustNotIncludeNodesDeletedInThisTransaction() {
        long nodeIdB;
        long nodeIdA;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            Node nodeA = this.db.createNode(new Label[]{LABEL});
            nodeA.setProperty(PROP, (Object)"value");
            nodeIdA = nodeA.getId();
            Node nodeB = this.db.createNode(new Label[]{LABEL});
            nodeB.setProperty(PROP, (Object)"value");
            nodeIdB = nodeB.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var6_10 = null;
        try {
            this.db.getNodeById(nodeIdA).delete();
            this.db.getNodeById(nodeIdB).delete();
            try (Result result = this.db.execute(String.format(QUERY_NODES, "nodes", "value"));){
                Assert.assertThat((Object)result.stream().count(), (Matcher)Matchers.is((Object)0L));
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var6_10 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_10 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_10.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryResultsMustNotIncludeRelationshipsDeletedInThisTransaction() {
        long relIdB;
        long relIdA;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            Node node = this.db.createNode();
            Relationship relA = node.createRelationshipTo(node, REL);
            relA.setProperty(PROP, (Object)"value");
            relIdA = relA.getId();
            Relationship relB = node.createRelationshipTo(node, REL);
            relB.setProperty(PROP, (Object)"value");
            relIdB = relB.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var6_10 = null;
        try {
            this.db.getRelationshipById(relIdA).delete();
            this.db.getRelationshipById(relIdB).delete();
            try (Result result = this.db.execute(String.format(QUERY_RELS, "rels", "value"));){
                Assert.assertThat((Object)result.stream().count(), (Matcher)Matchers.is((Object)0L));
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var6_10 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_10 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_10.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryResultsMustIncludeNodesAddedInThisTransaction() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            Node node = this.db.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"value");
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "value", LongHashSet.newSetWith((long[])new long[]{node.getId()}));
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryResultsMustIncludeRelationshipsAddedInThisTransaction() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex();
            tx.success();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            Node node = this.db.createNode();
            Relationship relationship = node.createRelationshipTo(node, REL);
            relationship.setProperty(PROP, (Object)"value");
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "value", LongHashSet.newSetWith((long[])new long[]{relationship.getId()}));
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryResultsMustIncludeNodesWithPropertiesAddedToBeIndexed() {
        long nodeId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            nodeId = this.db.createNode(new Label[]{LABEL}).getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            this.db.getNodeById(nodeId).setProperty(PROP, (Object)"value");
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "prop:value", nodeId);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryResultsMustIncludeRelationshipsWithPropertiesAddedToBeIndexed() {
        long relId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            Node node = this.db.createNode();
            Relationship rel = node.createRelationshipTo(node, REL);
            relId = rel.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            Relationship rel = this.db.getRelationshipById(relId);
            rel.setProperty(PROP, (Object)"value");
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "prop:value", relId);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryResultsMustIncludeNodesWithLabelsModifedToBeIndexed() {
        long nodeId;
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            node = this.db.createNode();
            node.setProperty(PROP, (Object)"value");
            nodeId = node.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            node = this.db.getNodeById(nodeId);
            node.addLabel(LABEL);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "value", nodeId);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryResultsMustIncludeUpdatedValueOfChangedNodeProperties() {
        long nodeId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            Node node = this.db.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"primo");
            nodeId = node.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            this.db.getNodeById(nodeId).setProperty(PROP, (Object)"secundo");
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", new long[0]);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "secundo", nodeId);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryResultsMustIncludeUpdatedValuesOfChangedRelationshipProperties() {
        long relId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            Node node = this.db.createNode();
            Relationship rel = node.createRelationshipTo(node, REL);
            rel.setProperty(PROP, (Object)"primo");
            relId = rel.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            this.db.getRelationshipById(relId).setProperty(PROP, (Object)"secundo");
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", new long[0]);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "secundo", relId);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryResultsMustNotIncludeNodesWithRemovedIndexedProperties() {
        long nodeId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            Node node = this.db.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"value");
            nodeId = node.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            this.db.getNodeById(nodeId).removeProperty(PROP);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "value", new long[0]);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryResultsMustNotIncludeRelationshipsWithRemovedIndexedProperties() {
        long relId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            Node node = this.db.createNode();
            Relationship rel = node.createRelationshipTo(node, REL);
            rel.setProperty(PROP, (Object)"value");
            relId = rel.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            this.db.getRelationshipById(relId).removeProperty(PROP);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "value", new long[0]);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryResultsMustNotIncludeNodesWithRemovedIndexedLabels() {
        long nodeId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"value");
            nodeId = node.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            this.db.getNodeById(nodeId).removeLabel(LABEL);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "nodes", new long[0]);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryResultsMustIncludeOldNodePropertyValuesWhenModificationsAreUndone() {
        long nodeId;
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            node = this.db.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"primo");
            nodeId = node.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            node = this.db.getNodeById(nodeId);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", nodeId);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "secundo", new long[0]);
            node.setProperty(PROP, (Object)"secundo");
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", new long[0]);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "secundo", nodeId);
            node.setProperty(PROP, (Object)"primo");
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", nodeId);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "secundo", new long[0]);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryResultsMustIncludeOldRelationshipPropertyValuesWhenModificationsAreUndone() {
        long relId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            Node node = this.db.createNode();
            Relationship rel = node.createRelationshipTo(node, REL);
            rel.setProperty(PROP, (Object)"primo");
            relId = rel.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            Relationship rel = this.db.getRelationshipById(relId);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", relId);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "secundo", new long[0]);
            rel.setProperty(PROP, (Object)"secundo");
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", new long[0]);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "secundo", relId);
            rel.setProperty(PROP, (Object)"primo");
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", relId);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "secundo", new long[0]);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryResultsMustIncludeOldNodePropertyValuesWhenRemovalsAreUndone() {
        long nodeId;
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            node = this.db.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"primo");
            nodeId = node.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            node = this.db.getNodeById(nodeId);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", nodeId);
            node.removeProperty(PROP);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", new long[0]);
            node.setProperty(PROP, (Object)"primo");
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", nodeId);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryResultsMustIncludeOldRelationshipPropertyValuesWhenRemovalsAreUndone() {
        long relId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            Node node = this.db.createNode();
            Relationship rel = node.createRelationshipTo(node, REL);
            rel.setProperty(PROP, (Object)"primo");
            relId = rel.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            Relationship rel = this.db.getRelationshipById(relId);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", relId);
            rel.removeProperty(PROP);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", new long[0]);
            rel.setProperty(PROP, (Object)"primo");
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", relId);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryResultsMustIncludeNodesWhenNodeLabelRemovalsAreUndone() {
        long nodeId;
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            node = this.db.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"primo");
            nodeId = node.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var4_8 = null;
        try {
            node = this.db.getNodeById(nodeId);
            node.removeLabel(LABEL);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", new long[0]);
            node.addLabel(LABEL);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", nodeId);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryResultsFromTransactionStateMustSortTogetherWithResultFromBaseIndex() {
        long thirdId;
        long firstId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            Node first = this.db.createNode(new Label[]{LABEL});
            first.setProperty(PROP, (Object)"God of War");
            firstId = first.getId();
            Node third = this.db.createNode(new Label[]{LABEL});
            third.setProperty(PROP, (Object)"God Wars: Future Past");
            thirdId = third.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var8_11 = null;
        try {
            Node second = this.db.createNode(new Label[]{LABEL});
            second.setProperty(PROP, (Object)"God of War III Remastered");
            long secondId = second.getId();
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "god of war", firstId, secondId, thirdId);
            tx.success();
        }
        catch (Throwable throwable) {
            var8_11 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_11 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_11.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryingDroppedIndexForNodesInDroppingTransactionMustThrow() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.db.execute(String.format(DROP, "nodes")).close();
            this.expectedException.expect(QueryExecutionException.class);
            this.db.execute(String.format(QUERY_NODES, "nodes", "blabla"));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void queryingDroppedIndexForRelationshipsInDroppingTransactionMustThrow() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex();
            tx.success();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.db.execute(String.format(DROP, "rels")).close();
            this.expectedException.expect(QueryExecutionException.class);
            this.db.execute(String.format(QUERY_RELS, "rels", "blabla"));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void creatingAndDroppingIndexesInSameTransactionMustNotThrow() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            this.db.execute(String.format(DROP, "nodes")).close();
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.createSimpleRelationshipIndex();
            this.db.execute(String.format(DROP, "rels")).close();
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            Assert.assertFalse((boolean)this.db.schema().getIndexes().iterator().hasNext());
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void eventuallyConsistenIndexMustNotIncludeEntitiesAddedInTransaction() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.db.execute(String.format(NODE_CREATE, "nodes", FulltextProceduresTest.array(LABEL.name()), FulltextProceduresTest.array(PROP) + EVENTUALLY_CONSISTENT)).close();
            this.db.execute(String.format(RELATIONSHIP_CREATE, "rels", FulltextProceduresTest.array(REL.name()), FulltextProceduresTest.array(PROP) + EVENTUALLY_CONSISTENT)).close();
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.awaitIndexesOnline();
            Node node = this.db.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"value");
            node.createRelationshipTo(node, REL).setProperty(PROP, (Object)"value");
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "value", new long[0]);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "value", new long[0]);
            this.db.execute(AWAIT_REFRESH).close();
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "value", new long[0]);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "value", new long[0]);
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void transactionStateMustNotPreventIndexUpdatesFromBeingApplied() throws Exception {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            this.createSimpleRelationshipIndex();
            tx.success();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            Node node = this.db.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"value");
            Relationship rel = node.createRelationshipTo(node, REL);
            rel.setProperty(PROP, (Object)"value");
            LongHashSet nodeIds = new LongHashSet();
            LongHashSet relIds = new LongHashSet();
            nodeIds.add(node.getId());
            relIds.add(rel.getId());
            ExecutorService executor = (ExecutorService)this.cleanup.add((Object)Executors.newSingleThreadExecutor());
            executor.submit(() -> {
                try (Transaction forkedTx = this.db.beginTx();){
                    Node node2 = this.db.createNode(new Label[]{LABEL});
                    node2.setProperty(PROP, (Object)"value");
                    Relationship rel2 = node2.createRelationshipTo(node2, REL);
                    rel2.setProperty(PROP, (Object)"value");
                    nodeIds.add(node2.getId());
                    relIds.add(rel2.getId());
                    forkedTx.success();
                }
            }).get();
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "value", nodeIds);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "value", relIds);
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void dropMustNotApplyToRegularSchemaIndexes() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().indexFor(LABEL).on(PROP).create();
            tx.success();
        }
        this.awaitIndexesOnline();
        try (Transaction ignore = this.db.beginTx();){
            String schemaIndexName;
            try (Result result = this.db.execute("call db.indexes");){
                Assert.assertTrue((boolean)result.hasNext());
                schemaIndexName = result.next().get("indexName").toString();
            }
            this.expectedException.expect(QueryExecutionException.class);
            this.db.execute(String.format(DROP, schemaIndexName)).close();
        }
    }

    @Test
    public void fulltextIndexMustNotBeAvailableForRegularIndexSeeks() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        String valueToQueryFor = "value to query for";
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            List<Value> values = this.generateRandomSimpleValues();
            for (Value value : values) {
                this.db.createNode(new Label[]{LABEL}).setProperty(PROP, value.asObject());
            }
            this.db.createNode(new Label[]{LABEL}).setProperty(PROP, (Object)valueToQueryFor);
            tx.success();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PROP, valueToQueryFor);
        try (Result result = this.db.execute("profile match (n:" + LABEL.name() + ") where n." + PROP + " = {prop} return n", params);){
            this.assertNoIndexSeeks(result);
        }
        result = this.db.execute("cypher planner=rule profile match (n:" + LABEL.name() + ") where n." + PROP + " = {prop} return n", params);
        var4_7 = null;
        try {
            this.assertNoIndexSeeks(result);
        }
        catch (Throwable throwable) {
            var4_7 = throwable;
            throw throwable;
        }
        finally {
            if (result != null) {
                if (var4_7 != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable) {
                        var4_7.addSuppressed(throwable);
                    }
                } else {
                    result.close();
                }
            }
        }
        result = this.db.execute("cypher 2.3 profile match (n:" + LABEL.name() + ") where n." + PROP + " = {prop} return n", params);
        var4_7 = null;
        try {
            this.assertNoIndexSeeks(result);
        }
        catch (Throwable throwable) {
            var4_7 = throwable;
            throw throwable;
        }
        finally {
            if (result != null) {
                if (var4_7 != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable) {
                        var4_7.addSuppressed(throwable);
                    }
                } else {
                    result.close();
                }
            }
        }
        result = this.db.execute("cypher 3.1 profile match (n:" + LABEL.name() + ") where n." + PROP + " = {prop} return n", params);
        var4_7 = null;
        try {
            this.assertNoIndexSeeks(result);
        }
        catch (Throwable throwable) {
            var4_7 = throwable;
            throw throwable;
        }
        finally {
            if (result != null) {
                if (var4_7 != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable) {
                        var4_7.addSuppressed(throwable);
                    }
                } else {
                    result.close();
                }
            }
        }
        result = this.db.execute("cypher 3.4 profile match (n:" + LABEL.name() + ") where n." + PROP + " = {prop} return n", params);
        var4_7 = null;
        try {
            this.assertNoIndexSeeks(result);
        }
        catch (Throwable throwable) {
            var4_7 = throwable;
            throw throwable;
        }
        finally {
            if (result != null) {
                if (var4_7 != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable) {
                        var4_7.addSuppressed(throwable);
                    }
                } else {
                    result.close();
                }
            }
        }
    }

    @Test
    public void fulltextIndexMustNotBeAvailableForRegularIndexSeeksAfterShutDown() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        this.db.shutdown();
        this.db = this.createDatabase();
        String valueToQueryFor = "value to query for";
        try (Transaction tx = this.db.beginTx();){
            this.awaitIndexesOnline();
            List<Value> values = this.generateRandomSimpleValues();
            for (Value value : values) {
                this.db.createNode(new Label[]{LABEL}).setProperty(PROP, value.asObject());
            }
            this.db.createNode(new Label[]{LABEL}).setProperty(PROP, (Object)valueToQueryFor);
            tx.success();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PROP, valueToQueryFor);
        try (Result result = this.db.execute("profile match (n:" + LABEL.name() + ") where n." + PROP + " = {prop} return n", params);){
            this.assertNoIndexSeeks(result);
        }
        result = this.db.execute("cypher planner=rule profile match (n:" + LABEL.name() + ") where n." + PROP + " = {prop} return n", params);
        var4_7 = null;
        try {
            this.assertNoIndexSeeks(result);
        }
        catch (Throwable throwable) {
            var4_7 = throwable;
            throw throwable;
        }
        finally {
            if (result != null) {
                if (var4_7 != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable) {
                        var4_7.addSuppressed(throwable);
                    }
                } else {
                    result.close();
                }
            }
        }
        result = this.db.execute("cypher 2.3 profile match (n:" + LABEL.name() + ") where n." + PROP + " = {prop} return n", params);
        var4_7 = null;
        try {
            this.assertNoIndexSeeks(result);
        }
        catch (Throwable throwable) {
            var4_7 = throwable;
            throw throwable;
        }
        finally {
            if (result != null) {
                if (var4_7 != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable) {
                        var4_7.addSuppressed(throwable);
                    }
                } else {
                    result.close();
                }
            }
        }
        result = this.db.execute("cypher 3.1 profile match (n:" + LABEL.name() + ") where n." + PROP + " = {prop} return n", params);
        var4_7 = null;
        try {
            this.assertNoIndexSeeks(result);
        }
        catch (Throwable throwable) {
            var4_7 = throwable;
            throw throwable;
        }
        finally {
            if (result != null) {
                if (var4_7 != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable) {
                        var4_7.addSuppressed(throwable);
                    }
                } else {
                    result.close();
                }
            }
        }
        result = this.db.execute("cypher 3.4 profile match (n:" + LABEL.name() + ") where n." + PROP + " = {prop} return n", params);
        var4_7 = null;
        try {
            this.assertNoIndexSeeks(result);
        }
        catch (Throwable throwable) {
            var4_7 = throwable;
            throw throwable;
        }
        finally {
            if (result != null) {
                if (var4_7 != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable) {
                        var4_7.addSuppressed(throwable);
                    }
                } else {
                    result.close();
                }
            }
        }
    }

    @Test
    public void awaitIndexProcedureMustWorkOnIndexNames() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Node node = this.db.createNode(new Label[]{LABEL});
                node.setProperty(PROP, (Object)"value");
                Relationship rel = node.createRelationshipTo(node, REL);
                rel.setProperty(PROP, (Object)"value");
            }
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.createSimpleNodesIndex();
            this.createSimpleRelationshipIndex();
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.db.execute(String.format(DB_AWAIT_INDEX, "nodes")).close();
            this.db.execute(String.format(DB_AWAIT_INDEX, "rels")).close();
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void mustBePossibleToDropFulltextIndexByNameForWhichNormalIndexExistWithMatchingSchema() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.db.execute("CREATE INDEX ON :Person(name)").close();
            this.db.execute("call db.index.fulltext.createNodeIndex('nameIndex', ['Person'], ['name'])").close();
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.db.execute("call db.index.fulltext.drop('nameIndex')").close();
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            Assert.assertThat((Object)((IndexDefinition)Iterables.single((Iterable)this.db.schema().getIndexes())).getName(), (Matcher)Matchers.is((Matcher)Matchers.not((Object)"nameIndex")));
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void fulltextIndexesMustNotPreventNormalSchemaIndexesFromBeingDropped() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.db.execute("CREATE INDEX ON :Person(name)").close();
            this.db.execute("call db.index.fulltext.createNodeIndex('nameIndex', ['Person'], ['name'])").close();
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.db.execute("DROP INDEX ON :Person(name)").close();
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            Assert.assertThat((Object)((IndexDefinition)Iterables.single((Iterable)this.db.schema().getIndexes())).getName(), (Matcher)Matchers.is((Object)"nameIndex"));
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void creatingNormalIndexWithFulltextProviderMustThrow() {
        Throwable throwable;
        Transaction tx;
        this.db = this.createDatabase();
        Assert.assertThat((Object)FulltextIndexProviderFactory.DESCRIPTOR.name(), (Matcher)Matchers.is((Object)"fulltext-1.0"));
        try {
            tx = this.db.beginTx();
            throwable = null;
            try {
                this.db.execute("call db.createIndex( \":User(searchableString)\", \"" + FulltextIndexProviderFactory.DESCRIPTOR.name() + "\" );").close();
                tx.success();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (QueryExecutionException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"only supports fulltext index descriptors"));
        }
        tx = this.db.beginTx();
        throwable = null;
        try {
            long indexCount = this.db.execute(DB_INDEXES).stream().count();
            Assert.assertThat((Object)indexCount, (Matcher)Matchers.is((Object)0L));
            tx.success();
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void mustSupportWildcardEndsLikeStartsWith() {
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        LongHashSet ids = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"abcdef");
            ids.add(node.getId());
            tx.success();
        }
        tx = this.db.beginTx();
        var3_5 = null;
        try {
            node = this.db.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"abcxyz");
            ids.add(node.getId());
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "abc*", ids);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void mustSupportWildcardBeginningsLikeEndsWith() {
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        LongHashSet ids = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"defabc");
            ids.add(node.getId());
            tx.success();
        }
        tx = this.db.beginTx();
        var3_5 = null;
        try {
            node = this.db.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"xyzabc");
            ids.add(node.getId());
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "*abc", ids);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void mustSupportWildcardBeginningsAndEndsLikeContains() {
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex();
            tx.success();
        }
        LongHashSet ids = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"defabcdef");
            ids.add(node.getId());
            tx.success();
        }
        tx = this.db.beginTx();
        var3_5 = null;
        try {
            node = this.db.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"xyzabcxyz");
            ids.add(node.getId());
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "*abc*", ids);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void assertNoIndexSeeks(Result result) {
        Assert.assertThat((Object)result.stream().count(), (Matcher)Matchers.is((Object)1L));
        String planDescription = result.getExecutionPlanDescription().toString();
        Assert.assertThat((Object)planDescription, (Matcher)Matchers.containsString((String)"NodeByLabel"));
        Assert.assertThat((Object)planDescription, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"IndexSeek")));
    }

    private GraphDatabaseAPI createDatabase() {
        return (GraphDatabaseAPI)this.cleanup.add((Object)this.builder.newGraphDatabase());
    }

    private void awaitIndexesOnline() {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
    }

    static void assertQueryFindsIds(GraphDatabaseService db, boolean queryNodes, String index, String query, long ... ids) {
        try (Transaction tx = db.beginTx();){
            String queryCall = queryNodes ? QUERY_NODES : QUERY_RELS;
            Result result = db.execute(String.format(queryCall, index, query));
            int num = 0;
            Double score = Double.MAX_VALUE;
            while (result.hasNext()) {
                Map entry = result.next();
                Long nextId = ((Entity)entry.get(queryNodes ? NODE : RELATIONSHIP)).getId();
                Double nextScore = (Double)entry.get(SCORE);
                Assert.assertThat((Object)nextScore, (Matcher)Matchers.lessThanOrEqualTo((Comparable)score));
                score = nextScore;
                if (num < ids.length) {
                    Assert.assertEquals((String)String.format("Result returned id %d, expected %d", nextId, ids[num]), (long)ids[num], (long)nextId);
                } else {
                    Assert.fail((String)String.format("Result returned id %d, which is beyond the number of ids (%d) that were expected.", nextId, ids.length));
                }
                ++num;
            }
            Assert.assertEquals((String)"Number of results differ from expected", (long)ids.length, (long)num);
            tx.success();
        }
    }

    static void assertQueryFindsIds(GraphDatabaseService db, boolean queryNodes, String index, String query, LongHashSet ids) {
        String queryCall;
        ids = new LongHashSet(ids);
        String string = queryCall = queryNodes ? QUERY_NODES : QUERY_RELS;
        LongFunction<Entity> getEntity = queryNodes ? arg_0 -> ((GraphDatabaseService)db).getNodeById(arg_0) : arg_0 -> ((GraphDatabaseService)db).getRelationshipById(arg_0);
        long[] expectedIds = ids.toArray();
        LongHashSet actualIds = new LongHashSet();
        try (Transaction tx = db.beginTx();){
            Result result = db.execute(String.format(queryCall, index, query));
            Double score = Double.MAX_VALUE;
            while (result.hasNext()) {
                Map entry = result.next();
                long nextId = ((Entity)entry.get(queryNodes ? NODE : RELATIONSHIP)).getId();
                Double nextScore = (Double)entry.get(SCORE);
                Assert.assertThat((Object)nextScore, (Matcher)Matchers.lessThanOrEqualTo((Comparable)score));
                score = nextScore;
                actualIds.add(nextId);
                if (ids.remove(nextId)) continue;
                String msg = "This id was not expected: " + nextId;
                FulltextProceduresTest.failQuery(getEntity, index, query, (MutableLongSet)ids, expectedIds, (MutableLongSet)actualIds, msg);
            }
            if (!ids.isEmpty()) {
                String msg = "Not all expected ids were found: " + ids;
                FulltextProceduresTest.failQuery(getEntity, index, query, (MutableLongSet)ids, expectedIds, (MutableLongSet)actualIds, msg);
            }
            tx.success();
        }
    }

    private static void failQuery(LongFunction<Entity> getEntity, String index, String query, MutableLongSet ids, long[] expectedIds, MutableLongSet actualIds, String msg) {
        Entity entity;
        long id;
        StringBuilder message = new StringBuilder(msg).append('\n');
        MutableLongIterator itr = ids.longIterator();
        while (itr.hasNext()) {
            id = itr.next();
            entity = getEntity.apply(id);
            message.append('\t').append(entity).append(entity.getAllProperties()).append('\n');
        }
        message.append("for query: '").append(query).append("'\nin index: ").append(index).append('\n');
        message.append("all expected ids: ").append(Arrays.toString(expectedIds)).append('\n');
        message.append("actual ids: ").append(actualIds);
        itr = actualIds.longIterator();
        while (itr.hasNext()) {
            id = itr.next();
            entity = getEntity.apply(id);
            message.append("\n\t").append(entity).append(entity.getAllProperties());
        }
        Assert.fail((String)message.toString());
    }

    static String array(String ... args) {
        return Arrays.stream(args).map(s -> "\"" + s + "\"").collect(Collectors.joining(", ", "[", "]"));
    }

    private List<Value> generateRandomNonStringValues() {
        Predicate<Value> nonString = v -> v.valueGroup() != ValueGroup.TEXT;
        return this.generateRandomValues(nonString);
    }

    private List<Value> generateRandomSimpleValues() {
        EnumSet<ValueGroup> simpleTypes = EnumSet.of(ValueGroup.BOOLEAN, ValueGroup.BOOLEAN_ARRAY, ValueGroup.NUMBER, ValueGroup.NUMBER_ARRAY);
        return this.generateRandomValues(v -> simpleTypes.contains(v.valueGroup()));
    }

    private List<Value> generateRandomValues(Predicate<Value> predicate) {
        int valuesToGenerate = 1000;
        RandomValues generator = RandomValues.create();
        ArrayList<Value> values = new ArrayList<Value>(valuesToGenerate);
        for (int i = 0; i < valuesToGenerate; ++i) {
            Value value;
            while (!predicate.test(value = generator.nextValue())) {
            }
            values.add(value);
        }
        return values;
    }

    private String quoteValueForQuery(Value value) {
        return QueryParserUtil.escape((String)value.prettyPrint()).replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private void createSimpleRelationshipIndex() {
        this.db.execute(String.format(RELATIONSHIP_CREATE, "rels", FulltextProceduresTest.array(REL.name()), FulltextProceduresTest.array(PROP))).close();
    }

    private void createSimpleNodesIndex() {
        this.db.execute(String.format(NODE_CREATE, "nodes", FulltextProceduresTest.array(LABEL.name()), FulltextProceduresTest.array(PROP))).close();
    }
}

