/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.TestLabels;

@RunWith(value=Parameterized.class)
public class DefaultSchemaIndexConfigTest {
    private static final String KEY = "key";
    private static final TestLabels LABEL = TestLabels.LABEL_ONE;
    private static final GraphDatabaseBuilder dbBuilder = new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder();
    @Parameterized.Parameter
    public GraphDatabaseSettings.SchemaIndex provider;

    @Parameterized.Parameters(name="{0}")
    public static List<GraphDatabaseSettings.SchemaIndex> providers() {
        ArrayList<GraphDatabaseSettings.SchemaIndex> providers = new ArrayList<GraphDatabaseSettings.SchemaIndex>(Arrays.asList(GraphDatabaseSettings.SchemaIndex.values()));
        providers.add(null);
        return providers;
    }

    @Test
    public void shouldUseConfiguredIndexProvider() throws IndexNotFoundKernelException {
        GraphDatabaseService db = dbBuilder.setConfig(GraphDatabaseSettings.default_schema_provider, this.provider == null ? null : this.provider.providerName()).newGraphDatabase();
        try {
            this.createIndex(db);
            this.assertIndexProvider(db, this.provider == null ? GenericNativeIndexProvider.DESCRIPTOR.name() : this.provider.providerName());
        }
        finally {
            db.shutdown();
        }
    }

    private void assertIndexProvider(GraphDatabaseService db, String expectedProviderIdentifier) throws IndexNotFoundKernelException {
        GraphDatabaseAPI graphDatabaseAPI = (GraphDatabaseAPI)db;
        try (Transaction tx = graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((ThreadToStatementContextBridge)graphDatabaseAPI.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
            TokenRead tokenRead = ktx.tokenRead();
            int labelId = tokenRead.nodeLabel(LABEL.name());
            int propertyId = tokenRead.propertyKey(KEY);
            IndexReference index = ktx.schemaRead().index(labelId, new int[]{propertyId});
            Assert.assertEquals((String)"expected IndexProvider.Descriptor", (Object)expectedProviderIdentifier, (Object)new IndexProviderDescriptor(index.providerKey(), index.providerVersion()).name());
            tx.success();
        }
    }

    private void createIndex(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            db.schema().indexFor((Label)LABEL).on(KEY).create();
            tx.success();
        }
        tx = db.beginTx();
        var3_3 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

