/*
 * Decompiled with CFR 0.152.
 */
package examples;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.test.TestGraphDatabaseFactory;

public class RelatedNodesQuestionTest {
    @Test
    public void question5346011() {
        GraphDatabaseService service = new TestGraphDatabaseFactory().newImpermanentDatabase();
        try (Transaction tx = service.beginTx();){
            RelationshipIndex index = service.index().forRelationships("exact");
            Node node1 = service.createNode();
            Node node2 = service.createNode();
            String uuid = "xyz";
            Relationship relationship = node1.createRelationshipTo(node2, RelationshipType.withName((String)"related"));
            index.add((PropertyContainer)relationship, "uuid", (Object)uuid);
            try (IndexHits hits = index.get("uuid", (Object)uuid, node1, node2);){
                Assert.assertEquals((long)1L, (long)hits.size());
            }
            tx.success();
        }
        service.shutdown();
    }
}

