/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.test.rule.concurrent.OtherThreadRule;

public class NestedIndexReadersIT {
    private static final int NODE_PER_ID = 3;
    private static final int IDS = 5;
    private static final Label LABEL = Label.label((String)"Label");
    private static final String KEY = "key";
    @Rule
    public final ImpermanentDatabaseRule db = new ImpermanentDatabaseRule();
    @Rule
    public final OtherThreadRule<Void> t2 = new OtherThreadRule();

    @Test
    public void shouldReadCorrectResultsFromMultipleNestedReaders() {
        this.createIndex();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 3; ++i) {
                this.createRoundOfNodes();
            }
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            ArrayList<ResourceIterator<Node>> iterators = new ArrayList<ResourceIterator<Node>>();
            for (int id = 0; id < 5; ++id) {
                iterators.add((ResourceIterator<Node>)this.db.findNodes(LABEL, KEY, (Object)id));
            }
            for (int i = 0; i < 3; ++i) {
                this.assertRoundOfNodes(iterators);
            }
            for (ResourceIterator resourceIterator : iterators) {
                Assert.assertFalse((boolean)resourceIterator.hasNext());
                resourceIterator.close();
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldReadCorrectResultsFromMultipleNestedReadersWhenConcurrentWriteHappens() throws Exception {
        int i;
        this.createIndex();
        try (Transaction tx = this.db.beginTx();){
            for (int id = 0; id < 5; ++id) {
                for (i = 0; i < 3; ++i) {
                    this.db.createNode(new Label[]{LABEL}).setProperty(KEY, (Object)id);
                }
            }
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            ArrayList<ResourceIterator<Node>> iterators = new ArrayList<ResourceIterator<Node>>();
            for (int id = 0; id < 5; ++id) {
                iterators.add((ResourceIterator<Node>)this.db.findNodes(LABEL, KEY, (Object)id));
            }
            for (i = 0; i < 3; ++i) {
                this.assertRoundOfNodes(iterators);
                if (i % 2 != 1) continue;
                this.t2.execute(this.nodeCreator()).get();
            }
            this.assertRoundOfNodes(iterators);
            for (ResourceIterator resourceIterator : iterators) {
                Assert.assertFalse((boolean)resourceIterator.hasNext());
                resourceIterator.close();
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void createRoundOfNodes() {
        for (int id = 0; id < 5; ++id) {
            this.db.createNode(new Label[]{LABEL}).setProperty(KEY, (Object)id);
        }
    }

    private void assertRoundOfNodes(List<ResourceIterator<Node>> iterators) {
        for (int id = 0; id < 5; ++id) {
            this.assertNode(iterators.get(id), id);
        }
    }

    private OtherThreadExecutor.WorkerCommand<Void, Void> nodeCreator() {
        return state -> {
            try (Transaction tx = this.db.beginTx();){
                this.createRoundOfNodes();
                tx.success();
            }
            return null;
        };
    }

    private void assertNode(ResourceIterator<Node> reader, int id) {
        Assert.assertTrue((boolean)reader.hasNext());
        Node node = (Node)reader.next();
        Assert.assertTrue((boolean)node.hasLabel(LABEL));
        Assert.assertEquals((String)("Expected node " + node + " (returned by index reader) to have 'id' property w/ value " + id), (Object)id, (Object)node.getProperty(KEY));
    }

    private void createIndex() {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().indexFor(LABEL).on(KEY).create();
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

