/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
class IndexSamplingIntegrationTest {
    @Inject
    private DatabaseLayout databaseLayout;
    private final Label label = Label.label((String)"Person");
    private final String property = "name";
    private final String schemaName = "schema_name";
    private final long nodes = 1000L;
    private final String[] names = new String[]{"Neo4j", "Neo", "Graph", "Apa"};

    IndexSamplingIntegrationTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldSampleNotUniqueIndex() throws Throwable {
        DatabaseManagementService managementService = null;
        long deletedNodes = 0L;
        try {
            int i;
            IndexDefinition indexDefinition;
            managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).build();
            GraphDatabaseService db = managementService.database("neo4j");
            try (Transaction tx = db.beginTx();){
                indexDefinition = tx.schema().indexFor(this.label).on("name").withName("schema_name").create();
                tx.commit();
            }
            tx = db.beginTx();
            try {
                tx.schema().awaitIndexOnline(indexDefinition, 10L, TimeUnit.SECONDS);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            tx = db.beginTx();
            try {
                i = 0;
                while ((long)i < 1000L) {
                    tx.createNode(new Label[]{this.label}).setProperty("name", (Object)this.names[i % this.names.length]);
                    ++i;
                }
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            tx = db.beginTx();
            try {
                i = 0;
                while ((long)i < 100L) {
                    try (ResourceIterator nodes = tx.findNodes(this.label, "name", (Object)this.names[i % this.names.length]);){
                        ((Node)nodes.next()).delete();
                    }
                    ++deletedNodes;
                    ++i;
                }
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        finally {
            if (managementService != null) {
                managementService.shutdown();
            }
        }
        this.triggerIndexResamplingOnNextStartup();
        Register.DoubleLongRegister register = this.fetchIndexSamplingValues();
        Assertions.assertEquals((long)this.names.length, (long)register.readFirst());
        MatcherAssert.assertThat((Object)register.readSecond(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1000L - deletedNodes)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(1000L))));
        Register.DoubleLongRegister indexSizeRegister = this.fetchIndexSizeValues();
        Assertions.assertEquals((long)0L, (long)indexSizeRegister.readFirst());
        Assertions.assertEquals((long)(1000L - deletedNodes), (long)indexSizeRegister.readSecond());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldSampleUniqueIndex() throws Throwable {
        GraphDatabaseService db = null;
        DatabaseManagementService managementService = null;
        long deletedNodes = 0L;
        try {
            int i;
            managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).build();
            db = managementService.database("neo4j");
            try (Transaction tx = db.beginTx();){
                tx.schema().constraintFor(this.label).assertPropertyIsUnique("name").withName("schema_name").create();
                tx.commit();
            }
            tx = db.beginTx();
            try {
                i = 0;
                while ((long)i < 1000L) {
                    tx.createNode(new Label[]{this.label}).setProperty("name", (Object)("" + i));
                    ++i;
                }
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            tx = db.beginTx();
            try {
                i = 0;
                while ((long)i < 1000L) {
                    if (i % 10 == 0) {
                        ++deletedNodes;
                        tx.findNode(this.label, "name", (Object)("" + i)).delete();
                    }
                    ++i;
                }
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        finally {
            if (db != null) {
                managementService.shutdown();
            }
        }
        this.triggerIndexResamplingOnNextStartup();
        Register.DoubleLongRegister indexSampleRegister = this.fetchIndexSamplingValues();
        Assertions.assertEquals((long)(1000L - deletedNodes), (long)indexSampleRegister.readFirst());
        Assertions.assertEquals((long)(1000L - deletedNodes), (long)indexSampleRegister.readSecond());
        Register.DoubleLongRegister indexSizeRegister = this.fetchIndexSizeValues();
        Assertions.assertEquals((long)0L, (long)indexSizeRegister.readFirst());
        Assertions.assertEquals((long)(1000L - deletedNodes), (long)indexSizeRegister.readSecond());
    }

    private IndexDescriptor indexId(KernelTransaction tx) {
        return tx.schemaRead().indexGetForName("schema_name");
    }

    private Register.DoubleLongRegister fetchIndexSamplingValues() throws IndexNotFoundKernelException, TransactionFailureException {
        DatabaseManagementService managementService = null;
        try {
            Register.DoubleLongRegister doubleLongRegister;
            block10: {
                managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).build();
                GraphDatabaseService db = managementService.database("neo4j");
                GraphDatabaseAPI api = (GraphDatabaseAPI)db;
                Kernel kernel = (Kernel)api.getDependencyResolver().resolveDependency(Kernel.class);
                KernelTransaction tx = kernel.beginTransaction(KernelTransaction.Type.explicit, LoginContext.AUTH_DISABLED);
                try {
                    doubleLongRegister = tx.schemaRead().indexSample(this.indexId(tx), Registers.newDoubleLongRegister());
                    if (tx == null) break block10;
                }
                catch (Throwable throwable) {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tx.close();
            }
            return doubleLongRegister;
        }
        finally {
            if (managementService != null) {
                managementService.shutdown();
            }
        }
    }

    private Register.DoubleLongRegister fetchIndexSizeValues() throws IndexNotFoundKernelException, TransactionFailureException {
        DatabaseManagementService managementService = null;
        try {
            Register.DoubleLongRegister doubleLongRegister;
            block10: {
                managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).build();
                GraphDatabaseService db = managementService.database("neo4j");
                GraphDatabaseAPI api = (GraphDatabaseAPI)db;
                Kernel kernel = (Kernel)api.getDependencyResolver().resolveDependency(Kernel.class);
                KernelTransaction tx = kernel.beginTransaction(KernelTransaction.Type.explicit, LoginContext.AUTH_DISABLED);
                try {
                    doubleLongRegister = tx.schemaRead().indexUpdatesAndSize(this.indexId(tx), Registers.newDoubleLongRegister());
                    if (tx == null) break block10;
                }
                catch (Throwable throwable) {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tx.close();
            }
            return doubleLongRegister;
        }
        finally {
            if (managementService != null) {
                managementService.shutdown();
            }
        }
    }

    private void triggerIndexResamplingOnNextStartup() {
        FileUtils.deleteFile((File)this.databaseLayout.countStore());
    }
}

