/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

@RunWith(value=Parameterized.class)
public class IndexingServiceIntegrationTest {
    private static final String FOOD_LABEL = "food";
    private static final String CLOTHES_LABEL = "clothes";
    private static final String WEATHER_LABEL = "weather";
    private static final String PROPERTY_NAME = "name";
    private static final int NUMBER_OF_NODES = 100;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    private GraphDatabaseService database;
    private DatabaseManagementService managementService;
    @Parameterized.Parameter
    public GraphDatabaseSettings.SchemaIndex schemaIndex;

    @Parameterized.Parameters(name="{0}")
    public static GraphDatabaseSettings.SchemaIndex[] parameters() {
        return GraphDatabaseSettings.SchemaIndex.values();
    }

    @Before
    public void setUp() {
        EphemeralFileSystemAbstraction fileSystem = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        this.managementService = new TestDatabaseManagementServiceBuilder().setFileSystem((FileSystemAbstraction)fileSystem).impermanent().setConfig(GraphDatabaseSettings.default_schema_provider, (Object)this.schemaIndex.providerName()).build();
        this.database = this.managementService.database("neo4j");
        this.createData(this.database);
    }

    @After
    public void tearDown() {
        try {
            this.managementService.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testManualIndexPopulation() throws InterruptedException, IndexNotFoundKernelException {
        IndexDescriptor index;
        try (Transaction tx = this.database.beginTx();){
            IndexDefinitionImpl indexDefinition = (IndexDefinitionImpl)tx.schema().indexFor(Label.label((String)FOOD_LABEL)).on(PROPERTY_NAME).create();
            index = indexDefinition.getIndexReference();
            tx.commit();
        }
        IndexingService indexingService = this.getIndexingService(this.database);
        IndexProxy indexProxy = indexingService.getIndexProxy(index);
        this.waitIndexOnline(indexProxy);
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)indexProxy.getState());
        PopulationProgress progress = indexProxy.getIndexPopulationProgress();
        Assert.assertEquals((long)progress.getCompleted(), (long)progress.getTotal());
    }

    @Test
    public void testManualRelationshipIndexPopulation() throws Exception {
        IndexDescriptor index;
        Kernel kernel = (Kernel)((GraphDatabaseAPI)this.database).getDependencyResolver().resolveDependency(Kernel.class);
        try (KernelTransaction tx = kernel.beginTransaction(KernelTransaction.Type.explicit, LoginContext.AUTH_DISABLED);){
            int foodId = tx.tokenWrite().relationshipTypeGetOrCreateForName(FOOD_LABEL);
            int propertyId = tx.tokenWrite().propertyKeyGetOrCreateForName(PROPERTY_NAME);
            RelationTypeSchemaDescriptor schema = SchemaDescriptor.forRelType((int)foodId, (int[])new int[]{propertyId});
            index = tx.schemaWrite().indexCreate((SchemaDescriptor)schema, "food names");
            tx.commit();
        }
        IndexingService indexingService = this.getIndexingService(this.database);
        IndexProxy indexProxy = indexingService.getIndexProxy(index);
        this.waitIndexOnline(indexProxy);
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)indexProxy.getState());
        PopulationProgress progress = indexProxy.getIndexPopulationProgress();
        Assert.assertEquals((long)progress.getCompleted(), (long)progress.getTotal());
    }

    @Test
    public void testSchemaIndexMatchIndexingService() throws IndexNotFoundKernelException {
        String constraintName = "MyConstraint";
        String indexName = "MyIndex";
        try (Transaction transaction = this.database.beginTx();){
            transaction.schema().constraintFor(Label.label((String)CLOTHES_LABEL)).assertPropertyIsUnique(PROPERTY_NAME).withName(constraintName).create();
            transaction.schema().indexFor(Label.label((String)WEATHER_LABEL)).on(PROPERTY_NAME).withName(indexName).create();
            transaction.commit();
        }
        try (Transaction tx = this.database.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        IndexingService indexingService = this.getIndexingService(this.database);
        IndexProxy clothesIndex = indexingService.getIndexProxy(this.getIndexByName(constraintName));
        IndexProxy weatherIndex = indexingService.getIndexProxy(this.getIndexByName(indexName));
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)clothesIndex.getState());
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)weatherIndex.getState());
    }

    @Test
    public void failForceIndexesWhenOneOfTheIndexesIsBroken() throws Exception {
        String constraintLabelPrefix = "ConstraintLabel";
        String constraintPropertyPrefix = "ConstraintProperty";
        String indexLabelPrefix = "Label";
        String indexPropertyPrefix = "Property";
        IndexDescriptor index7 = null;
        for (int i = 0; i < 10; ++i) {
            try (Transaction transaction = this.database.beginTx();){
                transaction.schema().constraintFor(Label.label((String)(constraintLabelPrefix + i))).assertPropertyIsUnique(constraintPropertyPrefix + i).create();
                IndexDefinition indexDefinition = transaction.schema().indexFor(Label.label((String)(indexLabelPrefix + i))).on(indexPropertyPrefix + i).create();
                if (i == 7) {
                    index7 = ((IndexDefinitionImpl)indexDefinition).getIndexReference();
                }
                transaction.commit();
                continue;
            }
        }
        try (Transaction tx = this.database.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        IndexingService indexingService = this.getIndexingService(this.database);
        assert (index7 != null);
        IndexProxy index = indexingService.getIndexProxy(index7);
        index.drop();
        this.expectedException.expect(UnderlyingStorageException.class);
        this.expectedException.expectMessage("Unable to force");
        indexingService.forceAll(IOLimiter.UNLIMITED);
    }

    private void waitIndexOnline(IndexProxy indexProxy) throws InterruptedException {
        while (InternalIndexState.ONLINE != indexProxy.getState()) {
            Thread.sleep(10L);
        }
    }

    private IndexingService getIndexingService(GraphDatabaseService database) {
        return (IndexingService)this.getDependencyResolver(database).resolveDependency(IndexingService.class);
    }

    private DependencyResolver getDependencyResolver(GraphDatabaseService database) {
        return ((GraphDatabaseAPI)database).getDependencyResolver();
    }

    private void createData(GraphDatabaseService database) {
        for (int i = 0; i < 100; ++i) {
            try (Transaction transaction = database.beginTx();){
                Node node = transaction.createNode(new Label[]{Label.label((String)FOOD_LABEL), Label.label((String)CLOTHES_LABEL), Label.label((String)WEATHER_LABEL)});
                node.setProperty(PROPERTY_NAME, (Object)("Node" + i));
                Relationship relationship = node.createRelationshipTo(node, RelationshipType.withName((String)FOOD_LABEL));
                relationship.setProperty(PROPERTY_NAME, (Object)("Relationship" + i));
                transaction.commit();
                continue;
            }
        }
    }

    private IndexDescriptor getIndexByName(String name) {
        try (Transaction tx = this.database.beginTx();){
            KernelTransaction transaction = ((InternalTransaction)tx).kernelTransaction();
            IndexDescriptor indexDescriptor = transaction.schemaRead().indexGetForName(name);
            return indexDescriptor;
        }
    }
}

