/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.lucene.queryparser.flexible.standard.QueryParserUtil;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexSettingImpl;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.api.exceptions.schema.RepeatedLabelInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedRelationshipTypeInSchemaException;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProceduresUtil;
import org.neo4j.kernel.api.impl.fulltext.FulltextSettings;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Level;
import org.neo4j.procedure.builtin.FulltextProcedures;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.ThreadTestUtils;
import org.neo4j.test.rule.CleanupRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.VerboseTimeout;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.util.concurrent.BinaryLatch;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class FulltextProceduresTest {
    private static final String SCORE = "score";
    private static final String NODE = "node";
    private static final String RELATIONSHIP = "relationship";
    private static final String DESCARTES_MEDITATIONES = "/meditationes--rene-descartes--public-domain.txt";
    private static final Label LABEL = Label.label((String)"Label");
    private static final RelationshipType REL = RelationshipType.withName((String)"REL");
    private final Timeout timeout = VerboseTimeout.builder().withTimeout(1L, TimeUnit.HOURS).build();
    private final DefaultFileSystemRule fs = new DefaultFileSystemRule();
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final ExpectedException expectedException = ExpectedException.none();
    private final CleanupRule cleanup = new CleanupRule();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.timeout).around((TestRule)this.fs).around((TestRule)this.testDirectory).around((TestRule)this.expectedException).around((TestRule)this.cleanup);
    private GraphDatabaseAPI db;
    private DatabaseManagementServiceBuilder builder;
    private static final String PROP = "prop";
    private static final String EVENTUALLY_CONSISTENT = ", {eventually_consistent: 'true'}";
    private static final String EVENTUALLY_CONSISTENT_PREFIXED = ", {`fulltext.eventually_consistent`: 'true'}";
    private DatabaseManagementService managementService;

    @Before
    public void before() {
        this.builder = new TestDatabaseManagementServiceBuilder(this.testDirectory.homeDir());
        this.builder.setConfig(GraphDatabaseSettings.store_internal_log_level, (Object)Level.DEBUG);
    }

    @After
    public void tearDown() {
        if (this.db != null) {
            this.managementService.shutdown();
        }
    }

    @Test
    public void createNodeFulltextIndex() {
        Map row;
        Result result;
        this.db = this.createDatabase();
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "test-index", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Label1", "Label2"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"prop1", "prop2"}))).close();
            transaction.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            result = tx.execute("CALL db.indexes()");
            Assert.assertTrue((boolean)result.hasNext());
            row = result.next();
            Assert.assertEquals(Arrays.asList("Label1", "Label2"), row.get("labelsOrTypes"));
            Assert.assertEquals(Arrays.asList("prop1", "prop2"), row.get("properties"));
            Assert.assertEquals((Object)"test-index", row.get("name"));
            Assert.assertEquals((Object)"FULLTEXT", row.get("type"));
            Assert.assertFalse((boolean)result.hasNext());
            result.close();
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            result = tx.execute("CALL db.indexes()");
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"ONLINE", result.next().get("state"));
            Assert.assertFalse((boolean)result.hasNext());
            result.close();
            Assert.assertNotNull((Object)tx.schema().getIndexByName("test-index"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        this.db = this.createDatabase();
        tx = this.db.beginTx();
        try {
            result = tx.execute("CALL db.indexes()");
            Assert.assertTrue((boolean)result.hasNext());
            row = result.next();
            Assert.assertEquals(Arrays.asList("Label1", "Label2"), row.get("labelsOrTypes"));
            Assert.assertEquals(Arrays.asList("prop1", "prop2"), row.get("properties"));
            Assert.assertEquals((Object)"test-index", row.get("name"));
            Assert.assertEquals((Object)"FULLTEXT", row.get("type"));
            Assert.assertEquals((Object)"ONLINE", row.get("state"));
            Assert.assertFalse((boolean)result.hasNext());
            Assert.assertFalse((boolean)result.hasNext());
            Assert.assertNotNull((Object)tx.schema().getIndexByName("test-index"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void createRelationshipFulltextIndex() {
        Map row;
        Result result;
        this.db = this.createDatabase();
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "test-index", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Reltype1", "Reltype2"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"prop1", "prop2"}))).close();
            transaction.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            result = tx.execute("CALL db.indexes()");
            Assert.assertTrue((boolean)result.hasNext());
            row = result.next();
            Assert.assertEquals(Arrays.asList("Reltype1", "Reltype2"), row.get("labelsOrTypes"));
            Assert.assertEquals(Arrays.asList("prop1", "prop2"), row.get("properties"));
            Assert.assertEquals((Object)"test-index", row.get("name"));
            Assert.assertEquals((Object)"FULLTEXT", row.get("type"));
            Assert.assertFalse((boolean)result.hasNext());
            result.close();
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            result = tx.execute("CALL db.indexes()");
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"ONLINE", result.next().get("state"));
            Assert.assertFalse((boolean)result.hasNext());
            result.close();
            Assert.assertNotNull((Object)tx.schema().getIndexByName("test-index"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        this.db = this.createDatabase();
        tx = this.db.beginTx();
        try {
            result = tx.execute("CALL db.indexes()");
            Assert.assertTrue((boolean)result.hasNext());
            row = result.next();
            Assert.assertEquals(Arrays.asList("Reltype1", "Reltype2"), row.get("labelsOrTypes"));
            Assert.assertEquals(Arrays.asList("prop1", "prop2"), row.get("properties"));
            Assert.assertEquals((Object)"test-index", row.get("name"));
            Assert.assertEquals((Object)"FULLTEXT", row.get("type"));
            Assert.assertEquals((Object)"ONLINE", row.get("state"));
            Assert.assertFalse((boolean)result.hasNext());
            Assert.assertFalse((boolean)result.hasNext());
            Assert.assertNotNull((Object)tx.schema().getIndexByName("test-index"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void dropIndex() {
        this.db = this.createDatabase();
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", NODE, FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Label1", "Label2"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"prop1", "prop2"}))).close();
            transaction.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rel", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Reltype1", "Reltype2"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"prop1", "prop2"}))).close();
            HashMap indexes = new HashMap();
            transaction.execute("call db.indexes()").forEachRemaining(m -> indexes.put((String)m.get("name"), (String)m.get("description")));
            transaction.execute(String.format("CALL db.index.fulltext.drop(\"%s\")", NODE));
            indexes.remove(NODE);
            HashMap newIndexes = new HashMap();
            transaction.execute("call db.indexes()").forEachRemaining(m -> newIndexes.put((String)m.get("name"), (String)m.get("description")));
            Assert.assertEquals(indexes, newIndexes);
            transaction.execute(String.format("CALL db.index.fulltext.drop(\"%s\")", "rel"));
            indexes.remove("rel");
            newIndexes.clear();
            transaction.execute("call db.indexes()").forEachRemaining(m -> newIndexes.put((String)m.get("name"), (String)m.get("description")));
            Assert.assertEquals(indexes, newIndexes);
            transaction.commit();
        }
    }

    @Test
    public void mustNotBeAbleToCreateTwoIndexesWithSameName() {
        this.db = this.createDatabase();
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", NODE, FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Label1", "Label2"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"prop1", "prop2"}))).close();
            transaction.commit();
        }
        this.expectedException.expectMessage("already exists");
        transaction = this.db.beginTx();
        try {
            transaction.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", NODE, FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Label1", "Label2"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"prop3", "prop4"}))).close();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    public void mustNotBeAbleToCreateNormalIndexWithSameNameAndSchemaAsExistingFulltextIndex() {
        this.db = this.createDatabase();
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", NODE, FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Label1"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"prop1"}))).close();
            transaction.commit();
        }
        this.expectedException.expectMessage("already exists");
        transaction = this.db.beginTx();
        try {
            transaction.execute("CREATE INDEX `node` FOR (n:Label1) ON (n.prop1)").close();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    public void mustNotBeAbleToCreateNormalIndexWithSameNameDifferentSchemaAsExistingFulltextIndex() {
        this.db = this.createDatabase();
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", NODE, FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Label1"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"prop1", "prop2"}))).close();
            transaction.commit();
        }
        this.expectedException.expectMessage("There already exists an index called 'node'.");
        transaction = this.db.beginTx();
        try {
            transaction.execute("CREATE INDEX `node` FOR (n:Label1) ON (n.prop1)").close();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    public void mustNotBeAbleToCreateFulltextIndexWithSameNameAndSchemaAsExistingNormalIndex() {
        this.db = this.createDatabase();
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute("CREATE INDEX `node` FOR (n:Label1) ON (n.prop1)").close();
            transaction.commit();
        }
        this.expectedException.expectMessage("already exists");
        transaction = this.db.beginTx();
        try {
            transaction.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", NODE, FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Label1"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"prop1"}))).close();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    public void mustNotBeAbleToCreateFulltextIndexWithSameNameDifferentSchemaAsExistingNormalIndex() {
        this.db = this.createDatabase();
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute("CREATE INDEX `node` FOR (n:Label1) ON (n.prop1)").close();
            transaction.commit();
        }
        this.expectedException.expectMessage("already exists");
        transaction = this.db.beginTx();
        try {
            transaction.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", NODE, FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Label1"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"prop1", "prop2"}))).close();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    public void nodeIndexesMustHaveLabels() {
        this.db = this.createDatabase();
        this.expectedException.expect(QueryExecutionException.class);
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodeIndex", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[0]), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}))).close();
        }
    }

    @Test
    public void relationshipIndexesMustHaveRelationshipTypes() {
        this.db = this.createDatabase();
        this.expectedException.expect(QueryExecutionException.class);
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "relIndex", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[0]), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP})));
        }
    }

    @Test
    public void nodeIndexesMustHaveProperties() {
        this.db = this.createDatabase();
        this.expectedException.expect(QueryExecutionException.class);
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodeIndex", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Label"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[0]))).close();
        }
    }

    @Test
    public void relationshipIndexesMustHaveProperties() {
        this.db = this.createDatabase();
        this.expectedException.expect(QueryExecutionException.class);
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "relIndex", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"RELTYPE"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[0])));
        }
    }

    @Test
    public void creatingIndexesWhichImpliesTokenCreateMustNotBlockForever() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodesA", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"SOME_LABEL"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"this"})));
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "relsA", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"SOME_REL_TYPE"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"foo"})));
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodesB", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"SOME_OTHER_LABEL"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"that"})));
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "relsB", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"SOME_OTHER_REL_TYPE"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"bar"})));
        }
    }

    @Test
    public void creatingIndexWithSpecificAnalyzerMustUseThatAnalyzerForPopulationUpdatingAndQuerying() {
        this.db = this.createDatabase();
        LongHashSet noResults = new LongHashSet();
        LongHashSet swedishNodes = new LongHashSet();
        LongHashSet englishNodes = new LongHashSet();
        LongHashSet swedishRels = new LongHashSet();
        LongHashSet englishRels = new LongHashSet();
        String labelledSwedishNodes = "labelledSwedishNodes";
        String typedSwedishRelationships = "typedSwedishRelationships";
        try (Transaction tx = this.db.beginTx();){
            Node nodeA = tx.createNode(new Label[]{LABEL});
            nodeA.setProperty(PROP, (Object)"En apa och en tomte bodde i ett hus.");
            swedishNodes.add(nodeA.getId());
            Node nodeB = tx.createNode(new Label[]{LABEL});
            nodeB.setProperty(PROP, (Object)"Hello and hello again, in the end.");
            englishNodes.add(nodeB.getId());
            Relationship relA = nodeA.createRelationshipTo(nodeB, REL);
            relA.setProperty(PROP, (Object)"En apa och en tomte bodde i ett hus.");
            swedishRels.add(relA.getId());
            Relationship relB = nodeB.createRelationshipTo(nodeA, REL);
            relB.setProperty(PROP, (Object)"Hello and hello again, in the end.");
            englishRels.add(relB.getId());
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            String lbl = FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{LABEL.name()});
            String rel = FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{REL.name()});
            String props = FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP});
            String swedish = props + ", {analyzer: 'swedish'}";
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", labelledSwedishNodes, lbl, swedish)).close();
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", typedSwedishRelationships, rel, swedish)).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            Node nodeC = tx.createNode(new Label[]{LABEL});
            nodeC.setProperty(PROP, (Object)"En apa och en tomte bodde i ett hus.");
            swedishNodes.add(nodeC.getId());
            Node nodeD = tx.createNode(new Label[]{LABEL});
            nodeD.setProperty(PROP, (Object)"Hello and hello again, in the end.");
            englishNodes.add(nodeD.getId());
            Relationship relC = nodeC.createRelationshipTo(nodeD, REL);
            relC.setProperty(PROP, (Object)"En apa och en tomte bodde i ett hus.");
            swedishRels.add(relC.getId());
            Relationship relD = nodeD.createRelationshipTo(nodeC, REL);
            relD.setProperty(PROP, (Object)"Hello and hello again, in the end.");
            englishRels.add(relD.getId());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, labelledSwedishNodes, "and", englishNodes);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, labelledSwedishNodes, "ett", noResults);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, labelledSwedishNodes, "apa", swedishNodes);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, typedSwedishRelationships, "and", englishRels);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, typedSwedishRelationships, "ett", noResults);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, typedSwedishRelationships, "apa", swedishRels);
    }

    @Test
    public void queryShouldFindDataAddedInLaterTransactions() {
        long horseRelId;
        long horseId;
        this.db = this.createDatabase();
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", NODE, FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Label1", "Label2"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"prop1", "prop2"}))).close();
            transaction.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rel", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Reltype1", "Reltype2"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"prop1", "prop2"}))).close();
            transaction.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node zebra = tx.createNode();
            zebra.setProperty("prop1", (Object)"zebra");
            Node horse = tx.createNode(new Label[]{Label.label((String)"Label1")});
            horse.setProperty("prop2", (Object)"horse");
            horse.setProperty("prop3", (Object)"zebra");
            Relationship horseRel = zebra.createRelationshipTo(horse, RelationshipType.withName((String)"Reltype1"));
            horseRel.setProperty("prop1", (Object)"horse");
            Relationship loop = horse.createRelationshipTo(horse, RelationshipType.withName((String)"loop"));
            loop.setProperty("prop2", (Object)"zebra");
            horseId = horse.getId();
            horseRelId = horseRel.getId();
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "horse", LongHashSet.newSetWith((long[])new long[]{horseId}));
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "horse zebra", LongHashSet.newSetWith((long[])new long[]{horseId}));
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "horse", LongHashSet.newSetWith((long[])new long[]{horseRelId}));
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "horse zebra", LongHashSet.newSetWith((long[])new long[]{horseRelId}));
    }

    @Test
    public void queryShouldFindDataAddedInIndexPopulation() {
        Relationship relationship;
        Node node2;
        Node node1;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            node1 = tx.createNode(new Label[]{LABEL});
            node1.setProperty(PROP, (Object)"This is a integration test.");
            node2 = tx.createNode(new Label[]{LABEL});
            node2.setProperty("otherprop", (Object)"This is a related integration test");
            relationship = node1.createRelationshipTo(node2, REL);
            relationship.setProperty(PROP, (Object)"They relate");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", NODE, FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP, "otherprop"})));
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rel", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP})));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "integration", node1.getId(), node2.getId());
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "test", node1.getId(), node2.getId());
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "related", LongHashSet.newSetWith((long[])new long[]{node2.getId()}));
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "relate", LongHashSet.newSetWith((long[])new long[]{relationship.getId()}));
    }

    @Test
    public void updatesToEventuallyConsistentIndexMustEventuallyBecomeVisible() {
        String value = "bla bla";
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", NODE, FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}) + EVENTUALLY_CONSISTENT));
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rel", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}) + EVENTUALLY_CONSISTENT));
            tx.commit();
        }
        int entityCount = 200;
        LongHashSet nodeIds = new LongHashSet();
        LongHashSet relIds = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < entityCount; ++i) {
                Node node = tx.createNode(new Label[]{LABEL});
                node.setProperty(PROP, (Object)value);
                Relationship rel = node.createRelationshipTo(node, REL);
                rel.setProperty(PROP, (Object)value);
                nodeIds.add(node.getId());
                relIds.add(rel.getId());
            }
            tx.commit();
        }
        long deadline = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(20L);
        boolean success = false;
        while (true) {
            try {
                FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "bla", nodeIds);
                FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "bla", relIds);
                success = true;
            }
            finally {
                if (!success) continue;
            }
            break;
        }
    }

    @Test
    public void updatesToEventuallyConsistentIndexMustBecomeVisibleAfterAwaitRefresh() {
        String value = "bla bla";
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", NODE, FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}) + EVENTUALLY_CONSISTENT));
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rel", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}) + EVENTUALLY_CONSISTENT));
            tx.commit();
        }
        this.awaitIndexesOnline();
        int entityCount = 200;
        LongHashSet nodeIds = new LongHashSet();
        LongHashSet relIds = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < entityCount; ++i) {
                Node node = tx.createNode(new Label[]{LABEL});
                node.setProperty(PROP, (Object)value);
                Relationship rel = node.createRelationshipTo(node, REL);
                rel.setProperty(PROP, (Object)value);
                nodeIds.add(node.getId());
                relIds.add(rel.getId());
            }
            tx.commit();
        }
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute("CALL db.index.fulltext.awaitEventuallyConsistentIndexRefresh()").close();
            transaction.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "bla", nodeIds);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "bla", relIds);
    }

    @Test
    public void eventuallyConsistentIndexMustPopulateWithExistingDataWhenCreated() {
        String value = "bla bla";
        this.db = this.createDatabase();
        int entityCount = 200;
        LongHashSet nodeIds = new LongHashSet();
        LongHashSet relIds = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < entityCount; ++i) {
                Node node = tx.createNode(new Label[]{LABEL});
                node.setProperty(PROP, (Object)value);
                Relationship rel = node.createRelationshipTo(node, REL);
                rel.setProperty(PROP, (Object)value);
                nodeIds.add(node.getId());
                relIds.add(rel.getId());
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", NODE, FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}) + EVENTUALLY_CONSISTENT));
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rel", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}) + EVENTUALLY_CONSISTENT));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "bla", nodeIds);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "bla", relIds);
    }

    @Test
    public void concurrentPopulationAndUpdatesToAnEventuallyConsistentIndexMustEventuallyResultInCorrectIndexState() throws Exception {
        String oldValue = "red";
        String newValue = "green";
        this.db = this.createDatabase();
        int entityCount = 200;
        LongHashSet nodeIds = new LongHashSet();
        LongHashSet relIds = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < entityCount; ++i) {
                Node node = tx.createNode(new Label[]{LABEL});
                node.setProperty(PROP, (Object)oldValue);
                Relationship rel = node.createRelationshipTo(node, REL);
                rel.setProperty(PROP, (Object)oldValue);
                nodeIds.add(node.getId());
                relIds.add(rel.getId());
            }
            tx.commit();
        }
        CountDownLatch readyLatch = new CountDownLatch(2);
        BinaryLatch startLatch = new BinaryLatch();
        Runnable createIndexes = () -> {
            readyLatch.countDown();
            startLatch.await();
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", NODE, FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}) + EVENTUALLY_CONSISTENT));
                tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rel", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}) + EVENTUALLY_CONSISTENT));
                tx.commit();
            }
        };
        Runnable makeAllEntitiesGreen = () -> {
            try (Transaction tx = this.db.beginTx();){
                nodeIds.forEach((LongProcedure & Serializable)nodeId -> tx.getNodeById(nodeId).setProperty(PROP, (Object)newValue));
                relIds.forEach((LongProcedure & Serializable)relId -> tx.getRelationshipById(relId).setProperty(PROP, (Object)newValue));
                tx.commit();
                readyLatch.countDown();
                startLatch.await();
            }
        };
        ExecutorService executor = (ExecutorService)this.cleanup.add((Object)Executors.newFixedThreadPool(2));
        Future<?> future1 = executor.submit(createIndexes);
        Future<?> future2 = executor.submit(makeAllEntitiesGreen);
        readyLatch.await();
        startLatch.release();
        future1.get();
        future2.get();
        this.awaitIndexesOnline();
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute("CALL db.index.fulltext.awaitEventuallyConsistentIndexRefresh()").close();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, newValue, nodeIds);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", newValue, relIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fulltextIndexesMustBeEventuallyConsistentByDefaultWhenThisIsConfigured() throws InterruptedException {
        long relId;
        this.builder.setConfig(FulltextSettings.eventually_consistent, (Object)true);
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", NODE, FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP, "otherprop"})));
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rel", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP})));
            tx.commit();
        }
        this.awaitIndexesOnline();
        BinaryLatch indexUpdateBlocker = new BinaryLatch();
        ((JobScheduler)this.db.getDependencyResolver().resolveDependency(JobScheduler.class)).schedule(Group.INDEX_UPDATING, () -> ((BinaryLatch)indexUpdateBlocker).await());
        LongHashSet nodeIds = new LongHashSet();
        try {
            try (Transaction tx = this.db.beginTx();){
                Node node1 = tx.createNode(new Label[]{LABEL});
                node1.setProperty(PROP, (Object)"bla bla");
                Node node2 = tx.createNode(new Label[]{LABEL});
                node2.setProperty("otherprop", (Object)"bla bla");
                Relationship relationship = node1.createRelationshipTo(node2, REL);
                relationship.setProperty(PROP, (Object)"bla bla");
                nodeIds.add(node1.getId());
                nodeIds.add(node2.getId());
                relId = relationship.getId();
                tx.commit();
            }
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "bla", new LongHashSet());
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "bla", new LongHashSet());
        }
        finally {
            Thread.sleep(10L);
            indexUpdateBlocker.release();
        }
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute("CALL db.index.fulltext.awaitEventuallyConsistentIndexRefresh()").close();
            transaction.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, NODE, "bla", nodeIds);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "bla", LongHashSet.newSetWith((long[])new long[]{relId}));
    }

    @Test
    public void mustBeAbleToListAvailableAnalyzers() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            HashSet<String> analyzers = new HashSet<String>();
            try (ResourceIterator iterator = tx.execute("CALL db.index.fulltext.listAvailableAnalyzers()").columnAs("analyzer");){
                while (iterator.hasNext()) {
                    analyzers.add((String)iterator.next());
                }
            }
            Assert.assertThat(analyzers, (Matcher)Matchers.hasItem((Object)"english"));
            Assert.assertThat(analyzers, (Matcher)Matchers.hasItem((Object)"swedish"));
            Assert.assertThat(analyzers, (Matcher)Matchers.hasItem((Object)"standard"));
            Assert.assertThat(analyzers, (Matcher)Matchers.hasItem((Object)"galician"));
            Assert.assertThat(analyzers, (Matcher)Matchers.hasItem((Object)"irish"));
            Assert.assertThat(analyzers, (Matcher)Matchers.hasItem((Object)"latvian"));
            Assert.assertThat(analyzers, (Matcher)Matchers.hasItem((Object)"sorani"));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            try (Result result = tx.execute("CALL db.index.fulltext.listAvailableAnalyzers()");){
                while (result.hasNext()) {
                    Map row = result.next();
                    Object description = row.get("description");
                    if (row.containsKey("description") && description instanceof String && !((String)description).trim().isEmpty()) continue;
                    Assert.fail((String)("Found no description for analyzer: " + row));
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void analyzersMustKnowTheirStopWords() {
        Object stopwords;
        Map row;
        Result result;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            result = tx.execute("CALL db.index.fulltext.listAvailableAnalyzers()");
            try {
                while (result.hasNext()) {
                    row = result.next();
                    stopwords = row.get("stopwords");
                    if (!row.containsKey("stopwords") || !(stopwords instanceof List)) {
                        Assert.fail((String)("Found no stop-words list for analyzer: " + row));
                    }
                    List words = (List)stopwords;
                    String analyzerName = (String)row.get("analyzer");
                    if (analyzerName.equals("english") || analyzerName.equals("standard")) {
                        Assert.assertThat((Object)words, (Matcher)Matchers.hasItem((Object)"and"));
                        continue;
                    }
                    if (!analyzerName.equals("standard-no-stop-words")) continue;
                    Assert.assertTrue((boolean)words.isEmpty());
                }
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            result = tx.execute("CALL db.index.fulltext.listAvailableAnalyzers()");
            try {
                while (result.hasNext()) {
                    row = result.next();
                    stopwords = (List)row.get("stopwords");
                    Iterator iterator = stopwords.iterator();
                    while (iterator.hasNext()) {
                        String stopword = (String)iterator.next();
                        if (!stopword.isBlank() && !stopword.contains("#") && !stopword.contains(" ")) continue;
                        Assert.fail((String)("The list of stop-words for the " + row.get("analyzer") + " analyzer contains dirty data. Specifically, '" + stopword + "' does not look like a valid stop-word. The full list:" + System.lineSeparator() + (List)stopwords));
                    }
                }
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void queryNodesMustThrowWhenQueryingRelationshipIndex() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            this.expectedException.expect(Exception.class);
            tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "rels", "bla bla")).next();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void queryRelationshipsMustThrowWhenQueryingNodeIndex() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            this.expectedException.expect(Exception.class);
            tx.execute(String.format("CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")", "nodes", "bla bla")).next();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void fulltextIndexMustIgnoreNonStringPropertiesForUpdate() {
        this.db = this.createDatabase();
        Label label = LABEL;
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{label.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}))).close();
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        List<Value> values = this.generateRandomNonStringValues();
        try (Transaction tx = this.db.beginTx();){
            for (Value value : values) {
                Node node = tx.createNode(new Label[]{label});
                Object propertyValue = value.asObject();
                node.setProperty(PROP, propertyValue);
                node.createRelationshipTo(node, REL).setProperty(PROP, propertyValue);
            }
            tx.commit();
        }
        for (Value value : values) {
            Transaction transaction = this.db.beginTx();
            try {
                Result nodes;
                String fulltextQuery = this.quoteValueForQuery(value);
                String cypherQuery = String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", fulltextQuery);
                try {
                    nodes = transaction.execute(cypherQuery);
                }
                catch (QueryExecutionException e) {
                    throw new AssertionError("Failed to execute query: " + cypherQuery + " based on value " + value.prettyPrint(), e);
                }
                if (nodes.hasNext()) {
                    Assert.fail((String)("did not expect to find any nodes, but found at least: " + nodes.next()));
                }
                nodes.close();
                Result relationships = transaction.execute(String.format("CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")", "rels", fulltextQuery));
                if (relationships.hasNext()) {
                    Assert.fail((String)("did not expect to find any relationships, but found at least: " + relationships.next()));
                }
                relationships.close();
                transaction.commit();
            }
            finally {
                if (transaction == null) continue;
                transaction.close();
            }
        }
    }

    @Test
    public void fulltextIndexMustIgnoreNonStringPropertiesForPopulation() {
        this.db = this.createDatabase();
        List<Value> values = this.generateRandomNonStringValues();
        try (Transaction tx = this.db.beginTx();){
            for (Value value : values) {
                Node node = tx.createNode(new Label[]{LABEL});
                Object propertyValue = value.asObject();
                node.setProperty(PROP, propertyValue);
                node.createRelationshipTo(node, REL).setProperty(PROP, propertyValue);
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            this.createSimpleNodesIndex(tx);
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        for (Value value : values) {
            Transaction transaction = this.db.beginTx();
            try {
                Result nodes;
                String fulltextQuery = this.quoteValueForQuery(value);
                String cypherQuery = String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", fulltextQuery);
                try {
                    nodes = transaction.execute(cypherQuery);
                }
                catch (QueryExecutionException e) {
                    throw new AssertionError("Failed to execute query: " + cypherQuery + " based on value " + value.prettyPrint(), e);
                }
                if (nodes.hasNext()) {
                    Assert.fail((String)("did not expect to find any nodes, but found at least: " + nodes.next()));
                }
                nodes.close();
                Result relationships = transaction.execute(String.format("CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")", "rels", fulltextQuery));
                if (relationships.hasNext()) {
                    Assert.fail((String)("did not expect to find any relationships, but found at least: " + relationships.next()));
                }
                relationships.close();
                transaction.commit();
            }
            finally {
                if (transaction == null) continue;
                transaction.close();
            }
        }
    }

    @Test
    public void entitiesMustBeRemovedFromFulltextIndexWhenPropertyValuesChangeAwayFromText() {
        long nodeId;
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            nodeId = node.getId();
            node.setProperty(PROP, (Object)"bla bla");
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.setProperty(PROP, (Object)42);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Result result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", "bla"));
            Assert.assertFalse((boolean)result.hasNext());
            result.close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void entitiesMustBeAddedToFulltextIndexWhenPropertyValuesChangeToText() {
        long nodeId;
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)42);
            nodeId = node.getId();
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.setProperty(PROP, (Object)"bla bla");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "bla", nodeId);
    }

    @Test
    public void propertiesMustBeRemovedFromFulltextIndexWhenTheirValueTypeChangesAwayFromText() {
        long nodeId;
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            nodeId = node.getId();
            node.setProperty("prop1", (Object)"foo");
            node.setProperty("prop2", (Object)"bar");
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.setProperty("prop2", (Object)42);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "foo", nodeId);
        tx = this.db.beginTx();
        try {
            Result result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", "bar"));
            Assert.assertFalse((boolean)result.hasNext());
            result.close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void propertiesMustBeAddedToFulltextIndexWhenTheirValueTypeChangesToText() {
        long nodeId;
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            nodeId = node.getId();
            node.setProperty("prop1", (Object)"foo");
            node.setProperty("prop2", (Object)42);
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.setProperty("prop2", (Object)"bar");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "foo", nodeId);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "bar", nodeId);
    }

    @Test
    public void mustBeAbleToIndexHugeTextPropertiesInIndexUpdates() throws Exception {
        long nodeId;
        String meditationes;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(DESCARTES_MEDITATIONES), StandardCharsets.UTF_8));){
            meditationes = reader.lines().collect(Collectors.joining("\n"));
        }
        this.db = this.createDatabase();
        Label label = Label.label((String)"Book");
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "books", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{label.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"title", "author", "contents"}))).close();
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{label});
            nodeId = node.getId();
            node.setProperty("title", (Object)"Meditationes de prima philosophia");
            node.setProperty("author", (Object)"Ren\u00e9 Descartes");
            node.setProperty("contents", (Object)meditationes);
            tx.commit();
        }
        this.awaitIndexesOnline();
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "books", "impellit scriptum offerendum", nodeId);
    }

    @Test
    public void mustBeAbleToIndexHugeTextPropertiesInIndexPopulation() throws Exception {
        long nodeId;
        String meditationes;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(DESCARTES_MEDITATIONES), StandardCharsets.UTF_8));){
            meditationes = reader.lines().collect(Collectors.joining("\n"));
        }
        this.db = this.createDatabase();
        Label label = Label.label((String)"Book");
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{label});
            nodeId = node.getId();
            node.setProperty("title", (Object)"Meditationes de prima philosophia");
            node.setProperty("author", (Object)"Ren\u00e9 Descartes");
            node.setProperty("contents", (Object)meditationes);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "books", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{label.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"title", "author", "contents"}))).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "books", "impellit scriptum offerendum", nodeId);
    }

    @Test
    public void mustBeAbleToQuerySpecificPropertiesViaLuceneSyntax() {
        long book2id;
        this.db = this.createDatabase();
        Label book = Label.label((String)"Book");
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "books", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{book.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"title", "author"}))).close();
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            Node book1 = tx.createNode(new Label[]{book});
            book1.setProperty("author", (Object)"Ren\u00e9 Descartes");
            book1.setProperty("title", (Object)"Meditationes de prima philosophia");
            Node book2 = tx.createNode(new Label[]{book});
            book2.setProperty("author", (Object)"E. M. Curley");
            book2.setProperty("title", (Object)"Descartes Against the Skeptics");
            book2id = book2.getId();
            tx.commit();
        }
        LongHashSet ids = LongHashSet.newSetWith((long[])new long[]{book2id});
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "books", "title:Descartes", ids);
    }

    @Test
    public void mustIndexNodesByCorrectProperties() {
        long nodeId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"a", "b", "c", "d", "e", "f"}))).close();
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{LABEL});
            node.setProperty("e", (Object)"value");
            nodeId = node.getId();
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "e:value", nodeId);
    }

    @Test
    public void queryingIndexInPopulatingStateMustBlockUntilIndexIsOnline() {
        this.db = this.createDatabase();
        long nodeCount = 10000L;
        try (Transaction tx = this.db.beginTx();){
            int i = 0;
            while ((long)i < nodeCount) {
                tx.createNode(new Label[]{LABEL}).setProperty(PROP, (Object)"value");
                ++i;
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            try (Result result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", "value"));
                 Stream stream = result.stream();){
                Assert.assertThat((Object)stream.count(), (Matcher)Matchers.is((Object)nodeCount));
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void queryingIndexInPopulatingStateMustBlockUntilIndexIsOnlineEvenWhenTransactionHasState() {
        this.db = this.createDatabase();
        long nodeCount = 10000L;
        try (Transaction tx = this.db.beginTx();){
            int i = 0;
            while ((long)i < nodeCount) {
                tx.createNode(new Label[]{LABEL}).setProperty(PROP, (Object)"value");
                ++i;
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.createNode(new Label[]{LABEL}).setProperty(PROP, (Object)"value");
            try (Result result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", "value"));
                 Stream stream = result.stream();){
                Assert.assertThat((Object)stream.count(), (Matcher)Matchers.is((Object)(nodeCount + 1L)));
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void queryingIndexInTransactionItWasCreatedInMustThrow() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            this.expectedException.expect(QueryExecutionException.class);
            tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", "value")).next();
        }
    }

    @Test
    public void queryResultsMustNotIncludeNodesDeletedInOtherConcurrentlyCommittedTransactions() throws Exception {
        long nodeIdB;
        long nodeIdA;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node nodeA = tx.createNode(new Label[]{LABEL});
            nodeA.setProperty(PROP, (Object)"value");
            nodeIdA = nodeA.getId();
            Node nodeB = tx.createNode(new Label[]{LABEL});
            nodeB.setProperty(PROP, (Object)"value");
            nodeIdB = nodeB.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            try (Result result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", "value"));){
                ThreadTestUtils.forkFuture(() -> {
                    try (Transaction forkedTx = this.db.beginTx();){
                        tx.getNodeById(nodeIdA).delete();
                        tx.getNodeById(nodeIdB).delete();
                        forkedTx.commit();
                    }
                    return null;
                }).get();
                Assert.assertThat((Object)result.stream().count(), (Matcher)Matchers.is((Object)0L));
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void queryResultsMustNotIncludeRelationshipsDeletedInOtherConcurrentlyCommittedTransactions() throws Exception {
        long relIdB;
        long relIdA;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            Relationship relA = node.createRelationshipTo(node, REL);
            relA.setProperty(PROP, (Object)"value");
            relIdA = relA.getId();
            Relationship relB = node.createRelationshipTo(node, REL);
            relB.setProperty(PROP, (Object)"value");
            relIdB = relB.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            try (Result result = tx.execute(String.format("CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")", "rels", "value"));){
                ThreadTestUtils.forkFuture(() -> {
                    try (Transaction forkedTx = this.db.beginTx();){
                        tx.getRelationshipById(relIdA).delete();
                        tx.getRelationshipById(relIdB).delete();
                        forkedTx.commit();
                    }
                    return null;
                }).get();
                Assert.assertThat((Object)result.stream().count(), (Matcher)Matchers.is((Object)0L));
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void queryResultsMustNotIncludeNodesDeletedInThisTransaction() {
        long nodeIdB;
        long nodeIdA;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node nodeA = tx.createNode(new Label[]{LABEL});
            nodeA.setProperty(PROP, (Object)"value");
            nodeIdA = nodeA.getId();
            Node nodeB = tx.createNode(new Label[]{LABEL});
            nodeB.setProperty(PROP, (Object)"value");
            nodeIdB = nodeB.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(nodeIdA).delete();
            tx.getNodeById(nodeIdB).delete();
            try (Result result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", "value"));){
                Assert.assertThat((Object)result.stream().count(), (Matcher)Matchers.is((Object)0L));
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void queryResultsMustNotIncludeRelationshipsDeletedInThisTransaction() {
        long relIdB;
        long relIdA;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            Relationship relA = node.createRelationshipTo(node, REL);
            relA.setProperty(PROP, (Object)"value");
            relIdA = relA.getId();
            Relationship relB = node.createRelationshipTo(node, REL);
            relB.setProperty(PROP, (Object)"value");
            relIdB = relB.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getRelationshipById(relIdA).delete();
            tx.getRelationshipById(relIdB).delete();
            try (Result result = tx.execute(String.format("CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")", "rels", "value"));){
                Assert.assertThat((Object)result.stream().count(), (Matcher)Matchers.is((Object)0L));
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void queryResultsMustIncludeNodesAddedInThisTransaction() {
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"value");
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "value", LongHashSet.newSetWith((long[])new long[]{node.getId()}));
    }

    @Test
    public void queryResultsMustIncludeRelationshipsAddedInThisTransaction() {
        Relationship relationship;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            relationship = node.createRelationshipTo(node, REL);
            relationship.setProperty(PROP, (Object)"value");
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "value", LongHashSet.newSetWith((long[])new long[]{relationship.getId()}));
    }

    @Test
    public void queryResultsMustIncludeNodesWithPropertiesAddedToBeIndexed() {
        long nodeId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            nodeId = tx.createNode(new Label[]{LABEL}).getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(nodeId).setProperty(PROP, (Object)"value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "prop:value", nodeId);
    }

    @Test
    public void queryResultsMustIncludeRelationshipsWithPropertiesAddedToBeIndexed() {
        long relId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            Relationship rel = node.createRelationshipTo(node, REL);
            relId = rel.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Relationship rel = tx.getRelationshipById(relId);
            rel.setProperty(PROP, (Object)"value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "prop:value", relId);
    }

    @Test
    public void queryResultsMustIncludeNodesWithLabelsModifedToBeIndexed() {
        long nodeId;
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            node.setProperty(PROP, (Object)"value");
            nodeId = node.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.addLabel(LABEL);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "value", nodeId);
    }

    @Test
    public void queryResultsMustIncludeUpdatedValueOfChangedNodeProperties() {
        long nodeId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"primo");
            nodeId = node.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(nodeId).setProperty(PROP, (Object)"secundo");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", new long[0]);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "secundo", nodeId);
    }

    @Test
    public void queryResultsMustIncludeUpdatedValuesOfChangedRelationshipProperties() {
        long relId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            Relationship rel = node.createRelationshipTo(node, REL);
            rel.setProperty(PROP, (Object)"primo");
            relId = rel.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getRelationshipById(relId).setProperty(PROP, (Object)"secundo");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", new long[0]);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "secundo", relId);
    }

    @Test
    public void queryResultsMustNotIncludeNodesWithRemovedIndexedProperties() {
        long nodeId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"value");
            nodeId = node.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(nodeId).removeProperty(PROP);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "value", new long[0]);
    }

    @Test
    public void queryResultsMustNotIncludeRelationshipsWithRemovedIndexedProperties() {
        long relId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            Relationship rel = node.createRelationshipTo(node, REL);
            rel.setProperty(PROP, (Object)"value");
            relId = rel.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getRelationshipById(relId).removeProperty(PROP);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "value", new long[0]);
    }

    @Test
    public void queryResultsMustNotIncludeNodesWithRemovedIndexedLabels() {
        long nodeId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"value");
            nodeId = node.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(nodeId).removeLabel(LABEL);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "nodes", new long[0]);
    }

    @Test
    public void queryResultsMustIncludeOldNodePropertyValuesWhenModificationsAreUndone() {
        long nodeId;
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"primo");
            nodeId = node.getId();
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", nodeId);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "secundo", new long[0]);
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.setProperty(PROP, (Object)"secundo");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", new long[0]);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "secundo", nodeId);
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.setProperty(PROP, (Object)"primo");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", nodeId);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "secundo", new long[0]);
    }

    @Test
    public void queryResultsMustIncludeOldRelationshipPropertyValuesWhenModificationsAreUndone() {
        Relationship rel;
        long relId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            Relationship rel2 = node.createRelationshipTo(node, REL);
            rel2.setProperty(PROP, (Object)"primo");
            relId = rel2.getId();
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", relId);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "secundo", new long[0]);
        tx = this.db.beginTx();
        try {
            rel = tx.getRelationshipById(relId);
            rel.setProperty(PROP, (Object)"secundo");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", new long[0]);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "secundo", relId);
        tx = this.db.beginTx();
        try {
            rel = tx.getRelationshipById(relId);
            rel.setProperty(PROP, (Object)"primo");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", relId);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "secundo", new long[0]);
    }

    @Test
    public void queryResultsMustIncludeOldNodePropertyValuesWhenRemovalsAreUndone() {
        long nodeId;
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"primo");
            nodeId = node.getId();
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", nodeId);
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.removeProperty(PROP);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", new long[0]);
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.setProperty(PROP, (Object)"primo");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", nodeId);
    }

    @Test
    public void queryResultsMustIncludeOldRelationshipPropertyValuesWhenRemovalsAreUndone() {
        Relationship rel;
        long relId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            Relationship rel2 = node.createRelationshipTo(node, REL);
            rel2.setProperty(PROP, (Object)"primo");
            relId = rel2.getId();
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", relId);
        tx = this.db.beginTx();
        try {
            rel = tx.getRelationshipById(relId);
            rel.removeProperty(PROP);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", new long[0]);
        tx = this.db.beginTx();
        try {
            rel = tx.getRelationshipById(relId);
            rel.setProperty(PROP, (Object)"primo");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", relId);
    }

    @Test
    public void queryResultsMustIncludeNodesWhenNodeLabelRemovalsAreUndone() {
        long nodeId;
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"primo");
            nodeId = node.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.removeLabel(LABEL);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", new long[0]);
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.addLabel(LABEL);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", nodeId);
    }

    @Test
    public void queryResultsFromTransactionStateMustSortTogetherWithResultFromBaseIndex() {
        long secondId;
        long thirdId;
        long firstId;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node first = tx.createNode(new Label[]{LABEL});
            first.setProperty(PROP, (Object)"God of War");
            firstId = first.getId();
            Node third = tx.createNode(new Label[]{LABEL});
            third.setProperty(PROP, (Object)"God Wars: Future Past");
            thirdId = third.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Node second = tx.createNode(new Label[]{LABEL});
            second.setProperty(PROP, (Object)"God of War III Remastered");
            secondId = second.getId();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "god of war", firstId, secondId, thirdId);
    }

    @Test
    public void queryResultsMustBeOrderedByScore() {
        long thirdId;
        long secondId;
        long firstId;
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"dude sweet");
            firstId = node.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"dude sweet dude sweet");
            secondId = node.getId();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"dude sweet dude dude dude sweet");
            thirdId = node.getId();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "dude", thirdId, secondId, firstId);
    }

    @Test
    public void queryingDroppedIndexForNodesInDroppingTransactionMustThrow() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.drop(\"%s\")", "nodes")).close();
            this.expectedException.expect(QueryExecutionException.class);
            tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", "blabla")).next();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void queryingDroppedIndexForRelationshipsInDroppingTransactionMustThrow() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.drop(\"%s\")", "rels")).close();
            this.expectedException.expect(QueryExecutionException.class);
            tx.execute(String.format("CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")", "rels", "blabla")).next();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void creatingAndDroppingIndexesInSameTransactionMustNotThrow() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.execute(String.format("CALL db.index.fulltext.drop(\"%s\")", "nodes")).close();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            this.createSimpleRelationshipIndex(tx);
            tx.execute(String.format("CALL db.index.fulltext.drop(\"%s\")", "rels")).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            Assert.assertFalse((boolean)tx.schema().getIndexes().iterator().hasNext());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void eventuallyConsistenIndexMustNotIncludeEntitiesAddedInTransaction() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}) + EVENTUALLY_CONSISTENT)).close();
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}) + EVENTUALLY_CONSISTENT)).close();
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            Node node = tx.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"value");
            node.createRelationshipTo(node, REL).setProperty(PROP, (Object)"value");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "value", new long[0]);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "value", new long[0]);
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute("CALL db.index.fulltext.awaitEventuallyConsistentIndexRefresh()").close();
            transaction.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "value", new long[0]);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "value", new long[0]);
    }

    @Test
    public void prefixedFulltextIndexSettingMustBeRecognized() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}) + EVENTUALLY_CONSISTENT_PREFIXED)).close();
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}) + EVENTUALLY_CONSISTENT_PREFIXED)).close();
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            for (IndexDefinition index : tx.schema().getIndexes()) {
                Map indexConfiguration = index.getIndexConfiguration();
                Object eventuallyConsistentObj = indexConfiguration.get(IndexSettingImpl.FULLTEXT_EVENTUALLY_CONSISTENT);
                Assert.assertNotNull(eventuallyConsistentObj);
                Assert.assertThat(eventuallyConsistentObj, (Matcher)Matchers.instanceOf(Boolean.class));
                Assert.assertEquals((Object)true, eventuallyConsistentObj);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void prefixedFulltextIndexSettingMustBeRecognizedTogetherWithNonPrefixed() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            String mixedPrefixConfig = ", {`fulltext.analyzer`: 'english', eventually_consistent: 'true'}";
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}) + mixedPrefixConfig)).close();
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}) + mixedPrefixConfig)).close();
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            for (IndexDefinition index : tx.schema().getIndexes()) {
                Map indexConfiguration = index.getIndexConfiguration();
                Object eventuallyConsistentObj = indexConfiguration.get(IndexSettingImpl.FULLTEXT_EVENTUALLY_CONSISTENT);
                Assert.assertNotNull(eventuallyConsistentObj);
                Assert.assertThat(eventuallyConsistentObj, (Matcher)Matchers.instanceOf(Boolean.class));
                Assert.assertEquals((Object)true, eventuallyConsistentObj);
                Object analyzerObj = indexConfiguration.get(IndexSettingImpl.FULLTEXT_ANALYZER);
                Assert.assertNotNull(analyzerObj);
                Assert.assertThat(analyzerObj, (Matcher)Matchers.instanceOf(String.class));
                Assert.assertEquals((Object)"english", analyzerObj);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void mustThrowOnDuplicateFulltextIndexSetting() {
        Throwable rootCause;
        Transaction tx;
        this.db = this.createDatabase();
        String duplicateConfig = ", {`fulltext.analyzer`: 'english', analyzer: 'swedish'}";
        try {
            tx = this.db.beginTx();
            try {
                tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}) + duplicateConfig)).close();
                Assert.fail((String)"Expected to fail");
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (QueryExecutionException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Config setting was specified more than once, 'analyzer'."));
            rootCause = ExceptionUtils.getRootCause((Throwable)e);
            Assert.assertThat((Object)rootCause, (Matcher)Matchers.instanceOf(IllegalArgumentException.class));
        }
        try {
            tx = this.db.beginTx();
            try {
                tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}) + duplicateConfig)).close();
                Assert.fail((String)"Expected to fail");
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (QueryExecutionException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Config setting was specified more than once, 'analyzer'."));
            rootCause = ExceptionUtils.getRootCause((Throwable)e);
            Assert.assertThat((Object)rootCause, (Matcher)Matchers.instanceOf(IllegalArgumentException.class));
        }
    }

    @Test
    public void transactionStateMustNotPreventIndexUpdatesFromBeingApplied() throws Exception {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        LongHashSet nodeIds = new LongHashSet();
        LongHashSet relIds = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"value");
            Relationship rel = node.createRelationshipTo(node, REL);
            rel.setProperty(PROP, (Object)"value");
            nodeIds.add(node.getId());
            relIds.add(rel.getId());
            ExecutorService executor = (ExecutorService)this.cleanup.add((Object)Executors.newSingleThreadExecutor());
            executor.submit(() -> {
                try (Transaction forkedTx = this.db.beginTx();){
                    Node node2 = forkedTx.createNode(new Label[]{LABEL});
                    node2.setProperty(PROP, (Object)"value");
                    Relationship rel2 = node2.createRelationshipTo(node2, REL);
                    rel2.setProperty(PROP, (Object)"value");
                    nodeIds.add(node2.getId());
                    relIds.add(rel2.getId());
                    forkedTx.commit();
                }
            }).get();
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "value", nodeIds);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "value", relIds);
    }

    @Test
    public void dropMustNotApplyToRegularSchemaIndexes() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on(PROP).create();
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            String schemaIndexName;
            try (Result result = tx.execute("call db.indexes()");){
                Assert.assertTrue((boolean)result.hasNext());
                schemaIndexName = result.next().get("name").toString();
            }
            this.expectedException.expect(QueryExecutionException.class);
            tx.execute(String.format("CALL db.index.fulltext.drop(\"%s\")", schemaIndexName)).close();
        }
    }

    @Test
    public void fulltextIndexMustNotBeAvailableForRegularIndexSeeks() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        String valueToQueryFor = "value to query for";
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            List<Value> values = this.generateRandomSimpleValues();
            for (Value value : values) {
                tx.createNode(new Label[]{LABEL}).setProperty(PROP, value.asObject());
            }
            tx.createNode(new Label[]{LABEL}).setProperty(PROP, (Object)valueToQueryFor);
            tx.commit();
        }
        try (Transaction transaction = this.db.beginTx();){
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(PROP, valueToQueryFor);
            try (Result result = transaction.execute("profile match (n:" + LABEL.name() + ") where n.prop = $prop return n", params);){
                this.assertNoIndexSeeks(result);
            }
            result = transaction.execute("cypher 3.5 profile match (n:" + LABEL.name() + ") where n.prop = $prop return n", params);
            try {
                this.assertNoIndexSeeks(result);
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            transaction.commit();
        }
    }

    @Test
    public void fulltextIndexMustNotBeAvailableForRegularIndexSeeksAfterShutDown() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.managementService.shutdown();
        this.db = this.createDatabase();
        String valueToQueryFor = "value to query for";
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            List<Value> values = this.generateRandomSimpleValues();
            for (Value value : values) {
                tx.createNode(new Label[]{LABEL}).setProperty(PROP, value.asObject());
            }
            tx.createNode(new Label[]{LABEL}).setProperty(PROP, (Object)valueToQueryFor);
            tx.commit();
        }
        try (Transaction transaction = this.db.beginTx();){
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(PROP, valueToQueryFor);
            try (Result result = transaction.execute("profile match (n:" + LABEL.name() + ") where n.prop = $prop return n", params);){
                this.assertNoIndexSeeks(result);
            }
            result = transaction.execute("cypher 3.5 profile match (n:" + LABEL.name() + ") where n.prop = $prop return n", params);
            try {
                this.assertNoIndexSeeks(result);
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            transaction.commit();
        }
    }

    @Test
    public void nodeOutputMustBeOrderedByScoreDescending() {
        FulltextProcedures.NodeOutput a = new FulltextProcedures.NodeOutput(null, Float.NaN);
        FulltextProcedures.NodeOutput b = new FulltextProcedures.NodeOutput(null, Float.POSITIVE_INFINITY);
        FulltextProcedures.NodeOutput c = new FulltextProcedures.NodeOutput(null, Float.MAX_VALUE);
        FulltextProcedures.NodeOutput d = new FulltextProcedures.NodeOutput(null, 1.0f);
        FulltextProcedures.NodeOutput e = new FulltextProcedures.NodeOutput(null, Float.MIN_NORMAL);
        FulltextProcedures.NodeOutput f = new FulltextProcedures.NodeOutput(null, Float.MIN_VALUE);
        FulltextProcedures.NodeOutput g = new FulltextProcedures.NodeOutput(null, 0.0f);
        FulltextProcedures.NodeOutput h = new FulltextProcedures.NodeOutput(null, -1.0f);
        FulltextProcedures.NodeOutput i = new FulltextProcedures.NodeOutput(null, Float.NEGATIVE_INFINITY);
        Object[] expectedOrder = new FulltextProcedures.NodeOutput[]{a, b, c, d, e, f, g, h, i};
        Object[] array = (FulltextProcedures.NodeOutput[])expectedOrder.clone();
        for (int counter = 0; counter < 10; ++counter) {
            ArrayUtils.shuffle((Object[])array);
            Arrays.sort(array);
            Assert.assertArrayEquals((Object[])expectedOrder, (Object[])array);
        }
    }

    @Test
    public void relationshipOutputMustBeOrderedByScoreDescending() {
        FulltextProcedures.RelationshipOutput a = new FulltextProcedures.RelationshipOutput(null, Float.NaN);
        FulltextProcedures.RelationshipOutput b = new FulltextProcedures.RelationshipOutput(null, Float.POSITIVE_INFINITY);
        FulltextProcedures.RelationshipOutput c = new FulltextProcedures.RelationshipOutput(null, Float.MAX_VALUE);
        FulltextProcedures.RelationshipOutput d = new FulltextProcedures.RelationshipOutput(null, 1.0f);
        FulltextProcedures.RelationshipOutput e = new FulltextProcedures.RelationshipOutput(null, Float.MIN_NORMAL);
        FulltextProcedures.RelationshipOutput f = new FulltextProcedures.RelationshipOutput(null, Float.MIN_VALUE);
        FulltextProcedures.RelationshipOutput g = new FulltextProcedures.RelationshipOutput(null, 0.0f);
        FulltextProcedures.RelationshipOutput h = new FulltextProcedures.RelationshipOutput(null, -1.0f);
        FulltextProcedures.RelationshipOutput i = new FulltextProcedures.RelationshipOutput(null, Float.NEGATIVE_INFINITY);
        Object[] expectedOrder = new FulltextProcedures.RelationshipOutput[]{a, b, c, d, e, f, g, h, i};
        Object[] array = (FulltextProcedures.RelationshipOutput[])expectedOrder.clone();
        for (int counter = 0; counter < 10; ++counter) {
            ArrayUtils.shuffle((Object[])array);
            Arrays.sort(array);
            Assert.assertArrayEquals((Object[])expectedOrder, (Object[])array);
        }
    }

    @Test
    public void awaitIndexProcedureMustWorkOnIndexNames() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Node node = tx.createNode(new Label[]{LABEL});
                node.setProperty(PROP, (Object)"value");
                Relationship rel = node.createRelationshipTo(node, REL);
                rel.setProperty(PROP, (Object)"value");
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            this.createSimpleNodesIndex(tx);
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.awaitIndex(\"%s\")", "nodes")).close();
            tx.execute(String.format("CALL db.awaitIndex(\"%s\")", "rels")).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void mustBePossibleToDropFulltextIndexByNameForWhichNormalIndexExistWithMatchingSchema() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            tx.execute("CREATE INDEX FOR (n:Person) ON (n.name)").close();
            tx.execute("call db.index.fulltext.createNodeIndex('nameIndex', ['Person'], ['name'])").close();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.execute("call db.index.fulltext.drop('nameIndex')").close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Assert.assertThat((Object)((IndexDefinition)Iterables.single((Iterable)tx.schema().getIndexes())).getName(), (Matcher)Matchers.is((Matcher)Matchers.not((Object)"nameIndex")));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void fulltextIndexesMustNotPreventNormalSchemaIndexesFromBeingDropped() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            tx.execute("CREATE INDEX FOR (n:Person) ON (n.name)").close();
            tx.execute("call db.index.fulltext.createNodeIndex('nameIndex', ['Person'], ['name'])").close();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.execute("DROP INDEX ON :Person(name)").close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Assert.assertThat((Object)((IndexDefinition)Iterables.single((Iterable)tx.schema().getIndexes())).getName(), (Matcher)Matchers.is((Object)"nameIndex"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void creatingNormalIndexWithFulltextProviderMustThrow() {
        Transaction tx;
        this.db = this.createDatabase();
        Assert.assertThat((Object)FulltextIndexProviderFactory.DESCRIPTOR.name(), (Matcher)Matchers.is((Object)"fulltext-1.0"));
        try {
            tx = this.db.beginTx();
            try {
                tx.execute("call db.createIndex( \"MyIndex\", ['User'], ['searchableString'], \"" + FulltextIndexProviderFactory.DESCRIPTOR.name() + "\" );").close();
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (QueryExecutionException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Could not create index with specified index provider 'fulltext-1.0'. To create fulltext index, please use 'db.index.fulltext.createNodeIndex' or 'db.index.fulltext.createRelationshipIndex'."));
        }
        tx = this.db.beginTx();
        try {
            long indexCount = tx.execute("CALL db.indexes()").stream().count();
            Assert.assertThat((Object)indexCount, (Matcher)Matchers.is((Object)0L));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void mustSupportWildcardEndsLikeStartsWith() {
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        LongHashSet ids = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"abcdef");
            ids.add(node.getId());
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"abcxyz");
            ids.add(node.getId());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "abc*", ids);
    }

    @Test
    public void mustSupportWildcardBeginningsLikeEndsWith() {
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        LongHashSet ids = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"defabc");
            ids.add(node.getId());
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"xyzabc");
            ids.add(node.getId());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "*abc", ids);
    }

    @Test
    public void mustSupportWildcardBeginningsAndEndsLikeContains() {
        Node node;
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        LongHashSet ids = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"defabcdef");
            ids.add(node.getId());
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty(PROP, (Object)"xyzabcxyz");
            ids.add(node.getId());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "*abc*", ids);
    }

    @Test
    public void mustMatchCaseInsensitiveWithStandardAnalyzer() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'A'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'B'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'C'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'b'}))").close();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "myindex", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Label"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"id"}) + ", {analyzer: 'standard'}")).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            try (Result result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "A"));){
                Assert.assertThat((Object)result.stream().count(), (Matcher)Matchers.is((Object)0L));
            }
            result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "B"));
            try {
                Assert.assertThat((Object)result.stream().count(), (Matcher)Matchers.is((Object)2000L));
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "C"));
            try {
                Assert.assertThat((Object)result.stream().count(), (Matcher)Matchers.is((Object)1000L));
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void mustMatchCaseInsensitiveWithSimpleAnalyzer() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'A'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'B'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'C'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'b'}))").close();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "myindex", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Label"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"id"}) + ", {analyzer: 'simple'}")).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            try (Result result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "A"));){
                Assert.assertThat((Object)result.stream().count(), (Matcher)Matchers.is((Object)1000L));
            }
            result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "B"));
            try {
                Assert.assertThat((Object)result.stream().count(), (Matcher)Matchers.is((Object)2000L));
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "C"));
            try {
                Assert.assertThat((Object)result.stream().count(), (Matcher)Matchers.is((Object)1000L));
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void mustMatchCaseInsensitiveWithDefaultAnalyzer() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'A'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'B'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'C'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'b'}))").close();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "myindex", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Label"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"id"}))).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            try (Result result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "A"));){
                Assert.assertThat((Object)result.stream().count(), (Matcher)Matchers.is((Object)1000L));
            }
            result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "B"));
            try {
                Assert.assertThat((Object)result.stream().count(), (Matcher)Matchers.is((Object)2000L));
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "C"));
            try {
                Assert.assertThat((Object)result.stream().count(), (Matcher)Matchers.is((Object)1000L));
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void makeSureFulltextIndexDoesNotBlockSchemaIndexOnSameSchemaPattern() {
        this.db = this.createDatabase();
        Label label = Label.label((String)"label");
        String prop = PROP;
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "myindex", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{label.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP})));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.awaitIndex(\"%s\")", "myindex"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().indexFor(label).on(PROP).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Assert.assertEquals((long)2L, (long)Iterables.count((Iterable)tx.schema().getIndexes()));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void makeSureSchemaIndexDoesNotBlockFulltextIndexOnSameSchemaPattern() {
        this.db = this.createDatabase();
        Label label = Label.label((String)"label");
        String prop = PROP;
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(label).on(PROP).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "myindex", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{label.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP})));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.awaitIndex(\"%s\")", "myindex"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Assert.assertEquals((long)2L, (long)Iterables.count((Iterable)tx.schema().getIndexes()));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void shouldNotBePossibleToCreateIndexWithDuplicateProperty() {
        this.db = this.createDatabase();
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "myindex", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Label"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"id", "id"})));
            }
        });
        Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
        Assert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(RepeatedPropertyInSchemaException.class));
    }

    @Test
    public void shouldNotBePossibleToCreateIndexWithDuplicateLabel() {
        this.db = this.createDatabase();
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "myindex", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Label", "Label"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"id"})));
            }
        });
        Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
        Assert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(RepeatedLabelInSchemaException.class));
    }

    @Test
    public void shouldNotBePossibleToCreateIndexWithDuplicateRelType() {
        this.db = this.createDatabase();
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "myindex", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"RelType", "RelType"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"id"})));
            }
        });
        Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
        Assert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(RepeatedRelationshipTypeInSchemaException.class));
    }

    @Test
    public void attemptingToIndexOnPropertyUsedForInternalReferenceMustThrow() {
        this.db = this.createDatabase();
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "myindex", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Label"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"__neo4j__lucene__fulltext__index__internal__id__"}))).close();
                tx.commit();
            }
        });
        Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"__neo4j__lucene__fulltext__index__internal__id__"));
    }

    @Test
    public void fulltextIndexMustWorkAfterRestartWithTxStateChanges() {
        this.db = this.createDatabase();
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}))).close();
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        this.managementService.shutdown();
        this.db = this.createDatabase();
        tx = this.db.beginTx();
        try {
            tx.createNode();
            tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", "*")).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.createNode();
            tx.execute(String.format("CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")", "rels", "*")).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void assertNoIndexSeeks(Result result) {
        Assert.assertThat((Object)result.stream().count(), (Matcher)Matchers.is((Object)1L));
        String planDescription = result.getExecutionPlanDescription().toString();
        Assert.assertThat((Object)planDescription, (Matcher)Matchers.containsString((String)"NodeByLabel"));
        Assert.assertThat((Object)planDescription, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"IndexSeek")));
    }

    private GraphDatabaseAPI createDatabase() {
        this.managementService = this.builder.build();
        this.cleanup.add((Object)this.managementService);
        return (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    private void awaitIndexesOnline() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
    }

    static void assertQueryFindsIds(GraphDatabaseService db, boolean queryNodes, String index, String query, long ... ids) {
        try (Transaction tx = db.beginTx();){
            String queryCall = queryNodes ? "CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")" : "CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")";
            Result result = tx.execute(String.format(queryCall, index, query));
            int num = 0;
            Double score = Double.MAX_VALUE;
            while (result.hasNext()) {
                Map entry = result.next();
                Long nextId = ((Entity)entry.get(queryNodes ? NODE : RELATIONSHIP)).getId();
                Double nextScore = (Double)entry.get(SCORE);
                Assert.assertThat((Object)nextScore, (Matcher)Matchers.lessThanOrEqualTo((Comparable)score));
                score = nextScore;
                if (num < ids.length) {
                    Assert.assertEquals((String)String.format("Result returned id %d, expected %d", nextId, ids[num]), (long)ids[num], (long)nextId);
                } else {
                    Assert.fail((String)String.format("Result returned id %d, which is beyond the number of ids (%d) that were expected.", nextId, ids.length));
                }
                ++num;
            }
            Assert.assertEquals((String)"Number of results differ from expected", (long)ids.length, (long)num);
            tx.commit();
        }
    }

    static void assertQueryFindsIds(GraphDatabaseService db, boolean queryNodes, String index, String query, LongHashSet ids) {
        ids = new LongHashSet(ids);
        String queryCall = queryNodes ? "CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")" : "CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")";
        long[] expectedIds = ids.toArray();
        LongHashSet actualIds = new LongHashSet();
        try (Transaction tx = db.beginTx();){
            LongFunction<Entity> getEntity = queryNodes ? arg_0 -> ((Transaction)tx).getNodeById(arg_0) : arg_0 -> ((Transaction)tx).getRelationshipById(arg_0);
            Result result = tx.execute(String.format(queryCall, index, query));
            Double score = Double.MAX_VALUE;
            while (result.hasNext()) {
                Map entry = result.next();
                long nextId = ((Entity)entry.get(queryNodes ? NODE : RELATIONSHIP)).getId();
                Double nextScore = (Double)entry.get(SCORE);
                Assert.assertThat((Object)nextScore, (Matcher)Matchers.lessThanOrEqualTo((Comparable)score));
                score = nextScore;
                actualIds.add(nextId);
                if (ids.remove(nextId)) continue;
                String msg = "This id was not expected: " + nextId;
                FulltextProceduresTest.failQuery(getEntity, index, query, (MutableLongSet)ids, expectedIds, (MutableLongSet)actualIds, msg);
            }
            if (!ids.isEmpty()) {
                String msg = "Not all expected ids were found: " + ids;
                FulltextProceduresTest.failQuery(getEntity, index, query, (MutableLongSet)ids, expectedIds, (MutableLongSet)actualIds, msg);
            }
            tx.commit();
        }
    }

    private static void failQuery(LongFunction<Entity> getEntity, String index, String query, MutableLongSet ids, long[] expectedIds, MutableLongSet actualIds, String msg) {
        Entity entity;
        long id;
        StringBuilder message = new StringBuilder(msg).append('\n');
        MutableLongIterator itr = ids.longIterator();
        while (itr.hasNext()) {
            id = itr.next();
            entity = getEntity.apply(id);
            message.append('\t').append(entity).append(entity.getAllProperties()).append('\n');
        }
        message.append("for query: '").append(query).append("'\nin index: ").append(index).append('\n');
        message.append("all expected ids: ").append(Arrays.toString(expectedIds)).append('\n');
        message.append("actual ids: ").append(actualIds);
        itr = actualIds.longIterator();
        while (itr.hasNext()) {
            id = itr.next();
            entity = getEntity.apply(id);
            message.append("\n\t").append(entity).append(entity.getAllProperties());
        }
        Assert.fail((String)message.toString());
    }

    private List<Value> generateRandomNonStringValues() {
        Predicate<Value> nonString = v -> v.valueGroup() != ValueGroup.TEXT;
        return this.generateRandomValues(nonString);
    }

    private List<Value> generateRandomSimpleValues() {
        EnumSet<ValueGroup> simpleTypes = EnumSet.of(ValueGroup.BOOLEAN, ValueGroup.BOOLEAN_ARRAY, ValueGroup.NUMBER, ValueGroup.NUMBER_ARRAY);
        return this.generateRandomValues(v -> simpleTypes.contains(v.valueGroup()));
    }

    private List<Value> generateRandomValues(Predicate<Value> predicate) {
        int valuesToGenerate = 1000;
        RandomValues generator = RandomValues.create();
        ArrayList<Value> values = new ArrayList<Value>(valuesToGenerate);
        for (int i = 0; i < valuesToGenerate; ++i) {
            Value value;
            while (!predicate.test(value = generator.nextValue())) {
            }
            values.add(value);
        }
        return values;
    }

    private String quoteValueForQuery(Value value) {
        return QueryParserUtil.escape((String)value.prettyPrint()).replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private void createSimpleRelationshipIndex(Transaction tx) {
        tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}))).close();
    }

    private void createSimpleNodesIndex(Transaction tx) {
        tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{PROP}))).close();
    }
}

