/*
 * Decompiled with CFR 0.152.
 */
package migration;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.compress.ZipUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexSettingsKeys;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.index.schema.config.CrsConfig;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.Unzip;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@Neo4jLayoutExtension
class IndexConfigMigrationIT {
    @Inject
    private DatabaseLayout databaseLayout;
    private static final Map<String, Value> staticExpectedIndexConfig = new HashMap<String, Value>();
    private static final String ZIP_FILE_3_5 = "IndexConfigMigrationIT-3_5-db.zip";
    private static final String propKey = "key";
    private static final Label label1;
    private static final Label label2;
    private static final Label label3;
    private static final Label label4;
    private static final Label[] labels;
    @Inject
    private TestDirectory testDirectory;

    IndexConfigMigrationIT() {
    }

    private static File tempStoreDirectory() throws IOException {
        File file = File.createTempFile("create-db", "neo4j");
        File storeDir = new File(file.getAbsoluteFile().getParentFile(), file.getName());
        FileUtils.deleteFile((File)file);
        return storeDir;
    }

    @Disabled(value="Here as reference for how 3.5 db was created")
    @Test
    void create3_5Database() throws Exception {
        File storeDir = IndexConfigMigrationIT.tempStoreDirectory();
        TestDatabaseManagementServiceBuilder builder = new TestDatabaseManagementServiceBuilder(storeDir);
        IndexConfigMigrationIT.setSpatialConfig((DatabaseManagementServiceBuilder)builder);
        DatabaseManagementService dbms = builder.build();
        GraphDatabaseService db = dbms.database("neo4j");
        IndexConfigMigrationIT.createIndex(db, GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerName(), label1);
        IndexConfigMigrationIT.createSpatialData(db, label1, label2, label3, label4);
        for (FulltextIndexDescription fulltextIndex : FulltextIndexDescription.values()) {
            IndexConfigMigrationIT.createFulltextIndex(db, fulltextIndex.indexProcedure, fulltextIndex.indexName, fulltextIndex.tokenName, propKey, fulltextIndex.configMap);
        }
        dbms.shutdown();
        File zipFile = new File(storeDir.getParentFile(), storeDir.getName() + ".zip");
        ZipUtils.zip((FileSystemAbstraction)new DefaultFileSystemAbstraction(), (File)storeDir, (File)zipFile);
        System.out.println("Db created in " + zipFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldHaveCorrectDataAndIndexConfiguration() throws IOException, IndexNotFoundKernelException {
        File databaseDir = this.databaseLayout.databaseDirectory();
        Unzip.unzip(this.getClass(), (String)ZIP_FILE_3_5, (File)databaseDir);
        TestDatabaseManagementServiceBuilder builder = new TestDatabaseManagementServiceBuilder(this.testDirectory.homeDir()).setConfig(GraphDatabaseSettings.allow_upgrade, (Object)true);
        DatabaseManagementService dbms = builder.build();
        try {
            GraphDatabaseAPI db = (GraphDatabaseAPI)dbms.database("neo4j");
            Set allCRS = Iterables.asSet((Iterable)CoordinateReferenceSystem.all());
            try (Transaction tx = db.beginTx();){
                IndexConfigMigrationIT.hasIndexCount(tx, 7);
                for (Node node : tx.getAllNodes()) {
                    IndexConfigMigrationIT.hasLabels(node, label1, label2, label3, label4);
                    Object property = node.getProperty(propKey);
                    if (!(property instanceof PointValue)) continue;
                    allCRS.remove(((PointValue)property).getCoordinateReferenceSystem());
                }
                Assertions.assertTrue((boolean)allCRS.isEmpty(), (String)("Expected all CRS to be represented in store, but missing " + allCRS));
                IndexConfigMigrationIT.assertIndexConfiguration(db, tx);
                IndexConfigMigrationIT.assertFulltextIndexConfiguration(db, tx);
                tx.commit();
            }
        }
        finally {
            dbms.shutdown();
        }
        File baseSchemaIndexFolder = IndexDirectoryStructure.baseSchemaIndexFolder((File)databaseDir);
        Set<File> retiredIndexProviderDirectories = Set.of(new File(baseSchemaIndexFolder, "lucene"), new File(baseSchemaIndexFolder, "lucene-1.0"), new File(baseSchemaIndexFolder, "lucene_native-1.0"), new File(baseSchemaIndexFolder, "lucene_native-2.0"));
        for (File indexProviderDirectory : Objects.requireNonNull(baseSchemaIndexFolder.listFiles())) {
            Assertions.assertFalse((boolean)retiredIndexProviderDirectories.contains(indexProviderDirectory), (String)("Expected old index provider directories to be deleted during migration but store still had directory " + indexProviderDirectory));
        }
    }

    private static void assertIndexConfiguration(GraphDatabaseAPI db, Transaction tx) throws IndexNotFoundKernelException {
        for (Label label : labels) {
            Map<String, Value> actualIndexConfig = IndexConfigMigrationIT.getIndexConfig(db, tx, label);
            HashMap<String, Value> expectedIndexConfig = new HashMap<String, Value>(staticExpectedIndexConfig);
            for (Map.Entry<String, Value> entry : actualIndexConfig.entrySet()) {
                String actualKey = entry.getKey();
                Value actualValue = entry.getValue();
                Value expectedValue = (Value)expectedIndexConfig.remove(actualKey);
                Assertions.assertNotNull((Object)expectedValue, (String)("Actual index config had map entry that was not among expected " + entry));
                Assertions.assertEquals((int)0, (int)Values.COMPARATOR.compare(expectedValue, actualValue), (String)String.format("Expected and actual index config value differed for %s, expected %s but was %s.", actualKey, expectedValue, actualValue));
            }
            Assertions.assertTrue((boolean)expectedIndexConfig.isEmpty(), (String)("Actual index config was missing some values: " + expectedIndexConfig));
        }
    }

    private static void assertFulltextIndexConfiguration(GraphDatabaseAPI db, Transaction tx) throws IndexNotFoundKernelException {
        for (FulltextIndexDescription fulltextIndex : FulltextIndexDescription.values()) {
            Map<String, Value> actualIndexConfig = IndexConfigMigrationIT.getIndexConfig(db, tx, fulltextIndex.indexName);
            for (Map.Entry<String, Value> expectedEntry : fulltextIndex.configMap.entrySet()) {
                Value actualValue = actualIndexConfig.get(expectedEntry.getKey());
                Assertions.assertEquals((Object)expectedEntry.getValue(), (Object)actualValue, (String)String.format("Index did not have expected config, %s.%nExpected: %s%nActual: %s ", fulltextIndex.indexName, fulltextIndex.configMap, actualIndexConfig));
            }
        }
    }

    private static Map<String, Value> getIndexConfig(GraphDatabaseAPI db, Transaction tx, String indexName) throws IndexNotFoundKernelException {
        IndexingService indexingService = IndexConfigMigrationIT.getIndexingService(db);
        IndexDescriptor indexReference = IndexConfigMigrationIT.schemaRead(tx).indexGetForName(indexName);
        IndexProxy indexProxy = indexingService.getIndexProxy(indexReference);
        return indexProxy.indexConfig();
    }

    private static Map<String, Value> getIndexConfig(GraphDatabaseAPI db, Transaction tx, Label label) throws IndexNotFoundKernelException {
        IndexDefinitionImpl indexDefinition = (IndexDefinitionImpl)Iterables.single((Iterable)tx.schema().getIndexes(label));
        IndexDescriptor index = indexDefinition.getIndexReference();
        IndexingService indexingService = IndexConfigMigrationIT.getIndexingService(db);
        IndexProxy indexProxy = indexingService.getIndexProxy(index);
        return indexProxy.indexConfig();
    }

    private static void hasIndexCount(Transaction transaction, int expectedIndexCount) {
        Iterable indexes = transaction.schema().getIndexes();
        long actualIndexCount = Iterables.count((Iterable)indexes);
        Assertions.assertEquals((long)expectedIndexCount, (long)actualIndexCount, (String)("Expected there to be " + expectedIndexCount + " indexes but was " + actualIndexCount));
    }

    private static void hasLabels(Node node, Label ... labels) {
        for (Label label : labels) {
            Assertions.assertTrue((boolean)node.hasLabel(label), (String)("Did not have label " + label));
        }
    }

    private static void createSpatialData(GraphDatabaseService db, Label ... labels) {
        try (Transaction tx = db.beginTx();){
            for (CoordinateReferenceSystem crs : CoordinateReferenceSystem.all()) {
                Node node = tx.createNode(labels);
                int dim = crs.getDimension();
                double[] coords = new double[dim];
                node.setProperty(propKey, (Object)Values.pointValue((CoordinateReferenceSystem)crs, (double[])coords));
            }
            tx.commit();
        }
    }

    private static void createIndex(GraphDatabaseService db, String providerName, Label label) {
        try (Transaction tx = db.beginTx();){
            String indexPattern = String.format("\":%s(%s)\"", label.name(), propKey);
            String indexProvider = "\"" + providerName + "\"";
            tx.execute(String.format("CALL db.createIndex( %s, %s )", indexPattern, indexProvider)).close();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static void createFulltextIndex(GraphDatabaseService db, String indexProcedure, String fulltextName, String token, String propKey, Map<String, Value> configMap) {
        try (Transaction tx = db.beginTx();){
            String labelArray = IndexConfigMigrationIT.array(token);
            String propArray = IndexConfigMigrationIT.array(propKey);
            String configString = IndexConfigMigrationIT.asConfigString(configMap);
            System.out.println(fulltextName + " created with config: " + configString);
            String query = String.format("CALL db.index.fulltext." + indexProcedure + "(\"%s\", %s, %s, %s )", fulltextName, labelArray, propArray, configString);
            tx.execute(query).close();
            tx.commit();
        }
    }

    private static Map<String, Value> asConfigMap(String analyzer, boolean eventuallyConsistent) {
        HashMap<String, Value> map = new HashMap<String, Value>();
        map.put(FulltextIndexSettingsKeys.ANALYZER, (Value)Values.stringValue((String)analyzer));
        map.put(FulltextIndexSettingsKeys.EVENTUALLY_CONSISTENT, (Value)Values.booleanValue((boolean)eventuallyConsistent));
        return map;
    }

    private static Map<String, Value> asConfigMap(String analyzer) {
        HashMap<String, Value> map = new HashMap<String, Value>();
        map.put(FulltextIndexSettingsKeys.ANALYZER, (Value)Values.stringValue((String)analyzer));
        return map;
    }

    private static Map<String, Value> asConfigMap(boolean eventuallyConsistent) {
        HashMap<String, Value> map = new HashMap<String, Value>();
        map.put(FulltextIndexSettingsKeys.EVENTUALLY_CONSISTENT, (Value)Values.booleanValue((boolean)eventuallyConsistent));
        return map;
    }

    private static String asConfigString(Map<String, Value> configMap) {
        StringJoiner joiner = new StringJoiner(", ", "{", "}");
        configMap.forEach((k, v) -> joiner.add(k + ": \"" + v.asObject() + "\""));
        return joiner.toString();
    }

    private static String array(String ... args) {
        return Arrays.stream(args).collect(Collectors.joining("\", \"", "[\"", "\"]"));
    }

    private static void setSpatialConfig(DatabaseManagementServiceBuilder builder) {
        for (MinMaxSetting minMaxSetting : MinMaxSetting.values()) {
            builder.setConfig(minMaxSetting.setting, minMaxSetting.settingValue);
        }
    }

    private static IndexingService getIndexingService(GraphDatabaseAPI db) {
        return (IndexingService)db.getDependencyResolver().resolveDependency(IndexingService.class);
    }

    private static SchemaRead schemaRead(Transaction tx) {
        return ((InternalTransaction)tx).kernelTransaction().schemaRead();
    }

    static {
        staticExpectedIndexConfig.put("spatial.wgs-84.min", (Value)Values.doubleArray((double[])new double[]{-1.0, -2.0}));
        staticExpectedIndexConfig.put("spatial.wgs-84.max", (Value)Values.doubleArray((double[])new double[]{3.0, 4.0}));
        staticExpectedIndexConfig.put("spatial.wgs-84-3d.min", (Value)Values.doubleArray((double[])new double[]{-5.0, -6.0, -7.0}));
        staticExpectedIndexConfig.put("spatial.wgs-84-3d.max", (Value)Values.doubleArray((double[])new double[]{8.0, 9.0, 10.0}));
        staticExpectedIndexConfig.put("spatial.cartesian.min", (Value)Values.doubleArray((double[])new double[]{-11.0, -12.0}));
        staticExpectedIndexConfig.put("spatial.cartesian.max", (Value)Values.doubleArray((double[])new double[]{13.0, 14.0}));
        staticExpectedIndexConfig.put("spatial.cartesian-3d.min", (Value)Values.doubleArray((double[])new double[]{-15.0, -16.0, -17.0}));
        staticExpectedIndexConfig.put("spatial.cartesian-3d.max", (Value)Values.doubleArray((double[])new double[]{18.0, 19.0, 20.0}));
        label1 = Label.label((String)"label1");
        label2 = Label.label((String)"label2");
        label3 = Label.label((String)"label3");
        label4 = Label.label((String)"label4");
        labels = new Label[]{label1, label2, label3, label4};
    }

    private static enum FulltextIndexDescription {
        BOTH("fulltextBoth", true, "fulltextToken1", IndexConfigMigrationIT.asConfigMap("simple", true)),
        ANALYZER_ONLY("fulltextAnalyzer", false, "fulltextToken2", IndexConfigMigrationIT.asConfigMap("russian")),
        EVENTUALLY_CONSISTENT_ONLY("fulltextEC", true, "fulltextToken3", IndexConfigMigrationIT.asConfigMap(true));

        private final String indexName;
        private final String indexProcedure;
        private final String tokenName;
        private final Map<String, Value> configMap;

        private FulltextIndexDescription(String indexName, boolean nodeIndex, String tokenName, Map<String, Value> configMap) {
            this.indexName = indexName;
            this.tokenName = tokenName;
            this.configMap = configMap;
            this.indexProcedure = nodeIndex ? "createNodeIndex" : "createRelationshipIndex";
        }
    }

    private static enum MinMaxSetting {
        wgs84Min((Setting<List<Double>>)CrsConfig.group((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84).min, List.of(Double.valueOf(-1.0), Double.valueOf(-2.0))),
        wgs84Max((Setting<List<Double>>)CrsConfig.group((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84).max, List.of(Double.valueOf(3.0), Double.valueOf(4.0))),
        wgs84_3DMin((Setting<List<Double>>)CrsConfig.group((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D).min, List.of(Double.valueOf(-5.0), Double.valueOf(-6.0), Double.valueOf(-7.0))),
        wgs84_3DMax((Setting<List<Double>>)CrsConfig.group((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D).max, List.of(Double.valueOf(8.0), Double.valueOf(9.0), Double.valueOf(10.0))),
        cartesianMin((Setting<List<Double>>)CrsConfig.group((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian).min, List.of(Double.valueOf(-11.0), Double.valueOf(-12.0))),
        cartesianMax((Setting<List<Double>>)CrsConfig.group((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian).max, List.of(Double.valueOf(13.0), Double.valueOf(14.0))),
        cartesian_3DMin((Setting<List<Double>>)CrsConfig.group((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D).min, List.of(Double.valueOf(-15.0), Double.valueOf(-16.0), Double.valueOf(-17.0))),
        cartesian_3DMax((Setting<List<Double>>)CrsConfig.group((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D).max, List.of(Double.valueOf(18.0), Double.valueOf(19.0), Double.valueOf(20.0)));

        private final Setting<List<Double>> setting;
        private final List<Double> settingValue;

        private MinMaxSetting(Setting<List<Double>> setting, List<Double> settingValue) {
            this.setting = setting;
            this.settingValue = settingValue;
        }
    }
}

