/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.schema;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Values;

@DbmsExtension
@ExtendWith(value={RandomExtension.class})
class IndexPopulationFlipRaceIT {
    private static final int NODES_PER_INDEX = 10;
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private RandomRule random;

    IndexPopulationFlipRaceIT() {
    }

    @Test
    void shouldAtomicallyFlipMultipleIndexes() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.createIndexesButDontWaitForThemToFullyPopulate(i);
            Pair<long[], long[]> data = this.createDataThatGoesIntoToThoseIndexes(i);
            this.awaitIndexes();
            this.verifyThatThereAreExactlyOneIndexEntryPerNodeInTheIndexes(i, data);
        }
    }

    private void awaitIndexes() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(30L, TimeUnit.SECONDS);
            tx.commit();
        }
    }

    private void createIndexesButDontWaitForThemToFullyPopulate(int i) {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(IndexPopulationFlipRaceIT.labelA(i)).on(IndexPopulationFlipRaceIT.keyA(i)).create();
            if (this.random.nextBoolean()) {
                tx.schema().indexFor(IndexPopulationFlipRaceIT.labelB(i)).on(IndexPopulationFlipRaceIT.keyB(i)).create();
            } else {
                tx.schema().constraintFor(IndexPopulationFlipRaceIT.labelB(i)).assertPropertyIsUnique(IndexPopulationFlipRaceIT.keyB(i)).create();
            }
            tx.commit();
        }
    }

    private static String keyB(int i) {
        return "key_b" + i;
    }

    private static Label labelB(int i) {
        return Label.label((String)("Label_b" + i));
    }

    private static String keyA(int i) {
        return "key_a" + i;
    }

    private static Label labelA(int i) {
        return Label.label((String)("Label_a" + i));
    }

    private Pair<long[], long[]> createDataThatGoesIntoToThoseIndexes(int i) {
        long[] dataA = new long[10];
        long[] dataB = new long[10];
        for (int t = 0; t < 10; ++t) {
            try (Transaction tx = this.db.beginTx();){
                Node nodeA = tx.createNode(new Label[]{IndexPopulationFlipRaceIT.labelA(i)});
                dataA[t] = nodeA.getId();
                nodeA.setProperty(IndexPopulationFlipRaceIT.keyA(i), (Object)dataA[t]);
                Node nodeB = tx.createNode(new Label[]{IndexPopulationFlipRaceIT.labelB(i)});
                dataB[t] = nodeB.getId();
                nodeB.setProperty(IndexPopulationFlipRaceIT.keyB(i), (Object)dataB[t]);
                tx.commit();
                continue;
            }
        }
        return Pair.of((Object)dataA, (Object)dataB);
    }

    private void verifyThatThereAreExactlyOneIndexEntryPerNodeInTheIndexes(int i, Pair<long[], long[]> data) throws Exception {
        Kernel kernel = (Kernel)this.db.getDependencyResolver().resolveDependency(Kernel.class);
        try (KernelTransaction tx = kernel.beginTransaction(KernelTransaction.Type.implicit, (LoginContext)AnonymousContext.read());){
            int labelAId = tx.tokenRead().nodeLabel(IndexPopulationFlipRaceIT.labelA(i).name());
            int keyAId = tx.tokenRead().propertyKey(IndexPopulationFlipRaceIT.keyA(i));
            int labelBId = tx.tokenRead().nodeLabel(IndexPopulationFlipRaceIT.labelB(i).name());
            int keyBId = tx.tokenRead().propertyKey(IndexPopulationFlipRaceIT.keyB(i));
            IndexDescriptor indexA = (IndexDescriptor)Iterators.single((Iterator)tx.schemaRead().index((SchemaDescriptor)SchemaDescriptor.forLabel((int)labelAId, (int[])new int[]{keyAId})));
            IndexDescriptor indexB = (IndexDescriptor)Iterators.single((Iterator)tx.schemaRead().index((SchemaDescriptor)SchemaDescriptor.forLabel((int)labelBId, (int[])new int[]{keyBId})));
            for (int j = 0; j < 10; ++j) {
                long nodeAId = ((long[])data.first())[j];
                Assertions.assertEquals((long)1L, (long)tx.schemaRead().nodesCountIndexed(indexA, nodeAId, keyAId, Values.of((Object)nodeAId)));
                long nodeBId = ((long[])data.other())[j];
                Assertions.assertEquals((long)1L, (long)tx.schemaRead().nodesCountIndexed(indexB, nodeBId, keyBId, Values.of((Object)nodeBId)));
            }
        }
    }
}

