/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.neo4j.index.NativeIndexRestartAction;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;

public class SabotageNativeIndex
extends NativeIndexRestartAction {
    private final Random random;

    SabotageNativeIndex(Random random) {
        this.random = random;
    }

    @Override
    protected void runOnDirectoryStructure(FileSystemAbstraction fs, IndexDirectoryStructure indexDirectoryStructure) throws IOException {
        int files = this.scrambleIndexFiles(fs, indexDirectoryStructure.rootDirectory());
        MatcherAssert.assertThat((String)"there is no index to sabotage", (Object)files, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
    }

    private int scrambleIndexFiles(FileSystemAbstraction fs, File fileOrDir) throws IOException {
        if (fs.isDirectory(fileOrDir)) {
            int count = 0;
            File[] children = fs.listFiles(fileOrDir);
            if (children != null) {
                for (File child : children) {
                    count += this.scrambleIndexFiles(fs, child);
                }
            }
            return count;
        }
        try (StoreChannel channel = fs.write(fileOrDir);){
            if (channel.size() > ByteUnit.mebiBytes((long)10L)) {
                throw new IllegalArgumentException("Was expecting small files here");
            }
            byte[] bytes = new byte[(int)channel.size()];
            this.random.nextBytes(bytes);
            channel.writeAll(ByteBuffer.wrap(bytes));
        }
        return 1;
    }
}

