/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.TreeNodeDynamicSize;
import org.neo4j.kernel.api.impl.schema.StringLengthIndexValidationIT;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.test.rule.RandomRule;

public class GenericStringLengthIndexValidationIT
extends StringLengthIndexValidationIT {
    @Override
    protected int getSingleKeySizeLimit() {
        return TreeNodeDynamicSize.keyValueSizeCapFromPageSize((int)8192);
    }

    @Override
    protected String getString(RandomRule random, int keySize) {
        return LayoutTestUtil.generateStringResultingInSizeForIndexProvider((int)keySize, (GraphDatabaseSettings.SchemaIndex)GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
    }

    @Override
    protected GraphDatabaseSettings.SchemaIndex getSchemaIndex() {
        return GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10;
    }

    @Override
    protected String expectedPopulationFailureMessage() {
        return "Index key-value size it to large. Please see index documentation for limitations.";
    }

    @Override
    protected String expectedPopulationFailureCauseMessage(long nodeId) {
        return String.format("Failed while trying to write to index, targetIndex=Index( 1, 'index_71616483', GENERAL BTREE, :LABEL_ONE(largeString), %s ), nodeId=%d", GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerName(), nodeId);
    }
}

