/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.kernel.api.impl.schema.StringLengthIndexValidationIT;
import org.neo4j.test.rule.RandomRule;

public class Native30StringLengthIndexValidationIT
extends StringLengthIndexValidationIT {
    private static final String failureMessage = "Document contains at least one immense term in field=\"string\" (whose UTF8 encoding is longer than the max length 32766), all of which were skipped.  Please correct the analyzer to not produce such terms.";

    @Override
    protected int getSingleKeySizeLimit() {
        return 32766;
    }

    @Override
    protected String getString(RandomRule random, int keySize) {
        return random.nextAlphaNumericString(keySize, keySize);
    }

    @Override
    protected GraphDatabaseSettings.SchemaIndex getSchemaIndex() {
        return GraphDatabaseSettings.SchemaIndex.NATIVE30;
    }

    @Override
    protected String expectedPopulationFailureMessage() {
        return failureMessage;
    }

    @Override
    protected String expectedPopulationFailureCauseMessage(long nodeId) {
        return failureMessage;
    }
}

