/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class ConstraintTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    protected abstract LabelSchemaDescriptor labelSchemaDescriptor(int var1, int ... var2);

    protected abstract ConstraintDescriptor uniqueConstraintDescriptor(int var1, int ... var2);

    @BeforeEach
    public void setup() {
        try (Transaction tx = graphDb.beginTx();){
            for (ConstraintDefinition definition : tx.schema().getConstraints()) {
                definition.drop();
            }
            tx.commit();
        }
    }

    @Test
    void shouldFindConstraintsBySchema() throws Exception {
        this.addConstraints("FOO", "prop");
        try (KernelTransaction tx = this.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("FOO");
            int prop = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            LabelSchemaDescriptor descriptor = this.labelSchemaDescriptor(label, prop);
            List constraints = Iterators.asList((Iterator)tx.schemaRead().constraintsGetForSchema((SchemaDescriptor)descriptor));
            MatcherAssert.assertThat((Object)constraints, (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((Object)((ConstraintDescriptor)constraints.get(0)).schema().getPropertyId(), (Matcher)Matchers.equalTo((Object)prop));
        }
    }

    @Test
    void shouldFindConstraintsByLabel() throws Exception {
        this.addConstraints("FOO", "prop1", "FOO", "prop2");
        try (KernelTransaction tx = this.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("FOO");
            List constraints = Iterators.asList((Iterator)tx.schemaRead().constraintsGetForLabel(label));
            MatcherAssert.assertThat((Object)constraints, (Matcher)Matchers.hasSize((int)2));
        }
    }

    @Test
    void shouldBeAbleCheckExistenceOfConstraints() throws Exception {
        try (Transaction tx = graphDb.beginTx();){
            tx.schema().constraintFor(Label.label((String)"FOO")).assertPropertyIsUnique("prop1").create();
            ConstraintDefinition dropped = tx.schema().constraintFor(Label.label((String)"FOO")).assertPropertyIsUnique("prop2").create();
            dropped.drop();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int label = tx.tokenWrite().labelGetOrCreateForName("FOO");
            int prop1 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop1");
            int prop2 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop2");
            Assertions.assertTrue((boolean)tx.schemaRead().constraintExists(this.uniqueConstraintDescriptor(label, prop1)));
            Assertions.assertFalse((boolean)tx.schemaRead().constraintExists(this.uniqueConstraintDescriptor(label, prop2)));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldFindAllConstraints() throws Exception {
        this.addConstraints("FOO", "prop1", "BAR", "prop2", "BAZ", "prop3");
        try (KernelTransaction tx = this.beginTransaction();){
            List constraints = Iterators.asList((Iterator)tx.schemaRead().constraintsGetAll());
            MatcherAssert.assertThat((Object)constraints, (Matcher)Matchers.hasSize((int)3));
        }
    }

    @Test
    void shouldCheckUniquenessWhenAddingLabel() throws Exception {
        int label;
        long nodeNotConflicting;
        long nodeConflicting;
        this.addConstraints("FOO", "prop");
        try (Transaction tx = graphDb.beginTx();){
            Node conflict = tx.createNode();
            conflict.setProperty("prop", (Object)1337);
            nodeConflicting = conflict.getId();
            Node ok = tx.createNode();
            ok.setProperty("prop", (Object)42);
            nodeNotConflicting = ok.getId();
            Node existing = tx.createNode();
            existing.addLabel(Label.label((String)"FOO"));
            existing.setProperty("prop", (Object)1337);
            tx.commit();
        }
        try (KernelTransaction tx = this.beginTransaction();){
            label = tx.tokenWrite().labelGetOrCreateForName("FOO");
            Assertions.assertTrue((boolean)tx.dataWrite().nodeAddLabel(nodeNotConflicting, label));
            try {
                tx.dataWrite().nodeAddLabel(nodeConflicting, label);
                Assertions.fail();
            }
            catch (ConstraintValidationException ok) {
                // empty catch block
            }
            tx.commit();
        }
        tx = this.beginTransaction();
        try (NodeCursor nodeCursor = tx.cursors().allocateNodeCursor();){
            tx.dataRead().singleNode(nodeNotConflicting, nodeCursor);
            Assertions.assertTrue((boolean)nodeCursor.next());
            Assertions.assertTrue((boolean)nodeCursor.labels().contains(label));
            tx.dataRead().singleNode(nodeConflicting, nodeCursor);
            Assertions.assertTrue((boolean)nodeCursor.next());
            Assertions.assertFalse((boolean)nodeCursor.labels().contains(label));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldCheckUniquenessWhenAddingProperties() throws Exception {
        int property;
        long nodeNotConflicting;
        long nodeConflicting;
        this.addConstraints("FOO", "prop");
        try (Transaction tx = graphDb.beginTx();){
            Node conflict = tx.createNode();
            conflict.addLabel(Label.label((String)"FOO"));
            nodeConflicting = conflict.getId();
            Node ok = tx.createNode();
            ok.addLabel(Label.label((String)"BAR"));
            nodeNotConflicting = ok.getId();
            Node existing = tx.createNode();
            existing.addLabel(Label.label((String)"FOO"));
            existing.setProperty("prop", (Object)1337);
            tx.commit();
        }
        try (KernelTransaction tx = this.beginTransaction();){
            property = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            tx.dataWrite().nodeSetProperty(nodeNotConflicting, property, (Value)Values.intValue((int)1337));
            try {
                tx.dataWrite().nodeSetProperty(nodeConflicting, property, (Value)Values.intValue((int)1337));
                Assertions.fail();
            }
            catch (ConstraintValidationException ok) {
                // empty catch block
            }
            tx.commit();
        }
        tx = this.beginTransaction();
        try (NodeCursor nodeCursor = tx.cursors().allocateNodeCursor();
             PropertyCursor propertyCursor = tx.cursors().allocatePropertyCursor();){
            tx.dataRead().singleNode(nodeNotConflicting, nodeCursor);
            Assertions.assertTrue((boolean)nodeCursor.next());
            nodeCursor.properties(propertyCursor);
            Assertions.assertTrue((boolean)this.hasKey(propertyCursor, property));
            tx.dataRead().singleNode(nodeConflicting, nodeCursor);
            Assertions.assertTrue((boolean)nodeCursor.next());
            nodeCursor.properties(propertyCursor);
            Assertions.assertFalse((boolean)this.hasKey(propertyCursor, property));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private boolean hasKey(PropertyCursor propertyCursor, int key) {
        while (propertyCursor.next()) {
            if (propertyCursor.propertyKey() != key) continue;
            return true;
        }
        return false;
    }

    private void addConstraints(String ... labelProps) {
        assert (labelProps.length % 2 == 0);
        try (Transaction tx = graphDb.beginTx();){
            for (int i = 0; i < labelProps.length; i += 2) {
                tx.schema().constraintFor(Label.label((String)labelProps[i])).assertPropertyIsUnique(labelProps[i + 1]).create();
            }
            tx.commit();
        }
    }
}

