/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.recovery;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.rule.TestDirectory;

@RunWith(value=Parameterized.class)
public class UniqueIndexRecoveryTest {
    @Rule
    public final TestDirectory storeDir = TestDirectory.testDirectory();
    private static final String PROPERTY_KEY = "key";
    private static final String PROPERTY_VALUE = "value";
    private static final Label LABEL = Label.label((String)"label");
    private GraphDatabaseAPI db;
    private DatabaseManagementService managementService;
    @Parameterized.Parameter
    public GraphDatabaseSettings.SchemaIndex schemaIndex;

    @Parameterized.Parameters(name="{0}")
    public static GraphDatabaseSettings.SchemaIndex[] parameters() {
        return GraphDatabaseSettings.SchemaIndex.values();
    }

    @Before
    public void before() {
        this.db = (GraphDatabaseAPI)this.newDb();
    }

    @After
    public void after() {
        this.managementService.shutdown();
    }

    @Test
    public void shouldRecoverCreationOfUniquenessConstraintFollowedByDeletionOfThatSameConstraint() throws Exception {
        this.createUniqueConstraint();
        this.dropConstraints();
        this.restart(UniqueIndexRecoveryTest.snapshot(this.storeDir.absolutePath()));
        try (Transaction tx = this.db.beginTx();){
            Assert.assertFalse((boolean)tx.schema().getConstraints(LABEL).iterator().hasNext());
            tx.commit();
        }
    }

    @Test
    public void shouldRecoverWhenCommandsTemporarilyViolateConstraints() throws Exception {
        Node unLabeledNode = this.createUnLabeledNodeWithProperty();
        Node labeledNode = this.createLabeledNode();
        this.createUniqueConstraint();
        this.rotateLogAndCheckPoint();
        this.setPropertyOnLabeledNode(labeledNode);
        this.deletePropertyOnLabeledNode(labeledNode);
        this.addLabelToUnLabeledNode(unLabeledNode);
        this.flushAll();
        this.restart(UniqueIndexRecoveryTest.snapshot(this.storeDir.absolutePath()));
        try (Transaction tx = this.db.beginTx();){
            MatcherAssert.assertThat((Object)tx.findNode(LABEL, PROPERTY_KEY, (Object)PROPERTY_VALUE), (Matcher)IsEqual.equalTo((Object)unLabeledNode));
            tx.commit();
        }
    }

    private void restart(File newStore) {
        this.managementService.shutdown();
        this.db = (GraphDatabaseAPI)this.newDb();
    }

    private GraphDatabaseService newDb() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.storeDir.absolutePath()).setConfig(GraphDatabaseSettings.default_schema_provider, (Object)this.schemaIndex.providerName()).build();
        return this.managementService.database("neo4j");
    }

    private static File snapshot(File path) throws IOException {
        File snapshotDir = new File(path, "snapshot-" + new Random().nextInt());
        FileUtils.copyRecursively((File)path, (File)snapshotDir, pathName -> {
            String subPath = pathName.getAbsolutePath().substring(path.getPath().length() + 1);
            return !"store_lock".equals(subPath) && !subPath.endsWith("write.lock");
        });
        return snapshotDir;
    }

    private void addLabelToUnLabeledNode(Node unLabeledNode) {
        try (Transaction tx = this.db.beginTx();){
            tx.getNodeById(unLabeledNode.getId()).addLabel(LABEL);
            tx.commit();
        }
    }

    private void setPropertyOnLabeledNode(Node labeledNode) {
        try (Transaction tx = this.db.beginTx();){
            tx.getNodeById(labeledNode.getId()).setProperty(PROPERTY_KEY, (Object)PROPERTY_VALUE);
            tx.commit();
        }
    }

    private void deletePropertyOnLabeledNode(Node labeledNode) {
        try (Transaction tx = this.db.beginTx();){
            tx.getNodeById(labeledNode.getId()).removeProperty(PROPERTY_KEY);
            tx.commit();
        }
    }

    private void createUniqueConstraint() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(LABEL).assertPropertyIsUnique(PROPERTY_KEY).create();
            tx.commit();
        }
    }

    private Node createLabeledNode() {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{LABEL});
            tx.commit();
            Node node2 = node;
            return node2;
        }
    }

    private Node createUnLabeledNodeWithProperty() {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            node.setProperty(PROPERTY_KEY, (Object)PROPERTY_VALUE);
            tx.commit();
            Node node2 = node;
            return node2;
        }
    }

    private void dropConstraints() {
        try (Transaction tx = this.db.beginTx();){
            for (ConstraintDefinition constraint : tx.schema().getConstraints(LABEL)) {
                constraint.drop();
            }
            tx.commit();
        }
    }

    private void rotateLogAndCheckPoint() throws IOException {
        DependencyResolver resolver = this.db.getDependencyResolver();
        ((LogRotation)resolver.resolveDependency(LogRotation.class)).rotateLogFile(LogAppendEvent.NULL);
        ((CheckPointer)resolver.resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
    }

    private void flushAll() throws IOException {
        ((CheckPointerImpl.ForceOperation)this.db.getDependencyResolver().resolveDependency(CheckPointerImpl.ForceOperation.class)).flushAndForce(IOLimiter.UNLIMITED);
    }
}

