/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.common.EntityType;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexLimitation;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexValueCapability;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexSettingsKeys;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextTestSupport;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.Values;

public class LuceneFulltextIndexTest
extends LuceneFulltextTestSupport {
    private static final String NODE_INDEX_NAME = "nodes";
    private static final String REL_INDEX_NAME = "rels";

    @Test
    public void shouldFindNodeWithString() throws Exception {
        long secondID;
        long firstID;
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").withIndexType(IndexType.FULLTEXT).withName(NODE_INDEX_NAME).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NODE_INDEX_NAME, 30L, TimeUnit.SECONDS);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction tx = this.db.beginTx();){
            firstID = this.createNodeIndexableByPropertyValue(tx, LABEL, "Hello. Hello again.");
            secondID = this.createNodeIndexableByPropertyValue(tx, LABEL, "A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "hello", firstID);
            this.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "zebra", secondID);
            this.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "zedonk", secondID);
            this.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "cross", secondID);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void shouldRepresentPropertyChanges() throws Exception {
        long secondID;
        long firstID;
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").withIndexType(IndexType.FULLTEXT).withName(NODE_INDEX_NAME).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NODE_INDEX_NAME, 30L, TimeUnit.SECONDS);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction tx = this.db.beginTx();){
            firstID = this.createNodeIndexableByPropertyValue(tx, LABEL, "Hello. Hello again.");
            secondID = this.createNodeIndexableByPropertyValue(tx, LABEL, "A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            this.setNodeProp(tx, firstID, "Finally! Potato!");
            this.setNodeProp(tx, secondID, "This one is a potato farmer.");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "hello");
            this.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "zebra");
            this.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "zedonk");
            this.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "cross");
            this.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "finally", firstID);
            this.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "farmer", secondID);
            this.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "potato", firstID, secondID);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void shouldNotFindRemovedNodes() throws Exception {
        long secondID;
        long firstID;
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").withIndexType(IndexType.FULLTEXT).withName(NODE_INDEX_NAME).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NODE_INDEX_NAME, 30L, TimeUnit.SECONDS);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction tx = this.db.beginTx();){
            firstID = this.createNodeIndexableByPropertyValue(tx, LABEL, "Hello. Hello again.");
            secondID = this.createNodeIndexableByPropertyValue(tx, LABEL, "A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(firstID).delete();
            tx.getNodeById(secondID).delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "hello");
            this.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "zebra");
            this.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "zedonk");
            this.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "cross");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void shouldNotFindRemovedProperties() throws Exception {
        long thirdID;
        long secondID;
        long firstID;
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").on("prop2").withIndexType(IndexType.FULLTEXT).withName(NODE_INDEX_NAME).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NODE_INDEX_NAME, 30L, TimeUnit.SECONDS);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction tx = this.db.beginTx();){
            firstID = this.createNodeIndexableByPropertyValue(tx, LABEL, "Hello. Hello again.");
            secondID = this.createNodeIndexableByPropertyValue(tx, LABEL, "A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
            thirdID = this.createNodeIndexableByPropertyValue(tx, LABEL, "Hello. Hello again.");
            this.setNodeProp(tx, firstID, "zebra");
            this.setNodeProp(tx, secondID, "Hello. Hello again.");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Node node = tx.getNodeById(firstID);
            Node node2 = tx.getNodeById(secondID);
            Node node3 = tx.getNodeById(thirdID);
            node.setProperty("prop", (Object)"tomtar");
            node.setProperty("prop2", (Object)"tomtar");
            node2.setProperty("prop", (Object)"tomtar");
            node2.setProperty("prop2", (Object)"Hello");
            node3.removeProperty("prop");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "hello", secondID);
            this.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "zebra");
            this.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "zedonk");
            this.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "cross");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void shouldOnlyIndexIndexedProperties() throws Exception {
        long firstID;
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").withIndexType(IndexType.FULLTEXT).withName(NODE_INDEX_NAME).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NODE_INDEX_NAME, 30L, TimeUnit.SECONDS);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction tx = this.db.beginTx();){
            firstID = this.createNodeIndexableByPropertyValue(tx, LABEL, "Hello. Hello again.");
            this.setNodeProp(tx, firstID, "prop2", "zebra");
            Node node2 = tx.createNode(new Label[]{LABEL});
            node2.setProperty("prop2", (Object)"zebra");
            node2.setProperty("prop3", (Object)"hello");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "hello", firstID);
            this.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "zebra");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void shouldSearchAcrossMultipleProperties() throws Exception {
        long thirdID;
        long secondID;
        long firstID;
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").on("prop2").withIndexType(IndexType.FULLTEXT).withName(NODE_INDEX_NAME).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NODE_INDEX_NAME, 30L, TimeUnit.SECONDS);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction tx = this.db.beginTx();){
            firstID = this.createNodeIndexableByPropertyValue(tx, LABEL, "Tomtar tomtar oftsat i tomteutstyrsel.");
            secondID = this.createNodeIndexableByPropertyValue(tx, LABEL, "Olof och Hans");
            this.setNodeProp(tx, secondID, "prop2", "och karl");
            Node node3 = tx.createNode(new Label[]{LABEL});
            thirdID = node3.getId();
            node3.setProperty("prop2", (Object)"Tomtar som inte tomtar ser upp till tomtar som tomtar.");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "tomtar Karl", firstID, secondID, thirdID);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void shouldOrderResultsBasedOnRelevance() throws Exception {
        long fourthID;
        long thirdID;
        long secondID;
        long firstID;
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("first").on("last").withIndexType(IndexType.FULLTEXT).withName(NODE_INDEX_NAME).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NODE_INDEX_NAME, 30L, TimeUnit.SECONDS);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction tx = this.db.beginTx();){
            firstID = tx.createNode(new Label[]{LABEL}).getId();
            secondID = tx.createNode(new Label[]{LABEL}).getId();
            thirdID = tx.createNode(new Label[]{LABEL}).getId();
            fourthID = tx.createNode(new Label[]{LABEL}).getId();
            this.setNodeProp(tx, firstID, "first", "Full");
            this.setNodeProp(tx, firstID, "last", "Hanks");
            this.setNodeProp(tx, secondID, "first", "Tom");
            this.setNodeProp(tx, secondID, "last", "Hunk");
            this.setNodeProp(tx, thirdID, "first", "Tom");
            this.setNodeProp(tx, thirdID, "last", "Hanks");
            this.setNodeProp(tx, fourthID, "first", "Tom Hanks");
            this.setNodeProp(tx, fourthID, "last", "Tom Hanks");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsNodeIdsInOrder(ktx, NODE_INDEX_NAME, "Tom Hanks", fourthID, thirdID, firstID, secondID);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void shouldDifferentiateNodesAndRelationships() throws Exception {
        long secondRelID;
        long firstRelID;
        long secondNodeID;
        long firstNodeID;
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").withIndexType(IndexType.FULLTEXT).withName(NODE_INDEX_NAME).create();
            tx.schema().indexFor(RELTYPE).on("prop").withIndexType(IndexType.FULLTEXT).withName(REL_INDEX_NAME).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NODE_INDEX_NAME, 30L, TimeUnit.SECONDS);
            tx.schema().awaitIndexOnline(REL_INDEX_NAME, 30L, TimeUnit.SECONDS);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction tx = this.db.beginTx();){
            firstNodeID = this.createNodeIndexableByPropertyValue(tx, LABEL, "Hello. Hello again.");
            secondNodeID = this.createNodeIndexableByPropertyValue(tx, LABEL, "A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
            firstRelID = this.createRelationshipIndexableByPropertyValue(tx, firstNodeID, secondNodeID, "Hello. Hello again.");
            secondRelID = this.createRelationshipIndexableByPropertyValue(tx, secondNodeID, firstNodeID, "And now, something completely different");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "hello", firstNodeID);
            this.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "zebra", secondNodeID);
            this.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "different");
            this.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "hello", firstRelID);
            this.assertQueryFindsNothing(ktx, false, REL_INDEX_NAME, "zebra");
            this.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "different", secondRelID);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void shouldNotReturnNonMatches() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").withIndexType(IndexType.FULLTEXT).withName(NODE_INDEX_NAME).create();
            tx.schema().indexFor(RELTYPE).on("prop").withIndexType(IndexType.FULLTEXT).withName(REL_INDEX_NAME).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NODE_INDEX_NAME, 30L, TimeUnit.SECONDS);
            tx.schema().awaitIndexOnline(REL_INDEX_NAME, 30L, TimeUnit.SECONDS);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            long firstNode = this.createNodeIndexableByPropertyValue(tx, LABEL, "Hello. Hello again.");
            long secondNode = this.createNodeWithProperty(tx, LABEL, "prop2", "A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
            this.createRelationshipIndexableByPropertyValue(tx, firstNode, secondNode, "Hello. Hello again.");
            this.createRelationshipWithProperty(tx, secondNode, firstNode, "prop2", "A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "zebra");
            this.assertQueryFindsNothing(ktx, false, REL_INDEX_NAME, "zebra");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void shouldPopulateIndexWithExistingNodesAndRelationships() throws Exception {
        long secondRelID;
        long firstRelID;
        long secondNodeID;
        long firstNodeID;
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            node.createRelationshipTo(node, RELTYPE);
            node.createRelationshipTo(node, RELTYPE);
            node.createRelationshipTo(node, RELTYPE);
            firstNodeID = this.createNodeIndexableByPropertyValue(tx, LABEL, "Hello. Hello again.");
            secondNodeID = this.createNodeIndexableByPropertyValue(tx, LABEL, "This string is slightly shorter than the zebra one");
            firstRelID = this.createRelationshipIndexableByPropertyValue(tx, firstNodeID, secondNodeID, "Goodbye");
            secondRelID = this.createRelationshipIndexableByPropertyValue(tx, secondNodeID, firstNodeID, "And now, something completely different");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().indexFor(LABEL).on("prop").withIndexType(IndexType.FULLTEXT).withName(NODE_INDEX_NAME).create();
            tx.schema().indexFor(RELTYPE).on("prop").withIndexType(IndexType.FULLTEXT).withName(REL_INDEX_NAME).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NODE_INDEX_NAME, 30L, TimeUnit.SECONDS);
            tx.schema().awaitIndexOnline(REL_INDEX_NAME, 30L, TimeUnit.SECONDS);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "hello", firstNodeID);
            this.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "string", secondNodeID);
            this.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "goodbye");
            this.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "different");
            this.assertQueryFindsNothing(ktx, false, REL_INDEX_NAME, "hello");
            this.assertQueryFindsNothing(ktx, false, REL_INDEX_NAME, "string");
            this.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "goodbye", firstRelID);
            this.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "different", secondRelID);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void shouldBeAbleToUpdateAndQueryAfterIndexChange() throws Exception {
        long fourthID;
        KernelTransaction ktx;
        long thirdID;
        long secondID;
        long firstID;
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").withIndexType(IndexType.FULLTEXT).withName(NODE_INDEX_NAME).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NODE_INDEX_NAME, 30L, TimeUnit.SECONDS);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction tx = this.db.beginTx();){
            firstID = this.createNodeIndexableByPropertyValue(tx, LABEL, "thing");
            secondID = tx.createNode(new Label[]{LABEL}).getId();
            this.setNodeProp(tx, secondID, "prop2", "zebra");
            thirdID = this.createNodeIndexableByPropertyValue(tx, LABEL, "zebra");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "thing zebra", firstID, thirdID);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().getIndexByName(NODE_INDEX_NAME).drop();
            tx.schema().indexFor(LABEL).on("prop2").withIndexType(IndexType.FULLTEXT).withName(NODE_INDEX_NAME).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NODE_INDEX_NAME, 30L, TimeUnit.SECONDS);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            this.setNodeProp(tx, firstID, "prop2", "thing");
            fourthID = tx.createNode(new Label[]{LABEL}).getId();
            this.setNodeProp(tx, fourthID, "prop2", "zebra");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "thing zebra", firstID, secondID, fourthID);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void shouldBeAbleToDropAndReadIndex() throws Exception {
        long secondID;
        long firstID;
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").withIndexType(IndexType.FULLTEXT).withName(NODE_INDEX_NAME).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NODE_INDEX_NAME, 30L, TimeUnit.SECONDS);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction tx = this.db.beginTx();){
            firstID = this.createNodeIndexableByPropertyValue(tx, LABEL, "thing");
            secondID = this.createNodeIndexableByPropertyValue(tx, LABEL, "zebra");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().getIndexByName(NODE_INDEX_NAME).drop();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().indexFor(LABEL).on("prop").withIndexType(IndexType.FULLTEXT).withName(NODE_INDEX_NAME).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NODE_INDEX_NAME, 30L, TimeUnit.SECONDS);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "thing zebra", firstID, secondID);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void completeConfigurationMustInjectMissingConfigurations() throws Exception {
        int propertyKey;
        int label;
        try (Transaction tx = this.db.beginTx();){
            this.createNodeIndexableByPropertyValue(tx, LABEL, "bla");
            tx.commit();
        }
        tx = this.getKernelTransaction();
        try {
            label = tx.tokenRead().nodeLabel(LABEL.name());
            propertyKey = tx.tokenRead().propertyKey("prop");
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        IndexConfig indexConfig = IndexConfig.with((String)FulltextIndexSettingsKeys.EVENTUALLY_CONSISTENT, (Value)Values.booleanValue((boolean)true));
        FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)EntityType.NODE, (int[])new int[]{label}, (int[])new int[]{propertyKey});
        IndexProviderDescriptor providerDescriptor = this.indexProvider.getProviderDescriptor();
        IndexDescriptor descriptor = this.indexProvider.completeConfiguration(IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)providerDescriptor).withName("index_1").withIndexConfig(indexConfig).materialise(1L));
        Assert.assertThat((Object)((TextValue)descriptor.getIndexConfig().get(FulltextIndexSettingsKeys.ANALYZER)), (Matcher)Matchers.is((Object)Values.stringValue((String)"standard-no-stop-words")));
        Assert.assertThat((Object)((BooleanValue)descriptor.getIndexConfig().get(FulltextIndexSettingsKeys.EVENTUALLY_CONSISTENT)), (Matcher)Matchers.is((Object)Values.booleanValue((boolean)true)));
        Assert.assertThat(Arrays.asList(descriptor.getCapability().limitations()), (Matcher)Matchers.contains((Object[])new IndexLimitation[]{IndexLimitation.EVENTUALLY_CONSISTENT}));
    }

    @Test
    public void completeConfigurationMustNotOverwriteExistingConfiguration() {
        IndexConfig indexConfig = IndexConfig.with((String)"A", (Value)Values.stringValue((String)"B"));
        FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)EntityType.NODE, (int[])new int[]{1}, (int[])new int[]{1});
        IndexProviderDescriptor providerDescriptor = this.indexProvider.getProviderDescriptor();
        IndexDescriptor descriptor = this.indexProvider.completeConfiguration(IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)providerDescriptor).withName("index_1").materialise(1L)).withIndexConfig(indexConfig);
        Assert.assertEquals((Object)Values.stringValue((String)"B"), (Object)descriptor.getIndexConfig().get("A"));
    }

    @Test
    public void completeConfigurationMustBeIdempotent() {
        FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)EntityType.NODE, (int[])new int[]{1}, (int[])new int[]{1});
        IndexProviderDescriptor providerDescriptor = this.indexProvider.getProviderDescriptor();
        IndexDescriptor onceCompleted = this.indexProvider.completeConfiguration(IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)providerDescriptor).withName("index_1").materialise(1L));
        IndexDescriptor twiceCompleted = this.indexProvider.completeConfiguration(onceCompleted);
        Assert.assertEquals((Object)onceCompleted.getIndexConfig(), (Object)twiceCompleted.getIndexConfig());
    }

    @Test
    public void mustAssignCapabilitiesToDescriptorsThatHaveNone() {
        FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)EntityType.NODE, (int[])new int[]{1}, (int[])new int[]{1});
        IndexProviderDescriptor providerDescriptor = this.indexProvider.getProviderDescriptor();
        IndexDescriptor completed = this.indexProvider.completeConfiguration(IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)providerDescriptor).withName("index_1").materialise(1L));
        Assert.assertNotEquals((Object)completed.getCapability(), (Object)IndexCapability.NO_CAPABILITY);
        completed = completed.withIndexCapability(IndexCapability.NO_CAPABILITY);
        completed = this.indexProvider.completeConfiguration(completed);
        Assert.assertNotEquals((Object)completed.getCapability(), (Object)IndexCapability.NO_CAPABILITY);
    }

    @Test
    public void mustNotOverwriteExistingCapabilities() {
        IndexCapability capability = new IndexCapability(){

            public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
                return new IndexOrder[0];
            }

            public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
                return IndexValueCapability.NO;
            }
        };
        FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)EntityType.NODE, (int[])new int[]{1}, (int[])new int[]{1});
        IndexProviderDescriptor providerDescriptor = this.indexProvider.getProviderDescriptor();
        IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)providerDescriptor).withName("index_1").materialise(1L).withIndexCapability(capability);
        IndexDescriptor completed = this.indexProvider.completeConfiguration(index);
        Assert.assertSame((Object)capability, (Object)completed.getCapability());
    }

    @Test
    public void fulltextIndexMustNotAnswerCoreApiIndexQueries() {
        long nodeId;
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").withIndexType(IndexType.FULLTEXT).withName(NODE_INDEX_NAME).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NODE_INDEX_NAME, 30L, TimeUnit.SECONDS);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction tx = this.db.beginTx();){
            nodeId = this.createNodeIndexableByPropertyValue(tx, LABEL, 1);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Node node = tx.findNode(LABEL, "prop", (Object)1);
            Assert.assertThat((Object)node.getId(), (Matcher)Matchers.is((Object)nodeId));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void fulltextIndexMustNotAnswerCoreApiCompositeIndexQueries() {
        long nodeId;
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").on("prop2").withIndexType(IndexType.FULLTEXT).withName(NODE_INDEX_NAME).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NODE_INDEX_NAME, 30L, TimeUnit.SECONDS);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)1);
            node.setProperty("prop2", (Object)2);
            nodeId = node.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Node node;
            try (ResourceIterator nodes = tx.findNodes(LABEL, "prop", (Object)1, "prop2", (Object)2);){
                Assert.assertTrue((boolean)nodes.hasNext());
                node = (Node)nodes.next();
                Assert.assertThat((Object)node.getId(), (Matcher)Matchers.is((Object)nodeId));
                Assert.assertFalse((boolean)nodes.hasNext());
            }
            nodes = tx.findNodes(LABEL, "prop2", (Object)2, "prop", (Object)1);
            try {
                Assert.assertTrue((boolean)nodes.hasNext());
                node = (Node)nodes.next();
                Assert.assertThat((Object)node.getId(), (Matcher)Matchers.is((Object)nodeId));
                Assert.assertFalse((boolean)nodes.hasNext());
            }
            finally {
                if (nodes != null) {
                    nodes.close();
                }
            }
            nodes = tx.findNodes(LABEL, "prop", (Object)1);
            try {
                Assert.assertTrue((boolean)nodes.hasNext());
                node = (Node)nodes.next();
                Assert.assertThat((Object)node.getId(), (Matcher)Matchers.is((Object)nodeId));
                Assert.assertFalse((boolean)nodes.hasNext());
            }
            finally {
                if (nodes != null) {
                    nodes.close();
                }
            }
            nodes = tx.findNodes(LABEL, "prop2", (Object)2);
            try {
                Assert.assertTrue((boolean)nodes.hasNext());
                node = (Node)nodes.next();
                Assert.assertThat((Object)node.getId(), (Matcher)Matchers.is((Object)nodeId));
                Assert.assertFalse((boolean)nodes.hasNext());
            }
            finally {
                if (nodes != null) {
                    nodes.close();
                }
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

