/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@DbmsExtension(configurationCallback="configure")
@ExtendWith(value={RandomExtension.class})
public abstract class StringLengthIndexValidationIT {
    private static final String propKey = "largeString";
    private final int singleKeySizeLimit = this.getSingleKeySizeLimit();
    private final GraphDatabaseSettings.SchemaIndex schemaIndex = this.getSchemaIndex();
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private RandomRule random;

    protected abstract int getSingleKeySizeLimit();

    protected abstract GraphDatabaseSettings.SchemaIndex getSchemaIndex();

    protected abstract String expectedPopulationFailureMessage();

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.default_schema_provider, (Object)this.schemaIndex.providerName());
    }

    @Test
    void shouldSuccessfullyWriteAndReadWithinIndexKeySizeLimit() {
        this.createIndex(propKey);
        String propValue = this.getString(this.singleKeySizeLimit);
        long expectedNodeId = this.createNode(propValue);
        this.assertReadNode(propValue, expectedNodeId);
    }

    @Test
    void shouldSuccessfullyPopulateIndexWithinIndexKeySizeLimit() {
        String propValue = this.getString(this.singleKeySizeLimit);
        long expectedNodeId = this.createNode(propValue);
        this.createIndex(propKey);
        this.assertReadNode(propValue, expectedNodeId);
    }

    @Test
    void txMustFailIfExceedingIndexKeySizeLimit() {
        this.createIndex(propKey);
        try (Transaction tx = this.db.beginTx();){
            String propValue = this.getString(this.singleKeySizeLimit + 1);
            tx.createNode(new Label[]{TestLabels.LABEL_ONE}).setProperty(propKey, (Object)propValue);
            tx.commit();
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Property value is too large to index into this particular index. Please see index documentation for limitations."));
        }
    }

    @Test
    void indexPopulationMustFailIfExceedingIndexKeySizeLimit() {
        String propValue = this.getString(this.singleKeySizeLimit + 1);
        this.createNode(propValue);
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(TestLabels.LABEL_ONE).on(propKey).create();
            tx.commit();
        }
        try {
            tx = this.db.beginTx();
            try {
                tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (IllegalStateException e) {
            GraphDatabaseSettings.SchemaIndex schemaIndex = this.getSchemaIndex();
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)String.format("Index IndexDefinition[label:LABEL_ONE on:largeString] (Index( 1, 'index_71616483', GENERAL BTREE, :label[0](property[0]), %s )) entered a FAILED state.", schemaIndex.providerName())));
        }
        tx = this.db.beginTx();
        try {
            Iterator iterator = tx.schema().getIndexes(TestLabels.LABEL_ONE).iterator();
            Assertions.assertTrue((boolean)iterator.hasNext());
            IndexDefinition next = (IndexDefinition)iterator.next();
            Assertions.assertEquals((Object)Schema.IndexState.FAILED, (Object)tx.schema().getIndexState(next), (String)"state is FAILED");
            MatcherAssert.assertThat((Object)tx.schema().getIndexFailure(next), (Matcher)Matchers.containsString((String)this.expectedPopulationFailureMessage()));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldHandleSizesCloseToTheLimit() {
        Node node;
        this.createIndex(propKey);
        HashMap<String, Long> strings = new HashMap<String, Long>();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                String string;
                while (strings.containsKey(string = this.random.nextAlphaNumericString(this.singleKeySizeLimit / 2, this.singleKeySizeLimit))) {
                }
                node = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
                node.setProperty(propKey, (Object)string);
                strings.put(string, node.getId());
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            for (String string : strings.keySet()) {
                node = tx.findNode(TestLabels.LABEL_ONE, propKey, (Object)string);
                Assertions.assertEquals((long)((Long)strings.get(string)), (long)node.getId());
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private String getString(int byteArraySize) {
        return this.random.nextAlphaNumericString(byteArraySize, byteArraySize);
    }

    private void createIndex(String ... keys) {
        try (Transaction tx = this.db.beginTx();){
            IndexCreator indexCreator = tx.schema().indexFor(TestLabels.LABEL_ONE);
            for (String key : keys) {
                indexCreator = indexCreator.on(key);
            }
            indexCreator.create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private long createNode(String propValue) {
        long expectedNodeId;
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
            node.setProperty(propKey, (Object)propValue);
            expectedNodeId = node.getId();
            tx.commit();
        }
        return expectedNodeId;
    }

    private void assertReadNode(String propValue, long expectedNodeId) {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.findNode(TestLabels.LABEL_ONE, propKey, (Object)propValue);
            Assertions.assertNotNull((Object)node);
            Assertions.assertEquals((long)expectedNodeId, (long)node.getId(), (String)"node id");
            tx.commit();
        }
    }
}

