/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.index.SabotageNativeIndex;
import org.neo4j.test.rule.DbmsRule;
import org.neo4j.test.rule.EmbeddedDbmsRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Values;

public class IndexFailureOnStartupTest {
    private static final Label PERSON = Label.label((String)"Person");
    @Rule
    public final RandomRule random = new RandomRule();
    @Rule
    public final DbmsRule db = new EmbeddedDbmsRule().startLazily();

    @Test
    public void failedIndexShouldRepairAutomatically() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(PERSON).on("name").create();
            tx.commit();
        }
        this.awaitIndexesOnline(5, TimeUnit.SECONDS);
        this.createNamed(PERSON, "Johan");
        this.db.restartDatabase((DbmsRule.RestartAction)new SabotageNativeIndex(this.random.random()));
        this.createNamed(PERSON, "Lars");
        this.awaitIndexesOnline(5, TimeUnit.SECONDS);
        this.indexStateShouldBe((Matcher<Schema.IndexState>)CoreMatchers.equalTo((Object)Schema.IndexState.ONLINE));
        this.assertFindsNamed(PERSON, "Lars");
    }

    @Test
    public void shouldNotBeAbleToViolateConstraintWhenBackingIndexFailsToOpen() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(PERSON).assertPropertyIsUnique("name").create();
            tx.commit();
        }
        this.createNamed(PERSON, "Lars");
        this.db.restartDatabase((DbmsRule.RestartAction)new SabotageNativeIndex(this.random.random()));
        this.createNamed(PERSON, "Johan");
        Throwable failure = null;
        try {
            this.createNamed(PERSON, "Lars");
        }
        catch (Throwable e) {
            failure = e;
        }
        Assert.assertNotNull((Object)failure);
        this.indexStateShouldBe((Matcher<Schema.IndexState>)CoreMatchers.equalTo((Object)Schema.IndexState.ONLINE));
    }

    @Test
    public void shouldArchiveFailedIndex() throws Exception {
        Node node;
        this.db.withSetting(GraphDatabaseSettings.archive_failed_index, (Object)true);
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{PERSON});
            node.setProperty("name", (Object)"Fry");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.createNode(new Label[]{PERSON});
            node.setProperty("name", (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{1.0, 2.0}));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().constraintFor(PERSON).assertPropertyIsUnique("name").create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        Assert.assertThat((Object)this.archiveFile(), (Matcher)CoreMatchers.nullValue());
        this.db.restartDatabase((DbmsRule.RestartAction)new SabotageNativeIndex(this.random.random()));
        this.indexStateShouldBe((Matcher<Schema.IndexState>)CoreMatchers.equalTo((Object)Schema.IndexState.ONLINE));
        Assert.assertThat((Object)this.archiveFile(), (Matcher)CoreMatchers.notNullValue());
    }

    private File archiveFile() {
        File indexDir = SabotageNativeIndex.nativeIndexDirectoryStructure(this.db.databaseLayout()).rootDirectory();
        File[] files = indexDir.listFiles(pathname -> pathname.isFile() && pathname.getName().startsWith("archive-"));
        if (files == null || files.length == 0) {
            return null;
        }
        Assert.assertEquals((long)1L, (long)files.length);
        return files[0];
    }

    private void awaitIndexesOnline(int timeout, TimeUnit unit) {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline((long)timeout, unit);
            tx.commit();
        }
    }

    private void assertFindsNamed(Label label, String name) {
        try (Transaction tx = this.db.beginTx();){
            Assert.assertNotNull((String)"Must be able to find node created while index was offline", (Object)tx.findNode(label, "name", (Object)name));
            tx.commit();
        }
    }

    private void indexStateShouldBe(Matcher<Schema.IndexState> matchesExpectation) {
        try (Transaction tx = this.db.beginTx();){
            for (IndexDefinition index : tx.schema().getIndexes()) {
                Assert.assertThat((Object)tx.schema().getIndexState(index), matchesExpectation);
            }
            tx.commit();
        }
    }

    private void createNamed(Label label, String name) {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode(new Label[]{label}).setProperty("name", (Object)name);
            tx.commit();
        }
    }
}

