/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.function.ThrowingAction;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextTestSupport;
import org.neo4j.test.Race;
import org.neo4j.test.rule.RepeatRule;

public class ConcurrentLuceneFulltextUpdaterTest
extends LuceneFulltextTestSupport {
    private final int aliceThreads = 1;
    private final int bobThreads = 1;
    private final int nodesCreatedPerThread = 500;
    private Race race;
    private CountDownLatch aliceLatch = new CountDownLatch(2);
    private CountDownLatch bobLatch = new CountDownLatch(2);

    @Override
    protected RepeatRule createRepeatRule() {
        return new RepeatRule(false, 1);
    }

    @Before
    public void createRace() {
        this.race = new Race();
    }

    private void createInitialIndex() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").withIndexType(IndexType.FULLTEXT).withName("nodes").create();
            tx.commit();
        }
    }

    private void raceContestantsAndVerifyResults(Runnable aliceWork, Runnable changeConfig, Runnable bobWork) throws Throwable {
        this.race.addContestants(1, aliceWork);
        this.race.addContestant(changeConfig);
        this.race.addContestants(1, bobWork);
        this.race.go();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexOnline("nodes", 30L, TimeUnit.SECONDS);
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = ConcurrentLuceneFulltextUpdaterTest.kernelTransaction(tx);
            IndexReadSession index = ktx.dataRead().indexReadSession(ktx.schemaRead().indexGetForName("nodes"));
            try (NodeValueIndexCursor bobCursor = ktx.cursors().allocateNodeValueIndexCursor();){
                ktx.dataRead().nodeIndexSeek(index, bobCursor, IndexOrder.NONE, false, new IndexQuery[]{IndexQuery.fulltextSearch((String)"bob")});
                int bobCount = 0;
                while (bobCursor.next()) {
                    ++bobCount;
                }
                Assert.assertEquals((long)500L, (long)bobCount);
            }
            try (NodeValueIndexCursor aliceCursor = ktx.cursors().allocateNodeValueIndexCursor();){
                ktx.dataRead().nodeIndexSeek(index, aliceCursor, IndexOrder.NONE, false, new IndexQuery[]{IndexQuery.fulltextSearch((String)"alice")});
                int aliceCount = 0;
                while (aliceCursor.next()) {
                    ++aliceCount;
                }
                Assert.assertEquals((long)0L, (long)aliceCount);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private Runnable work(int iterations, ThrowingConsumer<Transaction, Exception> work) {
        return () -> {
            try {
                for (int i = 0; i < iterations; ++i) {
                    Thread.yield();
                    try (Transaction tx = this.db.beginTx();){
                        Thread.yield();
                        work.accept((Object)tx);
                        Thread.yield();
                        tx.commit();
                        continue;
                    }
                }
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        };
    }

    private ThrowingAction<Exception> dropAndReCreateIndex() {
        return () -> {
            this.aliceLatch.await();
            this.bobLatch.await();
            try (Transaction tx = this.db.beginTx();){
                tx.schema().getIndexByName("nodes").drop();
                tx.schema().indexFor(LABEL).on("otherProp").withIndexType(IndexType.FULLTEXT).withName("nodes").create();
                tx.commit();
            }
        };
    }

    @Test
    public void labelledNodesCoreAPI() throws Throwable {
        this.createInitialIndex();
        Runnable aliceWork = this.work(500, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            tx.getNodeById(this.createNodeIndexableByPropertyValue((Transaction)tx, LABEL, "alice"));
            this.aliceLatch.countDown();
        }));
        Runnable bobWork = this.work(500, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            tx.getNodeById(this.createNodeWithProperty((Transaction)tx, LABEL, "otherProp", "bob"));
            this.bobLatch.countDown();
        }));
        Runnable changeConfig = this.work(1, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> this.dropAndReCreateIndex().apply()));
        this.raceContestantsAndVerifyResults(aliceWork, changeConfig, bobWork);
    }

    @Test
    public void labelledNodesCypherCurrent() throws Throwable {
        this.createInitialIndex();
        Runnable aliceWork = this.work(500, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            tx.execute("create (:LABEL {prop: \"alice\"})").close();
            this.aliceLatch.countDown();
        }));
        Runnable bobWork = this.work(500, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            tx.execute("create (:LABEL {otherProp: \"bob\"})").close();
            this.bobLatch.countDown();
        }));
        Runnable changeConfig = this.work(1, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> this.dropAndReCreateIndex().apply()));
        this.raceContestantsAndVerifyResults(aliceWork, changeConfig, bobWork);
    }
}

