/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProvider;
import org.neo4j.kernel.impl.api.KernelImpl;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.test.rule.DbmsRule;
import org.neo4j.test.rule.EmbeddedDbmsRule;
import org.neo4j.test.rule.RepeatRule;

public class LuceneFulltextTestSupport {
    static final Label LABEL = Label.label((String)"LABEL");
    static final RelationshipType RELTYPE = RelationshipType.withName((String)"type");
    static final String PROP = "prop";
    static final String PROP2 = "prop2";
    static final String PROP3 = "prop3";
    DbmsRule db = new EmbeddedDbmsRule();
    private RepeatRule repeatRule = this.createRepeatRule();
    @Rule
    public RuleChain rules = RuleChain.outerRule((TestRule)this.repeatRule).around((TestRule)this.db);
    FulltextIndexProvider indexProvider;

    protected RepeatRule createRepeatRule() {
        return new RepeatRule(false, 1);
    }

    @Before
    public void setUp() {
        this.indexProvider = this.getAdapter();
    }

    void applySetting(Setting<String> setting, String value) throws IOException {
        this.db.restartDatabase(Map.of(setting, value));
        this.db.ensureStarted();
        this.indexProvider = this.getAdapter();
    }

    KernelTransactionImplementation getKernelTransaction() {
        try {
            return (KernelTransactionImplementation)((KernelImpl)this.db.resolveDependency(KernelImpl.class)).beginTransaction(KernelTransaction.Type.explicit, LoginContext.AUTH_DISABLED);
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException("oops");
        }
    }

    private FulltextIndexProvider getAdapter() {
        return (FulltextIndexProvider)((IndexProviderMap)this.db.resolveDependency(IndexProviderMap.class)).lookup(FulltextIndexProviderFactory.DESCRIPTOR);
    }

    long createNodeIndexableByPropertyValue(Transaction tx, Label label, Object propertyValue) {
        return this.createNodeWithProperty(tx, label, PROP, propertyValue);
    }

    long createNodeWithProperty(Transaction tx, Label label, String propertyKey, Object propertyValue) {
        Node node = tx.createNode(new Label[]{label});
        node.setProperty(propertyKey, propertyValue);
        return node.getId();
    }

    long createRelationshipIndexableByPropertyValue(Transaction transaction, long firstNodeId, long secondNodeId, Object propertyValue) {
        return this.createRelationshipWithProperty(transaction, firstNodeId, secondNodeId, PROP, propertyValue);
    }

    long createRelationshipWithProperty(Transaction transaction, long firstNodeId, long secondNodeId, String propertyKey, Object propertyValue) {
        Node first = transaction.getNodeById(firstNodeId);
        Node second = transaction.getNodeById(secondNodeId);
        Relationship relationship = first.createRelationshipTo(second, RELTYPE);
        relationship.setProperty(propertyKey, propertyValue);
        return relationship.getId();
    }

    static KernelTransaction kernelTransaction(Transaction tx) {
        Assert.assertThat((Object)tx, (Matcher)Matchers.instanceOf(TransactionImpl.class));
        return ((InternalTransaction)tx).kernelTransaction();
    }

    void assertQueryFindsNothing(KernelTransaction ktx, boolean nodes, String indexName, String query) throws Exception {
        this.assertQueryFindsIds(ktx, nodes, indexName, query, new long[0]);
    }

    void assertQueryFindsIds(KernelTransaction ktx, boolean nodes, String indexName, String query, long ... ids) throws Exception {
        IndexDescriptor index = ktx.schemaRead().indexGetForName(indexName);
        IndexReadSession indexSession = ktx.dataRead().indexReadSession(index);
        MutableLongSet set = LongSets.mutable.of(ids);
        if (nodes) {
            try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor();){
                ktx.dataRead().nodeIndexSeek(indexSession, cursor, IndexOrder.NONE, false, new IndexQuery[]{IndexQuery.fulltextSearch((String)query)});
                while (cursor.next()) {
                    long nodeId = cursor.nodeReference();
                    Assert.assertTrue((String)String.format("Result returned node id %d, expected one of %s", nodeId, Arrays.toString(ids)), (boolean)set.remove(nodeId));
                }
            }
        }
        try (RelationshipIndexCursor cursor = ktx.cursors().allocateRelationshipIndexCursor();){
            ktx.dataRead().relationshipIndexSeek(index, cursor, new IndexQuery[]{IndexQuery.fulltextSearch((String)query)});
            while (cursor.next()) {
                long relationshipId = cursor.relationshipReference();
                Assert.assertTrue((String)String.format("Result returned relationship id %d, expected one of %s", relationshipId, Arrays.toString(ids)), (boolean)set.remove(relationshipId));
            }
        }
        if (!set.isEmpty()) {
            Assert.fail((String)("Number of results differ from expected. " + set.size() + " IDs were not found in the result: " + set));
        }
    }

    void assertQueryFindsNodeIdsInOrder(KernelTransaction ktx, String indexName, String query, long ... ids) throws Exception {
        IndexDescriptor index = ktx.schemaRead().indexGetForName(indexName);
        IndexReadSession indexSession = ktx.dataRead().indexReadSession(index);
        try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor();){
            int num = 0;
            float score = Float.MAX_VALUE;
            ktx.dataRead().nodeIndexSeek(indexSession, cursor, IndexOrder.NONE, false, new IndexQuery[]{IndexQuery.fulltextSearch((String)query)});
            while (cursor.next()) {
                long nextId = cursor.nodeReference();
                float nextScore = cursor.score();
                Assert.assertThat((Object)Float.valueOf(nextScore), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Float.valueOf(score)));
                score = nextScore;
                Assert.assertEquals((String)String.format("Result returned node id %d, expected %d", nextId, ids[num]), (long)ids[num], (long)nextId);
                ++num;
            }
            Assert.assertEquals((String)"Number of results differ from expected", (long)ids.length, (long)num);
        }
    }

    void setNodeProp(Transaction transaction, long nodeId, String value) {
        this.setNodeProp(transaction, nodeId, PROP, value);
    }

    void setNodeProp(Transaction transaction, long nodeId, String propertyKey, String value) {
        Node node = transaction.getNodeById(nodeId);
        node.setProperty(propertyKey, (Object)value);
    }

    void await(IndexDescriptor index) throws Exception {
        try (KernelTransactionImplementation tx = this.getKernelTransaction();){
            while (tx.schemaRead().indexGetState(index) != InternalIndexState.ONLINE) {
                Thread.sleep(100L);
            }
        }
    }
}

