/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.rule.ImpermanentDbmsRule;
import org.neo4j.test.rule.OtherThreadRule;

public class NestedIndexReadersIT {
    private static final int NODE_PER_ID = 3;
    private static final int IDS = 5;
    private static final Label LABEL = Label.label((String)"Label");
    private static final String KEY = "key";
    @Rule
    public final ImpermanentDbmsRule db = new ImpermanentDbmsRule();
    @Rule
    public final OtherThreadRule<Void> t2 = new OtherThreadRule();

    @Test
    public void shouldReadCorrectResultsFromMultipleNestedReaders() {
        this.createIndex();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 3; ++i) {
                this.createRoundOfNodes(tx);
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            ArrayList<ResourceIterator<Node>> iterators = new ArrayList<ResourceIterator<Node>>();
            for (int id = 0; id < 5; ++id) {
                iterators.add(tx.findNodes(LABEL, KEY, (Object)id));
            }
            for (int i = 0; i < 3; ++i) {
                this.assertRoundOfNodes(iterators);
            }
            for (ResourceIterator resourceIterator : iterators) {
                Assert.assertFalse((boolean)resourceIterator.hasNext());
                resourceIterator.close();
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void shouldReadCorrectResultsFromMultipleNestedReadersWhenConcurrentWriteHappens() throws Exception {
        int i;
        this.createIndex();
        try (Transaction tx = this.db.beginTx();){
            for (int id = 0; id < 5; ++id) {
                for (i = 0; i < 3; ++i) {
                    tx.createNode(new Label[]{LABEL}).setProperty(KEY, (Object)id);
                }
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            ArrayList<ResourceIterator<Node>> iterators = new ArrayList<ResourceIterator<Node>>();
            for (int id = 0; id < 5; ++id) {
                iterators.add(tx.findNodes(LABEL, KEY, (Object)id));
            }
            for (i = 0; i < 3; ++i) {
                this.assertRoundOfNodes(iterators);
                if (i % 2 != 1) continue;
                this.t2.execute(this.nodeCreator()).get();
            }
            this.assertRoundOfNodes(iterators);
            for (ResourceIterator resourceIterator : iterators) {
                Assert.assertFalse((boolean)resourceIterator.hasNext());
                resourceIterator.close();
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void createRoundOfNodes(Transaction tx) {
        for (int id = 0; id < 5; ++id) {
            tx.createNode(new Label[]{LABEL}).setProperty(KEY, (Object)id);
        }
    }

    private void assertRoundOfNodes(List<ResourceIterator<Node>> iterators) {
        for (int id = 0; id < 5; ++id) {
            this.assertNode(iterators.get(id), id);
        }
    }

    private OtherThreadExecutor.WorkerCommand<Void, Void> nodeCreator() {
        return state -> {
            try (Transaction tx = this.db.beginTx();){
                this.createRoundOfNodes(tx);
                tx.commit();
            }
            return null;
        };
    }

    private void assertNode(ResourceIterator<Node> reader, int id) {
        Assert.assertTrue((boolean)reader.hasNext());
        Node node = (Node)reader.next();
        Assert.assertTrue((boolean)node.hasLabel(LABEL));
        Assert.assertEquals((String)("Expected node " + node + " (returned by index reader) to have 'id' property w/ value " + id), (Object)id, (Object)node.getProperty(KEY));
    }

    private void createIndex() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on(KEY).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

