/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.tracking;

import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.tracking.TrackingReadersIndexProvider;

public class TrackingIndexExtensionFactory
extends ExtensionFactory<Dependencies> {
    private final ConcurrentHashMap<String, TrackingReadersIndexProvider> indexProvider = new ConcurrentHashMap();
    private final AbstractIndexProviderFactory delegate;

    public TrackingIndexExtensionFactory(AbstractIndexProviderFactory delegate) {
        super(ExtensionType.DATABASE, "trackingIndex");
        this.delegate = delegate;
    }

    public synchronized IndexProvider newInstance(ExtensionContext context, Dependencies dependencies) {
        NamedDatabaseId namedDatabaseId = dependencies.database().getNamedDatabaseId();
        return (IndexProvider)this.indexProvider.computeIfAbsent(namedDatabaseId.name(), s -> {
            IndexProvider indexProvider = this.delegate.newInstance(context, (AbstractIndexProviderFactory.Dependencies)dependencies);
            return new TrackingReadersIndexProvider(indexProvider);
        });
    }

    public TrackingReadersIndexProvider getIndexProvider(String databaseName) {
        return this.indexProvider.get(databaseName);
    }

    public static interface Dependencies
    extends AbstractIndexProviderFactory.Dependencies {
        public Database database();
    }
}

