/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;

@ImpermanentDbmsExtension
class BigPropertyIndexValidationIT {
    @Inject
    private GraphDatabaseService db;
    private Label LABEL;
    private String longString;
    private String propertyKey;

    BigPropertyIndexValidationIT() {
    }

    @BeforeEach
    void setup() {
        this.LABEL = Label.label((String)"LABEL");
        char[] chars = new char[32768];
        Arrays.fill(chars, 'c');
        this.longString = new String(chars);
        this.propertyKey = "name";
    }

    @Test
    void shouldFailTransactionThatIndexesLargePropertyDuringNodeCreation() {
        Neo4jMatchers.createIndex((GraphDatabaseService)this.db, (Label)this.LABEL, (String[])new String[]{this.propertyKey});
        Assertions.assertThrows(TransactionFailureException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                Assertions.assertThrows(IllegalArgumentException.class, () -> tx.execute("CREATE (n:" + this.LABEL + " {name: \"" + this.longString + "\"})"));
                tx.commit();
            }
            tx = this.db.beginTx();
            try {
                ResourceIterator nodes = tx.getAllNodes().iterator();
                Assertions.assertFalse((boolean)nodes.hasNext());
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        });
    }

    @Test
    void shouldFailTransactionThatIndexesLargePropertyAfterNodeCreation() {
        Neo4jMatchers.createIndex((GraphDatabaseService)this.db, (Label)this.LABEL, (String[])new String[]{this.propertyKey});
        Assertions.assertThrows(TransactionFailureException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute("CREATE (n:" + this.LABEL + ")");
                Assertions.assertThrows(IllegalArgumentException.class, () -> tx.execute("match (n:" + this.LABEL + ")set n.name= \"" + this.longString + "\""));
                tx.commit();
            }
            tx = this.db.beginTx();
            try {
                ResourceIterator nodes = tx.getAllNodes().iterator();
                Assertions.assertFalse((boolean)nodes.hasNext());
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        });
    }

    @Test
    void shouldFailTransactionThatIndexesLargePropertyOnLabelAdd() {
        Neo4jMatchers.createIndex((GraphDatabaseService)this.db, (Label)this.LABEL, (String[])new String[]{this.propertyKey});
        Assertions.assertThrows(TransactionFailureException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                String otherLabel = "SomethingElse";
                tx.execute("CREATE (n:" + otherLabel + " {name: \"" + this.longString + "\"})");
                Assertions.assertThrows(IllegalArgumentException.class, () -> tx.execute("match (n:" + otherLabel + ")set n:" + this.LABEL));
                tx.commit();
            }
            tx = this.db.beginTx();
            try {
                ResourceIterator nodes = tx.getAllNodes().iterator();
                Assertions.assertFalse((boolean)nodes.hasNext());
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        });
    }
}

