/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.PhysicalFlushableChecksumChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.rule.TestDirectory;

@Neo4jLayoutExtension
class RecoverIndexDropIT {
    private static final String KEY = "key";
    @Inject
    private DefaultFileSystemAbstraction fs;
    @Inject
    private TestDirectory directory;
    @Inject
    private DatabaseLayout databaseLayout;

    RecoverIndexDropIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldDropIndexOnRecovery() throws IOException {
        CommittedTransactionRepresentation dropTransaction = this.prepareDropTransaction();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).build();
        GraphDatabaseService db = managementService.database("neo4j");
        RecoverIndexDropIT.createIndex(db);
        managementService.shutdown();
        this.appendDropTransactionToTransactionLog(this.databaseLayout.getTransactionLogsDirectory(), dropTransaction);
        Monitors monitors = new Monitors();
        AssertRecoveryIsPerformed recoveryMonitor = new AssertRecoveryIsPerformed();
        monitors.addMonitorListener((Object)recoveryMonitor, new String[0]);
        managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setMonitors(monitors).build();
        db = managementService.database("neo4j");
        try {
            Assertions.assertTrue((boolean)recoveryMonitor.recoveryWasPerformed);
            try (Transaction tx = db.beginTx();){
                Assertions.assertEquals((long)0L, (long)Iterables.count((Iterable)tx.schema().getIndexes()));
                tx.commit();
            }
        }
        finally {
            managementService.shutdown();
        }
    }

    private static IndexDefinition createIndex(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            IndexDefinition index = tx.schema().indexFor(TestLabels.LABEL_ONE).on(KEY).create();
            tx.commit();
            IndexDefinition indexDefinition = index;
            return indexDefinition;
        }
    }

    private void appendDropTransactionToTransactionLog(File transactionLogsDirectory, CommittedTransactionRepresentation dropTransaction) throws IOException {
        LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((File)transactionLogsDirectory, (FileSystemAbstraction)this.fs).build();
        LogFile logFile = logFiles.getLogFile();
        try (ReadableLogChannel reader = logFile.getReader(logFiles.extractHeader(0L).getStartPosition());){
            VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
            while (logEntryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)reader) != null) {
            }
            LogPosition position = logEntryReader.lastPosition();
            StoreFileChannel storeChannel = this.fs.write(logFiles.getLogFileForVersion(logFiles.getHighestLogVersion()));
            storeChannel.position(position.getByteOffset());
            ByteBuffer buf = ByteBuffer.allocate(1000);
            try (PhysicalFlushableChecksumChannel writeChannel = new PhysicalFlushableChecksumChannel((StoreChannel)storeChannel, buf);){
                new LogEntryWriter((WritableChecksumChannel)writeChannel).serialize(dropTransaction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommittedTransactionRepresentation prepareDropTransaction() throws IOException {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.directory.directory("preparation", new String[0])).build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            IndexDefinition index = RecoverIndexDropIT.createIndex((GraphDatabaseService)db);
            try (Transaction tx = db.beginTx();){
                tx.schema().getIndexByName(index.getName()).drop();
                tx.commit();
            }
            CommittedTransactionRepresentation committedTransactionRepresentation = RecoverIndexDropIT.extractLastTransaction(db);
            return committedTransactionRepresentation;
        }
        finally {
            managementService.shutdown();
        }
    }

    private static CommittedTransactionRepresentation extractLastTransaction(GraphDatabaseAPI db) throws IOException {
        LogicalTransactionStore txStore = (LogicalTransactionStore)db.getDependencyResolver().resolveDependency(LogicalTransactionStore.class);
        CommittedTransactionRepresentation transaction = null;
        try (TransactionCursor cursor = txStore.getTransactions(2L);){
            while (cursor.next()) {
                transaction = (CommittedTransactionRepresentation)cursor.get();
            }
        }
        return transaction;
    }

    private static class AssertRecoveryIsPerformed
    implements RecoveryMonitor {
        boolean recoveryWasPerformed;

        private AssertRecoveryIsPerformed() {
        }

        public void recoveryRequired(LogPosition recoveryPosition) {
            this.recoveryWasPerformed = true;
        }
    }
}

