/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.index.internal.gbptree.TreeNodeDynamicSize;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@DbmsExtension(configurationCallback="configure")
@ExtendWith(value={RandomExtension.class})
public class GenericIndexValidationIT {
    private static final String[] PROP_KEYS = new String[]{"prop0", "prop1", "prop2", "prop3", "prop4"};
    private static final int KEY_SIZE_LIMIT = TreeNodeDynamicSize.keyValueSizeCapFromPageSize((int)8192);
    private static final int ESTIMATED_OVERHEAD_PER_SLOT = 2;
    private static final int WIGGLE_ROOM = 50;
    @Inject
    public GraphDatabaseAPI db;
    @Inject
    private RandomRule random;

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.default_schema_provider, (Object)GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerName());
    }

    @Test
    void shouldEnforceSizeCapSingleValueSingleType() {
        NamedDynamicValueGenerator[] dynamicValueGenerators;
        for (NamedDynamicValueGenerator generator : dynamicValueGenerators = NamedDynamicValueGenerator.values()) {
            String propKey = PROP_KEYS[0] + generator.name();
            this.createIndex(propKey);
            BinarySearch binarySearch = new BinarySearch();
            while (!binarySearch.finished()) {
                Object propValue = generator.dynamicValue(this.random, binarySearch.arrayLength);
                long expectedNodeId = -1L;
                boolean wasAbleToWrite = true;
                try (Transaction tx = this.db.beginTx();){
                    Node node = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
                    node.setProperty(propKey, propValue);
                    expectedNodeId = node.getId();
                    tx.commit();
                }
                catch (Exception e) {
                    wasAbleToWrite = false;
                }
                this.verifyReadExpected(propKey, propValue, expectedNodeId, wasAbleToWrite);
                binarySearch.progress(wasAbleToWrite);
            }
            Assertions.assertEquals((int)generator.expectedMax, (int)binarySearch.longestSuccessful, (String)String.format("expected longest successful array length for type %s, to be %d but was %d. This is a strong indication that documentation of max limit needs to be updated.", generator.name(), generator.expectedMax, binarySearch.longestSuccessful));
        }
    }

    @Test
    void shouldEnforceSizeCapMixedTypes() {
        for (int numberOfSlots = 1; numberOfSlots < 5; ++numberOfSlots) {
            String[] propKeys = this.generatePropertyKeys(numberOfSlots);
            this.createIndex(propKeys);
            int keySizeLimitPerSlot = KEY_SIZE_LIMIT / propKeys.length - 2;
            int wiggleRoomPerSlot = 50 / propKeys.length;
            SuccessAndFail successAndFail = new SuccessAndFail();
            for (int i = 0; i < 1000; ++i) {
                Object[] propValues = this.generatePropertyValues(propKeys, keySizeLimitPerSlot, wiggleRoomPerSlot);
                long expectedNodeId = -1L;
                boolean ableToWrite = true;
                try (Transaction tx = this.db.beginTx();){
                    Node node = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
                    this.setProperties(propKeys, propValues, node);
                    expectedNodeId = node.getId();
                    tx.commit();
                }
                catch (Exception e) {
                    ableToWrite = false;
                }
                successAndFail.ableToWrite(ableToWrite);
                this.verifyReadExpected(propKeys, propValues, expectedNodeId, ableToWrite);
            }
            successAndFail.verifyBothSuccessAndFail();
        }
    }

    private void setProperties(String[] propKeys, Object[] propValues, Node node) {
        for (int propKey = 0; propKey < propKeys.length; ++propKey) {
            node.setProperty(propKeys[propKey], propValues[propKey]);
        }
    }

    private String[] generatePropertyKeys(int numberOfSlots) {
        String[] propKeys = new String[numberOfSlots];
        for (int i = 0; i < numberOfSlots; ++i) {
            propKeys[i] = PROP_KEYS[i] + "numberOfSlots" + numberOfSlots;
        }
        return propKeys;
    }

    private Object[] generatePropertyValues(String[] propKeys, int keySizeLimitPerSlot, int wiggleRoomPerSlot) {
        Object[] propValues = new Object[propKeys.length];
        for (int propKey = 0; propKey < propKeys.length; ++propKey) {
            NamedDynamicValueGenerator among = (NamedDynamicValueGenerator)((Object)this.random.among((Object[])NamedDynamicValueGenerator.values()));
            propValues[propKey] = among.dynamicValue(this.random, keySizeLimitPerSlot, wiggleRoomPerSlot);
        }
        return propValues;
    }

    private void verifyReadExpected(String propKey, Object propValue, long expectedNodeId, boolean ableToWrite) {
        this.verifyReadExpected(new String[]{propKey}, new Object[]{propValue}, expectedNodeId, ableToWrite);
    }

    private void verifyReadExpected(String[] propKeys, Object[] propValues, long expectedNodeId, boolean ableToWrite) {
        try (Transaction tx = this.db.beginTx();){
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (int propKey = 0; propKey < propKeys.length; ++propKey) {
                values.put(propKeys[propKey], propValues[propKey]);
            }
            ResourceIterator nodes = tx.findNodes(TestLabels.LABEL_ONE, values);
            if (ableToWrite) {
                Assertions.assertTrue((boolean)nodes.hasNext());
                Node node = (Node)nodes.next();
                Assertions.assertNotNull((Object)node);
                Assertions.assertEquals((long)expectedNodeId, (long)node.getId(), (String)"node id");
            } else {
                Assertions.assertFalse((boolean)nodes.hasNext());
            }
            tx.commit();
        }
    }

    private void createIndex(String ... propKeys) {
        try (Transaction tx = this.db.beginTx();){
            IndexCreator indexCreator = tx.schema().indexFor(TestLabels.LABEL_ONE);
            for (String propKey : propKeys) {
                indexCreator = indexCreator.on(propKey);
            }
            indexCreator.create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static enum NamedDynamicValueGenerator {
        string(1, 8164, (random, i) -> random.randomValues().nextAlphaNumericTextValue(i, i).stringValue()),
        byteArray(1, 8163, (random, i) -> random.randomValues().nextByteArrayRaw(i, i)),
        shortArray(2, 4081, (random, i) -> random.randomValues().nextShortArrayRaw(i, i)),
        intArray(4, 2040, (random, i) -> random.randomValues().nextIntArrayRaw(i, i)),
        longArray(8, 1020, (random, i) -> random.randomValues().nextLongArrayRaw(i, i)),
        floatArray(4, 2040, (random, i) -> random.randomValues().nextFloatArrayRaw(i, i)),
        doubleArray(8, 1020, (random, i) -> random.randomValues().nextDoubleArrayRaw(i, i)),
        booleanArray(1, 8164, (random, i) -> random.randomValues().nextBooleanArrayRaw(i, i)),
        charArray(1, 2721, (random, i) -> random.randomValues().nextAlphaNumericTextValue(i, i).stringValue().toCharArray()),
        stringArray1(3, 2721, (random, i) -> random.randomValues().nextAlphaNumericStringArrayRaw(i, i, 1, 1)),
        stringArray10(12, 680, (random, i) -> random.randomValues().nextAlphaNumericStringArrayRaw(i, i, 10, 10)),
        stringArray100(102, 80, (random, i) -> random.randomValues().nextAlphaNumericStringArrayRaw(i, i, 100, 100)),
        stringArray1000(1002, 8, (random, i) -> random.randomValues().nextAlphaNumericStringArrayRaw(i, i, 1000, 1000)),
        dateArray(8, 1020, (random, i) -> random.randomValues().nextDateArrayRaw(i, i)),
        timeArray(12, 680, (random, i) -> random.randomValues().nextTimeArrayRaw(i, i)),
        localTimeArray(8, 1020, (random, i) -> random.randomValues().nextLocalTimeArrayRaw(i, i)),
        dateTimeArray(16, 510, (random, i) -> random.randomValues().nextDateTimeArrayRaw(i, i)),
        localDateTimeArray(12, 680, (random, i) -> random.randomValues().nextLocalDateTimeArrayRaw(i, i)),
        durationArray(28, 291, (random, i) -> random.randomValues().nextDurationArrayRaw(i, i)),
        periodArray(28, 291, (random, i) -> random.randomValues().nextPeriodArrayRaw(i, i)),
        cartesianPointArray(8, 340, (random, i) -> random.randomValues().nextCartesianPointArray(i, i).asObjectCopy()),
        cartesian3DPointArray(8, 255, (random, i) -> random.randomValues().nextCartesian3DPointArray(i, i).asObjectCopy()),
        geographicPointArray(8, 340, (random, i) -> random.randomValues().nextGeographicPointArray(i, i).asObjectCopy()),
        geographic3DPointArray(8, 255, (random, i) -> random.randomValues().nextGeographic3DPointArray(i, i).asObjectCopy());

        private final int singleArrayEntrySize;
        private final DynamicValueGenerator generator;
        private final int expectedMax;

        private NamedDynamicValueGenerator(int singleArrayEntrySize, int expectedLongestArrayLength, DynamicValueGenerator generator) {
            this.singleArrayEntrySize = singleArrayEntrySize;
            this.expectedMax = expectedLongestArrayLength;
            this.generator = generator;
        }

        Object dynamicValue(RandomRule random, int length) {
            return this.generator.dynamicValue(random, length);
        }

        Object dynamicValue(RandomRule random, int keySizeLimit, int wiggleRoom) {
            int lowLimit = this.lowLimit(keySizeLimit, wiggleRoom, this.singleArrayEntrySize);
            int highLimit = this.highLimit(keySizeLimit, wiggleRoom, this.singleArrayEntrySize);
            return this.dynamicValue(random, random.intBetween(lowLimit, highLimit));
        }

        private int lowLimit(int keySizeLimit, int wiggleRoom, int singleEntrySize) {
            return (keySizeLimit - wiggleRoom) / singleEntrySize;
        }

        private int highLimit(int keySizeLimit, int wiggleRoom, int singleEntrySize) {
            return (keySizeLimit + wiggleRoom) / singleEntrySize;
        }

        @FunctionalInterface
        private static interface DynamicValueGenerator {
            public Object dynamicValue(RandomRule var1, int var2);
        }
    }

    private static class SuccessAndFail {
        boolean atLeastOneSuccess;
        boolean atLeastOneFail;

        private SuccessAndFail() {
        }

        void ableToWrite(boolean ableToWrite) {
            if (ableToWrite) {
                this.atLeastOneSuccess = true;
            } else {
                this.atLeastOneFail = true;
            }
        }

        void verifyBothSuccessAndFail() {
            Assertions.assertTrue((boolean)this.atLeastOneSuccess, (String)"not a single successful write, need to adjust parameters");
            Assertions.assertTrue((boolean)this.atLeastOneFail, (String)"not a single failed write, need to adjust parameters");
        }
    }

    private static class BinarySearch {
        private int longestSuccessful;
        private int minArrayLength;
        private int maxArrayLength = 1;
        private int arrayLength = 1;
        private boolean foundMaxLimit;

        private BinarySearch() {
        }

        boolean finished() {
            return this.arrayLength == this.minArrayLength;
        }

        void progress(boolean wasAbleToWrite) {
            if (wasAbleToWrite) {
                this.longestSuccessful = Math.max(this.arrayLength, this.longestSuccessful);
                if (!this.foundMaxLimit) {
                    this.minArrayLength = this.arrayLength;
                    this.maxArrayLength *= 2;
                    this.arrayLength = this.maxArrayLength;
                } else {
                    this.minArrayLength = this.arrayLength;
                    this.arrayLength = (this.minArrayLength + this.maxArrayLength) / 2;
                }
            } else {
                this.foundMaxLimit = true;
                this.maxArrayLength = this.arrayLength;
                this.arrayLength = (this.minArrayLength + this.maxArrayLength) / 2;
            }
        }
    }
}

