/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.tracking;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;

public class TrackingIndexReader
implements IndexReader {
    private final IndexReader delegate;
    private final AtomicLong closeReadersCounter;

    TrackingIndexReader(IndexReader delegate, AtomicLong closeReadersCounter) {
        this.delegate = delegate;
        this.closeReadersCounter = closeReadersCounter;
    }

    public long countIndexedNodes(long nodeId, int[] propertyKeyIds, Value ... propertyValues) {
        return this.delegate.countIndexedNodes(nodeId, propertyKeyIds, propertyValues);
    }

    public IndexSampler createSampler() {
        return this.delegate.createSampler();
    }

    public void query(QueryContext context, IndexProgressor.EntityValueClient client, IndexOrder indexOrder, boolean needsValues, IndexQuery ... query) throws IndexNotApplicableKernelException {
        this.delegate.query(context, client, indexOrder, needsValues, query);
    }

    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return this.delegate.hasFullValuePrecision(predicates);
    }

    public void distinctValues(IndexProgressor.EntityValueClient client, NodePropertyAccessor propertyAccessor, boolean needsValues) {
        this.delegate.distinctValues(client, propertyAccessor, needsValues);
    }

    public void close() {
        this.delegate.close();
        this.closeReadersCounter.incrementAndGet();
    }
}

