/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.junit.rules.Timeout;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.recordstorage.SchemaStorage;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.fulltext.BrokenAnalyzerProvider;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProceduresUtil;
import org.neo4j.kernel.api.impl.fulltext.FulltextProceduresTest;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextTestSupport;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.api.KernelImpl;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.kernel.impl.newapi.ExtendedNodeValueIndexCursorAdapter;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.rule.DbmsRule;
import org.neo4j.test.rule.EmbeddedDbmsRule;
import org.neo4j.test.rule.VerboseTimeout;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class FulltextIndexProviderTest {
    private static final String NAME = "fulltext";
    @Rule
    public Timeout timeout = VerboseTimeout.builder().withTimeout(10L, TimeUnit.MINUTES).build();
    @Rule
    public DbmsRule db = new EmbeddedDbmsRule();
    private Node node1;
    private Node node2;
    private int labelIdHej;
    private int labelIdHa;
    private int labelIdHe;
    private int propIdHej;
    private int propIdHa;
    private int propIdHe;
    private int propIdHo;

    @Before
    public void prepDB() {
        Label hej = Label.label((String)"hej");
        Label ha = Label.label((String)"ha");
        Label he = Label.label((String)"he");
        try (Transaction transaction = this.db.beginTx();){
            this.node1 = transaction.createNode(new Label[]{hej, ha, he});
            this.node1.setProperty("hej", (Object)"value");
            this.node1.setProperty("ha", (Object)"value1");
            this.node1.setProperty("he", (Object)"value2");
            this.node1.setProperty("ho", (Object)"value3");
            this.node2 = transaction.createNode();
            Relationship rel = this.node1.createRelationshipTo(this.node2, RelationshipType.withName((String)"hej"));
            rel.setProperty("hej", (Object)"valuuu");
            rel.setProperty("ha", (Object)"value1");
            rel.setProperty("he", (Object)"value2");
            rel.setProperty("ho", (Object)"value3");
            transaction.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            TokenRead tokenRead = this.tokenRead(tx);
            this.labelIdHej = tokenRead.nodeLabel(hej.name());
            this.labelIdHa = tokenRead.nodeLabel(ha.name());
            this.labelIdHe = tokenRead.nodeLabel(he.name());
            this.propIdHej = tokenRead.propertyKey("hej");
            this.propIdHa = tokenRead.propertyKey("ha");
            this.propIdHe = tokenRead.propertyKey("he");
            this.propIdHo = tokenRead.propertyKey("ho");
            tx.commit();
        }
    }

    @Test
    public void createFulltextIndex() throws Exception {
        IndexDescriptor fulltextIndex = this.createIndex(new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, new int[]{this.propIdHej, this.propIdHa, this.propIdHe});
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            IndexDescriptor descriptor = transaction.schemaRead().indexGetForName(NAME);
            Assert.assertEquals((Object)descriptor.schema(), (Object)fulltextIndex.schema());
            transaction.success();
        }
    }

    @Test
    public void shouldHaveAReasonableDirectoryStructure() throws Exception {
        this.createIndex(new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, new int[]{this.propIdHej, this.propIdHa, this.propIdHe});
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            IndexDescriptor descriptor = transaction.schemaRead().indexGetForName(NAME);
            File indexDir = Path.of(this.db.databaseLayout().databaseDirectory().getAbsolutePath(), "schema", "index", descriptor.getIndexProvider().name(), "" + descriptor.getId()).toFile();
            List<File> listFiles = List.of(Objects.requireNonNull(indexDir.listFiles()));
            Assert.assertTrue((boolean)listFiles.contains(new File(indexDir, "failure-message")));
            Assert.assertTrue((boolean)listFiles.contains(new File(indexDir, "1")));
            Assert.assertTrue((boolean)listFiles.contains(new File(indexDir, indexDir.getName() + ".tx")));
        }
    }

    @Test
    public void createAndRetainFulltextIndex() throws Exception {
        IndexDescriptor fulltextIndex = this.createIndex(new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, new int[]{this.propIdHej, this.propIdHa, this.propIdHe});
        this.db.restartDatabase(DbmsRule.RestartAction.EMPTY);
        this.verifyThatFulltextIndexIsPresent(fulltextIndex);
    }

    @Test
    public void createAndRetainRelationshipFulltextIndex() throws Exception {
        IndexDescriptor indexReference;
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, (int[])new int[]{this.propIdHej, this.propIdHa, this.propIdHe, this.propIdHo});
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)FulltextIndexProviderFactory.DESCRIPTOR).withIndexType(IndexType.FULLTEXT).withName(NAME);
            indexReference = transaction.schemaWrite().indexCreate(prototype);
            transaction.success();
        }
        this.await(indexReference);
        this.db.restartDatabase(DbmsRule.RestartAction.EMPTY);
        this.verifyThatFulltextIndexIsPresent(indexReference);
    }

    @Test
    public void createAndQueryFulltextIndex() throws Exception {
        IndexDescriptor indexReference = this.createIndex(new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, new int[]{this.propIdHej, this.propIdHa, this.propIdHe, this.propIdHo});
        this.await(indexReference);
        long thirdNodeId = this.createTheThirdNode();
        this.verifyNodeData(thirdNodeId);
        this.db.restartDatabase(DbmsRule.RestartAction.EMPTY);
        this.verifyNodeData(thirdNodeId);
    }

    @Test
    public void createAndQueryFulltextRelationshipIndex() throws Exception {
        long secondRelId;
        IndexDescriptor indexReference;
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, (int[])new int[]{this.propIdHej, this.propIdHa, this.propIdHe, this.propIdHo});
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)FulltextIndexProviderFactory.DESCRIPTOR).withIndexType(IndexType.FULLTEXT).withName(NAME);
            indexReference = transaction.schemaWrite().indexCreate(prototype);
            transaction.success();
        }
        this.await(indexReference);
        try (Transaction transaction = this.db.beginTx();){
            Relationship ho = transaction.getNodeById(this.node1.getId()).createRelationshipTo(transaction.getNodeById(this.node2.getId()), RelationshipType.withName((String)"ho"));
            secondRelId = ho.getId();
            ho.setProperty("hej", (Object)"villa");
            ho.setProperty("ho", (Object)"value3");
            transaction.commit();
        }
        this.verifyRelationshipData(secondRelId);
        this.db.restartDatabase(DbmsRule.RestartAction.EMPTY);
        this.verifyRelationshipData(secondRelId);
    }

    @Test
    public void multiTokenFulltextIndexesMustShowUpInSchemaGetIndexes() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodeIndex", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"Label1", "Label2"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "relIndex", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"RelType1", "RelType2"}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            for (IndexDefinition index : tx.schema().getIndexes()) {
                Assert.assertFalse((boolean)index.isConstraintIndex());
                Assert.assertTrue((boolean)index.isMultiTokenIndex());
                Assert.assertTrue((boolean)index.isCompositeIndex());
                if (index.isNodeIndex()) {
                    Assert.assertFalse((boolean)index.isRelationshipIndex());
                    Assert.assertThat((Object)index.getLabels(), (Matcher)Matchers.containsInAnyOrder((Object[])new Label[]{Label.label((String)"Label1"), Label.label((String)"Label2")}));
                    try {
                        index.getRelationshipTypes();
                        Assert.fail((String)"index.getRelationshipTypes() on node IndexDefinition should have thrown.");
                    }
                    catch (IllegalStateException illegalStateException) {}
                    continue;
                }
                Assert.assertTrue((boolean)index.isRelationshipIndex());
                Assert.assertThat((Object)index.getRelationshipTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new RelationshipType[]{RelationshipType.withName((String)"RelType1"), RelationshipType.withName((String)"RelType2")}));
                try {
                    index.getLabels();
                    Assert.fail((String)"index.getLabels() on node IndexDefinition should have thrown.");
                }
                catch (IllegalStateException illegalStateException) {}
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void awaitIndexesOnlineMustWorkOnFulltextIndexes() {
        String prop1 = "prop1";
        String prop2 = "prop2";
        String prop3 = "prop3";
        String val1 = "foo foo";
        String val2 = "bar bar";
        String val3 = "baz baz";
        Label label1 = Label.label((String)"FirstLabel");
        Label label2 = Label.label((String)"SecondLabel");
        Label label3 = Label.label((String)"ThirdLabel");
        RelationshipType relType1 = RelationshipType.withName((String)"FirstRelType");
        RelationshipType relType2 = RelationshipType.withName((String)"SecondRelType");
        RelationshipType relType3 = RelationshipType.withName((String)"ThirdRelType");
        LongHashSet nodes1 = new LongHashSet();
        LongHashSet nodes2 = new LongHashSet();
        LongHashSet nodes3 = new LongHashSet();
        LongHashSet rels1 = new LongHashSet();
        LongHashSet rels2 = new LongHashSet();
        LongHashSet rels3 = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 100; ++i) {
                Node node1 = tx.createNode(new Label[]{label1});
                node1.setProperty(prop1, (Object)val1);
                nodes1.add(node1.getId());
                Relationship rel1 = node1.createRelationshipTo(node1, relType1);
                rel1.setProperty(prop1, (Object)val1);
                rels1.add(rel1.getId());
                Node node2 = tx.createNode(new Label[]{label2});
                node2.setProperty(prop2, (Object)val2);
                nodes2.add(node2.getId());
                Relationship rel2 = node1.createRelationshipTo(node2, relType2);
                rel2.setProperty(prop2, (Object)val2);
                rels2.add(rel2.getId());
                Node node3 = tx.createNode(new Label[]{label3});
                node3.setProperty(prop3, (Object)val3);
                nodes3.add(node3.getId());
                Relationship rel3 = node1.createRelationshipTo(node3, relType3);
                rel3.setProperty(prop3, (Object)val3);
                rels3.add(rel3.getId());
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodeIndex", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{label1.name(), label2.name(), label3.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{prop1, prop2, prop3}))).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodeIndex", "foo", nodes1);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodeIndex", "bar", nodes2);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodeIndex", "baz", nodes3);
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "relIndex", FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{relType1.name(), relType2.name(), relType3.name()}), FulltextIndexProceduresUtil.asCypherStringsList((String[])new String[]{prop1, prop2, prop3}))).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "relIndex", "foo", rels1);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "relIndex", "bar", rels2);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "relIndex", "baz", rels3);
    }

    @Test
    public void queryingWithIndexProgressorMustProvideScore() throws Exception {
        long nodeId = this.createTheThirdNode();
        IndexDescriptor index = this.createIndex(new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, new int[]{this.propIdHej, this.propIdHa, this.propIdHe, this.propIdHo});
        this.await(index);
        final ArrayList acceptedEntities = new ArrayList();
        try (KernelTransactionImplementation ktx = this.getKernelTransaction();){
            ExtendedNodeValueIndexCursorAdapter cursor = new ExtendedNodeValueIndexCursorAdapter(){
                private long nodeReference;
                private IndexProgressor progressor;

                public long nodeReference() {
                    return this.nodeReference;
                }

                public boolean next() {
                    return this.progressor.next();
                }

                public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] query, IndexOrder indexOrder, boolean needsValues, boolean indexIncludesTransactionState) {
                    this.progressor = progressor;
                }

                public boolean acceptEntity(long reference, float score, Value ... values) {
                    this.nodeReference = reference;
                    Assert.assertFalse((String)"score should not be NaN", (boolean)Float.isNaN(score));
                    Assert.assertThat((String)"score must be positive", (Object)Float.valueOf(score), (Matcher)Matchers.greaterThan((Comparable)Float.valueOf(0.0f)));
                    acceptedEntities.add("reference = " + reference + ", score = " + score + ", " + Arrays.toString(values));
                    return true;
                }
            };
            Read read = ktx.dataRead();
            IndexReadSession indexSession = ktx.dataRead().indexReadSession(index);
            read.nodeIndexSeek(indexSession, (NodeValueIndexCursor)cursor, IndexOrder.NONE, false, new IndexQuery[]{IndexQuery.fulltextSearch((String)"hej:\"villa\"")});
            int counter = 0;
            while (cursor.next()) {
                Assert.assertThat((Object)cursor.nodeReference(), (Matcher)Matchers.is((Object)nodeId));
                ++counter;
            }
            Assert.assertThat((Object)counter, (Matcher)Matchers.is((Object)1));
            Assert.assertThat((Object)acceptedEntities.size(), (Matcher)Matchers.is((Object)1));
            acceptedEntities.clear();
        }
    }

    @Test
    public void validateMustThrowIfSchemaIsNotFulltext() throws Exception {
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            int[] propertyIds = new int[]{this.propIdHa};
            LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)this.labelIdHa, (int[])propertyIds);
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema).withIndexType(IndexType.FULLTEXT).withName(NAME);
            SchemaWrite schemaWrite = transaction.schemaWrite();
            IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> schemaWrite.indexCreate(prototype));
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"schema is not a full-text index schema"));
            transaction.success();
        }
    }

    @Test
    public void indexWithUnknownAnalyzerWillBeMarkedAsFailedOnStartup() throws Exception {
        long indexId;
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            int[] propertyIds = new int[]{this.propIdHa};
            FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)EntityType.NODE, (int[])new int[]{this.labelIdHa}, (int[])propertyIds);
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema).withIndexType(IndexType.FULLTEXT).withName(NAME);
            SchemaWrite schemaWrite = transaction.schemaWrite();
            IndexDescriptor index = schemaWrite.indexCreate(prototype);
            indexId = index.getId();
            transaction.success();
        }
        this.db.restartDatabase((fs, databaseLayout) -> {
            DefaultIdGeneratorFactory idGenFactory = new DefaultIdGeneratorFactory(fs, RecoveryCleanupWorkCollector.ignore());
            try (JobScheduler scheduler = JobSchedulerFactory.createInitialisedScheduler();
                 PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs, (JobScheduler)scheduler);){
                StoreFactory factory = new StoreFactory(databaseLayout, Config.defaults(), (IdGeneratorFactory)idGenFactory, pageCache, fs, (LogProvider)NullLogProvider.getInstance());
                try (NeoStores neoStores = factory.openAllNeoStores(false);){
                    TokenHolders tokens = StoreTokens.readOnlyTokenHolders((NeoStores)neoStores);
                    SchemaStore schemaStore = neoStores.getSchemaStore();
                    SchemaStorage storage = new SchemaStorage(schemaStore, tokens);
                    IndexDescriptor index = (IndexDescriptor)storage.loadSingleSchemaRule(indexId);
                    HashMap indexConfigMap = new HashMap(index.getIndexConfig().asMap());
                    for (Map.Entry entry : indexConfigMap.entrySet()) {
                        if (!((String)entry.getKey()).contains("analyzer")) continue;
                        entry.setValue(Values.stringValue((String)"bla-bla-lyzer"));
                    }
                    index = index.withIndexConfig(IndexConfig.with(indexConfigMap));
                    storage.writeSchemaRule((SchemaRule)index);
                    schemaStore.flush();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition index = tx.schema().getIndexByName(NAME);
            Schema.IndexState indexState = tx.schema().getIndexState(index);
            Assert.assertThat((Object)indexState, (Matcher)Matchers.is((Object)Schema.IndexState.FAILED));
            String indexFailure = tx.schema().getIndexFailure(index);
            Assert.assertThat((Object)indexFailure, (Matcher)Matchers.containsString((String)"bla-bla-lyzer"));
        }
        tx = this.db.beginTx();
        try {
            tx.schema().getIndexByName(NAME).drop();
            Assertions.assertThrows(IllegalArgumentException.class, () -> tx.schema().getIndexByName(NAME));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> tx.schema().getIndexByName(NAME));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.db.restartDatabase();
        tx = this.db.beginTx();
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> tx.schema().getIndexByName(NAME));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ResourceLock(value="BrokenAnalyzerProvider")
    @Test
    public void indexWithAnalyzerThatThrowsWillNotBeCreated() throws Exception {
        Schema.IndexState indexState;
        IndexDefinition index;
        IndexCreator creator;
        BrokenAnalyzerProvider.shouldThrow = true;
        BrokenAnalyzerProvider.shouldReturnNull = false;
        try (Transaction tx = this.db.beginTx();){
            creator = tx.schema().indexFor(Label.label((String)"Label")).withIndexType(org.neo4j.graphdb.schema.IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSetting.fulltext_Analyzer(), "broken-analyzer")).on("prop").withName(NAME);
            RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ((IndexCreator)creator).create());
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"boom"));
            BrokenAnalyzerProvider.shouldThrow = false;
            creator.create();
            BrokenAnalyzerProvider.shouldThrow = true;
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> tx.schema().awaitIndexOnline(NAME, 10L, TimeUnit.SECONDS));
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"FAILED"));
            IndexDefinition index2 = tx.schema().getIndexByName(NAME);
            Assert.assertThat((Object)tx.schema().getIndexState(index2), (Matcher)Matchers.is((Object)Schema.IndexState.FAILED));
            index2.drop();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        BrokenAnalyzerProvider.shouldThrow = false;
        tx = this.db.beginTx();
        try {
            creator = tx.schema().indexFor(Label.label((String)"Label")).withIndexType(org.neo4j.graphdb.schema.IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSetting.fulltext_Analyzer(), "broken-analyzer")).on("prop").withName(NAME);
            creator.create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NAME, 10L, TimeUnit.SECONDS);
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assert.assertThat((Object)indexState, (Matcher)Matchers.is((Object)Schema.IndexState.ONLINE));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.db.restartDatabase();
        tx = this.db.beginTx();
        try {
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assert.assertThat((Object)indexState, (Matcher)Matchers.is((Object)Schema.IndexState.ONLINE));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ResourceLock(value="BrokenAnalyzerProvider")
    @Test
    public void indexWithAnalyzerThatReturnsNullWillNotBeCreated() throws Exception {
        Schema.IndexState indexState;
        IndexDefinition index;
        IndexCreator creator;
        BrokenAnalyzerProvider.shouldThrow = false;
        BrokenAnalyzerProvider.shouldReturnNull = true;
        try (Transaction tx = this.db.beginTx();){
            creator = tx.schema().indexFor(Label.label((String)"Label")).withIndexType(org.neo4j.graphdb.schema.IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSetting.fulltext_Analyzer(), "broken-analyzer")).on("prop").withName(NAME);
            RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ((IndexCreator)creator).create());
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"null"));
            BrokenAnalyzerProvider.shouldReturnNull = false;
            creator.create();
            BrokenAnalyzerProvider.shouldReturnNull = true;
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> tx.schema().awaitIndexOnline(NAME, 10L, TimeUnit.SECONDS));
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"FAILED"));
            IndexDefinition index2 = tx.schema().getIndexByName(NAME);
            Assert.assertThat((Object)tx.schema().getIndexState(index2), (Matcher)Matchers.is((Object)Schema.IndexState.FAILED));
            index2.drop();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        BrokenAnalyzerProvider.shouldReturnNull = false;
        tx = this.db.beginTx();
        try {
            creator = tx.schema().indexFor(Label.label((String)"Label")).withIndexType(org.neo4j.graphdb.schema.IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSetting.fulltext_Analyzer(), "broken-analyzer")).on("prop").withName(NAME);
            creator.create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NAME, 10L, TimeUnit.SECONDS);
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assert.assertThat((Object)indexState, (Matcher)Matchers.is((Object)Schema.IndexState.ONLINE));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.db.restartDatabase();
        tx = this.db.beginTx();
        try {
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assert.assertThat((Object)indexState, (Matcher)Matchers.is((Object)Schema.IndexState.ONLINE));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ResourceLock(value="BrokenAnalyzerProvider")
    @Test
    public void indexWithAnalyzerProviderThatThrowsAnExceptionOnStartupWillBeMarkedAsFailedOnStartup() throws Exception {
        Schema.IndexState indexState;
        IndexDefinition index;
        BrokenAnalyzerProvider.shouldThrow = false;
        BrokenAnalyzerProvider.shouldReturnNull = false;
        try (Transaction tx = this.db.beginTx();){
            IndexCreator creator = tx.schema().indexFor(Label.label((String)"Label")).withIndexType(org.neo4j.graphdb.schema.IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSetting.fulltext_Analyzer(), "broken-analyzer")).on("prop").withName(NAME);
            creator.create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NAME, 10L, TimeUnit.SECONDS);
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assert.assertThat((Object)indexState, (Matcher)Matchers.is((Object)Schema.IndexState.ONLINE));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        BrokenAnalyzerProvider.shouldThrow = true;
        this.db.restartDatabase();
        tx = this.db.beginTx();
        try {
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assert.assertThat((Object)indexState, (Matcher)Matchers.is((Object)Schema.IndexState.FAILED));
            String indexFailure = tx.schema().getIndexFailure(index);
            Assert.assertThat((Object)indexFailure, (Matcher)Matchers.containsString((String)"boom"));
            index.drop();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> tx.schema().getIndexByName(NAME));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ResourceLock(value="BrokenAnalyzerProvider")
    @Test
    public void indexWithAnalyzerProviderThatReturnsNullWillBeMarkedAsFailedOnStartup() throws Exception {
        Schema.IndexState indexState;
        IndexDefinition index;
        BrokenAnalyzerProvider.shouldThrow = false;
        BrokenAnalyzerProvider.shouldReturnNull = false;
        try (Transaction tx = this.db.beginTx();){
            IndexCreator creator = tx.schema().indexFor(Label.label((String)"Label")).withIndexType(org.neo4j.graphdb.schema.IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSetting.fulltext_Analyzer(), "broken-analyzer")).on("prop").withName(NAME);
            creator.create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NAME, 10L, TimeUnit.SECONDS);
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assert.assertThat((Object)indexState, (Matcher)Matchers.is((Object)Schema.IndexState.ONLINE));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        BrokenAnalyzerProvider.shouldReturnNull = true;
        this.db.restartDatabase();
        tx = this.db.beginTx();
        try {
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assert.assertThat((Object)indexState, (Matcher)Matchers.is((Object)Schema.IndexState.FAILED));
            String indexFailure = tx.schema().getIndexFailure(index);
            Assert.assertThat((Object)indexFailure, (Matcher)Matchers.containsString((String)"null"));
            index.drop();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> tx.schema().getIndexByName(NAME));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private TokenRead tokenRead(Transaction tx) {
        return ((InternalTransaction)tx).kernelTransaction().tokenRead();
    }

    private KernelTransactionImplementation getKernelTransaction() {
        try {
            KernelImpl kernel = (KernelImpl)this.db.resolveDependency(KernelImpl.class);
            return (KernelTransactionImplementation)kernel.beginTransaction(KernelTransaction.Type.explicit, LoginContext.AUTH_DISABLED);
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException("oops");
        }
    }

    private IndexDescriptor createIndex(int[] entityTokens, int[] propertyIds) throws KernelException {
        IndexDescriptor fulltext;
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)EntityType.NODE, (int[])entityTokens, (int[])propertyIds);
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)FulltextIndexProviderFactory.DESCRIPTOR).withIndexType(IndexType.FULLTEXT).withName(NAME);
            fulltext = transaction.schemaWrite().indexCreate(prototype);
            transaction.success();
        }
        return fulltext;
    }

    private void verifyThatFulltextIndexIsPresent(IndexDescriptor fulltextIndexDescriptor) throws TransactionFailureException {
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            IndexDescriptor descriptor = transaction.schemaRead().indexGetForName(NAME);
            Assert.assertEquals((Object)fulltextIndexDescriptor.schema(), (Object)descriptor.schema());
            Assert.assertEquals((Object)fulltextIndexDescriptor.isUnique(), (Object)descriptor.isUnique());
            transaction.success();
        }
    }

    private long createTheThirdNode() {
        long nodeId;
        try (Transaction transaction = this.db.beginTx();){
            Node hej = transaction.createNode(new Label[]{Label.label((String)"hej")});
            nodeId = hej.getId();
            hej.setProperty("hej", (Object)"villa");
            hej.setProperty("ho", (Object)"value3");
            transaction.commit();
        }
        return nodeId;
    }

    private void verifyNodeData(long thirdNodeId) throws Exception {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            IndexReadSession index = ktx.dataRead().indexReadSession(ktx.schemaRead().indexGetForName(NAME));
            try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor();){
                ktx.dataRead().nodeIndexSeek(index, cursor, IndexOrder.NONE, false, new IndexQuery[]{IndexQuery.fulltextSearch((String)"value")});
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertEquals((long)0L, (long)cursor.nodeReference());
                Assert.assertFalse((boolean)cursor.next());
                ktx.dataRead().nodeIndexSeek(index, cursor, IndexOrder.NONE, false, new IndexQuery[]{IndexQuery.fulltextSearch((String)"villa")});
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertEquals((long)thirdNodeId, (long)cursor.nodeReference());
                Assert.assertFalse((boolean)cursor.next());
                ktx.dataRead().nodeIndexSeek(index, cursor, IndexOrder.NONE, false, new IndexQuery[]{IndexQuery.fulltextSearch((String)"value3")});
                MutableLongSet ids = LongSets.mutable.empty();
                ids.add(0L);
                ids.add(thirdNodeId);
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertTrue((boolean)ids.remove(cursor.nodeReference()));
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertTrue((boolean)ids.remove(cursor.nodeReference()));
                Assert.assertFalse((boolean)cursor.next());
            }
            tx.commit();
        }
    }

    private void verifyRelationshipData(long secondRelId) throws Exception {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            IndexDescriptor index = ktx.schemaRead().indexGetForName(NAME);
            try (RelationshipIndexCursor cursor = ktx.cursors().allocateRelationshipIndexCursor();){
                ktx.dataRead().relationshipIndexSeek(index, cursor, new IndexQuery[]{IndexQuery.fulltextSearch((String)"valuuu")});
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertEquals((long)0L, (long)cursor.relationshipReference());
                Assert.assertFalse((boolean)cursor.next());
                ktx.dataRead().relationshipIndexSeek(index, cursor, new IndexQuery[]{IndexQuery.fulltextSearch((String)"villa")});
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertEquals((long)secondRelId, (long)cursor.relationshipReference());
                Assert.assertFalse((boolean)cursor.next());
                ktx.dataRead().relationshipIndexSeek(index, cursor, new IndexQuery[]{IndexQuery.fulltextSearch((String)"value3")});
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertEquals((long)0L, (long)cursor.relationshipReference());
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertEquals((long)secondRelId, (long)cursor.relationshipReference());
                Assert.assertFalse((boolean)cursor.next());
            }
            tx.commit();
        }
    }

    private void await(IndexDescriptor index) {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexOnline(index.getName(), 30L, TimeUnit.SECONDS);
        }
    }
}

