/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexSettingImpl;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.schema.RepeatedLabelInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedRelationshipTypeInSchemaException;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProceduresUtil;
import org.neo4j.kernel.api.impl.fulltext.FulltextProceduresTestSupport;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.procedure.builtin.FulltextProcedures;
import org.neo4j.test.ThreadTestUtils;
import org.neo4j.util.concurrent.BinaryLatch;
import org.neo4j.values.storable.Value;

class FulltextProceduresTest
extends FulltextProceduresTestSupport {
    FulltextProceduresTest() {
    }

    @Test
    void createNodeFulltextIndex() {
        Map row;
        Result result;
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "test-index", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label1", "Label2"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            result = tx.execute("CALL db.indexes()");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.hasNext());
            row = result.next();
            org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("Label1", "Label2"), row.get("labelsOrTypes"));
            org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("prop1", "prop2"), row.get("properties"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test-index", row.get("name"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"FULLTEXT", row.get("type"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.hasNext());
            result.close();
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            result = tx.execute("CALL db.indexes()");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.hasNext());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"ONLINE", result.next().get("state"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.hasNext());
            result.close();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tx.schema().getIndexByName("test-index"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.restartDatabase();
        tx = this.db.beginTx();
        try {
            result = tx.execute("CALL db.indexes()");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.hasNext());
            row = result.next();
            org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("Label1", "Label2"), row.get("labelsOrTypes"));
            org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("prop1", "prop2"), row.get("properties"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test-index", row.get("name"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"FULLTEXT", row.get("type"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"ONLINE", row.get("state"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.hasNext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.hasNext());
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tx.schema().getIndexByName("test-index"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void createRelationshipFulltextIndex() {
        Map row;
        Result result;
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "test-index", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Reltype1", "Reltype2"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            result = tx.execute("CALL db.indexes()");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.hasNext());
            row = result.next();
            org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("Reltype1", "Reltype2"), row.get("labelsOrTypes"));
            org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("prop1", "prop2"), row.get("properties"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test-index", row.get("name"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"FULLTEXT", row.get("type"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.hasNext());
            result.close();
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            result = tx.execute("CALL db.indexes()");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.hasNext());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"ONLINE", result.next().get("state"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.hasNext());
            result.close();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tx.schema().getIndexByName("test-index"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.restartDatabase();
        tx = this.db.beginTx();
        try {
            result = tx.execute("CALL db.indexes()");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.hasNext());
            row = result.next();
            org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("Reltype1", "Reltype2"), row.get("labelsOrTypes"));
            org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("prop1", "prop2"), row.get("properties"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test-index", row.get("name"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"FULLTEXT", row.get("type"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"ONLINE", row.get("state"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.hasNext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.hasNext());
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tx.schema().getIndexByName("test-index"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void dropIndex() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "node", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label1", "Label2"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rel", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Reltype1", "Reltype2"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop1", "prop2"}))).close();
            HashMap indexes = new HashMap();
            tx.execute("call db.indexes()").forEachRemaining(m -> indexes.put((String)m.get("name"), (String)m.get("description")));
            tx.execute(String.format("CALL db.index.fulltext.drop(\"%s\")", "node"));
            indexes.remove("node");
            HashMap newIndexes = new HashMap();
            tx.execute("call db.indexes()").forEachRemaining(m -> newIndexes.put((String)m.get("name"), (String)m.get("description")));
            org.junit.jupiter.api.Assertions.assertEquals(indexes, newIndexes);
            tx.execute(String.format("CALL db.index.fulltext.drop(\"%s\")", "rel"));
            indexes.remove("rel");
            newIndexes.clear();
            tx.execute("call db.indexes()").forEachRemaining(m -> newIndexes.put((String)m.get("name"), (String)m.get("description")));
            org.junit.jupiter.api.Assertions.assertEquals(indexes, newIndexes);
            tx.commit();
        }
    }

    @Test
    void mustNotBeAbleToCreateTwoIndexesWithSameName() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "node", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label1", "Label2"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "node", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label1", "Label2"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop3", "prop4"}))).close();
                tx.commit();
            }
        }, (String)"already exists");
    }

    @Test
    void mustNotBeAbleToCreateNormalIndexWithSameNameAndSchemaAsExistingFulltextIndex() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "node", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label1"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop1"}))).close();
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute("CREATE INDEX `node` FOR (n:Label1) ON (n.prop1)").close();
                tx.commit();
            }
        }, (String)"already exists");
    }

    @Test
    void mustNotBeAbleToCreateNormalIndexWithSameNameDifferentSchemaAsExistingFulltextIndex() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "node", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label1"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute("CREATE INDEX `node` FOR (n:Label1) ON (n.prop1)").close();
                tx.commit();
            }
        }, (String)"There already exists an index called 'node'.");
    }

    @Test
    void mustNotBeAbleToCreateFulltextIndexWithSameNameAndSchemaAsExistingNormalIndex() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute("CREATE INDEX `node` FOR (n:Label1) ON (n.prop1)").close();
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "node", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label1"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop1"}))).close();
                tx.commit();
            }
        }, (String)"already exists");
    }

    @Test
    void mustNotBeAbleToCreateFulltextIndexWithSameNameDifferentSchemaAsExistingNormalIndex() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute("CREATE INDEX `node` FOR (n:Label1) ON (n.prop1)").close();
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "node", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label1"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop1", "prop2"}))).close();
                tx.commit();
            }
        }, (String)"already exists");
    }

    @Test
    void nodeIndexesMustHaveLabels() {
        org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodeIndex", FulltextIndexProceduresUtil.asStrList((String[])new String[0]), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}))).close();
            }
        });
    }

    @Test
    void relationshipIndexesMustHaveRelationshipTypes() {
        org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "relIndex", FulltextIndexProceduresUtil.asStrList((String[])new String[0]), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"})));
            }
        });
    }

    @Test
    void nodeIndexesMustHaveProperties() {
        org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodeIndex", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label"}), FulltextIndexProceduresUtil.asStrList((String[])new String[0]))).close();
            }
        });
    }

    @Test
    void relationshipIndexesMustHaveProperties() {
        org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "relIndex", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"RELTYPE"}), FulltextIndexProceduresUtil.asStrList((String[])new String[0])));
            }
        });
    }

    @Test
    void creatingIndexesWhichImpliesTokenCreateMustNotBlockForever() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodesA", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"SOME_LABEL"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"this"})));
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "relsA", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"SOME_REL_TYPE"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"foo"})));
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodesB", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"SOME_OTHER_LABEL"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"that"})));
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "relsB", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"SOME_OTHER_REL_TYPE"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"bar"})));
        }
    }

    @Test
    void creatingIndexWithSpecificAnalyzerMustUseThatAnalyzerForPopulationUpdatingAndQuerying() {
        LongHashSet noResults = new LongHashSet();
        LongHashSet swedishNodes = new LongHashSet();
        LongHashSet englishNodes = new LongHashSet();
        LongHashSet swedishRels = new LongHashSet();
        LongHashSet englishRels = new LongHashSet();
        String labelledSwedishNodes = "labelledSwedishNodes";
        String typedSwedishRelationships = "typedSwedishRelationships";
        try (Transaction tx = this.db.beginTx();){
            Node nodeA = tx.createNode(new Label[]{LABEL});
            nodeA.setProperty("prop", (Object)"En apa och en tomte bodde i ett hus.");
            swedishNodes.add(nodeA.getId());
            Node nodeB = tx.createNode(new Label[]{LABEL});
            nodeB.setProperty("prop", (Object)"Hello and hello again, in the end.");
            englishNodes.add(nodeB.getId());
            Relationship relA = nodeA.createRelationshipTo(nodeB, REL);
            relA.setProperty("prop", (Object)"En apa och en tomte bodde i ett hus.");
            swedishRels.add(relA.getId());
            Relationship relB = nodeB.createRelationshipTo(nodeA, REL);
            relB.setProperty("prop", (Object)"Hello and hello again, in the end.");
            englishRels.add(relB.getId());
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            String lbl = FulltextIndexProceduresUtil.asStrList((String[])new String[]{LABEL.name()});
            String rel = FulltextIndexProceduresUtil.asStrList((String[])new String[]{REL.name()});
            String props = FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"});
            String swedish = props + ", {analyzer: 'swedish'}";
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", labelledSwedishNodes, lbl, swedish)).close();
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", typedSwedishRelationships, rel, swedish)).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            Node nodeC = tx.createNode(new Label[]{LABEL});
            nodeC.setProperty("prop", (Object)"En apa och en tomte bodde i ett hus.");
            swedishNodes.add(nodeC.getId());
            Node nodeD = tx.createNode(new Label[]{LABEL});
            nodeD.setProperty("prop", (Object)"Hello and hello again, in the end.");
            englishNodes.add(nodeD.getId());
            Relationship relC = nodeC.createRelationshipTo(nodeD, REL);
            relC.setProperty("prop", (Object)"En apa och en tomte bodde i ett hus.");
            swedishRels.add(relC.getId());
            Relationship relD = nodeD.createRelationshipTo(nodeC, REL);
            relD.setProperty("prop", (Object)"Hello and hello again, in the end.");
            englishRels.add(relD.getId());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, labelledSwedishNodes, "and", englishNodes);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, labelledSwedishNodes, "ett", noResults);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, labelledSwedishNodes, "apa", swedishNodes);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, typedSwedishRelationships, "and", englishRels);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, typedSwedishRelationships, "ett", noResults);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, typedSwedishRelationships, "apa", swedishRels);
    }

    @Test
    void mustFailToCreateIndexWithUnknownAnalyzer() {
        try (Transaction tx = this.db.beginTx();){
            String label = FulltextIndexProceduresUtil.asStrList((String[])new String[]{LABEL.name()});
            String props = FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"});
            String analyzer = props + ", {analyzer: 'blablalyzer'}";
            try {
                tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "my_index", label, analyzer)).close();
                org.junit.jupiter.api.Assertions.fail((String)"Expected query to fail.");
            }
            catch (QueryExecutionException e) {
                Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"blablalyzer"});
            }
        }
    }

    @Test
    void queryShouldFindDataAddedInLaterTransactions() {
        long horseRelId;
        long horseId;
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "node", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label1", "Label2"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rel", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Reltype1", "Reltype2"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node zebra = tx.createNode();
            zebra.setProperty("prop1", (Object)"zebra");
            Node horse = tx.createNode(new Label[]{Label.label((String)"Label1")});
            horse.setProperty("prop2", (Object)"horse");
            horse.setProperty("prop3", (Object)"zebra");
            Relationship horseRel = zebra.createRelationshipTo(horse, RelationshipType.withName((String)"Reltype1"));
            horseRel.setProperty("prop1", (Object)"horse");
            Relationship loop = horse.createRelationshipTo(horse, RelationshipType.withName((String)"loop"));
            loop.setProperty("prop2", (Object)"zebra");
            horseId = horse.getId();
            horseRelId = horseRel.getId();
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "node", "horse", LongHashSet.newSetWith((long[])new long[]{horseId}));
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "node", "horse zebra", LongHashSet.newSetWith((long[])new long[]{horseId}));
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "horse", LongHashSet.newSetWith((long[])new long[]{horseRelId}));
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "horse zebra", LongHashSet.newSetWith((long[])new long[]{horseRelId}));
    }

    @Test
    void queryShouldFindDataAddedInIndexPopulation() {
        Relationship relationship;
        Node node2;
        Node node1;
        try (Transaction tx = this.db.beginTx();){
            node1 = tx.createNode(new Label[]{LABEL});
            node1.setProperty("prop", (Object)"This is a integration test.");
            node2 = tx.createNode(new Label[]{LABEL});
            node2.setProperty("otherprop", (Object)"This is a related integration test");
            relationship = node1.createRelationshipTo(node2, REL);
            relationship.setProperty("prop", (Object)"They relate");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "node", FulltextIndexProceduresUtil.asStrList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop", "otherprop"})));
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rel", FulltextIndexProceduresUtil.asStrList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"})));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "node", "integration", node1.getId(), node2.getId());
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "node", "test", node1.getId(), node2.getId());
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "node", "related", LongHashSet.newSetWith((long[])new long[]{node2.getId()}));
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "relate", LongHashSet.newSetWith((long[])new long[]{relationship.getId()}));
    }

    @Test
    void updatesToEventuallyConsistentIndexMustEventuallyBecomeVisible() {
        String value = "bla bla";
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "node", FulltextIndexProceduresUtil.asStrList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}) + ", {eventually_consistent: 'true'}"));
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rel", FulltextIndexProceduresUtil.asStrList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}) + ", {eventually_consistent: 'true'}"));
            tx.commit();
        }
        int entityCount = 200;
        LongHashSet nodeIds = new LongHashSet();
        LongHashSet relIds = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < entityCount; ++i) {
                Node node = tx.createNode(new Label[]{LABEL});
                node.setProperty("prop", (Object)value);
                Relationship rel = node.createRelationshipTo(node, REL);
                rel.setProperty("prop", (Object)value);
                nodeIds.add(node.getId());
                relIds.add(rel.getId());
            }
            tx.commit();
        }
        long deadline = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(20L);
        boolean success = false;
        while (true) {
            try {
                FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "node", "bla", nodeIds);
                FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "bla", relIds);
                success = true;
            }
            finally {
                if (!success) continue;
            }
            break;
        }
    }

    @Test
    void updatesToEventuallyConsistentIndexMustBecomeVisibleAfterAwaitRefresh() {
        String value = "bla bla";
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "node", FulltextIndexProceduresUtil.asStrList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}) + ", {eventually_consistent: 'true'}"));
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rel", FulltextIndexProceduresUtil.asStrList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}) + ", {eventually_consistent: 'true'}"));
            tx.commit();
        }
        this.awaitIndexesOnline();
        int entityCount = 200;
        LongHashSet nodeIds = new LongHashSet();
        LongHashSet relIds = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < entityCount; ++i) {
                Node node = tx.createNode(new Label[]{LABEL});
                node.setProperty("prop", (Object)value);
                Relationship rel = node.createRelationshipTo(node, REL);
                rel.setProperty("prop", (Object)value);
                nodeIds.add(node.getId());
                relIds.add(rel.getId());
            }
            tx.commit();
        }
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute("CALL db.index.fulltext.awaitEventuallyConsistentIndexRefresh()").close();
            transaction.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "node", "bla", nodeIds);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "bla", relIds);
    }

    @Test
    void eventuallyConsistentIndexMustPopulateWithExistingDataWhenCreated() {
        String value = "bla bla";
        int entityCount = 200;
        LongHashSet nodeIds = new LongHashSet();
        LongHashSet relIds = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < entityCount; ++i) {
                Node node = tx.createNode(new Label[]{LABEL});
                node.setProperty("prop", (Object)value);
                Relationship rel = node.createRelationshipTo(node, REL);
                rel.setProperty("prop", (Object)value);
                nodeIds.add(node.getId());
                relIds.add(rel.getId());
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "node", FulltextIndexProceduresUtil.asStrList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}) + ", {eventually_consistent: 'true'}"));
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rel", FulltextIndexProceduresUtil.asStrList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}) + ", {eventually_consistent: 'true'}"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "node", "bla", nodeIds);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "bla", relIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void concurrentPopulationAndUpdatesToAnEventuallyConsistentIndexMustEventuallyResultInCorrectIndexState() throws Exception {
        String oldValue = "red";
        String newValue = "green";
        int entityCount = 200;
        LongHashSet nodeIds = new LongHashSet();
        LongHashSet relIds = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < entityCount; ++i) {
                Node node = tx.createNode(new Label[]{LABEL});
                node.setProperty("prop", (Object)oldValue);
                Relationship rel = node.createRelationshipTo(node, REL);
                rel.setProperty("prop", (Object)oldValue);
                nodeIds.add(node.getId());
                relIds.add(rel.getId());
            }
            tx.commit();
        }
        CountDownLatch readyLatch = new CountDownLatch(2);
        BinaryLatch startLatch = new BinaryLatch();
        Runnable createIndexes = () -> {
            readyLatch.countDown();
            startLatch.await();
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "node", FulltextIndexProceduresUtil.asStrList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}) + ", {eventually_consistent: 'true'}"));
                tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rel", FulltextIndexProceduresUtil.asStrList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}) + ", {eventually_consistent: 'true'}"));
                tx.commit();
            }
        };
        Runnable makeAllEntitiesGreen = () -> {
            try (Transaction tx = this.db.beginTx();){
                nodeIds.forEach((LongProcedure & Serializable)nodeId -> tx.getNodeById(nodeId).setProperty("prop", (Object)newValue));
                relIds.forEach((LongProcedure & Serializable)relId -> tx.getRelationshipById(relId).setProperty("prop", (Object)newValue));
                tx.commit();
                readyLatch.countDown();
                startLatch.await();
            }
        };
        ExecutorService executor = Executors.newFixedThreadPool(2);
        Future<?> future1 = executor.submit(createIndexes);
        Future<?> future2 = executor.submit(makeAllEntitiesGreen);
        readyLatch.await();
        startLatch.release();
        try {
            future1.get();
            future2.get();
            this.awaitIndexesOnline();
            try (Transaction tx = this.db.beginTx();){
                tx.execute("CALL db.index.fulltext.awaitEventuallyConsistentIndexRefresh()").close();
            }
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "node", newValue, nodeIds);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", newValue, relIds);
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[1];
            autoCloseableArray[0] = executor::shutdown;
            IOUtils.closeAllSilently((AutoCloseable[])autoCloseableArray);
            throw throwable;
        }
        AutoCloseable[] autoCloseableArray = new AutoCloseable[1];
        autoCloseableArray[0] = executor::shutdown;
        IOUtils.closeAllSilently((AutoCloseable[])autoCloseableArray);
    }

    @Test
    void mustBeAbleToListAvailableAnalyzers() {
        try (Transaction tx = this.db.beginTx();){
            HashSet<String> analyzers = new HashSet<String>();
            try (ResourceIterator iterator = tx.execute("CALL db.index.fulltext.listAvailableAnalyzers()").columnAs("analyzer");){
                while (iterator.hasNext()) {
                    analyzers.add((String)iterator.next());
                }
            }
            Assertions.assertThat(analyzers).contains((Object[])new String[]{"english"});
            Assertions.assertThat(analyzers).contains((Object[])new String[]{"swedish"});
            Assertions.assertThat(analyzers).contains((Object[])new String[]{"standard"});
            Assertions.assertThat(analyzers).contains((Object[])new String[]{"galician"});
            Assertions.assertThat(analyzers).contains((Object[])new String[]{"irish"});
            Assertions.assertThat(analyzers).contains((Object[])new String[]{"latvian"});
            Assertions.assertThat(analyzers).contains((Object[])new String[]{"sorani"});
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            try (Result result = tx.execute("CALL db.index.fulltext.listAvailableAnalyzers()");){
                while (result.hasNext()) {
                    Map row = result.next();
                    Object description = row.get("description");
                    if (row.containsKey("description") && description instanceof String && !((String)description).trim().isEmpty()) continue;
                    org.junit.jupiter.api.Assertions.fail((String)("Found no description for analyzer: " + row));
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void analyzersMustKnowTheirStopWords() {
        Object stopwords;
        Map row;
        Result result;
        try (Transaction tx = this.db.beginTx();){
            result = tx.execute("CALL db.index.fulltext.listAvailableAnalyzers()");
            try {
                while (result.hasNext()) {
                    row = result.next();
                    stopwords = row.get("stopwords");
                    if (!row.containsKey("stopwords") || !(stopwords instanceof List)) {
                        org.junit.jupiter.api.Assertions.fail((String)("Found no stop-words list for analyzer: " + row));
                    }
                    List words = (List)stopwords;
                    String analyzerName = (String)row.get("analyzer");
                    if (analyzerName.equals("english") || analyzerName.equals("standard")) {
                        Assertions.assertThat((List)words).contains((Object[])new String[]{"and"});
                        continue;
                    }
                    if (!analyzerName.equals("standard-no-stop-words")) continue;
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)words.isEmpty());
                }
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            result = tx.execute("CALL db.index.fulltext.listAvailableAnalyzers()");
            try {
                while (result.hasNext()) {
                    row = result.next();
                    stopwords = (List)row.get("stopwords");
                    Iterator iterator = stopwords.iterator();
                    while (iterator.hasNext()) {
                        String stopword = (String)iterator.next();
                        if (!stopword.isBlank() && !stopword.contains("#") && !stopword.contains(" ")) continue;
                        org.junit.jupiter.api.Assertions.fail((String)("The list of stop-words for the " + row.get("analyzer") + " analyzer contains dirty data. Specifically, '" + stopword + "' does not look like a valid stop-word. The full list:" + System.lineSeparator() + (List)stopwords));
                    }
                }
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void queryNodesMustThrowWhenQueryingRelationshipIndex() {
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "rels", "bla bla")).next());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void queryRelationshipsMustThrowWhenQueryingNodeIndex() {
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> tx.execute(String.format("CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")", "nodes", "bla bla")).next());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void fulltextIndexMustIgnoreNonStringPropertiesForUpdate() {
        Label label = LABEL;
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{label.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}))).close();
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        List<Value> values = this.generateRandomNonStringValues();
        try (Transaction tx = this.db.beginTx();){
            for (Value value : values) {
                Node node = tx.createNode(new Label[]{label});
                Object propertyValue = value.asObject();
                node.setProperty("prop", propertyValue);
                node.createRelationshipTo(node, REL).setProperty("prop", propertyValue);
            }
            tx.commit();
        }
        for (Value value : values) {
            Transaction tx = this.db.beginTx();
            try {
                Result nodes;
                String fulltextQuery = this.quoteValueForQuery(value);
                String cypherQuery = String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", fulltextQuery);
                try {
                    nodes = tx.execute(cypherQuery);
                }
                catch (QueryExecutionException e) {
                    throw new AssertionError("Failed to execute query: " + cypherQuery + " based on value " + value.prettyPrint(), e);
                }
                if (nodes.hasNext()) {
                    org.junit.jupiter.api.Assertions.fail((String)("did not expect to find any nodes, but found at least: " + nodes.next()));
                }
                nodes.close();
                Result relationships = tx.execute(String.format("CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")", "rels", fulltextQuery));
                if (relationships.hasNext()) {
                    org.junit.jupiter.api.Assertions.fail((String)("did not expect to find any relationships, but found at least: " + relationships.next()));
                }
                relationships.close();
                tx.commit();
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
    }

    @Test
    void fulltextIndexMustIgnoreNonStringPropertiesForPopulation() {
        List<Value> values = this.generateRandomNonStringValues();
        try (Transaction tx = this.db.beginTx();){
            for (Value value : values) {
                Node node = tx.createNode(new Label[]{LABEL});
                Object propertyValue = value.asObject();
                node.setProperty("prop", propertyValue);
                node.createRelationshipTo(node, REL).setProperty("prop", propertyValue);
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            this.createSimpleNodesIndex(tx);
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        for (Value value : values) {
            Transaction tx = this.db.beginTx();
            try {
                Result nodes;
                String fulltextQuery = this.quoteValueForQuery(value);
                String cypherQuery = String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", fulltextQuery);
                try {
                    nodes = tx.execute(cypherQuery);
                }
                catch (QueryExecutionException e) {
                    throw new AssertionError("Failed to execute query: " + cypherQuery + " based on value " + value.prettyPrint(), e);
                }
                if (nodes.hasNext()) {
                    org.junit.jupiter.api.Assertions.fail((String)("did not expect to find any nodes, but found at least: " + nodes.next()));
                }
                nodes.close();
                Result relationships = tx.execute(String.format("CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")", "rels", fulltextQuery));
                if (relationships.hasNext()) {
                    org.junit.jupiter.api.Assertions.fail((String)("did not expect to find any relationships, but found at least: " + relationships.next()));
                }
                relationships.close();
                tx.commit();
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
    }

    @Test
    void entitiesMustBeRemovedFromFulltextIndexWhenPropertyValuesChangeAwayFromText() {
        long nodeId;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            nodeId = node.getId();
            node.setProperty("prop", (Object)"bla bla");
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.setProperty("prop", (Object)42);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Result result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", "bla"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.hasNext());
            result.close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void entitiesMustBeAddedToFulltextIndexWhenPropertyValuesChangeToText() {
        long nodeId;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)42);
            nodeId = node.getId();
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.setProperty("prop", (Object)"bla bla");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "bla", nodeId);
    }

    @Test
    void propertiesMustBeRemovedFromFulltextIndexWhenTheirValueTypeChangesAwayFromText() {
        long nodeId;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            nodeId = node.getId();
            node.setProperty("prop1", (Object)"foo");
            node.setProperty("prop2", (Object)"bar");
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.setProperty("prop2", (Object)42);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "foo", nodeId);
        tx = this.db.beginTx();
        try {
            Result result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", "bar"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.hasNext());
            result.close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void propertiesMustBeAddedToFulltextIndexWhenTheirValueTypeChangesToText() {
        long nodeId;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            nodeId = node.getId();
            node.setProperty("prop1", (Object)"foo");
            node.setProperty("prop2", (Object)42);
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.setProperty("prop2", (Object)"bar");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "foo", nodeId);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "bar", nodeId);
    }

    @Test
    void mustBeAbleToIndexHugeTextPropertiesInIndexUpdates() throws Exception {
        long nodeId;
        String meditationes;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/meditationes--rene-descartes--public-domain.txt"), StandardCharsets.UTF_8));){
            meditationes = reader.lines().collect(Collectors.joining("\n"));
        }
        Label label = Label.label((String)"Book");
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "books", FulltextIndexProceduresUtil.asStrList((String[])new String[]{label.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"title", "author", "contents"}))).close();
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{label});
            nodeId = node.getId();
            node.setProperty("title", (Object)"Meditationes de prima philosophia");
            node.setProperty("author", (Object)"Ren\u00e9 Descartes");
            node.setProperty("contents", (Object)meditationes);
            tx.commit();
        }
        this.awaitIndexesOnline();
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "books", "impellit scriptum offerendum", nodeId);
    }

    @Test
    void mustBeAbleToIndexHugeTextPropertiesInIndexPopulation() throws Exception {
        long nodeId;
        String meditationes;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/meditationes--rene-descartes--public-domain.txt"), StandardCharsets.UTF_8));){
            meditationes = reader.lines().collect(Collectors.joining("\n"));
        }
        Label label = Label.label((String)"Book");
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{label});
            nodeId = node.getId();
            node.setProperty("title", (Object)"Meditationes de prima philosophia");
            node.setProperty("author", (Object)"Ren\u00e9 Descartes");
            node.setProperty("contents", (Object)meditationes);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "books", FulltextIndexProceduresUtil.asStrList((String[])new String[]{label.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"title", "author", "contents"}))).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "books", "impellit scriptum offerendum", nodeId);
    }

    @Test
    void mustBeAbleToQuerySpecificPropertiesViaLuceneSyntax() {
        long book2id;
        Label book = Label.label((String)"Book");
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "books", FulltextIndexProceduresUtil.asStrList((String[])new String[]{book.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"title", "author"}))).close();
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            Node book1 = tx.createNode(new Label[]{book});
            book1.setProperty("author", (Object)"Ren\u00e9 Descartes");
            book1.setProperty("title", (Object)"Meditationes de prima philosophia");
            Node book2 = tx.createNode(new Label[]{book});
            book2.setProperty("author", (Object)"E. M. Curley");
            book2.setProperty("title", (Object)"Descartes Against the Skeptics");
            book2id = book2.getId();
            tx.commit();
        }
        LongHashSet ids = LongHashSet.newSetWith((long[])new long[]{book2id});
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "books", "title:Descartes", ids);
    }

    @Test
    void mustIndexNodesByCorrectProperties() {
        long nodeId;
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"a", "b", "c", "d", "e", "f"}))).close();
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{LABEL});
            node.setProperty("e", (Object)"value");
            nodeId = node.getId();
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "e:value", nodeId);
    }

    @Test
    void queryingIndexInPopulatingStateMustBlockUntilIndexIsOnline() {
        long nodeCount = 10000L;
        try (Transaction tx = this.db.beginTx();){
            int i = 0;
            while ((long)i < nodeCount) {
                tx.createNode(new Label[]{LABEL}).setProperty("prop", (Object)"value");
                ++i;
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            try (Result result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", "value"));
                 Stream stream = result.stream();){
                Assertions.assertThat((long)stream.count()).isEqualTo(nodeCount);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void queryingIndexInPopulatingStateMustBlockUntilIndexIsOnlineEvenWhenTransactionHasState() {
        long nodeCount = 10000L;
        try (Transaction tx = this.db.beginTx();){
            int i = 0;
            while ((long)i < nodeCount) {
                tx.createNode(new Label[]{LABEL}).setProperty("prop", (Object)"value");
                ++i;
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.createNode(new Label[]{LABEL}).setProperty("prop", (Object)"value");
            try (Result result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", "value"));
                 Stream stream = result.stream();){
                Assertions.assertThat((long)stream.count()).isEqualTo(nodeCount + 1L);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void queryingIndexInTransactionItWasCreatedInMustThrow() {
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", "value")).next());
        }
    }

    @Test
    void queryResultsMustNotIncludeNodesDeletedInOtherConcurrentlyCommittedTransactions() throws Exception {
        long nodeIdB;
        long nodeIdA;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node nodeA = tx.createNode(new Label[]{LABEL});
            nodeA.setProperty("prop", (Object)"value");
            nodeIdA = nodeA.getId();
            Node nodeB = tx.createNode(new Label[]{LABEL});
            nodeB.setProperty("prop", (Object)"value");
            nodeIdB = nodeB.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            try (Result result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", "value"));){
                ThreadTestUtils.forkFuture(() -> {
                    try (Transaction forkedTx = this.db.beginTx();){
                        tx.getNodeById(nodeIdA).delete();
                        tx.getNodeById(nodeIdB).delete();
                        forkedTx.commit();
                    }
                    return null;
                }).get();
                Assertions.assertThat((long)result.stream().count()).isEqualTo(0L);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void queryResultsMustNotIncludeRelationshipsDeletedInOtherConcurrentlyCommittedTransactions() throws Exception {
        long relIdB;
        long relIdA;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            Relationship relA = node.createRelationshipTo(node, REL);
            relA.setProperty("prop", (Object)"value");
            relIdA = relA.getId();
            Relationship relB = node.createRelationshipTo(node, REL);
            relB.setProperty("prop", (Object)"value");
            relIdB = relB.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            try (Result result = tx.execute(String.format("CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")", "rels", "value"));){
                ThreadTestUtils.forkFuture(() -> {
                    try (Transaction forkedTx = this.db.beginTx();){
                        tx.getRelationshipById(relIdA).delete();
                        tx.getRelationshipById(relIdB).delete();
                        forkedTx.commit();
                    }
                    return null;
                }).get();
                Assertions.assertThat((long)result.stream().count()).isEqualTo(0L);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void queryResultsMustNotIncludeNodesDeletedInThisTransaction() {
        long nodeIdB;
        long nodeIdA;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node nodeA = tx.createNode(new Label[]{LABEL});
            nodeA.setProperty("prop", (Object)"value");
            nodeIdA = nodeA.getId();
            Node nodeB = tx.createNode(new Label[]{LABEL});
            nodeB.setProperty("prop", (Object)"value");
            nodeIdB = nodeB.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(nodeIdA).delete();
            tx.getNodeById(nodeIdB).delete();
            try (Result result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", "value"));){
                Assertions.assertThat((long)result.stream().count()).isEqualTo(0L);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void queryResultsMustNotIncludeRelationshipsDeletedInThisTransaction() {
        long relIdB;
        long relIdA;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            Relationship relA = node.createRelationshipTo(node, REL);
            relA.setProperty("prop", (Object)"value");
            relIdA = relA.getId();
            Relationship relB = node.createRelationshipTo(node, REL);
            relB.setProperty("prop", (Object)"value");
            relIdB = relB.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getRelationshipById(relIdA).delete();
            tx.getRelationshipById(relIdB).delete();
            try (Result result = tx.execute(String.format("CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")", "rels", "value"));){
                Assertions.assertThat((long)result.stream().count()).isEqualTo(0L);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void queryResultsMustIncludeNodesAddedInThisTransaction() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"value");
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "value", LongHashSet.newSetWith((long[])new long[]{node.getId()}));
    }

    @Test
    void queryResultsMustIncludeRelationshipsAddedInThisTransaction() {
        Relationship relationship;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            relationship = node.createRelationshipTo(node, REL);
            relationship.setProperty("prop", (Object)"value");
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "value", LongHashSet.newSetWith((long[])new long[]{relationship.getId()}));
    }

    @Test
    void queryResultsMustIncludeNodesWithPropertiesAddedToBeIndexed() {
        long nodeId;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            nodeId = tx.createNode(new Label[]{LABEL}).getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(nodeId).setProperty("prop", (Object)"value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "prop:value", nodeId);
    }

    @Test
    void queryResultsMustIncludeRelationshipsWithPropertiesAddedToBeIndexed() {
        long relId;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            Relationship rel = node.createRelationshipTo(node, REL);
            relId = rel.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Relationship rel = tx.getRelationshipById(relId);
            rel.setProperty("prop", (Object)"value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "prop:value", relId);
    }

    @Test
    void queryResultsMustIncludeNodesWithLabelsModifedToBeIndexed() {
        long nodeId;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            node.setProperty("prop", (Object)"value");
            nodeId = node.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.addLabel(LABEL);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "value", nodeId);
    }

    @Test
    void queryResultsMustIncludeUpdatedValueOfChangedNodeProperties() {
        long nodeId;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"primo");
            nodeId = node.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(nodeId).setProperty("prop", (Object)"secundo");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", new long[0]);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "secundo", nodeId);
    }

    @Test
    void queryResultsMustIncludeUpdatedValuesOfChangedRelationshipProperties() {
        long relId;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            Relationship rel = node.createRelationshipTo(node, REL);
            rel.setProperty("prop", (Object)"primo");
            relId = rel.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getRelationshipById(relId).setProperty("prop", (Object)"secundo");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", new long[0]);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "secundo", relId);
    }

    @Test
    void queryResultsMustNotIncludeNodesWithRemovedIndexedProperties() {
        long nodeId;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"value");
            nodeId = node.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(nodeId).removeProperty("prop");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "value", new long[0]);
    }

    @Test
    void queryResultsMustNotIncludeRelationshipsWithRemovedIndexedProperties() {
        long relId;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            Relationship rel = node.createRelationshipTo(node, REL);
            rel.setProperty("prop", (Object)"value");
            relId = rel.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getRelationshipById(relId).removeProperty("prop");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "value", new long[0]);
    }

    @Test
    void queryResultsMustNotIncludeNodesWithRemovedIndexedLabels() {
        long nodeId;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"value");
            nodeId = node.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(nodeId).removeLabel(LABEL);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "nodes", new long[0]);
    }

    @Test
    void queryResultsMustIncludeOldNodePropertyValuesWhenModificationsAreUndone() {
        long nodeId;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"primo");
            nodeId = node.getId();
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", nodeId);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "secundo", new long[0]);
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.setProperty("prop", (Object)"secundo");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", new long[0]);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "secundo", nodeId);
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.setProperty("prop", (Object)"primo");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", nodeId);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "secundo", new long[0]);
    }

    @Test
    void queryResultsMustIncludeOldRelationshipPropertyValuesWhenModificationsAreUndone() {
        Relationship rel;
        long relId;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            Relationship rel2 = node.createRelationshipTo(node, REL);
            rel2.setProperty("prop", (Object)"primo");
            relId = rel2.getId();
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", relId);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "secundo", new long[0]);
        tx = this.db.beginTx();
        try {
            rel = tx.getRelationshipById(relId);
            rel.setProperty("prop", (Object)"secundo");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", new long[0]);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "secundo", relId);
        tx = this.db.beginTx();
        try {
            rel = tx.getRelationshipById(relId);
            rel.setProperty("prop", (Object)"primo");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", relId);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "secundo", new long[0]);
    }

    @Test
    void queryResultsMustIncludeOldNodePropertyValuesWhenRemovalsAreUndone() {
        long nodeId;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"primo");
            nodeId = node.getId();
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", nodeId);
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.removeProperty("prop");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", new long[0]);
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.setProperty("prop", (Object)"primo");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", nodeId);
    }

    @Test
    void queryResultsMustIncludeOldRelationshipPropertyValuesWhenRemovalsAreUndone() {
        Relationship rel;
        long relId;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            Relationship rel2 = node.createRelationshipTo(node, REL);
            rel2.setProperty("prop", (Object)"primo");
            relId = rel2.getId();
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", relId);
        tx = this.db.beginTx();
        try {
            rel = tx.getRelationshipById(relId);
            rel.removeProperty("prop");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", new long[0]);
        tx = this.db.beginTx();
        try {
            rel = tx.getRelationshipById(relId);
            rel.setProperty("prop", (Object)"primo");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "primo", relId);
    }

    @Test
    void queryResultsMustIncludeNodesWhenNodeLabelRemovalsAreUndone() {
        long nodeId;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"primo");
            nodeId = node.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.removeLabel(LABEL);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", new long[0]);
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.addLabel(LABEL);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "primo", nodeId);
    }

    @Test
    void queryResultsFromTransactionStateMustSortTogetherWithResultFromBaseIndex() {
        long secondId;
        long thirdId;
        long firstId;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node first = tx.createNode(new Label[]{LABEL});
            first.setProperty("prop", (Object)"God of War");
            firstId = first.getId();
            Node third = tx.createNode(new Label[]{LABEL});
            third.setProperty("prop", (Object)"God Wars: Future Past");
            thirdId = third.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Node second = tx.createNode(new Label[]{LABEL});
            second.setProperty("prop", (Object)"God of War III Remastered");
            secondId = second.getId();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "god of war", firstId, secondId, thirdId);
    }

    @Test
    void queryResultsMustBeOrderedByScore() {
        long thirdId;
        long secondId;
        long firstId;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"dude sweet");
            firstId = node.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"dude sweet dude sweet");
            secondId = node.getId();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"dude sweet dude dude dude sweet");
            thirdId = node.getId();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "dude", thirdId, secondId, firstId);
    }

    @Test
    void queryingDroppedIndexForNodesInDroppingTransactionMustThrow() {
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.drop(\"%s\")", "nodes")).close();
            org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", "blabla")).next());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void queryingDroppedIndexForRelationshipsInDroppingTransactionMustThrow() {
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.drop(\"%s\")", "rels")).close();
            org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> tx.execute(String.format("CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")", "rels", "blabla")).next());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void creatingAndDroppingIndexesInSameTransactionMustNotThrow() {
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.execute(String.format("CALL db.index.fulltext.drop(\"%s\")", "nodes")).close();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            this.createSimpleRelationshipIndex(tx);
            tx.execute(String.format("CALL db.index.fulltext.drop(\"%s\")", "rels")).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.schema().getIndexes().iterator().hasNext());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void eventuallyConsistentIndexMustNotIncludeEntitiesAddedInTransaction() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}) + ", {eventually_consistent: 'true'}")).close();
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextIndexProceduresUtil.asStrList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}) + ", {eventually_consistent: 'true'}")).close();
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            Node node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"value");
            node.createRelationshipTo(node, REL).setProperty("prop", (Object)"value");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "value", new long[0]);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "value", new long[0]);
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute("CALL db.index.fulltext.awaitEventuallyConsistentIndexRefresh()").close();
            transaction.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "value", new long[0]);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "value", new long[0]);
    }

    @Test
    void prefixedFulltextIndexSettingMustBeRecognized() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}) + ", {`fulltext.eventually_consistent`: 'true'}")).close();
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextIndexProceduresUtil.asStrList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}) + ", {`fulltext.eventually_consistent`: 'true'}")).close();
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            for (IndexDefinition index : tx.schema().getIndexes()) {
                Map indexConfiguration = index.getIndexConfiguration();
                Object eventuallyConsistentObj = indexConfiguration.get(IndexSettingImpl.FULLTEXT_EVENTUALLY_CONSISTENT);
                org.junit.jupiter.api.Assertions.assertNotNull(eventuallyConsistentObj);
                Assertions.assertThat(eventuallyConsistentObj).isInstanceOf(Boolean.class);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)eventuallyConsistentObj));
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void prefixedFulltextIndexSettingMustBeRecognizedTogetherWithNonPrefixed() {
        try (Transaction tx = this.db.beginTx();){
            String mixedPrefixConfig = ", {`fulltext.analyzer`: 'english', eventually_consistent: 'true'}";
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}) + mixedPrefixConfig)).close();
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextIndexProceduresUtil.asStrList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}) + mixedPrefixConfig)).close();
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            for (IndexDefinition index : tx.schema().getIndexes()) {
                Map indexConfiguration = index.getIndexConfiguration();
                Object eventuallyConsistentObj = indexConfiguration.get(IndexSettingImpl.FULLTEXT_EVENTUALLY_CONSISTENT);
                org.junit.jupiter.api.Assertions.assertNotNull(eventuallyConsistentObj);
                Assertions.assertThat(eventuallyConsistentObj).isInstanceOf(Boolean.class);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)eventuallyConsistentObj));
                Object analyzerObj = indexConfiguration.get(IndexSettingImpl.FULLTEXT_ANALYZER);
                org.junit.jupiter.api.Assertions.assertNotNull(analyzerObj);
                Assertions.assertThat(analyzerObj).isInstanceOf(String.class);
                org.junit.jupiter.api.Assertions.assertEquals((Object)"english", analyzerObj);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void mustThrowOnDuplicateFulltextIndexSetting() {
        Throwable rootCause;
        Transaction tx;
        String duplicateConfig = ", {`fulltext.analyzer`: 'english', analyzer: 'swedish'}";
        try {
            tx = this.db.beginTx();
            try {
                tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}) + duplicateConfig)).close();
                org.junit.jupiter.api.Assertions.fail((String)"Expected to fail");
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (QueryExecutionException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Config setting was specified more than once, 'analyzer'."});
            rootCause = ExceptionUtils.getRootCause((Throwable)e);
            Assertions.assertThat((Throwable)rootCause).isInstanceOf(IllegalArgumentException.class);
        }
        try {
            tx = this.db.beginTx();
            try {
                tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextIndexProceduresUtil.asStrList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}) + duplicateConfig)).close();
                org.junit.jupiter.api.Assertions.fail((String)"Expected to fail");
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (QueryExecutionException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Config setting was specified more than once, 'analyzer'."});
            rootCause = ExceptionUtils.getRootCause((Throwable)e);
            Assertions.assertThat((Throwable)rootCause).isInstanceOf(IllegalArgumentException.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void transactionStateMustNotPreventIndexUpdatesFromBeingApplied() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        LongHashSet nodeIds = new LongHashSet();
        LongHashSet relIds = new LongHashSet();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            try (Transaction tx = this.db.beginTx();){
                Node node = tx.createNode(new Label[]{LABEL});
                node.setProperty("prop", (Object)"value");
                Relationship rel = node.createRelationshipTo(node, REL);
                rel.setProperty("prop", (Object)"value");
                nodeIds.add(node.getId());
                relIds.add(rel.getId());
                executor.submit(() -> {
                    try (Transaction forkedTx = this.db.beginTx();){
                        Node node2 = forkedTx.createNode(new Label[]{LABEL});
                        node2.setProperty("prop", (Object)"value");
                        Relationship rel2 = node2.createRelationshipTo(node2, REL);
                        rel2.setProperty("prop", (Object)"value");
                        nodeIds.add(node2.getId());
                        relIds.add(rel2.getId());
                        forkedTx.commit();
                    }
                }).get();
                tx.commit();
            }
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "value", nodeIds);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "value", relIds);
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    void dropMustNotApplyToRegularSchemaIndexes() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").create();
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            String schemaIndexName;
            try (Result result = tx.execute("call db.indexes()");){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)result.hasNext());
                schemaIndexName = result.next().get("name").toString();
            }
            org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> tx.execute(String.format("CALL db.index.fulltext.drop(\"%s\")", schemaIndexName)).close());
        }
    }

    @Test
    void fulltextIndexMustNotBeAvailableForRegularIndexSeeks() {
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        String valueToQueryFor = "value to query for";
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            List<Value> values = this.generateRandomSimpleValues();
            for (Value value : values) {
                tx.createNode(new Label[]{LABEL}).setProperty("prop", value.asObject());
            }
            tx.createNode(new Label[]{LABEL}).setProperty("prop", (Object)valueToQueryFor);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("prop", valueToQueryFor);
            try (Result result = tx.execute("profile match (n:" + LABEL.name() + ") where n.prop = $prop return n", params);){
                this.assertNoIndexSeeks(result);
            }
            result = tx.execute("cypher 3.5 profile match (n:" + LABEL.name() + ") where n.prop = $prop return n", params);
            try {
                this.assertNoIndexSeeks(result);
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void fulltextIndexMustNotBeAvailableForRegularIndexSeeksAfterShutDown() {
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.restartDatabase();
        String valueToQueryFor = "value to query for";
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            List<Value> values = this.generateRandomSimpleValues();
            for (Value value : values) {
                tx.createNode(new Label[]{LABEL}).setProperty("prop", value.asObject());
            }
            tx.createNode(new Label[]{LABEL}).setProperty("prop", (Object)valueToQueryFor);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("prop", valueToQueryFor);
            try (Result result = tx.execute("profile match (n:" + LABEL.name() + ") where n.prop = $prop return n", params);){
                this.assertNoIndexSeeks(result);
            }
            result = tx.execute("cypher 3.5 profile match (n:" + LABEL.name() + ") where n.prop = $prop return n", params);
            try {
                this.assertNoIndexSeeks(result);
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void nodeOutputMustBeOrderedByScoreDescending() {
        FulltextProcedures.NodeOutput a = new FulltextProcedures.NodeOutput(null, Float.NaN);
        FulltextProcedures.NodeOutput b = new FulltextProcedures.NodeOutput(null, Float.POSITIVE_INFINITY);
        FulltextProcedures.NodeOutput c = new FulltextProcedures.NodeOutput(null, Float.MAX_VALUE);
        FulltextProcedures.NodeOutput d = new FulltextProcedures.NodeOutput(null, 1.0f);
        FulltextProcedures.NodeOutput e = new FulltextProcedures.NodeOutput(null, Float.MIN_NORMAL);
        FulltextProcedures.NodeOutput f = new FulltextProcedures.NodeOutput(null, Float.MIN_VALUE);
        FulltextProcedures.NodeOutput g = new FulltextProcedures.NodeOutput(null, 0.0f);
        FulltextProcedures.NodeOutput h = new FulltextProcedures.NodeOutput(null, -1.0f);
        FulltextProcedures.NodeOutput i = new FulltextProcedures.NodeOutput(null, Float.NEGATIVE_INFINITY);
        Object[] expectedOrder = new FulltextProcedures.NodeOutput[]{a, b, c, d, e, f, g, h, i};
        Object[] array = Arrays.copyOf(expectedOrder, expectedOrder.length);
        for (int counter = 0; counter < 10; ++counter) {
            ArrayUtils.shuffle((Object[])array);
            Arrays.sort(array);
            org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])expectedOrder, (Object[])array);
        }
    }

    @Test
    void relationshipOutputMustBeOrderedByScoreDescending() {
        FulltextProcedures.RelationshipOutput a = new FulltextProcedures.RelationshipOutput(null, Float.NaN);
        FulltextProcedures.RelationshipOutput b = new FulltextProcedures.RelationshipOutput(null, Float.POSITIVE_INFINITY);
        FulltextProcedures.RelationshipOutput c = new FulltextProcedures.RelationshipOutput(null, Float.MAX_VALUE);
        FulltextProcedures.RelationshipOutput d = new FulltextProcedures.RelationshipOutput(null, 1.0f);
        FulltextProcedures.RelationshipOutput e = new FulltextProcedures.RelationshipOutput(null, Float.MIN_NORMAL);
        FulltextProcedures.RelationshipOutput f = new FulltextProcedures.RelationshipOutput(null, Float.MIN_VALUE);
        FulltextProcedures.RelationshipOutput g = new FulltextProcedures.RelationshipOutput(null, 0.0f);
        FulltextProcedures.RelationshipOutput h = new FulltextProcedures.RelationshipOutput(null, -1.0f);
        FulltextProcedures.RelationshipOutput i = new FulltextProcedures.RelationshipOutput(null, Float.NEGATIVE_INFINITY);
        Object[] expectedOrder = new FulltextProcedures.RelationshipOutput[]{a, b, c, d, e, f, g, h, i};
        Object[] array = Arrays.copyOf(expectedOrder, expectedOrder.length);
        for (int counter = 0; counter < 10; ++counter) {
            ArrayUtils.shuffle((Object[])array);
            Arrays.sort(array);
            org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])expectedOrder, (Object[])array);
        }
    }

    @Test
    void awaitIndexProcedureMustWorkOnIndexNames() {
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Node node = tx.createNode(new Label[]{LABEL});
                node.setProperty("prop", (Object)"value");
                Relationship rel = node.createRelationshipTo(node, REL);
                rel.setProperty("prop", (Object)"value");
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            this.createSimpleNodesIndex(tx);
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.awaitIndex(\"%s\")", "nodes")).close();
            tx.execute(String.format("CALL db.awaitIndex(\"%s\")", "rels")).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void mustBePossibleToDropFulltextIndexByNameForWhichNormalIndexExistWithMatchingSchema() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute("CREATE INDEX FOR (n:Person) ON (n.name)").close();
            tx.execute("call db.index.fulltext.createNodeIndex('nameIndex', ['Person'], ['name'])").close();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.execute("call db.index.fulltext.drop('nameIndex')").close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((String)((IndexDefinition)Iterables.single((Iterable)tx.schema().getIndexes())).getName()).isNotEqualTo((Object)"nameIndex");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void fulltextIndexesMustNotPreventNormalSchemaIndexesFromBeingDropped() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute("CREATE INDEX FOR (n:Person) ON (n.name)").close();
            tx.execute("call db.index.fulltext.createNodeIndex('nameIndex', ['Person'], ['name'])").close();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.execute("DROP INDEX ON :Person(name)").close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((String)((IndexDefinition)Iterables.single((Iterable)tx.schema().getIndexes())).getName()).isEqualTo("nameIndex");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void creatingNormalIndexWithFulltextProviderMustThrow() {
        Transaction tx;
        String providerName = FulltextIndexProviderFactory.DESCRIPTOR.name();
        Assertions.assertThat((String)providerName).isEqualTo("fulltext-1.0");
        try {
            tx = this.db.beginTx();
            try {
                tx.execute("call db.createIndex( \"MyIndex\", ['User'], ['searchableString'], \"" + providerName + "\" );").close();
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (QueryExecutionException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Could not create index with specified index provider 'fulltext-1.0'. To create fulltext index, please use 'db.index.fulltext.createNodeIndex' or 'db.index.fulltext.createRelationshipIndex'."});
        }
        tx = this.db.beginTx();
        try {
            long indexCount = tx.execute("CALL db.indexes()").stream().count();
            Assertions.assertThat((long)indexCount).isEqualTo(0L);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void mustSupportWildcardEndsLikeStartsWith() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        LongHashSet ids = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"abcdef");
            ids.add(node.getId());
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"abcxyz");
            ids.add(node.getId());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "abc*", ids);
    }

    @Test
    void mustSupportWildcardBeginningsLikeEndsWith() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        LongHashSet ids = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"defabc");
            ids.add(node.getId());
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"xyzabc");
            ids.add(node.getId());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "*abc", ids);
    }

    @Test
    void mustSupportWildcardBeginningsAndEndsLikeContains() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            tx.commit();
        }
        LongHashSet ids = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"defabcdef");
            ids.add(node.getId());
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"xyzabcxyz");
            ids.add(node.getId());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "*abc*", ids);
    }

    @Test
    void mustMatchCaseInsensitiveWithStandardAnalyzer() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'A'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'B'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'C'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'b'}))").close();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "myindex", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"id"}) + ", {analyzer: 'standard'}")).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            try (Result result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "A"));){
                Assertions.assertThat((long)result.stream().count()).isEqualTo(0L);
            }
            result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "B"));
            try {
                Assertions.assertThat((long)result.stream().count()).isEqualTo(2000L);
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "C"));
            try {
                Assertions.assertThat((long)result.stream().count()).isEqualTo(1000L);
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void mustMatchCaseInsensitiveWithSimpleAnalyzer() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'A'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'B'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'C'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'b'}))").close();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "myindex", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"id"}) + ", {analyzer: 'simple'}")).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            try (Result result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "A"));){
                Assertions.assertThat((long)result.stream().count()).isEqualTo(1000L);
            }
            result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "B"));
            try {
                Assertions.assertThat((long)result.stream().count()).isEqualTo(2000L);
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "C"));
            try {
                Assertions.assertThat((long)result.stream().count()).isEqualTo(1000L);
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void mustMatchCaseInsensitiveWithDefaultAnalyzer() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'A'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'B'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'C'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'b'}))").close();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "myindex", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"id"}))).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            try (Result result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "A"));){
                Assertions.assertThat((long)result.stream().count()).isEqualTo(1000L);
            }
            result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "B"));
            try {
                Assertions.assertThat((long)result.stream().count()).isEqualTo(2000L);
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "C"));
            try {
                Assertions.assertThat((long)result.stream().count()).isEqualTo(1000L);
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void makeSureFulltextIndexDoesNotBlockSchemaIndexOnSameSchemaPattern() {
        Label label = Label.label((String)"label");
        String prop = "prop";
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "myindex", FulltextIndexProceduresUtil.asStrList((String[])new String[]{label.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"})));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.awaitIndex(\"%s\")", "myindex"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().indexFor(label).on("prop").create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)Iterables.count((Iterable)tx.schema().getIndexes()));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void makeSureSchemaIndexDoesNotBlockFulltextIndexOnSameSchemaPattern() {
        Label label = Label.label((String)"label");
        String prop = "prop";
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(label).on("prop").create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "myindex", FulltextIndexProceduresUtil.asStrList((String[])new String[]{label.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"})));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.awaitIndex(\"%s\")", "myindex"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)Iterables.count((Iterable)tx.schema().getIndexes()));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNotBePossibleToCreateIndexWithDuplicateProperty() {
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "myindex", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"id", "id"})));
            }
        });
        Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
        Assertions.assertThat((Throwable)cause).isInstanceOf(RepeatedPropertyInSchemaException.class);
    }

    @Test
    void shouldNotBePossibleToCreateIndexWithDuplicateLabel() {
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "myindex", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label", "Label"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"id"})));
            }
        });
        Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
        Assertions.assertThat((Throwable)cause).isInstanceOf(RepeatedLabelInSchemaException.class);
    }

    @Test
    void shouldNotBePossibleToCreateIndexWithDuplicateRelType() {
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "myindex", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"RelType", "RelType"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"id"})));
            }
        });
        Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
        Assertions.assertThat((Throwable)cause).isInstanceOf(RepeatedRelationshipTypeInSchemaException.class);
    }

    @Test
    void attemptingToIndexOnPropertyUsedForInternalReferenceMustThrow() {
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "myindex", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"__neo4j__lucene__fulltext__index__internal__id__"}))).close();
                tx.commit();
            }
        });
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"__neo4j__lucene__fulltext__index__internal__id__"});
    }

    @Test
    void fulltextIndexMustWorkAfterRestartWithTxStateChanges() {
        try (Transaction tx = this.db.beginTx();){
            this.createSimpleNodesIndex(tx);
            this.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        this.restartDatabase();
        tx = this.db.beginTx();
        try {
            tx.createNode();
            tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", "*")).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.createNode();
            tx.execute(String.format("CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")", "rels", "*")).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Nested
    class SkipAndLimitRelationships {
        long topRel;
        long middleRel;
        long bottomRel;

        SkipAndLimitRelationships() {
        }

        @BeforeEach
        void setUp() {
            try (Transaction tx = FulltextProceduresTest.this.db.beginTx();){
                FulltextProceduresTest.this.createSimpleRelationshipIndex(tx);
                tx.commit();
            }
            FulltextProceduresTest.this.awaitIndexesOnline();
            tx = FulltextProceduresTest.this.db.beginTx();
            try {
                Node node = tx.createNode();
                Relationship top = node.createRelationshipTo(node, FulltextProceduresTestSupport.REL);
                Relationship middle = node.createRelationshipTo(node, FulltextProceduresTestSupport.REL);
                Relationship bottom = node.createRelationshipTo(node, FulltextProceduresTestSupport.REL);
                top.setProperty("prop", (Object)"zebra zebra zebra zebra donkey");
                middle.setProperty("prop", (Object)"zebra zebra zebra donkey");
                bottom.setProperty("prop", (Object)"zebra donkey");
                this.topRel = top.getId();
                this.middleRel = middle.getId();
                this.bottomRel = bottom.getId();
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }

        @Test
        void queryRelationshipsMustApplySkip() {
            try (Transaction tx = FulltextProceduresTest.this.db.beginTx();
                 ResourceIterator iterator = tx.execute("CALL db.index.fulltext.queryRelationships('rels', 'zebra', {skip:1})").columnAs("relationship");){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
                Assertions.assertThat((long)((Relationship)iterator.next()).getId()).isEqualTo(this.middleRel);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
                Assertions.assertThat((long)((Relationship)iterator.next()).getId()).isEqualTo(this.bottomRel);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
                tx.commit();
            }
        }

        @Test
        void queryRelationshipsMustApplyLimit() {
            try (Transaction tx = FulltextProceduresTest.this.db.beginTx();
                 ResourceIterator iterator = tx.execute("CALL db.index.fulltext.queryRelationships('rels', 'zebra', {limit:1})").columnAs("relationship");){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
                Assertions.assertThat((long)((Relationship)iterator.next()).getId()).isEqualTo(this.topRel);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
                tx.commit();
            }
        }

        @Test
        void queryRelationshipsMustApplySkipAndLimit() {
            try (Transaction tx = FulltextProceduresTest.this.db.beginTx();
                 ResourceIterator iterator = tx.execute("CALL db.index.fulltext.queryRelationships('rels', 'zebra', {skip:1, limit:1})").columnAs("relationship");){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
                Assertions.assertThat((long)((Relationship)iterator.next()).getId()).isEqualTo(this.middleRel);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
                tx.commit();
            }
        }

        @Test
        void queryRelationshipsWithSkipAndLimitMustIgnoreRelationshipsDeletedInTransaction() {
            try (Transaction tx = FulltextProceduresTest.this.db.beginTx();){
                tx.getRelationshipById(this.topRel).delete();
                try (ResourceIterator iterator = tx.execute("CALL db.index.fulltext.queryRelationships('rels', 'zebra', {skip:1})").columnAs("relationship");){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
                    Assertions.assertThat((long)((Relationship)iterator.next()).getId()).isEqualTo(this.bottomRel);
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
                }
                iterator = tx.execute("CALL db.index.fulltext.queryRelationships('rels', 'zebra', {limit:1})").columnAs("relationship");
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
                    Assertions.assertThat((long)((Relationship)iterator.next()).getId()).isEqualTo(this.middleRel);
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
                }
                finally {
                    if (iterator != null) {
                        iterator.close();
                    }
                }
                tx.commit();
            }
        }

        @Test
        void queryRelationshipsWithSkipAndLimitMustIncludeRelationshipsAddedInTransaction() {
            try (Transaction tx = FulltextProceduresTest.this.db.beginTx();){
                Node node = tx.createNode();
                Relationship rel = node.createRelationshipTo(node, FulltextProceduresTestSupport.REL);
                long relId = rel.getId();
                rel.setProperty("prop", (Object)"zebra zebra donkey");
                try (ResourceIterator iterator = tx.execute("CALL db.index.fulltext.queryRelationships('rels', 'zebra', {skip:1, limit:2})").columnAs("relationship");){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
                    Assertions.assertThat((long)((Relationship)iterator.next()).getId()).isEqualTo(this.middleRel);
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
                    Assertions.assertThat((long)((Relationship)iterator.next()).getId()).isEqualTo(relId);
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
                }
                tx.commit();
            }
        }
    }

    @Nested
    class SkipAndLimitNodes {
        long topNode;
        long middleNode;
        long bottomNode;

        SkipAndLimitNodes() {
        }

        @BeforeEach
        void setUp() {
            try (Transaction tx = FulltextProceduresTest.this.db.beginTx();){
                FulltextProceduresTest.this.createSimpleNodesIndex(tx);
                tx.commit();
            }
            FulltextProceduresTest.this.awaitIndexesOnline();
            tx = FulltextProceduresTest.this.db.beginTx();
            try {
                Node top = tx.createNode(new Label[]{FulltextProceduresTestSupport.LABEL});
                Node middle = tx.createNode(new Label[]{FulltextProceduresTestSupport.LABEL});
                Node bottom = tx.createNode(new Label[]{FulltextProceduresTestSupport.LABEL});
                top.setProperty("prop", (Object)"zebra zebra zebra zebra donkey");
                middle.setProperty("prop", (Object)"zebra zebra zebra donkey");
                bottom.setProperty("prop", (Object)"zebra donkey");
                this.topNode = top.getId();
                this.middleNode = middle.getId();
                this.bottomNode = bottom.getId();
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }

        @Test
        void queryNodesMustApplySkip() {
            try (Transaction tx = FulltextProceduresTest.this.db.beginTx();
                 ResourceIterator iterator = tx.execute("CALL db.index.fulltext.queryNodes('nodes', 'zebra', {skip:1})").columnAs("node");){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
                Assertions.assertThat((long)((Node)iterator.next()).getId()).isEqualTo(this.middleNode);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
                Assertions.assertThat((long)((Node)iterator.next()).getId()).isEqualTo(this.bottomNode);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
                tx.commit();
            }
        }

        @Test
        void queryNodesMustApplyLimit() {
            try (Transaction tx = FulltextProceduresTest.this.db.beginTx();
                 ResourceIterator iterator = tx.execute("CALL db.index.fulltext.queryNodes('nodes', 'zebra', {limit:1})").columnAs("node");){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
                Assertions.assertThat((long)((Node)iterator.next()).getId()).isEqualTo(this.topNode);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
                tx.commit();
            }
        }

        @Test
        void queryNodesMustApplySkipAndLimit() {
            try (Transaction tx = FulltextProceduresTest.this.db.beginTx();
                 ResourceIterator iterator = tx.execute("CALL db.index.fulltext.queryNodes('nodes', 'zebra', {skip:1, limit:1})").columnAs("node");){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
                Assertions.assertThat((long)((Node)iterator.next()).getId()).isEqualTo(this.middleNode);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
                tx.commit();
            }
        }

        @Test
        void queryNodesWithSkipAndLimitMustIgnoreNodesDeletedInTransaction() {
            try (Transaction tx = FulltextProceduresTest.this.db.beginTx();){
                tx.getNodeById(this.topNode).delete();
                try (ResourceIterator iterator = tx.execute("CALL db.index.fulltext.queryNodes('nodes', 'zebra', {skip:1})").columnAs("node");){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
                    Assertions.assertThat((long)((Node)iterator.next()).getId()).isEqualTo(this.bottomNode);
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
                }
                iterator = tx.execute("CALL db.index.fulltext.queryNodes('nodes', 'zebra', {limit:1})").columnAs("node");
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
                    Assertions.assertThat((long)((Node)iterator.next()).getId()).isEqualTo(this.middleNode);
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
                }
                finally {
                    if (iterator != null) {
                        iterator.close();
                    }
                }
                tx.commit();
            }
        }

        @Test
        void queryNodesWithSkipAndLimitMustIncludeNodesAddedInTransaction() {
            try (Transaction tx = FulltextProceduresTest.this.db.beginTx();){
                Node node = tx.createNode(new Label[]{FulltextProceduresTestSupport.LABEL});
                long nodeId = node.getId();
                node.setProperty("prop", (Object)"zebra zebra donkey");
                try (ResourceIterator iterator = tx.execute("CALL db.index.fulltext.queryNodes('nodes', 'zebra', {skip:1, limit:2})").columnAs("node");){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
                    Assertions.assertThat((long)((Node)iterator.next()).getId()).isEqualTo(this.middleNode);
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
                    Assertions.assertThat((long)((Node)iterator.next()).getId()).isEqualTo(nodeId);
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
                }
                tx.commit();
            }
        }
    }
}

