/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.index.SetInitialStateInNativeIndex;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.Barrier;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.DbmsRule;
import org.neo4j.test.rule.EmbeddedDbmsRule;
import org.neo4j.test.rule.OtherThreadRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;

@RunWith(value=Parameterized.class)
@Ignore
public class IndexCleanupIT {
    @Parameterized.Parameter
    public GraphDatabaseSettings.SchemaIndex schemaIndex;
    private static final String propertyKey = "key";
    private RandomRule random = new RandomRule();
    private FileSystemRule fs = new DefaultFileSystemRule();
    private TestDirectory directory = TestDirectory.testDirectory((FileSystemAbstraction)this.fs);
    private DbmsRule db = new EmbeddedDbmsRule(this.directory).startLazily();
    private OtherThreadRule<Void> t2 = new OtherThreadRule("T2");
    @Rule
    public RuleChain rules = RuleChain.outerRule((TestRule)this.random).around((TestRule)this.fs).around((TestRule)this.directory).around((TestRule)this.db);

    @Parameterized.Parameters(name="{index} {0}")
    public static Collection<GraphDatabaseSettings.SchemaIndex> schemaIndexes() {
        return Arrays.asList(GraphDatabaseSettings.SchemaIndex.values());
    }

    @Test
    public void mustClearIndexDirectoryOnDropWhileOnline() {
        File[] providerDirectories;
        this.configureDb(this.schemaIndex);
        this.createIndex((GraphDatabaseService)this.db, true);
        for (File providerDirectory : providerDirectories = this.providerDirectories((FileSystemAbstraction)this.fs, this.db)) {
            Assertions.assertTrue((this.fs.listFiles(providerDirectory).length > 0 ? 1 : 0) != 0, (String)"expected there to be at least one index per existing provider map");
        }
        this.dropAllIndexes();
        this.assertNoIndexFilesExisting(providerDirectories);
    }

    @Test
    public void mustClearIndexDirectoryOnDropWhileFailed() throws IOException {
        this.configureDb(this.schemaIndex);
        this.createIndex((GraphDatabaseService)this.db, true);
        IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor(this.schemaIndex.providerKey(), this.schemaIndex.providerVersion());
        SetInitialStateInNativeIndex setInitialStateInNativeIndex = new SetInitialStateInNativeIndex(0, providerDescriptor);
        this.db.restartDatabase((DbmsRule.RestartAction)setInitialStateInNativeIndex);
        try (Transaction tx = this.db.beginTx();){
            for (IndexDefinition index : tx.schema().getIndexes()) {
                Schema.IndexState indexState = tx.schema().getIndexState(index);
                Assertions.assertEquals((Object)Schema.IndexState.FAILED, (Object)indexState, (String)("expected index state to be " + Schema.IndexState.FAILED));
            }
            tx.commit();
        }
        this.dropAllIndexes();
        this.assertNoIndexFilesExisting(this.providerDirectories((FileSystemAbstraction)this.fs, this.db));
    }

    @Test
    public void mustClearIndexDirectoryOnDropWhilePopulating() throws InterruptedException {
        File[] providerDirectories;
        final Barrier.Control midPopulation = new Barrier.Control();
        IndexingService.MonitorAdapter trappingMonitor = new IndexingService.MonitorAdapter(){

            public void indexPopulationScanStarting() {
                midPopulation.reached();
            }
        };
        this.configureDb(this.schemaIndex);
        Monitors monitors = (Monitors)this.db.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(Monitors.class);
        monitors.addMonitorListener((Object)trappingMonitor, new String[0]);
        this.createIndex((GraphDatabaseService)this.db, false);
        midPopulation.await();
        for (File providerDirectory : providerDirectories = this.providerDirectories((FileSystemAbstraction)this.fs, this.db)) {
            Assertions.assertTrue((this.fs.listFiles(providerDirectory).length > 0 ? 1 : 0) != 0, (String)"expected there to be at least one index per existing provider map");
        }
        this.dropAllIndexes();
        midPopulation.release();
        this.assertNoIndexFilesExisting(providerDirectories);
    }

    private void assertNoIndexFilesExisting(File[] providerDirectories) {
        for (File providerDirectory : providerDirectories) {
            Assertions.assertEquals((int)0, (int)this.fs.listFiles(providerDirectory).length, (String)"expected there to be no index files");
        }
    }

    private void dropAllIndexes() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getIndexes().forEach(IndexDefinition::drop);
            tx.commit();
        }
    }

    private void configureDb(GraphDatabaseSettings.SchemaIndex schemaIndex) {
        this.db.withSetting(GraphDatabaseSettings.default_schema_provider, (Object)schemaIndex.providerName());
    }

    private void createIndex(GraphDatabaseService db, boolean awaitOnline) {
        try (Transaction tx = db.beginTx();){
            IndexDefinition indexDefinition = tx.schema().indexFor(TestLabels.LABEL_ONE).on(propertyKey).create();
            tx.commit();
        }
        if (awaitOnline) {
            tx = db.beginTx();
            try {
                tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
    }

    private File[] providerDirectories(FileSystemAbstraction fs, DbmsRule db) {
        DatabaseLayout databaseLayout = db.databaseLayout();
        File dbDir = databaseLayout.databaseDirectory();
        File schemaDir = new File(dbDir, "schema");
        File indexDir = new File(schemaDir, "index");
        return fs.listFiles(indexDir);
    }
}

