/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.TreeNodeDynamicSize;
import org.neo4j.kernel.api.impl.schema.StringLengthIndexValidationIT;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.test.rule.RandomRule;

public class GenericStringLengthIndexValidationIT
extends StringLengthIndexValidationIT {
    @Override
    protected int getSingleKeySizeLimit() {
        return TreeNodeDynamicSize.keyValueSizeCapFromPageSize((int)8192);
    }

    @Override
    protected String getString(RandomRule random, int keySize) {
        return LayoutTestUtil.generateStringResultingInSizeForIndexProvider((int)keySize, (GraphDatabaseSettings.SchemaIndex)GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
    }

    @Override
    protected GraphDatabaseSettings.SchemaIndex getSchemaIndex() {
        return GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10;
    }

    @Override
    protected String expectedPopulationFailureCauseMessage(long entityId) {
        return String.format("Property value is too large to index, please see index documentation for limitations. Index: Index( id=1, name='index_71616483', type='GENERAL BTREE', schema=(:LABEL_ONE {largeString}), indexProvider='native-btree-1.0' ), entity id: %d", entityId);
    }
}

