/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.schema;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.Value;

@DbmsExtension
class SchemaReadIT {
    private static final String INDEX_NAME = "testIndex";
    private static final String PROPERTY_NAME = "property";
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private Kernel kernel;

    SchemaReadIT() {
    }

    @Test
    void trackPageCacheAccessOnIndexNodeCount() throws KernelException {
        Label label = Label.label((String)"foo");
        this.createIndex(label);
        try (KernelTransaction tx = this.kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, (LoginContext)AnonymousContext.read());){
            PageCursorTracer cursorTracer = tx.pageCursorTracer();
            IndexDescriptor indexDescriptor = tx.schemaRead().indexGetForName(INDEX_NAME);
            Assertions.assertThat((long)cursorTracer.faults()).isZero();
            Assertions.assertThat((long)cursorTracer.unpins()).isZero();
            Assertions.assertThat((long)cursorTracer.pins()).isZero();
            tx.schemaRead().nodesCountIndexed(indexDescriptor, 0L, 0, (Value)BooleanValue.FALSE);
            Assertions.assertThat((long)cursorTracer.faults()).isOne();
            Assertions.assertThat((long)cursorTracer.unpins()).isOne();
            Assertions.assertThat((long)cursorTracer.pins()).isOne();
        }
    }

    private void createIndex(Label label) {
        try (Transaction transaction = this.db.beginTx();){
            transaction.schema().indexFor(label).on(PROPERTY_NAME).withName(INDEX_NAME).create();
            transaction.commit();
        }
        transaction = this.db.beginTx();
        try {
            transaction.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }
}

