/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class DefaultSchemaIndexConfigTest {
    private static final String KEY = "key";
    @Rule
    public TestDirectory directory = TestDirectory.testDirectory();
    private DatabaseManagementServiceBuilder dbBuilder;
    private IndexDescriptor index;
    @Parameterized.Parameter
    public GraphDatabaseSettings.SchemaIndex provider;

    @Before
    public void setup() {
        this.dbBuilder = new TestDatabaseManagementServiceBuilder(this.directory.homeDir());
    }

    @Parameterized.Parameters(name="{0}")
    public static List<GraphDatabaseSettings.SchemaIndex> providers() {
        ArrayList<GraphDatabaseSettings.SchemaIndex> providers = new ArrayList<GraphDatabaseSettings.SchemaIndex>(Arrays.asList(GraphDatabaseSettings.SchemaIndex.values()));
        providers.add(null);
        return providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldUseConfiguredIndexProvider() {
        DatabaseManagementServiceBuilder databaseManagementServiceBuilder = this.dbBuilder.setConfig(GraphDatabaseSettings.default_schema_provider, this.provider == null ? null : this.provider.providerName());
        DatabaseManagementService managementService = databaseManagementServiceBuilder.build();
        GraphDatabaseService db = managementService.database("neo4j");
        try {
            this.createIndex(db);
            this.assertIndexProvider(this.provider == null ? GenericNativeIndexProvider.DESCRIPTOR.name() : this.provider.providerName());
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void indexShouldHaveIndexConfig() throws IndexNotFoundKernelException {
        DatabaseManagementServiceBuilder databaseManagementServiceBuilder = this.dbBuilder.setConfig(GraphDatabaseSettings.default_schema_provider, this.provider == null ? null : this.provider.providerName());
        DatabaseManagementService managementService = databaseManagementServiceBuilder.build();
        GraphDatabaseService db = managementService.database("neo4j");
        try {
            this.createIndex(db);
            this.validateIndexConfig(db);
        }
        finally {
            managementService.shutdown();
        }
        managementService = databaseManagementServiceBuilder.build();
        db = managementService.database("neo4j");
        try {
            this.validateIndexConfig(db);
        }
        finally {
            managementService.shutdown();
        }
    }

    private void validateIndexConfig(GraphDatabaseService db) throws IndexNotFoundKernelException {
        try (Transaction tx = db.beginTx();){
            GraphDatabaseAPI api = (GraphDatabaseAPI)db;
            IndexingService indexingService = DefaultSchemaIndexConfigTest.getIndexingService(api);
            IndexProxy indexProxy = indexingService.getIndexProxy(this.index);
            Map indexConfig = indexProxy.indexConfig();
            Assert.assertEquals((Object)Values.doubleArray((double[])new double[]{-1000000.0, -1000000.0}), indexConfig.get("spatial.cartesian.min"));
            Assert.assertEquals((Object)Values.doubleArray((double[])new double[]{1000000.0, 1000000.0}), indexConfig.get("spatial.cartesian.max"));
            Assert.assertEquals((Object)Values.doubleArray((double[])new double[]{-1000000.0, -1000000.0, -1000000.0}), indexConfig.get("spatial.cartesian-3d.min"));
            Assert.assertEquals((Object)Values.doubleArray((double[])new double[]{1000000.0, 1000000.0, 1000000.0}), indexConfig.get("spatial.cartesian-3d.max"));
            Assert.assertEquals((Object)Values.doubleArray((double[])new double[]{-180.0, -90.0}), indexConfig.get("spatial.wgs-84.min"));
            Assert.assertEquals((Object)Values.doubleArray((double[])new double[]{180.0, 90.0}), indexConfig.get("spatial.wgs-84.max"));
            Assert.assertEquals((Object)Values.doubleArray((double[])new double[]{-180.0, -90.0, -1000000.0}), indexConfig.get("spatial.wgs-84-3d.min"));
            Assert.assertEquals((Object)Values.doubleArray((double[])new double[]{180.0, 90.0, 1000000.0}), indexConfig.get("spatial.wgs-84-3d.max"));
            tx.commit();
        }
    }

    private static IndexingService getIndexingService(GraphDatabaseAPI db) {
        return (IndexingService)db.getDependencyResolver().resolveDependency(IndexingService.class);
    }

    private void assertIndexProvider(String expectedProviderIdentifier) {
        Assert.assertEquals((String)"expected IndexProvider.Descriptor", (Object)expectedProviderIdentifier, (Object)this.index.getIndexProvider().name());
    }

    private void createIndex(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            IndexDefinitionImpl indexDefinition = (IndexDefinitionImpl)tx.schema().indexFor(TestLabels.LABEL_ONE).on(KEY).create();
            this.index = indexDefinition.getIndexReference();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

