/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.Barrier;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@DbmsExtension(configurationCallback="configure")
@ExtendWith(value={RandomExtension.class})
public abstract class StringLengthIndexValidationIT {
    private static final String propKey = "largeString";
    private final AtomicBoolean trapPopulation = new AtomicBoolean();
    private final Barrier.Control populationScanFinished = new Barrier.Control();
    private final int singleKeySizeLimit = this.getSingleKeySizeLimit();
    private final GraphDatabaseSettings.SchemaIndex schemaIndex = this.getSchemaIndex();
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private RandomRule random;

    protected abstract int getSingleKeySizeLimit();

    protected abstract String getString(RandomRule var1, int var2);

    protected abstract GraphDatabaseSettings.SchemaIndex getSchemaIndex();

    protected abstract String expectedPopulationFailureCauseMessage(long var1);

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        Monitors monitors = new Monitors();
        IndexingService.MonitorAdapter trappingMonitor = new IndexingService.MonitorAdapter(){

            public void indexPopulationScanComplete() {
                if (StringLengthIndexValidationIT.this.trapPopulation.get()) {
                    StringLengthIndexValidationIT.this.populationScanFinished.reached();
                }
            }
        };
        monitors.addMonitorListener((Object)trappingMonitor, new String[0]);
        builder.setMonitors(monitors);
        builder.setConfig(GraphDatabaseSettings.default_schema_provider, (Object)this.schemaIndex.providerName());
    }

    @Test
    void shouldSuccessfullyWriteAndReadWithinIndexKeySizeLimit() {
        this.createIndex(propKey);
        String propValue = this.getString(this.random, this.singleKeySizeLimit);
        long expectedNodeId = this.createNode(propValue);
        this.assertReadNode(propValue, expectedNodeId);
    }

    @Test
    void shouldSuccessfullyPopulateIndexWithinIndexKeySizeLimit() {
        String propValue = this.getString(this.random, this.singleKeySizeLimit);
        long expectedNodeId = this.createNode(propValue);
        this.createIndex(propKey);
        this.assertReadNode(propValue, expectedNodeId);
    }

    @Test
    void txMustFailIfExceedingIndexKeySizeLimit() {
        this.createIndex(propKey);
        try (Transaction tx = this.db.beginTx();){
            String propValue = this.getString(this.random, this.singleKeySizeLimit + 1);
            tx.createNode(new Label[]{TestLabels.LABEL_ONE}).setProperty(propKey, (Object)propValue);
            tx.commit();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{String.format("Property value is too large to index, please see index documentation for limitations. Index: Index( id=1, name='index_71616483', type='GENERAL BTREE', schema=(:LABEL_ONE {largeString}), indexProvider='%s' ), entity id: 0", this.schemaIndex.providerName())});
        }
    }

    @Test
    void indexPopulationMustFailIfExceedingIndexKeySizeLimit() {
        String propValue = this.getString(this.random, this.singleKeySizeLimit + 1);
        long nodeId = this.createNode(propValue);
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(TestLabels.LABEL_ONE).on(propKey).create();
            tx.commit();
        }
        this.assertIndexFailToComeOnline(nodeId);
        this.assertIndexInFailedState(nodeId);
    }

    @Test
    public void externalUpdatesMustNotFailIndexPopulationIfWithinIndexKeySizeLimit() throws InterruptedException {
        this.trapPopulation.set(true);
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(TestLabels.LABEL_ONE).on(propKey).create();
            tx.commit();
        }
        this.populationScanFinished.await();
        String propValue = this.getString(this.random, this.singleKeySizeLimit);
        long nodeId = this.createNode(propValue);
        this.populationScanFinished.release();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        this.assertReadNode(propValue, nodeId);
    }

    @Test
    public void externalUpdatesMustFailIndexPopulationIfExceedingIndexKeySizeLimit() throws InterruptedException {
        this.trapPopulation.set(true);
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(TestLabels.LABEL_ONE).on(propKey).create();
            tx.commit();
        }
        this.populationScanFinished.await();
        String propValue = this.getString(this.random, this.singleKeySizeLimit + 1);
        long nodeId = this.createNode(propValue);
        this.populationScanFinished.release();
        this.assertIndexFailToComeOnline(nodeId);
        this.assertIndexInFailedState(nodeId);
    }

    public void assertIndexFailToComeOnline(long entityId) {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        catch (IllegalStateException e) {
            GraphDatabaseSettings.SchemaIndex schemaIndex = this.getSchemaIndex();
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{String.format("Index IndexDefinition[label:LABEL_ONE on:largeString] (Index( id=1, name='index_71616483', type='GENERAL BTREE', schema=(:LABEL_ONE {largeString}), indexProvider='%s' )) entered a FAILED state.", schemaIndex.providerName()), this.expectedPopulationFailureCauseMessage(entityId)});
        }
    }

    public void assertIndexInFailedState(long entityId) {
        try (Transaction tx = this.db.beginTx();){
            Iterator iterator = tx.schema().getIndexes(TestLabels.LABEL_ONE).iterator();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
            IndexDefinition next = (IndexDefinition)iterator.next();
            org.junit.jupiter.api.Assertions.assertEquals((Object)Schema.IndexState.FAILED, (Object)tx.schema().getIndexState(next), (String)"state is FAILED");
            Assertions.assertThat((String)tx.schema().getIndexFailure(next)).contains(new CharSequence[]{this.expectedPopulationFailureCauseMessage(entityId)});
            tx.commit();
        }
    }

    @Test
    void shouldHandleSizesCloseToTheLimit() {
        Node node;
        this.createIndex(propKey);
        HashMap<String, Long> strings = new HashMap<String, Long>();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                String string;
                while (strings.containsKey(string = this.getString(this.random, this.random.nextInt(this.singleKeySizeLimit / 2, this.singleKeySizeLimit)))) {
                }
                node = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
                node.setProperty(propKey, (Object)string);
                strings.put(string, node.getId());
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            for (String string : strings.keySet()) {
                node = tx.findNode(TestLabels.LABEL_ONE, propKey, (Object)string);
                org.junit.jupiter.api.Assertions.assertEquals((long)((Long)strings.get(string)), (long)node.getId());
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void createIndex(String ... keys) {
        try (Transaction tx = this.db.beginTx();){
            IndexCreator indexCreator = tx.schema().indexFor(TestLabels.LABEL_ONE);
            for (String key : keys) {
                indexCreator = indexCreator.on(key);
            }
            indexCreator.create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private long createNode(String propValue) {
        long expectedNodeId;
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
            node.setProperty(propKey, (Object)propValue);
            expectedNodeId = node.getId();
            tx.commit();
        }
        return expectedNodeId;
    }

    private void assertReadNode(String propValue, long expectedNodeId) {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.findNode(TestLabels.LABEL_ONE, propKey, (Object)propValue);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)node);
            org.junit.jupiter.api.Assertions.assertEquals((long)expectedNodeId, (long)node.getId(), (String)"node id");
            tx.commit();
        }
    }
}

