/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.api.impl.schema.DatabaseFunctions;
import org.neo4j.test.rule.DbmsRule;
import org.neo4j.test.rule.ImpermanentDbmsRule;

@RunWith(value=Parameterized.class)
public class UniqueIndexApplicationIT {
    @Rule
    public final DbmsRule db = new ImpermanentDbmsRule();
    private final Function<Transaction, ?> createIndex;

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> indexTypes() {
        return Arrays.asList(UniqueIndexApplicationIT.createIndex(DatabaseFunctions.index(Label.label((String)"Label1"), "key1")), UniqueIndexApplicationIT.createIndex(DatabaseFunctions.uniquenessConstraint(Label.label((String)"Label1"), "key1")));
    }

    @After
    public void then() {
        try (Transaction transaction = this.db.beginTx();){
            ((ListAssert)Assertions.assertThat(this.listNodeIdsFromIndexLookup(transaction, Label.label((String)"Label1"), "key1", "value1").apply((GraphDatabaseService)this.db)).as("Matching nodes from index lookup", new Object[0])).hasSize(1);
        }
    }

    @Before
    public void given() {
        this.db.executeAndCommit(this.createIndex::apply);
        this.db.executeAndCommit(transaction -> {
            DatabaseFunctions.awaitIndexesOnline(5L, TimeUnit.SECONDS).apply((Transaction)transaction);
            return null;
        });
    }

    @Test
    public void tx_createNode_addLabel_setProperty() {
        try (Transaction transaction = this.db.beginTx();){
            Node node = transaction.createNode();
            node.addLabel(Label.label((String)"Label1"));
            node.setProperty("key1", (Object)"value1");
            transaction.commit();
        }
    }

    @Test
    public void tx_createNode_tx_addLabel_setProperty() {
        try (Transaction transaction = this.db.beginTx();){
            Node node = transaction.createNode();
            node.addLabel(Label.label((String)"Label1"));
            node.setProperty("key1", (Object)"value1");
            transaction.commit();
        }
    }

    @Test
    public void tx_createNode_addLabel_tx_setProperty() {
        Node node;
        try (Transaction transaction = this.db.beginTx();){
            node = transaction.createNode();
            node.addLabel(Label.label((String)"Label1"));
            transaction.commit();
        }
        transaction = this.db.beginTx();
        try {
            transaction.getNodeById(node.getId()).setProperty("key1", (Object)"value1");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    public void tx_createNode_setProperty_tx_addLabel() {
        Node node;
        try (Transaction transaction = this.db.beginTx();){
            node = transaction.createNode();
            node.addLabel(Label.label((String)"Label1"));
            node.setProperty("key1", (Object)"value1");
            transaction.commit();
        }
        transaction = this.db.beginTx();
        try {
            transaction.getNodeById(node.getId()).addLabel(Label.label((String)"Label1"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    public void tx_createNode_tx_addLabel_tx_setProperty() {
        Node node;
        try (Transaction transaction = this.db.beginTx();){
            node = transaction.createNode();
            transaction.commit();
        }
        transaction = this.db.beginTx();
        try {
            transaction.getNodeById(node.getId()).addLabel(Label.label((String)"Label1"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.db.beginTx();
        try {
            transaction.getNodeById(node.getId()).setProperty("key1", (Object)"value1");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    public void tx_createNode_tx_setProperty_tx_addLabel() {
        try (Transaction transaction = this.db.beginTx();){
            Node node = transaction.createNode();
            node.setProperty("key1", (Object)"value1");
            node.addLabel(Label.label((String)"Label1"));
            transaction.commit();
        }
    }

    private Function<GraphDatabaseService, List<Long>> listNodeIdsFromIndexLookup(Transaction tx, Label label, String propertyKey, Object value) {
        return graphDb -> {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Node node : Iterators.loop((Iterator)tx.findNodes(label, propertyKey, value))) {
                ids.add(node.getId());
            }
            return ids;
        };
    }

    public UniqueIndexApplicationIT(Function<Transaction, ?> createIndex) {
        this.createIndex = createIndex;
    }

    private static Object[] createIndex(Function<Transaction, Void> createIndex) {
        return new Object[]{createIndex};
    }
}

