/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class NodeScanIT {
    @Inject
    private Kernel kernel;

    NodeScanIT() {
    }

    @Test
    void trackPageCacheAccessOnNodeLabelScan() throws TransactionFailureException {
        Label testLabel = Label.label((String)"testLabel");
        try (KernelTransaction tx = this.kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, (LoginContext)AnonymousContext.read());){
            PageCursorTracer cursorTracer = tx.pageCursorTracer();
            Assertions.assertThat((long)cursorTracer.pins()).isZero();
            int labelId = tx.tokenRead().nodeLabel(testLabel.name());
            tx.dataRead().nodeLabelScan(labelId);
            Assertions.assertThat((long)cursorTracer.pins()).isNotZero();
        }
    }
}

