/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.batchinsert.BatchInserter;
import org.neo4j.batchinsert.BatchInserters;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.id.ReservedIdException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.EmbeddedDbmsRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class BatchInsertionIT {
    @Rule
    public final EmbeddedDbmsRule dbRule = new EmbeddedDbmsRule().startLazily();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();

    @Test
    public void shouldIndexNodesWithMultipleLabels() throws Exception {
        BatchInserter inserter = BatchInserters.inserter((DatabaseLayout)this.dbRule.databaseLayout(), (FileSystemAbstraction)this.fileSystemRule.get());
        inserter.createNode(MapUtil.map((Object[])new Object[]{"name", "Bob"}), new Label[]{Label.label((String)"User"), Label.label((String)"Admin")});
        inserter.createDeferredSchemaIndex(Label.label((String)"User")).on("name").create();
        inserter.createDeferredSchemaIndex(Label.label((String)"Admin")).on("name").create();
        inserter.shutdown();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            Assertions.assertThat((long)Iterators.count((Iterator)tx.findNodes(Label.label((String)"User"), "name", (Object)"Bob"))).isEqualTo(1L);
            Assertions.assertThat((long)Iterators.count((Iterator)tx.findNodes(Label.label((String)"Admin"), "name", (Object)"Bob"))).isEqualTo(1L);
        }
    }

    @Test
    public void shouldNotIndexNodesWithWrongLabel() throws Exception {
        BatchInserter inserter = BatchInserters.inserter((DatabaseLayout)this.dbRule.databaseLayout(), (FileSystemAbstraction)this.fileSystemRule.get());
        inserter.createNode(MapUtil.map((Object[])new Object[]{"name", "Bob"}), new Label[]{Label.label((String)"User"), Label.label((String)"Admin")});
        inserter.createDeferredSchemaIndex(Label.label((String)"Banana")).on("name").create();
        inserter.shutdown();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            Assertions.assertThat((long)Iterators.count((Iterator)tx.findNodes(Label.label((String)"Banana"), "name", (Object)"Bob"))).isEqualTo(0L);
        }
    }

    @Test
    public void shouldBeAbleToMakeRepeatedCallsToSetNodeProperty() throws Exception {
        BatchInserter inserter = BatchInserters.inserter((DatabaseLayout)this.dbRule.databaseLayout(), (FileSystemAbstraction)this.fileSystemRule.get());
        long nodeId = inserter.createNode(Collections.emptyMap(), new Label[0]);
        Integer finalValue = 87;
        inserter.setNodeProperty(nodeId, "a", (Object)"some property value");
        inserter.setNodeProperty(nodeId, "a", (Object)42);
        inserter.setNodeProperty(nodeId, "a", (Object)3.14);
        inserter.setNodeProperty(nodeId, "a", (Object)true);
        inserter.setNodeProperty(nodeId, "a", (Object)finalValue);
        inserter.shutdown();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            Assertions.assertThat((Object)tx.getNodeById(nodeId).getProperty("a")).isEqualTo((Object)finalValue);
        }
    }

    @Test
    public void shouldBeAbleToMakeRepeatedCallsToSetNodePropertyWithMultiplePropertiesPerBlock() throws Exception {
        BatchInserter inserter = BatchInserters.inserter((DatabaseLayout)this.dbRule.databaseLayout(), (FileSystemAbstraction)this.fileSystemRule.get());
        long nodeId = inserter.createNode(Collections.emptyMap(), new Label[0]);
        Integer finalValue1 = 87;
        Double finalValue2 = 3.14;
        inserter.setNodeProperty(nodeId, "a", (Object)"some property value");
        inserter.setNodeProperty(nodeId, "a", (Object)42);
        inserter.setNodeProperty(nodeId, "b", (Object)finalValue2);
        inserter.setNodeProperty(nodeId, "a", (Object)finalValue2);
        inserter.setNodeProperty(nodeId, "a", (Object)true);
        inserter.setNodeProperty(nodeId, "a", (Object)finalValue1);
        inserter.shutdown();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            Assertions.assertThat((Object)tx.getNodeById(nodeId).getProperty("a")).isEqualTo((Object)finalValue1);
            Assertions.assertThat((Object)tx.getNodeById(nodeId).getProperty("b")).isEqualTo((Object)finalValue2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ReservedIdException.class)
    public void makeSureCantCreateNodeWithMagicNumber() throws IOException {
        BatchInserter inserter = BatchInserters.inserter((DatabaseLayout)this.dbRule.databaseLayout(), (FileSystemAbstraction)this.fileSystemRule.get());
        try {
            long id = 0xFFFFFFFFL;
            inserter.createNode(id, null, new Label[0]);
        }
        finally {
            inserter.shutdown();
        }
    }
}

