/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;

public abstract class AbstractIndexQueryingTest<S extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<S> {
    public void createTestGraph(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            tx.execute("call db.index.fulltext.createNodeIndex('ftsNodes', ['Label'], ['prop'])").close();
            tx.execute("call db.index.fulltext.createRelationshipIndex('ftsRels', ['Type'], ['prop'])").close();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void nodeIndexSeekMustThrowOnWrongIndexEntityType() throws Exception {
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName("ftsRels"));
        try (NodeValueIndexCursor cursor = this.cursors.allocateNodeValueIndexCursor(PageCursorTracer.NULL);){
            Assertions.assertThrows(IndexNotApplicableKernelException.class, () -> this.read.nodeIndexSeek(index, cursor, IndexQueryConstraints.unconstrained(), new IndexQuery[]{IndexQuery.fulltextSearch((String)"search")}));
        }
    }

    @Test
    void relationshipIndexSeekMustThrowOnWrongIndexEntityType() {
        IndexDescriptor index = this.schemaRead.indexGetForName("ftsNodes");
        try (RelationshipIndexCursor cursor = this.cursors.allocateRelationshipIndexCursor(PageCursorTracer.NULL);){
            Assertions.assertThrows(IndexNotApplicableKernelException.class, () -> this.read.relationshipIndexSeek(index, cursor, IndexQueryConstraints.unconstrained(), new IndexQuery[]{IndexQuery.fulltextSearch((String)"search")}));
        }
    }
}

