/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import org.apache.lucene.queryparser.flexible.standard.QueryParserUtil;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.Assert;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProceduresUtil;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Level;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsController;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

@DbmsExtension(configurationCallback="configure")
class FulltextProceduresTestSupport {
    static final String SCORE = "score";
    static final String NODE = "node";
    static final String RELATIONSHIP = "relationship";
    static final String DESCARTES_MEDITATIONES = "/meditationes--rene-descartes--public-domain.txt";
    static final Label LABEL = Label.label((String)"Label");
    static final RelationshipType REL = RelationshipType.withName((String)"REL");
    static final String PROP = "prop";
    static final String EVENTUALLY_CONSISTENT = ", {eventually_consistent: 'true'}";
    static final String EVENTUALLY_CONSISTENT_PREFIXED = ", {`fulltext.eventually_consistent`: 'true'}";
    @Inject
    GraphDatabaseAPI db;
    @Inject
    DbmsController controller;

    FulltextProceduresTestSupport() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.store_internal_log_level, (Object)Level.DEBUG);
    }

    void assertNoIndexSeeks(Result result) {
        Assertions.assertThat((long)result.stream().count()).isEqualTo(1L);
        String planDescription = result.getExecutionPlanDescription().toString();
        Assertions.assertThat((String)planDescription).contains(new CharSequence[]{"NodeByLabel"});
        Assertions.assertThat((String)planDescription).doesNotContain(new CharSequence[]{"IndexSeek"});
    }

    void restartDatabase() {
        this.controller.restartDbms();
    }

    void awaitIndexesOnline() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
    }

    static void assertQueryFindsIds(GraphDatabaseService db, boolean queryNodes, String index, String query, long ... ids) {
        try (Transaction tx = db.beginTx();){
            String queryCall = queryNodes ? "CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")" : "CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")";
            Result result = tx.execute(String.format(queryCall, index, query));
            int num = 0;
            Double score = Double.MAX_VALUE;
            while (result.hasNext()) {
                Map entry = result.next();
                Long nextId = ((Entity)entry.get(queryNodes ? NODE : RELATIONSHIP)).getId();
                Double nextScore = (Double)entry.get(SCORE);
                Assertions.assertThat((Double)nextScore).isLessThanOrEqualTo(score);
                score = nextScore;
                if (num < ids.length) {
                    Assert.assertEquals((String)String.format("Result returned id %d, expected %d", nextId, ids[num]), (long)ids[num], (long)nextId);
                } else {
                    Assert.fail((String)String.format("Result returned id %d, which is beyond the number of ids (%d) that were expected.", nextId, ids.length));
                }
                ++num;
            }
            Assert.assertEquals((String)"Number of results differ from expected", (long)ids.length, (long)num);
            tx.commit();
        }
    }

    static void assertQueryFindsIds(GraphDatabaseService db, boolean queryNodes, String index, String query, LongHashSet ids) {
        ids = new LongHashSet(ids);
        String queryCall = queryNodes ? "CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")" : "CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")";
        long[] expectedIds = ids.toArray();
        LongHashSet actualIds = new LongHashSet();
        try (Transaction tx = db.beginTx();){
            LongFunction<Entity> getEntity = queryNodes ? arg_0 -> ((Transaction)tx).getNodeById(arg_0) : arg_0 -> ((Transaction)tx).getRelationshipById(arg_0);
            Result result = tx.execute(String.format(queryCall, index, query));
            Double score = Double.MAX_VALUE;
            while (result.hasNext()) {
                Map entry = result.next();
                long nextId = ((Entity)entry.get(queryNodes ? NODE : RELATIONSHIP)).getId();
                Double nextScore = (Double)entry.get(SCORE);
                Assertions.assertThat((Double)nextScore).isLessThanOrEqualTo(score);
                score = nextScore;
                actualIds.add(nextId);
                if (ids.remove(nextId)) continue;
                String msg = "This id was not expected: " + nextId;
                FulltextProceduresTestSupport.failQuery(getEntity, index, query, (MutableLongSet)ids, expectedIds, (MutableLongSet)actualIds, msg);
            }
            if (!ids.isEmpty()) {
                String msg = "Not all expected ids were found: " + ids;
                FulltextProceduresTestSupport.failQuery(getEntity, index, query, (MutableLongSet)ids, expectedIds, (MutableLongSet)actualIds, msg);
            }
            tx.commit();
        }
    }

    static void failQuery(LongFunction<Entity> getEntity, String index, String query, MutableLongSet ids, long[] expectedIds, MutableLongSet actualIds, String msg) {
        Entity entity;
        long id;
        StringBuilder message = new StringBuilder(msg).append('\n');
        MutableLongIterator itr = ids.longIterator();
        while (itr.hasNext()) {
            id = itr.next();
            entity = getEntity.apply(id);
            message.append('\t').append(entity).append(entity.getAllProperties()).append('\n');
        }
        message.append("for query: '").append(query).append("'\nin index: ").append(index).append('\n');
        message.append("all expected ids: ").append(Arrays.toString(expectedIds)).append('\n');
        message.append("actual ids: ").append(actualIds);
        itr = actualIds.longIterator();
        while (itr.hasNext()) {
            id = itr.next();
            entity = getEntity.apply(id);
            message.append("\n\t").append(entity).append(entity.getAllProperties());
        }
        Assert.fail((String)message.toString());
    }

    List<Value> generateRandomNonStringValues() {
        Predicate<Value> nonString = v -> v.valueGroup() != ValueGroup.TEXT;
        return this.generateRandomValues(nonString);
    }

    List<Value> generateRandomSimpleValues() {
        EnumSet<ValueGroup> simpleTypes = EnumSet.of(ValueGroup.BOOLEAN, ValueGroup.BOOLEAN_ARRAY, ValueGroup.NUMBER, ValueGroup.NUMBER_ARRAY);
        return this.generateRandomValues(v -> simpleTypes.contains(v.valueGroup()));
    }

    List<Value> generateRandomValues(Predicate<Value> predicate) {
        int valuesToGenerate = 1000;
        RandomValues generator = RandomValues.create();
        ArrayList<Value> values = new ArrayList<Value>(valuesToGenerate);
        for (int i = 0; i < valuesToGenerate; ++i) {
            Value value;
            while (!predicate.test(value = generator.nextValue())) {
            }
            values.add(value);
        }
        return values;
    }

    String quoteValueForQuery(Value value) {
        return QueryParserUtil.escape((String)value.prettyPrint()).replace("\\", "\\\\").replace("\"", "\\\"");
    }

    void createSimpleRelationshipIndex(Transaction tx) {
        tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextIndexProceduresUtil.asStrList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{PROP}))).close();
    }

    void createSimpleNodesIndex(Transaction tx) {
        tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{PROP}))).close();
    }
}

