/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProvider;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.NativeLuceneFusionIndexProviderFactory30;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.DbmsRule;
import org.neo4j.test.rule.EmbeddedDbmsRule;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

public class FusionIndexIT {
    @Rule
    public DbmsRule db = new EmbeddedDbmsRule().withSetting(GraphDatabaseSettings.default_schema_provider, (Object)GraphDatabaseSettings.SchemaIndex.NATIVE30.providerName());
    private DatabaseLayout databaseLayout;
    private final Label label = Label.label((String)"label");
    private final String propKey = "propKey";
    private FileSystemAbstraction fs;
    private int numberValue = 1;
    private String stringValue = "string";
    private PointValue spatialValue = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.5, 0.5});
    private DateValue temporalValue = DateValue.date((int)2018, (int)3, (int)19);

    @Before
    public void setup() {
        this.databaseLayout = this.db.databaseLayout();
        this.fs = (FileSystemAbstraction)this.db.getDependencyResolver().resolveDependency(FileSystemAbstraction.class);
    }

    @Test
    public void mustRebuildFusionIndexIfNativePartIsMissing() {
        this.initializeIndexWithDataAndShutdown();
        IndexProviderDescriptor descriptor = GenericNativeIndexProvider.DESCRIPTOR;
        this.deleteIndexFilesFor(descriptor);
        this.verifyContent();
    }

    @Test
    public void mustRebuildFusionIndexIfLucenePartIsMissing() {
        this.initializeIndexWithDataAndShutdown();
        IndexProviderDescriptor descriptor = LuceneIndexProvider.DESCRIPTOR;
        this.deleteIndexFilesFor(descriptor);
        this.verifyContent();
    }

    @Test
    public void mustRebuildFusionIndexIfCompletelyMissing() {
        this.initializeIndexWithDataAndShutdown();
        IndexProviderDescriptor luceneDescriptor = LuceneIndexProvider.DESCRIPTOR;
        IndexProviderDescriptor nativeDescriptor = GenericNativeIndexProvider.DESCRIPTOR;
        this.deleteIndexFilesFor(luceneDescriptor);
        this.deleteIndexFilesFor(nativeDescriptor);
        this.verifyContent();
    }

    private void verifyContent() {
        GraphDatabaseAPI newDb = this.db.getGraphDatabaseAPI();
        try (Transaction tx = newDb.beginTx();){
            Assert.assertEquals((long)1L, (long)Iterators.stream(tx.schema().getIndexes(this.label).iterator()).count());
            Assert.assertNotNull((Object)tx.findNode(this.label, "propKey", (Object)this.numberValue));
            Assert.assertNotNull((Object)tx.findNode(this.label, "propKey", (Object)this.stringValue));
            Assert.assertNotNull((Object)tx.findNode(this.label, "propKey", (Object)this.spatialValue));
            Assert.assertNotNull((Object)tx.findNode(this.label, "propKey", (Object)this.temporalValue));
            tx.commit();
        }
    }

    private void deleteIndexFilesFor(IndexProviderDescriptor descriptor) {
        File[] files;
        File databaseDirectory = this.databaseLayout.databaseDirectory();
        File rootDirectory = NativeLuceneFusionIndexProviderFactory30.subProviderDirectoryStructure((File)databaseDirectory).forProvider(descriptor).rootDirectory();
        for (File indexFile : files = this.fs.listFiles(rootDirectory)) {
            this.fs.deleteFile(indexFile);
        }
    }

    private void initializeIndexWithDataAndShutdown() {
        this.createIndex();
        try (Transaction tx = this.db.beginTx();){
            tx.createNode(new Label[]{this.label}).setProperty("propKey", (Object)this.numberValue);
            tx.createNode(new Label[]{this.label}).setProperty("propKey", (Object)this.stringValue);
            tx.createNode(new Label[]{this.label}).setProperty("propKey", (Object)this.spatialValue);
            tx.createNode(new Label[]{this.label}).setProperty("propKey", (Object)this.temporalValue);
            tx.commit();
        }
        this.db.shutdown();
    }

    private void createIndex() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(this.label).on("propKey").create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

