/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.schema;

import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.SchemaCache;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingServiceFactory;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.transaction.state.storeview.DynamicIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityIdIterator;
import org.neo4j.kernel.impl.transaction.state.storeview.LabelViewNodeStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.lock.LockService;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.test.rule.EmbeddedDbmsRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class MultiIndexPopulationConcurrentUpdatesIT {
    private static final String NAME_PROPERTY = "name";
    private static final String COUNTRY_LABEL = "country";
    private static final String COLOR_LABEL = "color";
    private static final String CAR_LABEL = "car";
    @Rule
    public EmbeddedDbmsRule embeddedDatabase = new EmbeddedDbmsRule();
    private IndexDescriptor[] rules;
    private StorageEngine storageEngine;
    private SchemaCache schemaCache;
    @Parameterized.Parameter
    public GraphDatabaseSettings.SchemaIndex schemaIndex;
    private IndexingService indexService;
    private int propertyId;
    private Map<String, Integer> labelsNameIdMap;
    private Map<Integer, String> labelsIdNameMap;
    private Node country1;
    private Node country2;
    private Node color1;
    private Node color2;
    private Node car1;
    private Node car2;
    private Node[] otherNodes;

    @Parameterized.Parameters(name="{0}")
    public static GraphDatabaseSettings.SchemaIndex[] parameters() {
        return GraphDatabaseSettings.SchemaIndex.values();
    }

    @After
    public void tearDown() throws Throwable {
        if (this.indexService != null) {
            this.indexService.shutdown();
        }
    }

    @Before
    public void setUp() {
        this.prepareDb();
        this.labelsNameIdMap = this.getLabelsNameIdMap();
        this.labelsIdNameMap = this.labelsNameIdMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.propertyId = this.getPropertyId();
        this.storageEngine = (StorageEngine)this.embeddedDatabase.getDependencyResolver().resolveDependency(StorageEngine.class);
    }

    @Test
    public void applyConcurrentDeletesToPopulatedIndex() throws Throwable {
        ArrayList<EntityUpdates> updates = new ArrayList<EntityUpdates>(2);
        updates.add(EntityUpdates.forEntity((long)this.country1.getId(), (boolean)false).withTokens(this.id(COUNTRY_LABEL)).removed(this.propertyId, Values.of((Object)"Sweden")).build());
        updates.add(EntityUpdates.forEntity((long)this.color2.getId(), (boolean)false).withTokens(this.id(COLOR_LABEL)).removed(this.propertyId, Values.of((Object)"green")).build());
        this.launchCustomIndexPopulation(this.labelsNameIdMap, this.propertyId, new UpdateGenerator(updates));
        this.waitAndActivateIndexes(this.labelsNameIdMap, this.propertyId);
        try (Transaction tx = this.embeddedDatabase.beginTx();){
            Integer countryLabelId = this.labelsNameIdMap.get(COUNTRY_LABEL);
            Integer colorLabelId = this.labelsNameIdMap.get(COLOR_LABEL);
            try (IndexReader indexReader = this.getIndexReader(this.propertyId, countryLabelId);){
                Assert.assertEquals((String)"Should be removed by concurrent remove.", (long)0L, (long)indexReader.countIndexedNodes(0L, PageCursorTracer.NULL, new int[]{this.propertyId}, new Value[]{Values.of((Object)"Sweden")}));
            }
            indexReader = this.getIndexReader(this.propertyId, colorLabelId);
            try {
                Assert.assertEquals((String)"Should be removed by concurrent remove.", (long)0L, (long)indexReader.countIndexedNodes(3L, PageCursorTracer.NULL, new int[]{this.propertyId}, new Value[]{Values.of((Object)"green")}));
            }
            finally {
                if (indexReader != null) {
                    indexReader.close();
                }
            }
        }
    }

    @Test
    public void applyConcurrentAddsToPopulatedIndex() throws Throwable {
        ArrayList<EntityUpdates> updates = new ArrayList<EntityUpdates>(2);
        updates.add(EntityUpdates.forEntity((long)this.otherNodes[0].getId(), (boolean)false).withTokens(this.id(COUNTRY_LABEL)).added(this.propertyId, Values.of((Object)"Denmark")).build());
        updates.add(EntityUpdates.forEntity((long)this.otherNodes[1].getId(), (boolean)false).withTokens(this.id(CAR_LABEL)).added(this.propertyId, Values.of((Object)"BMW")).build());
        this.launchCustomIndexPopulation(this.labelsNameIdMap, this.propertyId, new UpdateGenerator(updates));
        this.waitAndActivateIndexes(this.labelsNameIdMap, this.propertyId);
        try (Transaction tx = this.embeddedDatabase.beginTx();){
            Integer countryLabelId = this.labelsNameIdMap.get(COUNTRY_LABEL);
            Integer carLabelId = this.labelsNameIdMap.get(CAR_LABEL);
            try (IndexReader indexReader = this.getIndexReader(this.propertyId, countryLabelId);){
                Assert.assertEquals((String)"Should be added by concurrent add.", (long)1L, (long)indexReader.countIndexedNodes(this.otherNodes[0].getId(), PageCursorTracer.NULL, new int[]{this.propertyId}, new Value[]{Values.of((Object)"Denmark")}));
            }
            indexReader = this.getIndexReader(this.propertyId, carLabelId);
            try {
                Assert.assertEquals((String)"Should be added by concurrent add.", (long)1L, (long)indexReader.countIndexedNodes(this.otherNodes[1].getId(), PageCursorTracer.NULL, new int[]{this.propertyId}, new Value[]{Values.of((Object)"BMW")}));
            }
            finally {
                if (indexReader != null) {
                    indexReader.close();
                }
            }
        }
    }

    @Test
    public void applyConcurrentChangesToPopulatedIndex() throws Throwable {
        ArrayList<EntityUpdates> updates = new ArrayList<EntityUpdates>(2);
        updates.add(EntityUpdates.forEntity((long)this.color2.getId(), (boolean)false).withTokens(this.id(COLOR_LABEL)).changed(this.propertyId, Values.of((Object)"green"), Values.of((Object)"pink")).build());
        updates.add(EntityUpdates.forEntity((long)this.car2.getId(), (boolean)false).withTokens(this.id(CAR_LABEL)).changed(this.propertyId, Values.of((Object)"Ford"), Values.of((Object)"SAAB")).build());
        this.launchCustomIndexPopulation(this.labelsNameIdMap, this.propertyId, new UpdateGenerator(updates));
        this.waitAndActivateIndexes(this.labelsNameIdMap, this.propertyId);
        try (Transaction tx = this.embeddedDatabase.beginTx();){
            Integer colorLabelId = this.labelsNameIdMap.get(COLOR_LABEL);
            Integer carLabelId = this.labelsNameIdMap.get(CAR_LABEL);
            try (IndexReader indexReader = this.getIndexReader(this.propertyId, colorLabelId);){
                Assert.assertEquals((String)String.format("Should be deleted by concurrent change. Reader is: %s, ", indexReader), (long)0L, (long)indexReader.countIndexedNodes(this.color2.getId(), PageCursorTracer.NULL, new int[]{this.propertyId}, new Value[]{Values.of((Object)"green")}));
            }
            indexReader = this.getIndexReader(this.propertyId, colorLabelId);
            try {
                Assert.assertEquals((String)"Should be updated by concurrent change.", (long)1L, (long)indexReader.countIndexedNodes(this.color2.getId(), PageCursorTracer.NULL, new int[]{this.propertyId}, new Value[]{Values.of((Object)"pink")}));
            }
            finally {
                if (indexReader != null) {
                    indexReader.close();
                }
            }
            indexReader = this.getIndexReader(this.propertyId, carLabelId);
            try {
                Assert.assertEquals((String)"Should be added by concurrent change.", (long)1L, (long)indexReader.countIndexedNodes(this.car2.getId(), PageCursorTracer.NULL, new int[]{this.propertyId}, new Value[]{Values.of((Object)"SAAB")}));
            }
            finally {
                if (indexReader != null) {
                    indexReader.close();
                }
            }
        }
    }

    @Test
    public void dropOneOfTheIndexesWhilePopulationIsOngoingDoesInfluenceOtherPopulators() throws Throwable {
        this.launchCustomIndexPopulation(this.labelsNameIdMap, this.propertyId, new IndexDropAction(this.labelsNameIdMap.get(COLOR_LABEL)));
        this.labelsNameIdMap.remove(COLOR_LABEL);
        this.waitAndActivateIndexes(this.labelsNameIdMap, this.propertyId);
        this.checkIndexIsOnline(this.labelsNameIdMap.get(CAR_LABEL));
        this.checkIndexIsOnline(this.labelsNameIdMap.get(COUNTRY_LABEL));
    }

    @Test
    public void indexDroppedDuringPopulationDoesNotExist() throws Throwable {
        Integer labelToDropId = this.labelsNameIdMap.get(COLOR_LABEL);
        this.launchCustomIndexPopulation(this.labelsNameIdMap, this.propertyId, new IndexDropAction(labelToDropId));
        this.labelsNameIdMap.remove(COLOR_LABEL);
        this.waitAndActivateIndexes(this.labelsNameIdMap, this.propertyId);
        try {
            Iterator iterator = this.schemaCache.indexesForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)labelToDropId, (int[])new int[]{this.propertyId}));
            while (iterator.hasNext()) {
                IndexDescriptor index = (IndexDescriptor)iterator.next();
                this.indexService.getIndexProxy(index);
            }
            Assert.fail((String)"Index does not exist, we should fail to find it.");
        }
        catch (IndexNotFoundKernelException indexNotFoundKernelException) {
            // empty catch block
        }
    }

    private void checkIndexIsOnline(int labelId) throws IndexNotFoundKernelException {
        LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)labelId, (int[])new int[]{this.propertyId});
        IndexDescriptor index = (IndexDescriptor)Iterators.single((Iterator)this.schemaCache.indexesForSchema((SchemaDescriptor)schema));
        IndexProxy indexProxy = this.indexService.getIndexProxy(index);
        Assert.assertSame((Object)InternalIndexState.ONLINE, (Object)indexProxy.getState());
    }

    private long[] id(String label) {
        return new long[]{this.labelsNameIdMap.get(label).intValue()};
    }

    private IndexReader getIndexReader(int propertyId, Integer countryLabelId) throws IndexNotFoundKernelException {
        LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)countryLabelId, (int[])new int[]{propertyId});
        IndexDescriptor index = (IndexDescriptor)Iterators.single((Iterator)this.schemaCache.indexesForSchema((SchemaDescriptor)schema));
        return this.indexService.getIndexProxy(index).newReader();
    }

    private void launchCustomIndexPopulation(Map<String, Integer> labelNameIdMap, int propertyId, Runnable customAction) throws Throwable {
        RecordStorageEngine storageEngine = this.getStorageEngine();
        LabelScanStore labelScanStore = this.getLabelScanStore();
        RelationshipTypeScanStore relationshipTypeScanStore = this.getRelationshipTypeScanStore();
        try (Transaction transaction = this.embeddedDatabase.beginTx();){
            Config config = Config.defaults();
            KernelTransaction ktx = ((InternalTransaction)transaction).kernelTransaction();
            DynamicIndexStoreView storeView = this.dynamicIndexStoreViewWrapper(customAction, () -> ((RecordStorageEngine)storageEngine).newReader(), labelScanStore, relationshipTypeScanStore, config);
            IndexProviderMap providerMap = this.getIndexProviderMap();
            JobScheduler scheduler = this.getJobScheduler();
            NullLogProvider nullLogProvider = NullLogProvider.getInstance();
            this.indexService = IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)scheduler, (IndexProviderMap)providerMap, (IndexStoreView)storeView, (TokenNameLookup)ktx.tokenRead(), (Iterable)Database.initialSchemaRulesLoader((StorageEngine)storageEngine), (LogProvider)nullLogProvider, (LogProvider)nullLogProvider, (IndexingService.Monitor)IndexingService.NO_MONITOR, (SchemaState)this.getSchemaState(), (IndexStatisticsStore)((IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class)), (PageCacheTracer)PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (boolean)false);
            this.indexService.start();
            this.rules = this.createIndexRules(labelNameIdMap, propertyId);
            this.schemaCache = new SchemaCache((ConstraintRuleAccessor)new StandardConstraintSemantics(), (IndexConfigCompleter)providerMap);
            this.schemaCache.load(Iterables.iterable((Object[])this.rules));
            this.indexService.createIndexes(this.rules);
            transaction.commit();
        }
    }

    private DynamicIndexStoreView dynamicIndexStoreViewWrapper(Runnable customAction, Supplier<StorageReader> readerSupplier, LabelScanStore labelScanStore, RelationshipTypeScanStore relationshipTypeScanStore, Config config) {
        LockService locks = LockService.NO_LOCK_SERVICE;
        NeoStoreIndexStoreView neoStoreIndexStoreView = new NeoStoreIndexStoreView(locks, readerSupplier);
        return new DynamicIndexStoreViewWrapper(neoStoreIndexStoreView, labelScanStore, relationshipTypeScanStore, locks, readerSupplier, customAction, config);
    }

    private void waitAndActivateIndexes(Map<String, Integer> labelsIds, int propertyId) throws IndexNotFoundKernelException, IndexPopulationFailedKernelException, InterruptedException, IndexActivationFailedKernelException {
        try (Transaction tx = this.embeddedDatabase.beginTx();){
            for (int labelId : labelsIds.values()) {
                this.waitIndexOnline(this.indexService, propertyId, labelId);
            }
        }
    }

    private int getPropertyId() {
        try (Transaction tx = this.embeddedDatabase.beginTx();){
            int n = this.getPropertyIdByName(tx, NAME_PROPERTY);
            return n;
        }
    }

    private Map<String, Integer> getLabelsNameIdMap() {
        try (Transaction tx = this.embeddedDatabase.beginTx();){
            Map<String, Integer> map = this.getLabelIdsByName(tx, COUNTRY_LABEL, COLOR_LABEL, CAR_LABEL);
            return map;
        }
    }

    private void waitIndexOnline(IndexingService indexService, int propertyId, int labelId) throws IndexNotFoundKernelException, IndexPopulationFailedKernelException, InterruptedException, IndexActivationFailedKernelException {
        LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)labelId, (int[])new int[]{propertyId});
        IndexDescriptor index = (IndexDescriptor)Iterators.single((Iterator)this.schemaCache.indexesForSchema((SchemaDescriptor)schema));
        IndexProxy indexProxy = indexService.getIndexProxy(index);
        indexProxy.awaitStoreScanCompleted(0L, TimeUnit.MILLISECONDS);
        while (indexProxy.getState() != InternalIndexState.ONLINE) {
            Thread.sleep(10L);
        }
        indexProxy.activate();
    }

    private IndexDescriptor[] createIndexRules(Map<String, Integer> labelNameIdMap, int propertyId) {
        IndexProviderMap indexProviderMap = this.getIndexProviderMap();
        IndexProvider indexProvider = indexProviderMap.lookup(this.schemaIndex.providerName());
        IndexProviderDescriptor providerDescriptor = indexProvider.getProviderDescriptor();
        ArrayList<IndexDescriptor> list = new ArrayList<IndexDescriptor>();
        for (Integer labelId : labelNameIdMap.values()) {
            LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)labelId, (int[])new int[]{propertyId});
            IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)providerDescriptor).withName("index_" + labelId).materialise((long)labelId.intValue());
            index = indexProvider.completeConfiguration(index);
            list.add(index);
        }
        return list.toArray(new IndexDescriptor[0]);
    }

    private Map<String, Integer> getLabelIdsByName(Transaction tx, String ... names) {
        HashMap<String, Integer> labelNameIdMap = new HashMap<String, Integer>();
        KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
        TokenRead tokenRead = ktx.tokenRead();
        for (String name : names) {
            labelNameIdMap.put(name, tokenRead.nodeLabel(name));
        }
        return labelNameIdMap;
    }

    private int getPropertyIdByName(Transaction tx, String name) {
        KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
        return ktx.tokenRead().propertyKey(name);
    }

    private void prepareDb() {
        Label countryLabel = Label.label((String)COUNTRY_LABEL);
        Label color = Label.label((String)COLOR_LABEL);
        Label car = Label.label((String)CAR_LABEL);
        try (Transaction transaction = this.embeddedDatabase.beginTx();){
            this.country1 = this.createNamedLabeledNode(transaction, countryLabel, "Sweden");
            this.country2 = this.createNamedLabeledNode(transaction, countryLabel, "USA");
            this.color1 = this.createNamedLabeledNode(transaction, color, "red");
            this.color2 = this.createNamedLabeledNode(transaction, color, "green");
            this.car1 = this.createNamedLabeledNode(transaction, car, "Volvo");
            this.car2 = this.createNamedLabeledNode(transaction, car, "Ford");
            this.otherNodes = new Node[250];
            for (int i = 0; i < 250; ++i) {
                this.otherNodes[i] = transaction.createNode();
            }
            transaction.commit();
        }
    }

    private Node createNamedLabeledNode(Transaction tx, Label label, String name) {
        Node node = tx.createNode(new Label[]{label});
        node.setProperty(NAME_PROPERTY, (Object)name);
        return node;
    }

    private LabelScanStore getLabelScanStore() {
        return (LabelScanStore)this.embeddedDatabase.resolveDependency(LabelScanStore.class);
    }

    private RelationshipTypeScanStore getRelationshipTypeScanStore() {
        return (RelationshipTypeScanStore)this.embeddedDatabase.resolveDependency(RelationshipTypeScanStore.class);
    }

    private RecordStorageEngine getStorageEngine() {
        return (RecordStorageEngine)this.embeddedDatabase.resolveDependency(RecordStorageEngine.class);
    }

    private SchemaState getSchemaState() {
        return (SchemaState)this.embeddedDatabase.resolveDependency(SchemaState.class);
    }

    private IndexProviderMap getIndexProviderMap() {
        return (IndexProviderMap)this.embeddedDatabase.resolveDependency(IndexProviderMap.class);
    }

    private JobScheduler getJobScheduler() {
        return (JobScheduler)this.embeddedDatabase.resolveDependency(JobScheduler.class);
    }

    private class IndexDropAction
    implements Runnable {
        private final int labelIdToDropIndexFor;

        private IndexDropAction(int labelIdToDropIndexFor) {
            this.labelIdToDropIndexFor = labelIdToDropIndexFor;
        }

        @Override
        public void run() {
            LabelSchemaDescriptor descriptor = SchemaDescriptor.forLabel((int)this.labelIdToDropIndexFor, (int[])new int[]{MultiIndexPopulationConcurrentUpdatesIT.this.propertyId});
            IndexDescriptor rule = this.findRuleForLabel(descriptor);
            MultiIndexPopulationConcurrentUpdatesIT.this.indexService.dropIndex(rule);
        }

        private IndexDescriptor findRuleForLabel(LabelSchemaDescriptor schemaDescriptor) {
            for (IndexDescriptor rule : MultiIndexPopulationConcurrentUpdatesIT.this.rules) {
                if (!rule.schema().equals(schemaDescriptor)) continue;
                return rule;
            }
            return null;
        }
    }

    private class UpdateGenerator
    implements Runnable {
        private final Iterable<EntityUpdates> updates;

        UpdateGenerator(Iterable<EntityUpdates> updates) {
            this.updates = updates;
        }

        @Override
        public void run() {
            for (EntityUpdates update : this.updates) {
                Transaction transaction = MultiIndexPopulationConcurrentUpdatesIT.this.embeddedDatabase.beginTx();
                try {
                    Node node = transaction.getNodeById(update.getEntityId());
                    for (int labelId : MultiIndexPopulationConcurrentUpdatesIT.this.labelsNameIdMap.values()) {
                        LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)labelId, (int[])new int[]{MultiIndexPopulationConcurrentUpdatesIT.this.propertyId});
                        block18: for (IndexEntryUpdate indexUpdate : update.forIndexKeys(Collections.singleton(schema))) {
                            switch (indexUpdate.updateMode()) {
                                case CHANGED: 
                                case ADDED: {
                                    node.addLabel(Label.label((String)MultiIndexPopulationConcurrentUpdatesIT.this.labelsIdNameMap.get(schema.getLabelId())));
                                    node.setProperty(MultiIndexPopulationConcurrentUpdatesIT.NAME_PROPERTY, indexUpdate.values()[0].asObject());
                                    continue block18;
                                }
                                case REMOVED: {
                                    node.addLabel(Label.label((String)MultiIndexPopulationConcurrentUpdatesIT.this.labelsIdNameMap.get(schema.getLabelId())));
                                    node.delete();
                                    continue block18;
                                }
                            }
                            throw new IllegalArgumentException(indexUpdate.updateMode().name());
                        }
                    }
                    transaction.commit();
                }
                finally {
                    if (transaction == null) continue;
                    transaction.close();
                }
            }
            try (StorageReader reader = MultiIndexPopulationConcurrentUpdatesIT.this.storageEngine.newReader();){
                for (EntityUpdates update : this.updates) {
                    Set relatedIndexes = MultiIndexPopulationConcurrentUpdatesIT.this.schemaCache.getIndexesRelatedTo(update.entityTokensChanged(), update.entityTokensUnchanged(), update.propertiesChanged(), false, EntityType.NODE);
                    Iterable entryUpdates = update.forIndexKeys((Iterable)relatedIndexes, reader, EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                    MultiIndexPopulationConcurrentUpdatesIT.this.indexService.applyUpdates(entryUpdates, PageCursorTracer.NULL);
                }
            }
            catch (UncheckedIOException | KernelException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class DelegatingEntityIdIterator
    implements EntityIdIterator {
        private final Runnable customAction;
        private final EntityIdIterator delegate;

        DelegatingEntityIdIterator(EntityIdIterator delegate, Runnable customAction) {
            this.delegate = delegate;
            this.customAction = customAction;
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public long next() {
            long value = this.delegate.next();
            if (!this.hasNext()) {
                this.customAction.run();
            }
            return value;
        }

        public void close() {
            this.delegate.close();
        }

        public void invalidateCache() {
            this.delegate.invalidateCache();
        }
    }

    private static class LabelViewNodeStoreWrapper<FAILURE extends Exception>
    extends LabelViewNodeStoreScan<FAILURE> {
        private final LabelViewNodeStoreScan<FAILURE> delegate;
        private final Runnable customAction;

        LabelViewNodeStoreWrapper(StorageReader storageReader, LockService locks, LabelScanStore labelScanStore, Visitor<EntityTokenUpdate, FAILURE> labelUpdateVisitor, Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor, int[] labelIds, IntPredicate propertyKeyIdFilter, LabelViewNodeStoreScan<FAILURE> delegate, Runnable customAction) {
            super(storageReader, locks, labelScanStore, labelUpdateVisitor, propertyUpdatesVisitor, labelIds, propertyKeyIdFilter, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.delegate = delegate;
            this.customAction = customAction;
        }

        public EntityIdIterator getEntityIdIterator() {
            EntityIdIterator originalIterator = this.delegate.getEntityIdIterator();
            return new DelegatingEntityIdIterator(originalIterator, this.customAction);
        }
    }

    private class DynamicIndexStoreViewWrapper
    extends DynamicIndexStoreView {
        private final Runnable customAction;

        DynamicIndexStoreViewWrapper(NeoStoreIndexStoreView neoStoreIndexStoreView, LabelScanStore labelScanStore, RelationshipTypeScanStore relationshipTypeScanStore, LockService locks, Supplier<StorageReader> storageEngine, Runnable customAction, Config config) {
            super(neoStoreIndexStoreView, labelScanStore, relationshipTypeScanStore, locks, storageEngine, (LogProvider)NullLogProvider.getInstance(), config);
            this.customAction = customAction;
        }

        public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor, Visitor<EntityTokenUpdate, FAILURE> labelUpdateVisitor, boolean forceStoreScan, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
            StoreScan storeScan = super.visitNodes(labelIds, propertyKeyIdFilter, propertyUpdatesVisitor, labelUpdateVisitor, forceStoreScan, cursorTracer, memoryTracker);
            return new LabelViewNodeStoreWrapper<FAILURE>((StorageReader)this.storageEngine.get(), this.locks, MultiIndexPopulationConcurrentUpdatesIT.this.getLabelScanStore(), element -> false, propertyUpdatesVisitor, labelIds, propertyKeyIdFilter, (LabelViewNodeStoreScan)storeScan, this.customAction);
        }
    }
}

