/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.scheduler.CentralJobScheduler;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.time.Clocks;

@PageCacheExtension
class NonUniqueIndexTest {
    private static final String LABEL = "SomeLabel";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String INDEX_NAME = "indexName";
    @Inject
    private TestDirectory testDirectory;
    private DatabaseManagementService managementService;

    NonUniqueIndexTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void concurrentIndexPopulationAndInsertsShouldNotProduceDuplicates() throws Exception {
        GraphDatabaseService db = this.newEmbeddedGraphDatabaseWithSlowJobScheduler();
        try {
            Node node;
            try (Transaction tx = db.beginTx();){
                tx.schema().indexFor(Label.label((String)LABEL)).on(KEY).withName(INDEX_NAME).create();
                tx.commit();
            }
            try (Transaction tx = db.beginTx();){
                node = tx.createNode(new Label[]{Label.label((String)LABEL)});
                node.setProperty(KEY, (Object)VALUE);
                tx.commit();
            }
            tx = db.beginTx();
            try {
                tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            tx = db.beginTx();
            try {
                KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
                IndexDescriptor index = ktx.schemaRead().indexGetForName(INDEX_NAME);
                IndexReadSession indexSession = ktx.dataRead().indexReadSession(index);
                try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor(ktx.pageCursorTracer(), ktx.memoryTracker());){
                    ktx.dataRead().nodeIndexSeek(indexSession, cursor, IndexQueryConstraints.unconstrained(), new IndexQuery[]{IndexQuery.exact((int)1, (Object)VALUE)});
                    Assertions.assertTrue((boolean)cursor.next());
                    Assertions.assertEquals((long)node.getId(), (long)cursor.nodeReference());
                    Assertions.assertFalse((boolean)cursor.next());
                }
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        finally {
            this.managementService.shutdown();
        }
    }

    private GraphDatabaseService newEmbeddedGraphDatabaseWithSlowJobScheduler() {
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies(new Object[]{NonUniqueIndexTest.createJobScheduler()});
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setExternalDependencies((DependencyResolver)dependencies).build();
        return this.managementService.database("neo4j");
    }

    private static CentralJobScheduler createJobScheduler() {
        CentralJobScheduler scheduler = NonUniqueIndexTest.newSlowJobScheduler();
        scheduler.init();
        return scheduler;
    }

    private static CentralJobScheduler newSlowJobScheduler() {
        return new CentralJobScheduler(Clocks.nanoClock()){

            public JobHandle<?> schedule(Group group, Runnable job) {
                return super.schedule(group, JobMonitoringParams.NOT_MONITORED, NonUniqueIndexTest.slowRunnable(job));
            }
        };
    }

    private static Runnable slowRunnable(Runnable target) {
        return () -> {
            LockSupport.parkNanos(100000000L);
            target.run();
        };
    }
}

