/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class IndexFreshDataReadIT {
    @Inject
    private GraphDatabaseService db;
    private ExecutorService executor = Executors.newCachedThreadPool();

    IndexFreshDataReadIT() {
    }

    @AfterEach
    void tearDown() {
        this.executor.shutdown();
    }

    @Test
    void readLatestIndexDataAfterUsingExhaustedNodeRelationshipIterator() throws Exception {
        try (Transaction transaction = this.db.beginTx();){
            this.addStaffMember("Fry");
            Assertions.assertEquals((int)1, (int)this.countStaff(transaction).intValue());
            Node fry = transaction.getNodeById(0L);
            Iterable fryRelationships = fry.getRelationships();
            Assertions.assertFalse((boolean)fryRelationships.iterator().hasNext());
            this.addStaffMember("Lila");
            Assertions.assertEquals((int)2, (int)this.countStaff(transaction).intValue());
            this.addStaffMember("Bender");
            Assertions.assertEquals((int)3, (int)this.countStaff(transaction).intValue());
        }
    }

    private void addStaffMember(String name) throws InterruptedException, ExecutionException {
        this.executor.submit(new CreateNamedNodeTask(name)).get();
    }

    private Number countStaff(Transaction tx) {
        try (Result countResult = tx.execute("MATCH (n:staff) return count(n.name) as count");){
            Number number = (Number)countResult.columnAs("count").next();
            return number;
        }
    }

    private class CreateNamedNodeTask
    implements Runnable {
        private final String name;

        CreateNamedNodeTask(String name) {
            this.name = name;
        }

        @Override
        public void run() {
            try (Transaction transaction = IndexFreshDataReadIT.this.db.beginTx();){
                transaction.execute("CREATE (n:staff {name:$name})", MapUtil.map((Object[])new Object[]{"name", this.name}));
                transaction.commit();
            }
        }
    }
}

