/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.schema;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongFunction;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.GeneratingInputIterator;
import org.neo4j.internal.batchimport.ImportLogic;
import org.neo4j.internal.batchimport.InputIterable;
import org.neo4j.internal.batchimport.ParallelBatchImporter;
import org.neo4j.internal.batchimport.RandomsStates;
import org.neo4j.internal.batchimport.input.BadCollector;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.input.PropertySizeCalculator;
import org.neo4j.internal.batchimport.input.ReadableGroups;
import org.neo4j.internal.batchimport.staging.ExecutionMonitors;
import org.neo4j.internal.helpers.TimeUtil;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;
import org.neo4j.util.FeatureToggles;
import org.neo4j.values.storable.RandomValues;

@ExtendWith(value={RandomExtension.class})
@TestDirectoryExtension
class MultipleIndexPopulationStressIT {
    private static final String[] TOKENS = new String[]{"One", "Two", "Three", "Four"};
    private ExecutorService executor;
    @Inject
    private RandomRule random;
    @Inject
    private TestDirectory directory;
    @Inject
    private DefaultFileSystemAbstraction fileSystemAbstraction;

    MultipleIndexPopulationStressIT() {
    }

    @AfterEach
    public void tearDown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Test
    public void populateMultipleIndexWithSeveralNodesMultiThreaded() throws Exception {
        this.prepareAndRunTest(10, TimeUnit.SECONDS.toMillis(5L));
    }

    @Test
    public void shouldPopulateMultipleIndexPopulatorsUnderStressMultiThreaded() throws Exception {
        int concurrentUpdatesQueueFlushThreshold = this.random.nextInt(100, 5000);
        FeatureToggles.set(MultipleIndexPopulator.class, (String)"queue_threshold", (Object)concurrentUpdatesQueueFlushThreshold);
        try {
            this.readConfigAndRunTest();
        }
        finally {
            FeatureToggles.clear(MultipleIndexPopulator.class, (String)"queue_threshold");
        }
    }

    private void readConfigAndRunTest() throws Exception {
        int nodeCount = (int)SettingValueParsers.parseLongWithUnit((String)System.getProperty(this.getClass().getName() + ".nodes", "200k"));
        long duration = (Long)TimeUtil.parseTimeMillis.apply(System.getProperty(this.getClass().getName() + ".duration", "5s"));
        this.prepareAndRunTest(nodeCount, duration);
    }

    private void prepareAndRunTest(int nodeCount, long durationMillis) throws Exception {
        this.createRandomData(nodeCount);
        long endTime = System.currentTimeMillis() + durationMillis;
        while (System.currentTimeMillis() < endTime) {
            this.runTest(nodeCount);
        }
    }

    private void runTest(int nodeCount) throws Exception {
        this.populateDbAndIndexes(nodeCount);
        ConsistencyCheckService cc = new ConsistencyCheckService();
        Config config = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.directory.homePath()).set(GraphDatabaseSettings.pagecache_memory, (Object)"8m").build();
        ConsistencyCheckService.Result result = cc.runFullConsistencyCheck(DatabaseLayout.of((Config)config), config, ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false);
        Assertions.assertTrue((boolean)result.isSuccessful());
        this.dropIndexes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDbAndIndexes(int nodeCount) throws InterruptedException {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.directory.homePath()).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try {
            this.createIndexes(db);
            AtomicBoolean end = new AtomicBoolean();
            this.executor = Executors.newCachedThreadPool();
            for (int i = 0; i < 10; ++i) {
                this.executor.submit(() -> {
                    RandomValues randomValues = RandomValues.create();
                    while (!end.get()) {
                        this.changeRandomNode(db, nodeCount, randomValues);
                    }
                });
            }
            while (!this.indexesAreOnline(db)) {
                Thread.sleep(100L);
            }
            end.set(true);
            this.executor.shutdown();
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
            this.executor = null;
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropIndexes() {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.directory.homePath()).setConfig(GraphDatabaseSettings.pagecache_memory, (Object)"8m").build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            for (IndexDefinition index : tx.schema().getIndexes()) {
                index.drop();
            }
            tx.commit();
        }
        finally {
            managementService.shutdown();
        }
    }

    private boolean indexesAreOnline(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            block11: for (IndexDefinition index : tx.schema().getIndexes()) {
                switch (tx.schema().getIndexState(index)) {
                    case ONLINE: {
                        continue block11;
                    }
                    case POPULATING: {
                        boolean bl = false;
                        return bl;
                    }
                    case FAILED: {
                        Assertions.fail((String)(index + " entered failed state: " + tx.schema().getIndexFailure(index)));
                    }
                }
                throw new UnsupportedOperationException();
            }
            tx.commit();
        }
        return true;
    }

    private void createIndexes(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            for (String label : (String[])this.random.selection((Object[])TOKENS, 3, 3, false)) {
                for (String propertyKey : (String[])this.random.selection((Object[])TOKENS, 3, 3, false)) {
                    tx.schema().indexFor(Label.label((String)label)).on(propertyKey).create();
                }
            }
            tx.commit();
        }
    }

    private void changeRandomNode(GraphDatabaseService db, int nodeCount, RandomValues random) {
        try (Transaction tx = db.beginTx();){
            long nodeId = random.nextInt(nodeCount);
            Node node = tx.getNodeById(nodeId);
            Object[] keys = Iterables.asCollection((Iterable)node.getPropertyKeys()).toArray();
            String key = (String)random.among(keys);
            if ((double)random.nextFloat() < 0.1) {
                node.removeProperty(key);
            } else {
                node.setProperty(key, random.nextValue().asObject());
            }
            tx.commit();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void createRandomData(int count) throws Exception {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.neo4j_home, (Object)this.directory.homePath());
        RecordFormats recordFormats = RecordFormatSelector.selectForConfig((Config)config, (LogProvider)NullLogProvider.getInstance());
        try (RandomDataInput input = new RandomDataInput(count);
             ThreadPoolJobScheduler jobScheduler = new ThreadPoolJobScheduler();){
            DatabaseLayout layout = Neo4jLayout.of((Path)this.directory.homePath()).databaseLayout("neo4j");
            ParallelBatchImporter importer = new ParallelBatchImporter(layout, (FileSystemAbstraction)this.fileSystemAbstraction, null, PageCacheTracer.NULL, Configuration.DEFAULT, (LogService)NullLogService.getInstance(), ExecutionMonitors.invisible(), AdditionalInitialIds.EMPTY, config, recordFormats, ImportLogic.NO_MONITOR, (JobScheduler)jobScheduler, Collector.EMPTY, TransactionLogInitializer.getLogFilesInitializer(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            importer.doImport((Input)input);
        }
    }

    private class RandomDataInput
    implements Input,
    AutoCloseable {
        private final int count;
        private final BadCollector badCollector;

        RandomDataInput(int count) {
            this.count = count;
            this.badCollector = this.createBadCollector();
        }

        public InputIterable relationships(Collector badCollector) {
            return GeneratingInputIterator.EMPTY_ITERABLE;
        }

        public InputIterable nodes(Collector badCollector) {
            return () -> new RandomNodeGenerator(this.count, (GeneratingInputIterator.Generator<RandomValues>)((GeneratingInputIterator.Generator)(state, visitor, id) -> {
                String[] keys;
                for (String key : keys = (String[])MultipleIndexPopulationStressIT.this.random.randomValues().selection((Object[])TOKENS, 1, TOKENS.length, false)) {
                    visitor.property(key, MultipleIndexPopulationStressIT.this.random.nextValueAsObject());
                }
                visitor.labels((String[])MultipleIndexPopulationStressIT.this.random.selection((Object[])TOKENS, 1, TOKENS.length, false));
            }));
        }

        public IdType idType() {
            return IdType.ACTUAL;
        }

        public ReadableGroups groups() {
            return ReadableGroups.EMPTY;
        }

        private BadCollector createBadCollector() {
            try {
                return new BadCollector(MultipleIndexPopulationStressIT.this.fileSystemAbstraction.openAsOutputStream(MultipleIndexPopulationStressIT.this.directory.homePath().resolve("bad"), false), 0L, 0);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Input.Estimates calculateEstimates(PropertySizeCalculator valueSizeCalculator) {
            return Input.knownEstimates((long)this.count, (long)0L, (long)(this.count * TOKENS.length / 2), (long)0L, (long)(this.count * TOKENS.length / 2 * 8), (long)0L, (long)0L);
        }

        @Override
        public void close() {
            this.badCollector.close();
        }
    }

    private class RandomNodeGenerator
    extends GeneratingInputIterator<RandomValues> {
        RandomNodeGenerator(int count, GeneratingInputIterator.Generator<RandomValues> randomsGenerator) {
            super((long)count, 1000, (LongFunction)new RandomsStates(MultipleIndexPopulationStressIT.this.random.seed()), randomsGenerator, 0L);
        }
    }
}

