/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.concurrencytest;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.rule.concurrent.ThreadingExtension;
import org.neo4j.test.rule.concurrent.ThreadingRule;
import org.neo4j.values.storable.Values;

@ImpermanentDbmsExtension
@ExtendWith(value={ThreadingExtension.class})
class ConstraintIndexConcurrencyTest {
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private ThreadingRule threads;

    ConstraintIndexConcurrencyTest() {
    }

    @Test
    void shouldNotAllowConcurrentViolationOfConstraint() throws Exception {
        Label label = Label.label((String)"Foo");
        String propertyKey = "bar";
        String conflictingValue = "baz";
        String constraintName = "MyConstraint";
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(label).assertPropertyIsUnique(propertyKey).withName(constraintName).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            int labelId = ktx.tokenRead().nodeLabel(label.name());
            int propertyKeyId = ktx.tokenRead().propertyKey(propertyKey);
            Read read = ktx.dataRead();
            try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor(ktx.pageCursorTracer(), ktx.memoryTracker());){
                IndexDescriptor index = ktx.schemaRead().indexGetForName(constraintName);
                IndexReadSession indexSession = ktx.dataRead().indexReadSession(index);
                read.nodeIndexSeek(indexSession, cursor, IndexQueryConstraints.unconstrained(), new IndexQuery[]{IndexQuery.exact((int)propertyKeyId, (Object)"The value is irrelevant, we just want to perform some sort of lookup against this index")});
            }
            this.threads.execute(db -> {
                try (Transaction transaction = db.beginTx();){
                    transaction.createNode(new Label[]{label}).setProperty(propertyKey, (Object)conflictingValue);
                    transaction.commit();
                }
                return null;
            }, (Object)this.db).get();
            long node = ktx.dataWrite().nodeCreate();
            ktx.dataWrite().nodeAddLabel(node, labelId);
            UniquePropertyValueValidationException e = (UniquePropertyValueValidationException)Assertions.assertThrows(UniquePropertyValueValidationException.class, () -> ktx.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)conflictingValue)));
            Assertions.assertEquals((Object)ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{propertyKeyId}), (Object)e.constraint());
            IndexEntryConflictException conflict = (IndexEntryConflictException)Iterators.single(e.conflicts().iterator());
            Assertions.assertEquals((Object)Values.stringValue((String)conflictingValue), (Object)conflict.getSinglePropertyValue());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

