/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.Values;

@TestDirectoryExtension
public class DefaultSchemaIndexConfigTest {
    private static final String KEY = "key";
    @Inject
    private TestDirectory directory;
    private DatabaseManagementServiceBuilder dbBuilder;
    private IndexDescriptor index;

    @BeforeEach
    void setup() {
        this.dbBuilder = new TestDatabaseManagementServiceBuilder(this.directory.homePath());
    }

    private static Stream<GraphDatabaseSettings.SchemaIndex> providers() {
        ArrayList<GraphDatabaseSettings.SchemaIndex> providers = new ArrayList<GraphDatabaseSettings.SchemaIndex>(Arrays.asList(GraphDatabaseSettings.SchemaIndex.values()));
        providers.add(null);
        return providers.stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"providers"})
    void shouldUseConfiguredIndexProvider(GraphDatabaseSettings.SchemaIndex provider) {
        DatabaseManagementServiceBuilder databaseManagementServiceBuilder = this.dbBuilder.setConfig(GraphDatabaseSettings.default_schema_provider, (Object)(provider == null ? null : provider.providerName()));
        DatabaseManagementService managementService = databaseManagementServiceBuilder.build();
        GraphDatabaseService db = managementService.database("neo4j");
        try {
            this.createIndex(db);
            this.assertIndexProvider(provider == null ? GenericNativeIndexProvider.DESCRIPTOR.name() : provider.providerName());
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"providers"})
    void indexShouldHaveIndexConfig(GraphDatabaseSettings.SchemaIndex provider) throws IndexNotFoundKernelException {
        DatabaseManagementServiceBuilder databaseManagementServiceBuilder = this.dbBuilder.setConfig(GraphDatabaseSettings.default_schema_provider, (Object)(provider == null ? null : provider.providerName()));
        DatabaseManagementService managementService = databaseManagementServiceBuilder.build();
        GraphDatabaseService db = managementService.database("neo4j");
        try {
            this.createIndex(db);
            this.validateIndexConfig(db);
        }
        finally {
            managementService.shutdown();
        }
        managementService = databaseManagementServiceBuilder.build();
        db = managementService.database("neo4j");
        try {
            this.validateIndexConfig(db);
        }
        finally {
            managementService.shutdown();
        }
    }

    private void validateIndexConfig(GraphDatabaseService db) throws IndexNotFoundKernelException {
        try (Transaction tx = db.beginTx();){
            GraphDatabaseAPI api = (GraphDatabaseAPI)db;
            IndexingService indexingService = DefaultSchemaIndexConfigTest.getIndexingService(api);
            IndexProxy indexProxy = indexingService.getIndexProxy(this.index);
            Map indexConfig = indexProxy.indexConfig();
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.doubleArray((double[])new double[]{-1000000.0, -1000000.0}), indexConfig.get("spatial.cartesian.min"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.doubleArray((double[])new double[]{1000000.0, 1000000.0}), indexConfig.get("spatial.cartesian.max"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.doubleArray((double[])new double[]{-1000000.0, -1000000.0, -1000000.0}), indexConfig.get("spatial.cartesian-3d.min"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.doubleArray((double[])new double[]{1000000.0, 1000000.0, 1000000.0}), indexConfig.get("spatial.cartesian-3d.max"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.doubleArray((double[])new double[]{-180.0, -90.0}), indexConfig.get("spatial.wgs-84.min"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.doubleArray((double[])new double[]{180.0, 90.0}), indexConfig.get("spatial.wgs-84.max"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.doubleArray((double[])new double[]{-180.0, -90.0, -1000000.0}), indexConfig.get("spatial.wgs-84-3d.min"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.doubleArray((double[])new double[]{180.0, 90.0, 1000000.0}), indexConfig.get("spatial.wgs-84-3d.max"));
            tx.commit();
        }
    }

    private static IndexingService getIndexingService(GraphDatabaseAPI db) {
        return (IndexingService)db.getDependencyResolver().resolveDependency(IndexingService.class);
    }

    private void assertIndexProvider(String expectedProviderIdentifier) {
        ((AbstractStringAssert)Assertions.assertThat((String)this.index.getIndexProvider().name()).as("expected IndexProvider.Descriptor", new Object[0])).isEqualTo(expectedProviderIdentifier);
    }

    private void createIndex(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            IndexDefinitionImpl indexDefinition = (IndexDefinitionImpl)tx.schema().indexFor(TestLabels.LABEL_ONE).on(KEY).create();
            this.index = indexDefinition.getIndexReference();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

