/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.FulltextSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProceduresUtil;
import org.neo4j.kernel.api.impl.fulltext.FulltextProceduresTestSupport;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.util.concurrent.BinaryLatch;

class EventuallyConsistentFulltextProceduresTest
extends FulltextProceduresTestSupport {
    EventuallyConsistentFulltextProceduresTest() {
    }

    @Override
    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        super.configure(builder);
        builder.setConfig(FulltextSettings.eventually_consistent, (Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void fulltextIndexesMustBeEventuallyConsistentByDefaultWhenThisIsConfigured() throws InterruptedException {
        long relId;
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "node", FulltextIndexProceduresUtil.asStrList((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop", "otherprop"})));
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rel", FulltextIndexProceduresUtil.asStrList((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"})));
            tx.commit();
        }
        this.awaitIndexesOnline();
        BinaryLatch indexUpdateBlocker = new BinaryLatch();
        ((JobScheduler)this.db.getDependencyResolver().resolveDependency(JobScheduler.class)).schedule(Group.INDEX_UPDATING, JobMonitoringParams.NOT_MONITORED, () -> ((BinaryLatch)indexUpdateBlocker).await());
        LongHashSet nodeIds = new LongHashSet();
        try {
            try (Transaction tx = this.db.beginTx();){
                Node node1 = tx.createNode(new Label[]{LABEL});
                node1.setProperty("prop", (Object)"bla bla");
                Node node2 = tx.createNode(new Label[]{LABEL});
                node2.setProperty("otherprop", (Object)"bla bla");
                Relationship relationship = node1.createRelationshipTo(node2, REL);
                relationship.setProperty("prop", (Object)"bla bla");
                nodeIds.add(node1.getId());
                nodeIds.add(node2.getId());
                relId = relationship.getId();
                tx.commit();
            }
            EventuallyConsistentFulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "node", "bla", new LongHashSet());
            EventuallyConsistentFulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "bla", new LongHashSet());
        }
        finally {
            Thread.sleep(10L);
            indexUpdateBlocker.release();
        }
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute("CALL db.index.fulltext.awaitEventuallyConsistentIndexRefresh()").close();
            transaction.commit();
        }
        EventuallyConsistentFulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "node", "bla", nodeIds);
        EventuallyConsistentFulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rel", "bla", LongHashSet.newSetWith((long[])new long[]{relId}));
    }
}

