/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.nio.file.Path;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.api.exceptions.schema.UnableToValidateConstraintException;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.index.schema.FailingGenericNativeIndexProviderFactory;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
@ExtendWith(value={RandomExtension.class})
class ConstraintIndexFailureIT {
    @Inject
    private RandomRule random;
    @Inject
    private TestDirectory directory;

    ConstraintIndexFailureIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldFailToValidateConstraintsIfUnderlyingIndexIsFailed() throws Exception {
        Transaction tx;
        Path dir = this.directory.homePath();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(dir).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try {
            tx = db.beginTx();
            try {
                tx.schema().constraintFor(Label.label((String)"Label1")).assertPropertyIsUnique("key1").create();
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        finally {
            managementService.shutdown();
        }
        FileUtils.deleteDirectory((Path)IndexDirectoryStructure.baseSchemaIndexFolder((Path)dir));
        managementService = new TestDatabaseManagementServiceBuilder(dir).removeExtensions(TestDatabaseManagementServiceBuilder.INDEX_PROVIDERS_FILTER).addExtension((ExtensionFactory)new FailingGenericNativeIndexProviderFactory(new FailingGenericNativeIndexProviderFactory.FailureType[]{FailingGenericNativeIndexProviderFactory.FailureType.INITIAL_STATE})).noOpSystemGraphInitializer().build();
        db = managementService.database("neo4j");
        try {
            tx = db.beginTx();
            try {
                ConstraintViolationException e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> tx.createNode(new Label[]{Label.label((String)"Label1")}).setProperty("key1", (Object)"value1"));
                Assertions.assertThat((Throwable)e.getCause()).isInstanceOf(UnableToValidateConstraintException.class);
                ((AbstractStringAssert)Assertions.assertThat((String)e.getCause().getCause().getMessage()).contains(new CharSequence[]{"The index is in a failed state:"})).contains(new CharSequence[]{"Override initial state as failed"});
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        finally {
            managementService.shutdown();
        }
    }
}

