/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.FulltextSettings;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextTestSupport;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;

class FulltextAnalyzerTest
extends LuceneFulltextTestSupport {
    private static final String ENGLISH = "english";
    static final String SWEDISH = "swedish";
    private static final String FOLDING = "standard-folding";

    FulltextAnalyzerTest() {
    }

    @Test
    void shouldBeAbleToSpecifyEnglishAnalyzer() throws Exception {
        long id;
        this.applySetting((Setting<String>)FulltextSettings.fulltext_default_analyzer, ENGLISH);
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").withIndexType(IndexType.FULLTEXT).withName("nodes").create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline("nodes", 1L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction tx = this.db.beginTx();){
            this.createNodeIndexableByPropertyValue(tx, LABEL, "Hello and hello again, in the end.");
            id = this.createNodeIndexableByPropertyValue(tx, LABEL, "En apa och en tomte bodde i ett hus.");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = FulltextAnalyzerTest.kernelTransaction(tx);
            this.assertQueryFindsNothing(ktx, true, "nodes", "and");
            this.assertQueryFindsNothing(ktx, true, "nodes", "in");
            this.assertQueryFindsNothing(ktx, true, "nodes", "the");
            this.assertQueryFindsIds(ktx, true, "nodes", "en", id);
            this.assertQueryFindsIds(ktx, true, "nodes", "och", id);
            this.assertQueryFindsIds(ktx, true, "nodes", "ett", id);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldBeAbleToSpecifySwedishAnalyzer() throws Exception {
        long id;
        this.applySetting((Setting<String>)FulltextSettings.fulltext_default_analyzer, SWEDISH);
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").withIndexType(IndexType.FULLTEXT).withName("nodes").create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline("nodes", 1L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction tx = this.db.beginTx();){
            id = this.createNodeIndexableByPropertyValue(tx, LABEL, "Hello and hello again, in the end.");
            this.createNodeIndexableByPropertyValue(tx, LABEL, "En apa och en tomte bodde i ett hus.");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = FulltextAnalyzerTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx, true, "nodes", "and", id);
            this.assertQueryFindsIds(ktx, true, "nodes", "in", id);
            this.assertQueryFindsIds(ktx, true, "nodes", "the", id);
            this.assertQueryFindsNothing(ktx, true, "nodes", "en");
            this.assertQueryFindsNothing(ktx, true, "nodes", "och");
            this.assertQueryFindsNothing(ktx, true, "nodes", "ett");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldBeAbleToSpecifyFoldingAnalyzer() throws Exception {
        long id3;
        long id2;
        long id;
        this.applySetting((Setting<String>)FulltextSettings.fulltext_default_analyzer, FOLDING);
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").withIndexType(IndexType.FULLTEXT).withName("nodes").create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline("nodes", 1L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction tx = this.db.beginTx();){
            id = this.createNodeIndexableByPropertyValue(tx, LABEL, "P\u0159\u00edli\u0161 \u017elu\u0165ou\u010dk\u00fd k\u016f\u0148 \u00fap\u011bl \u010f\u00e1belsk\u00e9 \u00f3dy.");
            id2 = this.createNodeIndexableByPropertyValue(tx, LABEL, "1SOMEDATA1");
            id3 = this.createNodeIndexableByPropertyValue(tx, LABEL, "\u24b6pa \u2c6fmma \u01e2ta \ua736ajaj \ua73averka dett\u249c");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = FulltextAnalyzerTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx, true, "nodes", "prilis", id);
            this.assertQueryFindsIds(ktx, true, "nodes", "zlutoucky", id);
            this.assertQueryFindsIds(ktx, true, "nodes", "kun", id);
            this.assertQueryFindsIds(ktx, true, "nodes", "upel", id);
            this.assertQueryFindsIds(ktx, true, "nodes", "dabelske", id);
            this.assertQueryFindsIds(ktx, true, "nodes", "ody", id);
            this.assertQueryFindsIds(ktx, true, "nodes", "1SOMEDATA1", id2);
            this.assertQueryFindsIds(ktx, true, "nodes", "1somedata1", id2);
            this.assertQueryFindsIds(ktx, true, "nodes", "*SOMEDATA*", id2);
            this.assertQueryFindsIds(ktx, true, "nodes", "*somedata*", id2);
            this.assertQueryFindsIds(ktx, true, "nodes", "Apa", id3);
            this.assertQueryFindsIds(ktx, true, "nodes", "amma", id3);
            this.assertQueryFindsIds(ktx, true, "nodes", "AEta", id3);
            this.assertQueryFindsIds(ktx, true, "nodes", "Auajaj", id3);
            this.assertQueryFindsIds(ktx, true, "nodes", "Avverka", id3);
            this.assertQueryFindsIds(ktx, true, "nodes", "dett(a)", id3);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNotReindexNodesWhenDefaultAnalyzerIsChanged() throws Exception {
        long secondID;
        this.applySetting((Setting<String>)FulltextSettings.fulltext_default_analyzer, ENGLISH);
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").withIndexType(IndexType.FULLTEXT).withName("nodes").create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline("nodes", 1L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            this.createNodeIndexableByPropertyValue(tx, LABEL, "Hello and hello again, in the end.");
            secondID = this.createNodeIndexableByPropertyValue(tx, LABEL, "En apa och en tomte bodde i ett hus.");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = FulltextAnalyzerTest.kernelTransaction(tx);
            this.assertQueryFindsNothing(ktx, true, "nodes", "and");
            this.assertQueryFindsNothing(ktx, true, "nodes", "in");
            this.assertQueryFindsNothing(ktx, true, "nodes", "the");
            this.assertQueryFindsIds(ktx, true, "nodes", "en", secondID);
            this.assertQueryFindsIds(ktx, true, "nodes", "och", secondID);
            this.assertQueryFindsIds(ktx, true, "nodes", "ett", secondID);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.applySetting((Setting<String>)FulltextSettings.fulltext_default_analyzer, SWEDISH);
        try (KernelTransactionImplementation ktx = this.getKernelTransaction();){
            SchemaRead schemaRead = ktx.schemaRead();
            this.await(schemaRead.indexGetForName("nodes"));
            this.assertQueryFindsNothing((KernelTransaction)ktx, true, "nodes", "and");
            this.assertQueryFindsNothing((KernelTransaction)ktx, true, "nodes", "in");
            this.assertQueryFindsNothing((KernelTransaction)ktx, true, "nodes", "the");
            this.assertQueryFindsIds((KernelTransaction)ktx, true, "nodes", "en", secondID);
            this.assertQueryFindsIds((KernelTransaction)ktx, true, "nodes", "och", secondID);
            this.assertQueryFindsIds((KernelTransaction)ktx, true, "nodes", "ett", secondID);
        }
    }
}

