/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.schema.RepeatedLabelInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedRelationshipTypeInSchemaException;
import org.neo4j.kernel.impl.api.index.IndexProviderNotFoundException;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;

public class IndexCreateIT
extends KernelIntegrationTest {
    private static final IndexCreator INDEX_CREATOR = (schemaWrite, schema, provider, name) -> schemaWrite.indexCreate((SchemaDescriptor)schema, provider, IndexConfig.empty(), name);
    private static final IndexCreator UNIQUE_CONSTRAINT_CREATOR = (schemaWrite, schema, provider, name) -> schemaWrite.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)schemaWrite.indexProviderByName(provider)).withName(name));

    @Test
    void shouldCreateIndexWithSpecificExistingProviderName() throws KernelException {
        this.shouldCreateWithSpecificExistingProviderName(INDEX_CREATOR);
    }

    @Test
    void shouldCreateUniquePropertyConstraintWithSpecificExistingProviderName() throws KernelException {
        this.shouldCreateWithSpecificExistingProviderName(UNIQUE_CONSTRAINT_CREATOR);
    }

    @Test
    void shouldFailCreateIndexWithNonExistentProviderName() throws KernelException {
        this.shouldFailWithNonExistentProviderName(INDEX_CREATOR);
    }

    @Test
    void shouldFailCreateUniquePropertyConstraintWithNonExistentProviderName() throws KernelException {
        this.shouldFailWithNonExistentProviderName(UNIQUE_CONSTRAINT_CREATOR);
    }

    @Test
    void shouldFailCreateIndexWithDuplicateLabels() throws KernelException {
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        FulltextSchemaDescriptor descriptor = SchemaDescriptor.fulltext((EntityType)EntityType.NODE, (int[])new int[]{0, 0}, (int[])new int[]{1});
        Assertions.assertThrows(RepeatedLabelInSchemaException.class, () -> schemaWrite.indexCreate((SchemaDescriptor)descriptor, null));
    }

    @Test
    void shouldFailCreateIndexWithDuplicateRelationshipTypes() throws KernelException {
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        FulltextSchemaDescriptor descriptor = SchemaDescriptor.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])new int[]{0, 0}, (int[])new int[]{1});
        Assertions.assertThrows(RepeatedRelationshipTypeInSchemaException.class, () -> schemaWrite.indexCreate((SchemaDescriptor)descriptor, null));
    }

    @Test
    void shouldFailCreateIndexWithDuplicateProperties() throws KernelException {
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        FulltextSchemaDescriptor descriptor = SchemaDescriptor.fulltext((EntityType)EntityType.NODE, (int[])new int[]{0}, (int[])new int[]{1, 1});
        Assertions.assertThrows(RepeatedPropertyInSchemaException.class, () -> schemaWrite.indexCreate((SchemaDescriptor)descriptor, null));
    }

    protected void shouldFailWithNonExistentProviderName(IndexCreator creator) throws KernelException {
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        Assertions.assertThrows(IndexProviderNotFoundException.class, () -> creator.create(schemaWrite, SchemaDescriptor.forLabel((int)0, (int[])new int[]{0}), "something-completely-different", "index name"));
    }

    protected void shouldCreateWithSpecificExistingProviderName(IndexCreator creator) throws KernelException {
        int labelId = 0;
        for (GraphDatabaseSettings.SchemaIndex indexSetting : GraphDatabaseSettings.SchemaIndex.values()) {
            SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
            String provider = indexSetting.providerName();
            LabelSchemaDescriptor descriptor = SchemaDescriptor.forLabel((int)labelId++, (int[])new int[]{0});
            String indexName = "index-" + labelId;
            creator.create(schemaWrite, descriptor, provider, indexName);
            IndexDescriptor index = this.transaction.kernelTransaction().schemaRead().indexGetForName(indexName);
            this.commit();
            Assertions.assertEquals((Object)provider, (Object)this.indexingService.getIndexProxy(index).getDescriptor().getIndexProvider().name());
        }
    }

    protected static interface IndexCreator {
        public void create(SchemaWrite var1, LabelSchemaDescriptor var2, String var3, String var4) throws KernelException;
    }
}

