/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProvider;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.NativeLuceneFusionIndexProviderFactory30;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.conditions.Conditions;
import org.neo4j.test.extension.DbmsController;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

@DbmsExtension(configurationCallback="configure")
public class FusionIndexIT {
    private final Label label = Label.label((String)"label");
    private final String propKey = "propKey";
    @Inject
    private DbmsController controller;
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private FileSystemAbstraction fs;
    private final int numberValue = 1;
    private final String stringValue = "string";
    private final PointValue spatialValue = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.5, 0.5});
    private final DateValue temporalValue = DateValue.date((int)2018, (int)3, (int)19);
    private final String indexName = "some_index_name";

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.default_schema_provider, (Object)GraphDatabaseSettings.SchemaIndex.NATIVE30.providerName());
    }

    @Test
    void shouldKeepIndexSamplesUpdated() {
        this.createIndex();
        AssertionsForClassTypes.assertThat((Object)this.indexSample()).isEqualTo((Object)new IndexSample(0L, 0L, 0L, 0L));
        try (Transaction tx = this.db.beginTx();){
            tx.createNode(new Label[]{this.label}).setProperty("propKey", (Object)1);
            tx.createNode(new Label[]{this.label}).setProperty("propKey", (Object)"string");
            tx.createNode(new Label[]{this.label}).setProperty("propKey", (Object)this.spatialValue);
            tx.createNode(new Label[]{this.label}).setProperty("propKey", (Object)this.temporalValue);
            tx.commit();
        }
        Assert.assertEventually(this::indexSample, (Condition)Conditions.equalityCondition((Object)new IndexSample(4L, 4L, 4L)), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    @Test
    void mustRebuildFusionIndexIfNativePartIsMissing() {
        this.initializeIndexWithData();
        this.deleteIndexFilesForProviderAndRestartDbms(GenericNativeIndexProvider.DESCRIPTOR);
        this.verifyContent();
    }

    @Test
    void mustRebuildFusionIndexIfLucenePartIsMissing() {
        this.initializeIndexWithData();
        this.deleteIndexFilesForProviderAndRestartDbms(LuceneIndexProvider.DESCRIPTOR);
        this.verifyContent();
    }

    @Test
    void mustRebuildFusionIndexIfCompletelyMissing() {
        this.initializeIndexWithData();
        this.deleteIndexFilesForProviderAndRestartDbms(LuceneIndexProvider.DESCRIPTOR, GenericNativeIndexProvider.DESCRIPTOR);
        this.verifyContent();
    }

    private void deleteIndexFilesForProviderAndRestartDbms(IndexProviderDescriptor ... descriptors) {
        this.controller.restartDbms(this.db.databaseName(), builder -> {
            for (IndexProviderDescriptor descriptor : descriptors) {
                try {
                    this.deleteIndexFilesFor(descriptor);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return builder;
        });
    }

    private void verifyContent() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(30L, TimeUnit.SECONDS);
            Assertions.assertEquals((long)1L, (long)Iterators.stream(tx.schema().getIndexes(this.label).iterator()).count());
            Assertions.assertNotNull((Object)tx.findNode(this.label, "propKey", (Object)1));
            Assertions.assertNotNull((Object)tx.findNode(this.label, "propKey", (Object)"string"));
            Assertions.assertNotNull((Object)tx.findNode(this.label, "propKey", (Object)this.spatialValue));
            Assertions.assertNotNull((Object)tx.findNode(this.label, "propKey", (Object)this.temporalValue));
            AssertionsForClassTypes.assertThat((Object)this.indexSample()).isEqualTo((Object)new IndexSample(4L, 4L, 4L, 0L));
            tx.commit();
        }
    }

    private void deleteIndexFilesFor(IndexProviderDescriptor descriptor) throws IOException {
        Path[] files;
        Path databaseDirectory = this.db.databaseLayout().databaseDirectory();
        Path rootDirectory = NativeLuceneFusionIndexProviderFactory30.subProviderDirectoryStructure((Path)databaseDirectory).forProvider(descriptor).rootDirectory();
        for (Path indexFile : files = this.fs.listFiles(rootDirectory)) {
            this.fs.deleteRecursively(indexFile);
        }
    }

    private void initializeIndexWithData() {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode(new Label[]{this.label}).setProperty("propKey", (Object)1);
            tx.createNode(new Label[]{this.label}).setProperty("propKey", (Object)"string");
            tx.createNode(new Label[]{this.label}).setProperty("propKey", (Object)this.spatialValue);
            tx.createNode(new Label[]{this.label}).setProperty("propKey", (Object)this.temporalValue);
            tx.commit();
        }
        this.createIndex();
    }

    private void createIndex() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(this.label).on("propKey").withName("some_index_name").create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(30L, TimeUnit.SECONDS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private IndexSample indexSample() {
        try (Transaction tx = this.db.beginTx();){
            IndexDefinitionImpl index = (IndexDefinitionImpl)tx.schema().getIndexByName("some_index_name");
            IndexSample indexSample = ((IndexStatisticsStore)this.db.getDependencyResolver().resolveDependency(IndexStatisticsStore.class)).indexSample(index.getIndexReference().getId());
            return indexSample;
        }
    }
}

