/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

class IndexConstraintsTest {
    private static final Label LABEL = Label.label((String)"Label");
    private static final String PROPERTY_KEY = "x";
    private GraphDatabaseService graphDb;
    private DatabaseManagementService managementService;

    IndexConstraintsTest() {
    }

    @BeforeEach
    void setup() {
        this.managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
        this.graphDb = this.managementService.database("neo4j");
    }

    @AfterEach
    void shutdown() {
        this.managementService.shutdown();
    }

    @Test
    void convertIndexToConstraint() {
        try (Transaction tx = this.graphDb.beginTx();){
            tx.schema().indexFor(LABEL).on(PROPERTY_KEY).create();
            tx.commit();
        }
        tx = this.graphDb.beginTx();
        try {
            IndexDefinition index = (IndexDefinition)Iterables.firstOrNull((Iterable)tx.schema().getIndexes(LABEL));
            index.drop();
            tx.schema().constraintFor(LABEL).assertPropertyIsUnique(PROPERTY_KEY).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void convertIndexToConstraintWithExistingData() {
        try (Transaction tx = this.graphDb.beginTx();){
            for (int i = 0; i < 2000; ++i) {
                Node node = tx.createNode(new Label[]{LABEL});
                node.setProperty(PROPERTY_KEY, (Object)i);
            }
            tx.commit();
        }
        tx = this.graphDb.beginTx();
        try {
            tx.schema().indexFor(LABEL).on(PROPERTY_KEY).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.graphDb.beginTx();
        try {
            IndexDefinition index = (IndexDefinition)Iterables.firstOrNull((Iterable)tx.schema().getIndexes(LABEL));
            index.drop();
            tx.schema().constraintFor(LABEL).assertPropertyIsUnique(PROPERTY_KEY).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void convertConstraintToIndex() {
        try (Transaction tx = this.graphDb.beginTx();){
            tx.schema().constraintFor(LABEL).assertPropertyIsUnique(PROPERTY_KEY).create();
            tx.commit();
        }
        tx = this.graphDb.beginTx();
        try {
            ConstraintDefinition constraint = (ConstraintDefinition)Iterables.firstOrNull((Iterable)tx.schema().getConstraints(LABEL));
            constraint.drop();
            tx.schema().indexFor(LABEL).on(PROPERTY_KEY).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void creatingAndDroppingAndCreatingIndexInSameTransaction() {
        for (int times = 1; times <= 4; ++times) {
            try {
                try (Transaction tx = this.graphDb.beginTx();){
                    this.recreate(tx, tx.schema().indexFor(LABEL).on(PROPERTY_KEY).create(), times);
                    tx.commit();
                }
                tx = this.graphDb.beginTx();
                try {
                    Assertions.assertNotNull((Object)this.getIndex(tx, LABEL, PROPERTY_KEY), (String)"Index should exist");
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
                tx = this.graphDb.beginTx();
                try {
                    this.recreate(tx, this.getIndex(tx, LABEL, PROPERTY_KEY), times);
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
                tx = this.graphDb.beginTx();
                try {
                    Assertions.assertNotNull((Object)this.getIndex(tx, LABEL, PROPERTY_KEY), (String)"Index should exist");
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
                tx = this.graphDb.beginTx();
                try {
                    this.recreate(tx, this.getIndex(tx, LABEL, PROPERTY_KEY), times).drop();
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
                tx = this.graphDb.beginTx();
                try {
                    Assertions.assertNull((Object)this.getIndex(tx, LABEL, PROPERTY_KEY), (String)"Index should be removed");
                    continue;
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
            catch (Throwable e) {
                throw new AssertionError("times=" + times, e);
            }
        }
    }

    private IndexDefinition recreate(Transaction tx, IndexDefinition index, int times) {
        for (int i = 0; i < times; ++i) {
            index.drop();
            index = tx.schema().indexFor((Label)Iterables.single((Iterable)index.getLabels())).on((String)Iterables.single((Iterable)index.getPropertyKeys())).create();
        }
        return index;
    }

    private IndexDefinition getIndex(Transaction tx, Label label, String propertyKey) {
        IndexDefinition found = null;
        for (IndexDefinition index : tx.schema().getIndexes(label)) {
            if (!propertyKey.equals(Iterables.single((Iterable)index.getPropertyKeys()))) continue;
            Assertions.assertNull(found, (String)"Found multiple indexes.");
            found = index;
        }
        return found;
    }

    @Test
    void shouldRemoveIndexForConstraintEvenIfDroppedInCreatingTransaction() {
        try (Transaction tx = this.graphDb.beginTx();){
            tx.schema().constraintFor(LABEL).assertPropertyIsUnique(PROPERTY_KEY).create().drop();
            tx.rollback();
        }
        tx = this.graphDb.beginTx();
        try {
            Assertions.assertNull((Object)this.getIndex(tx, LABEL, PROPERTY_KEY), (String)"Should not have constraint index");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

